/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.performance;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.format.ObjectFormat;
import android.filterpacks.performance.Throughput;
import android.os.SystemClock;

public class ThroughputFilter
extends Filter {
    @GenerateFieldPort(name="period", hasDefault=true)
    private int mPeriod = 5;
    private long mLastTime = 0L;
    private int mTotalFrameCount = 0;
    private int mPeriodFrameCount = 0;
    private FrameFormat mOutputFormat;

    public ThroughputFilter(String name) {
        super(name);
    }

    public void setupPorts() {
        this.addInputPort("frame");
        this.mOutputFormat = ObjectFormat.fromClass(Throughput.class, 1);
        this.addOutputBasedOnInput("frame", "frame");
        this.addOutputPort("throughput", this.mOutputFormat);
    }

    public FrameFormat getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    public void open(FilterContext env) {
        this.mTotalFrameCount = 0;
        this.mPeriodFrameCount = 0;
        this.mLastTime = 0L;
    }

    public void process(FilterContext context) {
        long curTime;
        Frame input = this.pullInput("frame");
        this.pushOutput("frame", input);
        ++this.mTotalFrameCount;
        ++this.mPeriodFrameCount;
        if (this.mLastTime == 0L) {
            this.mLastTime = SystemClock.elapsedRealtime();
        }
        if ((curTime = SystemClock.elapsedRealtime()) - this.mLastTime >= (long)(this.mPeriod * 1000)) {
            FrameFormat inputFormat = input.getFormat();
            int pixelCount = inputFormat.getWidth() * inputFormat.getHeight();
            Throughput throughput = new Throughput(this.mTotalFrameCount, this.mPeriodFrameCount, this.mPeriod, pixelCount);
            Frame throughputFrame = context.getFrameManager().newFrame(this.mOutputFormat);
            throughputFrame.setObjectValue(throughput);
            this.pushOutput("throughput", throughputFrame);
            this.mLastTime = curTime;
            this.mPeriodFrameCount = 0;
        }
    }
}

