/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.util.SparseArray;
import java.io.File;

public class Typeface {
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    public static final Typeface MONOSPACE;
    static Typeface[] sDefaults;
    private static final SparseArray<SparseArray<Typeface>> sTypefaceCache;
    int native_instance;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    private int mStyle = 0;

    public int getStyle() {
        return this.mStyle;
    }

    public final boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public final boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    public static Typeface create(String familyName, int style2) {
        return new Typeface(Typeface.nativeCreate(familyName, style2));
    }

    public static Typeface create(Typeface family, int style2) {
        Typeface typeface;
        SparseArray<Typeface> styles;
        int ni = 0;
        if (family != null) {
            if (family.mStyle == style2) {
                return family;
            }
            ni = family.native_instance;
        }
        if ((styles = sTypefaceCache.get(ni)) != null && (typeface = styles.get(style2)) != null) {
            return typeface;
        }
        typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
        if (styles == null) {
            styles = new SparseArray(4);
            sTypefaceCache.put(ni, styles);
        }
        styles.put(style2, typeface);
        return typeface;
    }

    public static Typeface defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    public static Typeface createFromAsset(AssetManager mgr, String path) {
        return new Typeface(Typeface.nativeCreateFromAsset(mgr, path));
    }

    public static Typeface createFromFile(File path) {
        return new Typeface(Typeface.nativeCreateFromFile(path.getAbsolutePath()));
    }

    public static Typeface createFromFile(String path) {
        return new Typeface(Typeface.nativeCreateFromFile(path));
    }

    private Typeface(int ni) {
        if (ni == 0) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mStyle = Typeface.nativeGetStyle(ni);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    public int hashCode() {
        int result = this.native_instance;
        result = 31 * result + this.mStyle;
        return result;
    }

    private static native int nativeCreate(String var0, int var1);

    private static native int nativeCreateFromTypeface(int var0, int var1);

    private static native void nativeUnref(int var0);

    private static native int nativeGetStyle(int var0);

    private static native int nativeCreateFromAsset(AssetManager var0, String var1);

    private static native int nativeCreateFromFile(String var0);

    static {
        sTypefaceCache = new SparseArray(3);
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }
}

