/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.utils.CameraBinderDecorator;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraDevice
implements android.hardware.camera2.CameraDevice {
    private final String TAG;
    private final boolean DEBUG;
    private static final int REQUEST_ID_NONE = -1;
    private ICameraDeviceUser mRemoteDevice;
    private final Object mLock = new Object();
    private final CameraDeviceCallbacks mCallbacks = new CameraDeviceCallbacks();
    private final CameraDevice.StateListener mDeviceListener;
    private final Handler mDeviceHandler;
    private boolean mIdle = true;
    private final SparseArray<CaptureListenerHolder> mCaptureListenerMap = new SparseArray();
    private int mRepeatingRequestId = -1;
    private final ArrayList<Integer> mRepeatingRequestIdDeletedList = new ArrayList();
    private final SparseArray<Surface> mConfiguredOutputs = new SparseArray();
    private final String mCameraId;
    private final Runnable mCallOnOpened = new Runnable(){

        public void run() {
            if (!CameraDevice.this.isClosed()) {
                CameraDevice.this.mDeviceListener.onOpened(CameraDevice.this);
            }
        }
    };
    private final Runnable mCallOnUnconfigured = new Runnable(){

        public void run() {
            if (!CameraDevice.this.isClosed()) {
                CameraDevice.this.mDeviceListener.onUnconfigured(CameraDevice.this);
            }
        }
    };
    private final Runnable mCallOnActive = new Runnable(){

        public void run() {
            if (!CameraDevice.this.isClosed()) {
                CameraDevice.this.mDeviceListener.onActive(CameraDevice.this);
            }
        }
    };
    private final Runnable mCallOnBusy = new Runnable(){

        public void run() {
            if (!CameraDevice.this.isClosed()) {
                CameraDevice.this.mDeviceListener.onBusy(CameraDevice.this);
            }
        }
    };
    private final Runnable mCallOnClosed = new Runnable(){

        public void run() {
            if (!CameraDevice.this.isClosed()) {
                CameraDevice.this.mDeviceListener.onClosed(CameraDevice.this);
            }
        }
    };
    private final Runnable mCallOnIdle = new Runnable(){

        public void run() {
            if (!CameraDevice.this.isClosed()) {
                CameraDevice.this.mDeviceListener.onIdle(CameraDevice.this);
            }
        }
    };
    private final Runnable mCallOnDisconnected = new Runnable(){

        public void run() {
            if (!CameraDevice.this.isClosed()) {
                CameraDevice.this.mDeviceListener.onDisconnected(CameraDevice.this);
            }
        }
    };

    public CameraDevice(String cameraId, CameraDevice.StateListener listener, Handler handler) {
        if (cameraId == null || listener == null || handler == null) {
            throw new IllegalArgumentException("Null argument given");
        }
        this.mCameraId = cameraId;
        this.mDeviceListener = listener;
        this.mDeviceHandler = handler;
        this.TAG = String.format("CameraDevice-%s-JV", this.mCameraId);
        this.DEBUG = Log.isLoggable(this.TAG, 3);
    }

    public CameraDeviceCallbacks getCallbacks() {
        return this.mCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteDevice(ICameraDeviceUser remoteDevice) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRemoteDevice = CameraBinderDecorator.newInstance(remoteDevice);
            this.mDeviceHandler.post(this.mCallOnOpened);
            this.mDeviceHandler.post(this.mCallOnUnconfigured);
        }
    }

    @Override
    public String getId() {
        return this.mCameraId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureOutputs(List<Surface> outputs) throws CameraAccessException {
        if (outputs == null) {
            outputs = new ArrayList<Surface>();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkIfCameraClosed();
            HashSet<Surface> addSet = new HashSet<Surface>(outputs);
            ArrayList<Integer> deleteList = new ArrayList<Integer>();
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                int streamId = this.mConfiguredOutputs.keyAt(i);
                Surface s = this.mConfiguredOutputs.valueAt(i);
                if (!outputs.contains(s)) {
                    deleteList.add(streamId);
                    continue;
                }
                addSet.remove(s);
            }
            this.mDeviceHandler.post(this.mCallOnBusy);
            this.stopRepeating();
            try {
                this.waitUntilIdle();
                for (Integer streamId : deleteList) {
                    this.mRemoteDevice.deleteStream(streamId);
                    this.mConfiguredOutputs.delete(streamId);
                }
                for (Surface s : addSet) {
                    int streamId = this.mRemoteDevice.createStream(0, 0, 0, s);
                    this.mConfiguredOutputs.put(streamId, s);
                }
            }
            catch (CameraRuntimeException e) {
                if (e.getReason() == 4) {
                    throw new IllegalStateException("The camera is currently busy. You must wait until the previous operation completes.");
                }
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return;
            }
            if (outputs.size() > 0) {
                this.mDeviceHandler.post(this.mCallOnIdle);
            } else {
                this.mDeviceHandler.post(this.mCallOnUnconfigured);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaptureRequest.Builder createCaptureRequest(int templateType) throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkIfCameraClosed();
            CameraMetadataNative templatedRequest = new CameraMetadataNative();
            try {
                this.mRemoteDevice.createDefaultRequest(templateType, templatedRequest);
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return null;
            }
            CaptureRequest.Builder builder = new CaptureRequest.Builder(templatedRequest);
            return builder;
        }
    }

    @Override
    public int capture(CaptureRequest request, CameraDevice.CaptureListener listener, Handler handler) throws CameraAccessException {
        return this.submitCaptureRequest(request, listener, handler, false);
    }

    @Override
    public int captureBurst(List<CaptureRequest> requests, CameraDevice.CaptureListener listener, Handler handler) throws CameraAccessException {
        if (requests.isEmpty()) {
            Log.w(this.TAG, "Capture burst request list is empty, do nothing!");
            return -1;
        }
        throw new UnsupportedOperationException("Burst capture implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int submitCaptureRequest(CaptureRequest request, CameraDevice.CaptureListener listener, Handler handler, boolean repeating) throws CameraAccessException {
        if (listener != null) {
            handler = this.checkHandler(handler);
        }
        Object object = this.mLock;
        synchronized (object) {
            int requestId;
            this.checkIfCameraClosed();
            if (repeating) {
                this.stopRepeating();
            }
            try {
                requestId = this.mRemoteDevice.submitRequest(request, repeating);
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return -1;
            }
            if (listener != null) {
                this.mCaptureListenerMap.put(requestId, new CaptureListenerHolder(listener, request, handler, repeating));
            }
            if (repeating) {
                this.mRepeatingRequestId = requestId;
            }
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnActive);
            }
            this.mIdle = false;
            return requestId;
        }
    }

    @Override
    public int setRepeatingRequest(CaptureRequest request, CameraDevice.CaptureListener listener, Handler handler) throws CameraAccessException {
        return this.submitCaptureRequest(request, listener, handler, true);
    }

    @Override
    public int setRepeatingBurst(List<CaptureRequest> requests, CameraDevice.CaptureListener listener, Handler handler) throws CameraAccessException {
        if (requests.isEmpty()) {
            Log.w(this.TAG, "Set Repeating burst request list is empty, do nothing!");
            return -1;
        }
        throw new UnsupportedOperationException("Burst capture implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRepeating() throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkIfCameraClosed();
            if (this.mRepeatingRequestId != -1) {
                int requestId = this.mRepeatingRequestId;
                this.mRepeatingRequestId = -1;
                this.mRepeatingRequestIdDeletedList.add(requestId);
                try {
                    this.mRemoteDevice.cancelRequest(requestId);
                }
                catch (CameraRuntimeException e) {
                    throw e.asChecked();
                }
                catch (RemoteException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilIdle() throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkIfCameraClosed();
            if (this.mRepeatingRequestId != -1) {
                throw new IllegalStateException("Active repeating request ongoing");
            }
            try {
                this.mRemoteDevice.waitUntilIdle();
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return;
            }
            this.mRepeatingRequestId = -1;
            this.mRepeatingRequestIdDeletedList.clear();
            this.mCaptureListenerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkIfCameraClosed();
            this.mDeviceHandler.post(this.mCallOnBusy);
            try {
                this.mRemoteDevice.flush();
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mRemoteDevice != null) {
                    this.mRemoteDevice.disconnect();
                }
            }
            catch (CameraRuntimeException e) {
                Log.e(this.TAG, "Exception while closing: ", e.asChecked());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (this.mRemoteDevice != null) {
                this.mDeviceHandler.post(this.mCallOnClosed);
            }
            this.mRemoteDevice = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private Handler checkHandler(Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        return handler;
    }

    private void checkIfCameraClosed() {
        if (this.mRemoteDevice == null) {
            throw new IllegalStateException("CameraDevice was already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRemoteDevice == null;
        }
    }

    public class CameraDeviceCallbacks
    extends ICameraDeviceCallbacks.Stub {
        static final int ERROR_CAMERA_DISCONNECTED = 0;
        static final int ERROR_CAMERA_DEVICE = 1;
        static final int ERROR_CAMERA_SERVICE = 2;

        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraError(final int errorCode) {
            Runnable r = null;
            if (CameraDevice.this.isClosed()) {
                return;
            }
            Object object = CameraDevice.this.mLock;
            synchronized (object) {
                switch (errorCode) {
                    case 0: {
                        r = CameraDevice.this.mCallOnDisconnected;
                        break;
                    }
                    default: {
                        Log.e(CameraDevice.this.TAG, "Unknown error from camera device: " + errorCode);
                    }
                    case 1: 
                    case 2: {
                        r = new Runnable(){

                            public void run() {
                                if (!CameraDevice.this.isClosed()) {
                                    CameraDevice.this.mDeviceListener.onError(CameraDevice.this, errorCode);
                                }
                            }
                        };
                    }
                }
                CameraDevice.this.mDeviceHandler.post(r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraIdle() {
            if (CameraDevice.this.isClosed()) {
                return;
            }
            if (CameraDevice.this.DEBUG) {
                Log.d(CameraDevice.this.TAG, "Camera now idle");
            }
            Object object = CameraDevice.this.mLock;
            synchronized (object) {
                if (!CameraDevice.this.mIdle) {
                    CameraDevice.this.mDeviceHandler.post(CameraDevice.this.mCallOnIdle);
                }
                CameraDevice.this.mIdle = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCaptureStarted(int requestId, final long timestamp) {
            CaptureListenerHolder holder;
            if (CameraDevice.this.DEBUG) {
                Log.d(CameraDevice.this.TAG, "Capture started for id " + requestId);
            }
            Object object = CameraDevice.this.mLock;
            synchronized (object) {
                holder = (CaptureListenerHolder)CameraDevice.this.mCaptureListenerMap.get(requestId);
            }
            if (holder == null) {
                return;
            }
            if (CameraDevice.this.isClosed()) {
                return;
            }
            holder.getHandler().post(new Runnable(){

                public void run() {
                    if (!CameraDevice.this.isClosed()) {
                        holder.getListener().onCaptureStarted(CameraDevice.this, holder.getRequest(), timestamp);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResultReceived(int requestId, CameraMetadataNative result) throws RemoteException {
            CaptureListenerHolder holder;
            Boolean quirkPartial;
            if (CameraDevice.this.DEBUG) {
                Log.d(CameraDevice.this.TAG, "Received result for id " + requestId);
            }
            boolean quirkIsPartialResult = (quirkPartial = result.get(CaptureResult.QUIRKS_PARTIAL_RESULT)) != null && quirkPartial != false;
            Object object = CameraDevice.this.mLock;
            synchronized (object) {
                holder = (CaptureListenerHolder)CameraDevice.this.mCaptureListenerMap.get(requestId);
                if (holder != null && !holder.isRepeating() && !quirkIsPartialResult) {
                    CameraDevice.this.mCaptureListenerMap.remove(requestId);
                }
                if (holder != null && holder.isRepeating() && !quirkIsPartialResult && CameraDevice.this.mRepeatingRequestIdDeletedList.size() > 0) {
                    Iterator iter = CameraDevice.this.mRepeatingRequestIdDeletedList.iterator();
                    while (iter.hasNext()) {
                        int deletedRequestId = (Integer)iter.next();
                        if (deletedRequestId >= requestId) continue;
                        CameraDevice.this.mCaptureListenerMap.remove(deletedRequestId);
                        iter.remove();
                    }
                }
            }
            if (holder == null) {
                return;
            }
            if (CameraDevice.this.isClosed()) {
                return;
            }
            final CaptureRequest request = holder.getRequest();
            final CaptureResult resultAsCapture = new CaptureResult(result, request, requestId);
            Runnable resultDispatch = null;
            resultDispatch = quirkIsPartialResult ? new Runnable(){

                public void run() {
                    if (!CameraDevice.this.isClosed()) {
                        holder.getListener().onCapturePartial(CameraDevice.this, request, resultAsCapture);
                    }
                }
            } : new Runnable(){

                public void run() {
                    if (!CameraDevice.this.isClosed()) {
                        holder.getListener().onCaptureCompleted(CameraDevice.this, request, resultAsCapture);
                    }
                }
            };
            holder.getHandler().post(resultDispatch);
        }
    }

    static class CaptureListenerHolder {
        private final boolean mRepeating;
        private final CameraDevice.CaptureListener mListener;
        private final CaptureRequest mRequest;
        private final Handler mHandler;

        CaptureListenerHolder(CameraDevice.CaptureListener listener, CaptureRequest request, Handler handler, boolean repeating) {
            if (listener == null || handler == null) {
                throw new UnsupportedOperationException("Must have a valid handler and a valid listener");
            }
            this.mRepeating = repeating;
            this.mHandler = handler;
            this.mRequest = request;
            this.mListener = listener;
        }

        public boolean isRepeating() {
            return this.mRepeating;
        }

        public CameraDevice.CaptureListener getListener() {
            return this.mListener;
        }

        public CaptureRequest getRequest() {
            return this.mRequest;
        }

        public Handler getHandler() {
            return this.mHandler;
        }
    }
}

