/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.impl.MetadataMarshalClass;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMarshalString
implements MetadataMarshalClass<String> {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    @Override
    public int marshal(String value, ByteBuffer buffer, int nativeType, boolean sizeOnly) {
        byte[] arr = value.getBytes(UTF8_CHARSET);
        if (!sizeOnly) {
            buffer.put(arr);
            buffer.put((byte)0);
        }
        return arr.length + 1;
    }

    @Override
    public String unmarshal(ByteBuffer buffer, int nativeType) {
        buffer.mark();
        boolean foundNull = false;
        int stringLength = 0;
        while (buffer.hasRemaining()) {
            if (buffer.get() == 0) {
                foundNull = true;
                break;
            }
            ++stringLength;
        }
        if (!foundNull) {
            throw new IllegalArgumentException("Strings must be null-terminated");
        }
        buffer.reset();
        byte[] strBytes = new byte[stringLength + 1];
        buffer.get(strBytes, 0, stringLength + 1);
        return new String(strBytes, 0, stringLength, UTF8_CHARSET);
    }

    @Override
    public Class<String> getMarshalingClass() {
        return String.class;
    }

    @Override
    public boolean isNativeTypeSupported(int nativeType) {
        return nativeType == 0;
    }

    @Override
    public int getNativeSize(int nativeType) {
        return -1;
    }
}

