/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.os.ParcelFileDescriptor;
import java.io.FileDescriptor;

public class UsbDeviceConnection {
    private static final String TAG = "UsbDeviceConnection";
    private final UsbDevice mDevice;
    private long mNativeContext;

    public UsbDeviceConnection(UsbDevice device) {
        this.mDevice = device;
    }

    boolean open(String name, ParcelFileDescriptor pfd) {
        return this.native_open(name, pfd.getFileDescriptor());
    }

    public void close() {
        this.native_close();
    }

    public int getFileDescriptor() {
        return this.native_get_fd();
    }

    public byte[] getRawDescriptors() {
        return this.native_get_desc();
    }

    public boolean claimInterface(UsbInterface intf, boolean force) {
        return this.native_claim_interface(intf.getId(), force);
    }

    public boolean releaseInterface(UsbInterface intf) {
        return this.native_release_interface(intf.getId());
    }

    public int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int length, int timeout) {
        return this.controlTransfer(requestType, request, value, index, buffer, 0, length, timeout);
    }

    public int controlTransfer(int requestType, int request, int value, int index, byte[] buffer, int offset, int length, int timeout) {
        UsbDeviceConnection.checkBounds(buffer, offset, length);
        return this.native_control_request(requestType, request, value, index, buffer, offset, length, timeout);
    }

    public int bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int length, int timeout) {
        return this.bulkTransfer(endpoint, buffer, 0, length, timeout);
    }

    public int bulkTransfer(UsbEndpoint endpoint, byte[] buffer, int offset, int length, int timeout) {
        UsbDeviceConnection.checkBounds(buffer, offset, length);
        return this.native_bulk_request(endpoint.getAddress(), buffer, offset, length, timeout);
    }

    public UsbRequest requestWait() {
        UsbRequest request = this.native_request_wait();
        if (request != null) {
            request.dequeue();
        }
        return request;
    }

    public String getSerial() {
        return this.native_get_serial();
    }

    private static void checkBounds(byte[] buffer, int start, int length) {
        int bufferLength;
        int n = bufferLength = buffer != null ? buffer.length : 0;
        if (start < 0 || start + length > bufferLength) {
            throw new IllegalArgumentException("Buffer start or length out of bounds.");
        }
    }

    private native boolean native_open(String var1, FileDescriptor var2);

    private native void native_close();

    private native int native_get_fd();

    private native byte[] native_get_desc();

    private native boolean native_claim_interface(int var1, boolean var2);

    private native boolean native_release_interface(int var1);

    private native int native_control_request(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, int var8);

    private native int native_bulk_request(int var1, byte[] var2, int var3, int var4, int var5);

    private native UsbRequest native_request_wait();

    private native String native_get_serial();
}

