/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;

public abstract class SettingInjectorService
extends Service {
    private static final String TAG = "SettingInjectorService";
    public static final String ACTION_SERVICE_INTENT = "android.location.SettingInjectorService";
    public static final String META_DATA_NAME = "android.location.SettingInjectorService";
    public static final String ATTRIBUTES_NAME = "injected-location-setting";
    public static final String ACTION_INJECTED_SETTING_CHANGED = "android.location.InjectedSettingChanged";
    public static final String SUMMARY_KEY = "summary";
    public static final String ENABLED_KEY = "enabled";
    public static final String MESSENGER_KEY = "messenger";
    private final String mName;

    public SettingInjectorService(String name) {
        this.mName = name;
    }

    public final IBinder onBind(Intent intent) {
        return null;
    }

    public final void onStart(Intent intent, int startId) {
        super.onStart(intent, startId);
    }

    public final int onStartCommand(Intent intent, int flags, int startId) {
        this.onHandleIntent(intent);
        this.stopSelf(startId);
        return 2;
    }

    private void onHandleIntent(Intent intent) {
        boolean enabled;
        String summary;
        try {
            summary = this.onGetSummary();
        }
        catch (RuntimeException e) {
            this.sendStatus(intent, null, true);
            throw e;
        }
        try {
            enabled = this.onGetEnabled();
        }
        catch (RuntimeException e) {
            this.sendStatus(intent, summary, true);
            throw e;
        }
        this.sendStatus(intent, summary, enabled);
    }

    private void sendStatus(Intent intent, String summary, boolean enabled) {
        Message message = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putString(SUMMARY_KEY, summary);
        bundle.putBoolean(ENABLED_KEY, enabled);
        message.setData(bundle);
        if (Log.isLoggable(TAG, 3)) {
            Log.d(TAG, this.mName + ": received " + intent + ", summary=" + summary + ", enabled=" + enabled + ", sending message: " + message);
        }
        Messenger messenger = (Messenger)intent.getParcelableExtra(MESSENGER_KEY);
        try {
            messenger.send(message);
        }
        catch (RemoteException e) {
            Log.e(TAG, this.mName + ": sending dynamic status failed", e);
        }
    }

    protected abstract String onGetSummary();

    protected abstract boolean onGetEnabled();
}

