/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.DataSource;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.net.Uri;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaExtractor {
    public static final int SEEK_TO_PREVIOUS_SYNC = 0;
    public static final int SEEK_TO_NEXT_SYNC = 1;
    public static final int SEEK_TO_CLOSEST_SYNC = 2;
    public static final int SAMPLE_FLAG_SYNC = 1;
    public static final int SAMPLE_FLAG_ENCRYPTED = 2;
    private long mNativeContext;

    public MediaExtractor() {
        this.native_setup();
    }

    public final native void setDataSource(DataSource var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException ex) {
        }
        catch (IOException ex) {
        }
        finally {
            if (fd != null) {
                fd.close();
            }
        }
        this.setDataSource(uri.toString(), headers);
    }

    public final void setDataSource(String path, Map<String, String> headers) throws IOException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.setDataSource(path, keys, values);
    }

    private final native void setDataSource(String var1, String[] var2, String[] var3) throws IOException;

    public final void setDataSource(String path) throws IOException {
        this.setDataSource(path, null, null);
    }

    public final void setDataSource(FileDescriptor fd) throws IOException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public final native void setDataSource(FileDescriptor var1, long var2, long var4) throws IOException;

    protected void finalize() {
        this.native_finalize();
    }

    public final native void release();

    public final native int getTrackCount();

    public Map<UUID, byte[]> getPsshInfo() {
        HashMap<UUID, byte[]> psshMap = null;
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap != null && formatMap.containsKey("pssh")) {
            ByteBuffer rawpssh = (ByteBuffer)formatMap.get("pssh");
            rawpssh.order(ByteOrder.nativeOrder());
            rawpssh.rewind();
            formatMap.remove("pssh");
            psshMap = new HashMap<UUID, byte[]>();
            while (rawpssh.remaining() > 0) {
                rawpssh.order(ByteOrder.BIG_ENDIAN);
                long msb = rawpssh.getLong();
                long lsb = rawpssh.getLong();
                UUID uuid = new UUID(msb, lsb);
                rawpssh.order(ByteOrder.nativeOrder());
                int datalen = rawpssh.getInt();
                byte[] psshdata = new byte[datalen];
                rawpssh.get(psshdata);
                psshMap.put(uuid, psshdata);
            }
        }
        return psshMap;
    }

    private native Map<String, Object> getFileFormatNative();

    public MediaFormat getTrackFormat(int index) {
        return new MediaFormat(this.getTrackFormatNative(index));
    }

    private native Map<String, Object> getTrackFormatNative(int var1);

    public native void selectTrack(int var1);

    public native void unselectTrack(int var1);

    public native void seekTo(long var1, int var3);

    public native boolean advance();

    public native int readSampleData(ByteBuffer var1, int var2);

    public native int getSampleTrackIndex();

    public native long getSampleTime();

    public native int getSampleFlags();

    public native boolean getSampleCryptoInfo(MediaCodec.CryptoInfo var1);

    public native long getCachedDuration();

    public native boolean hasCacheReachedEndOfStream();

    private static final native void native_init();

    private final native void native_setup();

    private final native void native_finalize();

    static {
        System.loadLibrary("media_jni");
        MediaExtractor.native_init();
    }
}

