/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Handler;
import android.view.Surface;
import dalvik.system.CloseGuard;

public final class RemoteDisplay {
    public static final int DISPLAY_FLAG_SECURE = 1;
    public static final int DISPLAY_ERROR_UNKOWN = 1;
    public static final int DISPLAY_ERROR_CONNECTION_DROPPED = 2;
    private final CloseGuard mGuard = CloseGuard.get();
    private final Listener mListener;
    private final Handler mHandler;
    private long mPtr;

    private native long nativeListen(String var1);

    private native void nativeDispose(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private RemoteDisplay(Listener listener, Handler handler) {
        this.mListener = listener;
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public static RemoteDisplay listen(String iface, Listener listener, Handler handler) {
        if (iface == null) {
            throw new IllegalArgumentException("iface must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        RemoteDisplay display = new RemoteDisplay(listener, handler);
        display.startListening(iface);
        return display;
    }

    public void dispose() {
        this.dispose(false);
    }

    public void pause() {
        this.nativePause(this.mPtr);
    }

    public void resume() {
        this.nativeResume(this.mPtr);
    }

    private void dispose(boolean finalized) {
        if (this.mPtr != 0L) {
            if (this.mGuard != null) {
                if (finalized) {
                    this.mGuard.warnIfOpen();
                } else {
                    this.mGuard.close();
                }
            }
            this.nativeDispose(this.mPtr);
            this.mPtr = 0L;
        }
    }

    private void startListening(String iface) {
        this.mPtr = this.nativeListen(iface);
        if (this.mPtr == 0L) {
            throw new IllegalStateException("Could not start listening for remote display connection on \"" + iface + "\"");
        }
        this.mGuard.open("dispose");
    }

    private void notifyDisplayConnected(final Surface surface, final int width, final int height, final int flags, final int session) {
        this.mHandler.post(new Runnable(){

            public void run() {
                RemoteDisplay.this.mListener.onDisplayConnected(surface, width, height, flags, session);
            }
        });
    }

    private void notifyDisplayDisconnected() {
        this.mHandler.post(new Runnable(){

            public void run() {
                RemoteDisplay.this.mListener.onDisplayDisconnected();
            }
        });
    }

    private void notifyDisplayError(final int error) {
        this.mHandler.post(new Runnable(){

            public void run() {
                RemoteDisplay.this.mListener.onDisplayError(error);
            }
        });
    }

    public static interface Listener {
        public void onDisplayConnected(Surface var1, int var2, int var3, int var4, int var5);

        public void onDisplayDisconnected();

        public void onDisplayError(int var1);
    }
}

