/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.SystemProperties;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SoundPool {
    private final SoundPoolDelegate mImpl;

    public SoundPool(int maxStreams, int streamType, int srcQuality) {
        this.mImpl = SystemProperties.getBoolean("config.disable_media", false) ? new SoundPoolStub() : new SoundPoolImpl(this, maxStreams, streamType, srcQuality);
    }

    public int load(String path, int priority) {
        return this.mImpl.load(path, priority);
    }

    public int load(Context context, int resId, int priority) {
        return this.mImpl.load(context, resId, priority);
    }

    public int load(AssetFileDescriptor afd, int priority) {
        return this.mImpl.load(afd, priority);
    }

    public int load(FileDescriptor fd, long offset, long length, int priority) {
        return this.mImpl.load(fd, offset, length, priority);
    }

    public final boolean unload(int soundID) {
        return this.mImpl.unload(soundID);
    }

    public final int play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
        return this.mImpl.play(soundID, leftVolume, rightVolume, priority, loop, rate);
    }

    public final void pause(int streamID) {
        this.mImpl.pause(streamID);
    }

    public final void resume(int streamID) {
        this.mImpl.resume(streamID);
    }

    public final void autoPause() {
        this.mImpl.autoPause();
    }

    public final void autoResume() {
        this.mImpl.autoResume();
    }

    public final void stop(int streamID) {
        this.mImpl.stop(streamID);
    }

    public final void setVolume(int streamID, float leftVolume, float rightVolume) {
        this.mImpl.setVolume(streamID, leftVolume, rightVolume);
    }

    public void setVolume(int streamID, float volume) {
        this.setVolume(streamID, volume, volume);
    }

    public final void setPriority(int streamID, int priority) {
        this.mImpl.setPriority(streamID, priority);
    }

    public final void setLoop(int streamID, int loop) {
        this.mImpl.setLoop(streamID, loop);
    }

    public final void setRate(int streamID, float rate) {
        this.mImpl.setRate(streamID, rate);
    }

    public void setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        this.mImpl.setOnLoadCompleteListener(listener);
    }

    public final void release() {
        this.mImpl.release();
    }

    static class SoundPoolStub
    implements SoundPoolDelegate {
        public int load(String path, int priority) {
            return 0;
        }

        public int load(Context context, int resId, int priority) {
            return 0;
        }

        public int load(AssetFileDescriptor afd, int priority) {
            return 0;
        }

        public int load(FileDescriptor fd, long offset, long length, int priority) {
            return 0;
        }

        public final boolean unload(int soundID) {
            return true;
        }

        public final int play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
            return 0;
        }

        public final void pause(int streamID) {
        }

        public final void resume(int streamID) {
        }

        public final void autoPause() {
        }

        public final void autoResume() {
        }

        public final void stop(int streamID) {
        }

        public final void setVolume(int streamID, float leftVolume, float rightVolume) {
        }

        public void setVolume(int streamID, float volume) {
        }

        public final void setPriority(int streamID, int priority) {
        }

        public final void setLoop(int streamID, int loop) {
        }

        public final void setRate(int streamID, float rate) {
        }

        public void setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        }

        public final void release() {
        }
    }

    static class SoundPoolImpl
    implements SoundPoolDelegate {
        private static final String TAG = "SoundPool";
        private static final boolean DEBUG = false;
        private long mNativeContext;
        private EventHandler mEventHandler;
        private OnLoadCompleteListener mOnLoadCompleteListener;
        private SoundPool mProxy;
        private final Object mLock;
        private static final int SAMPLE_LOADED = 1;

        public SoundPoolImpl(SoundPool proxy, int maxStreams, int streamType, int srcQuality) {
            if (this.native_setup(new WeakReference<SoundPoolImpl>(this), maxStreams, streamType, srcQuality) != 0) {
                throw new RuntimeException("Native setup failed");
            }
            this.mLock = new Object();
            this.mProxy = proxy;
        }

        public int load(String path, int priority) {
            if (path.startsWith("http:")) {
                return this._load(path, priority);
            }
            int id2 = 0;
            try {
                File f = new File(path);
                ParcelFileDescriptor fd = ParcelFileDescriptor.open(f, 0x10000000);
                if (fd != null) {
                    id2 = this._load(fd.getFileDescriptor(), 0L, f.length(), priority);
                    fd.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "error loading " + path);
            }
            return id2;
        }

        public int load(Context context, int resId, int priority) {
            AssetFileDescriptor afd = context.getResources().openRawResourceFd(resId);
            int id2 = 0;
            if (afd != null) {
                id2 = this._load(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), priority);
                try {
                    afd.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return id2;
        }

        public int load(AssetFileDescriptor afd, int priority) {
            if (afd != null) {
                long len = afd.getLength();
                if (len < 0L) {
                    throw new AndroidRuntimeException("no length for fd");
                }
                return this._load(afd.getFileDescriptor(), afd.getStartOffset(), len, priority);
            }
            return 0;
        }

        public int load(FileDescriptor fd, long offset, long length, int priority) {
            return this._load(fd, offset, length, priority);
        }

        private final native int _load(String var1, int var2);

        private final native int _load(FileDescriptor var1, long var2, long var4, int var6);

        public final native boolean unload(int var1);

        public final native int play(int var1, float var2, float var3, int var4, int var5, float var6);

        public final native void pause(int var1);

        public final native void resume(int var1);

        public final native void autoPause();

        public final native void autoResume();

        public final native void stop(int var1);

        public final native void setVolume(int var1, float var2, float var3);

        public void setVolume(int streamID, float volume) {
            this.setVolume(streamID, volume, volume);
        }

        public final native void setPriority(int var1, int var2);

        public final native void setLoop(int var1, int var2);

        public final native void setRate(int var1, float var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOnLoadCompleteListener(OnLoadCompleteListener listener) {
            Object object = this.mLock;
            synchronized (object) {
                Looper looper;
                this.mEventHandler = listener != null ? ((looper = Looper.myLooper()) != null ? new EventHandler(this.mProxy, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this.mProxy, looper) : null)) : null;
                this.mOnLoadCompleteListener = listener;
            }
        }

        private static void postEventFromNative(Object weakRef, int msg, int arg1, int arg2, Object obj) {
            SoundPoolImpl soundPoolImpl = (SoundPoolImpl)((WeakReference)weakRef).get();
            if (soundPoolImpl == null) {
                return;
            }
            if (soundPoolImpl.mEventHandler != null) {
                Message m = soundPoolImpl.mEventHandler.obtainMessage(msg, arg1, arg2, obj);
                soundPoolImpl.mEventHandler.sendMessage(m);
            }
        }

        public final native void release();

        private final native int native_setup(Object var1, int var2, int var3, int var4);

        protected void finalize() {
            this.release();
        }

        static {
            System.loadLibrary("soundpool");
        }

        private class EventHandler
        extends Handler {
            private SoundPool mSoundPool;

            public EventHandler(SoundPool soundPool, Looper looper) {
                super(looper);
                this.mSoundPool = soundPool;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        Object object = SoundPoolImpl.this.mLock;
                        synchronized (object) {
                            if (SoundPoolImpl.this.mOnLoadCompleteListener != null) {
                                SoundPoolImpl.this.mOnLoadCompleteListener.onLoadComplete(this.mSoundPool, msg.arg1, msg.arg2);
                            }
                            break;
                        }
                    }
                    default: {
                        Log.e(SoundPoolImpl.TAG, "Unknown message type " + msg.what);
                        return;
                    }
                }
            }
        }
    }

    static interface SoundPoolDelegate {
        public int load(String var1, int var2);

        public int load(Context var1, int var2, int var3);

        public int load(AssetFileDescriptor var1, int var2);

        public int load(FileDescriptor var1, long var2, long var4, int var6);

        public boolean unload(int var1);

        public int play(int var1, float var2, float var3, int var4, int var5, float var6);

        public void pause(int var1);

        public void resume(int var1);

        public void autoPause();

        public void autoResume();

        public void stop(int var1);

        public void setVolume(int var1, float var2, float var3);

        public void setVolume(int var1, float var2);

        public void setPriority(int var1, int var2);

        public void setLoop(int var1, int var2);

        public void setRate(int var1, float var2);

        public void setOnLoadCompleteListener(OnLoadCompleteListener var1);

        public void release();
    }

    public static interface OnLoadCompleteListener {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }
}

