/*
 * Decompiled with CFR 0.152.
 */
package android.media.effect;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.GraphRunner;
import android.filterfw.core.SyncRunner;
import android.filterfw.io.GraphIOException;
import android.filterfw.io.GraphReader;
import android.filterfw.io.TextGraphReader;
import android.media.effect.EffectContext;
import android.media.effect.FilterEffect;

public class FilterGraphEffect
extends FilterEffect {
    private static final String TAG = "FilterGraphEffect";
    protected String mInputName;
    protected String mOutputName;
    protected GraphRunner mRunner;
    protected FilterGraph mGraph;
    protected Class mSchedulerClass;

    public FilterGraphEffect(EffectContext context, String name, String graphString, String inputName, String outputName, Class scheduler) {
        super(context, name);
        this.mInputName = inputName;
        this.mOutputName = outputName;
        this.mSchedulerClass = scheduler;
        this.createGraph(graphString);
    }

    private void createGraph(String graphString) {
        TextGraphReader reader = new TextGraphReader();
        try {
            this.mGraph = ((GraphReader)reader).readGraphString(graphString);
        }
        catch (GraphIOException e) {
            throw new RuntimeException("Could not setup effect", e);
        }
        if (this.mGraph == null) {
            throw new RuntimeException("Could not setup effect");
        }
        this.mRunner = new SyncRunner(this.getFilterContext(), this.mGraph, this.mSchedulerClass);
    }

    public void apply(int inputTexId, int width, int height, int outputTexId) {
        this.beginGLEffect();
        Filter src = this.mGraph.getFilter(this.mInputName);
        if (src == null) {
            throw new RuntimeException("Internal error applying effect");
        }
        src.setInputValue("texId", inputTexId);
        src.setInputValue("width", width);
        src.setInputValue("height", height);
        Filter dest = this.mGraph.getFilter(this.mOutputName);
        if (dest == null) {
            throw new RuntimeException("Internal error applying effect");
        }
        dest.setInputValue("texId", outputTexId);
        try {
            this.mRunner.run();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Internal error applying effect: ", e);
        }
        this.endGLEffect();
    }

    public void setParameter(String parameterKey, Object value) {
    }

    public void release() {
        this.mGraph.tearDown(this.getFilterContext());
        this.mGraph = null;
    }
}

