/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;
import libcore.io.OsConstants;

public class LinkAddress
implements Parcelable {
    private InetAddress address;
    private int prefixLength;
    private int flags;
    private int scope;
    public static final Parcelable.Creator<LinkAddress> CREATOR = new Parcelable.Creator<LinkAddress>(){

        @Override
        public LinkAddress createFromParcel(Parcel in) {
            InetAddress address = null;
            try {
                address = InetAddress.getByAddress(in.createByteArray());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            int prefixLength = in.readInt();
            int flags = in.readInt();
            int scope = in.readInt();
            return new LinkAddress(address, prefixLength, flags, scope);
        }

        public LinkAddress[] newArray(int size) {
            return new LinkAddress[size];
        }
    };

    static int scopeForUnicastAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress()) {
            return OsConstants.RT_SCOPE_HOST;
        }
        if (addr.isLoopbackAddress() || addr.isLinkLocalAddress()) {
            return OsConstants.RT_SCOPE_LINK;
        }
        if (!(addr instanceof Inet4Address) && addr.isSiteLocalAddress()) {
            return OsConstants.RT_SCOPE_SITE;
        }
        return OsConstants.RT_SCOPE_UNIVERSE;
    }

    private void init(InetAddress address, int prefixLength, int flags, int scope) {
        if (address == null || address.isMulticastAddress() || prefixLength < 0 || address instanceof Inet4Address && prefixLength > 32 || prefixLength > 128) {
            throw new IllegalArgumentException("Bad LinkAddress params " + address + "/" + prefixLength);
        }
        this.address = address;
        this.prefixLength = prefixLength;
        this.flags = flags;
        this.scope = scope;
    }

    public LinkAddress(InetAddress address, int prefixLength, int flags, int scope) {
        this.init(address, prefixLength, flags, scope);
    }

    public LinkAddress(InetAddress address, int prefixLength) {
        this(address, prefixLength, 0, 0);
        this.scope = LinkAddress.scopeForUnicastAddress(address);
    }

    public LinkAddress(InterfaceAddress interfaceAddress) {
        this(interfaceAddress.getAddress(), interfaceAddress.getNetworkPrefixLength());
    }

    public LinkAddress(String address) {
        this(address, 0, 0);
        this.scope = LinkAddress.scopeForUnicastAddress(this.address);
    }

    public LinkAddress(String address, int flags, int scope) {
        InetAddress inetAddress = null;
        int prefixLength = -1;
        try {
            String[] pieces = address.split("/", 2);
            prefixLength = Integer.parseInt(pieces[1]);
            inetAddress = InetAddress.parseNumericAddress(pieces[0]);
        }
        catch (NullPointerException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (NumberFormatException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (inetAddress == null || prefixLength == -1) {
            throw new IllegalArgumentException("Bad LinkAddress params " + address);
        }
        this.init(inetAddress, prefixLength, flags, scope);
    }

    public String toString() {
        return this.address.getHostAddress() + "/" + this.prefixLength;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LinkAddress)) {
            return false;
        }
        LinkAddress linkAddress = (LinkAddress)obj;
        return this.address.equals(linkAddress.address) && this.prefixLength == linkAddress.prefixLength && this.flags == linkAddress.flags && this.scope == linkAddress.scope;
    }

    public int hashCode() {
        return this.address.hashCode() + 11 * this.prefixLength + 19 * this.flags + 43 * this.scope;
    }

    public boolean isSameAddressAs(LinkAddress other) {
        return this.address.equals(other.address) && this.prefixLength == other.prefixLength;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getNetworkPrefixLength() {
        return this.prefixLength;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getScope() {
        return this.scope;
    }

    public boolean isGlobalPreferred() {
        return this.scope == OsConstants.RT_SCOPE_UNIVERSE && (long)(this.flags & (OsConstants.IFA_F_DADFAILED | OsConstants.IFA_F_DEPRECATED | OsConstants.IFA_F_TENTATIVE)) == 0L;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.address.getAddress());
        dest.writeInt(this.prefixLength);
        dest.writeInt(this.flags);
        dest.writeInt(this.scope);
    }
}

