/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlQuerySanitizer {
    private final HashMap<String, ValueSanitizer> mSanitizers = new HashMap();
    private final HashMap<String, String> mEntries = new HashMap();
    private final ArrayList<ParameterValuePair> mEntriesList = new ArrayList();
    private boolean mAllowUnregisteredParamaters;
    private boolean mPreferFirstRepeatedParameter;
    private ValueSanitizer mUnregisteredParameterValueSanitizer = UrlQuerySanitizer.getAllIllegal();
    private static final ValueSanitizer sAllIllegal = new IllegalCharacterValueSanitizer(0);
    private static final ValueSanitizer sAllButNulLegal = new IllegalCharacterValueSanitizer(1535);
    private static final ValueSanitizer sAllButWhitespaceLegal = new IllegalCharacterValueSanitizer(1532);
    private static final ValueSanitizer sURLLegal = new IllegalCharacterValueSanitizer(404);
    private static final ValueSanitizer sUrlAndSpaceLegal = new IllegalCharacterValueSanitizer(405);
    private static final ValueSanitizer sAmpLegal = new IllegalCharacterValueSanitizer(128);
    private static final ValueSanitizer sAmpAndSpaceLegal = new IllegalCharacterValueSanitizer(129);
    private static final ValueSanitizer sSpaceLegal = new IllegalCharacterValueSanitizer(1);
    private static final ValueSanitizer sAllButNulAndAngleBracketsLegal = new IllegalCharacterValueSanitizer(1439);

    public ValueSanitizer getUnregisteredParameterValueSanitizer() {
        return this.mUnregisteredParameterValueSanitizer;
    }

    public void setUnregisteredParameterValueSanitizer(ValueSanitizer sanitizer) {
        this.mUnregisteredParameterValueSanitizer = sanitizer;
    }

    public static final ValueSanitizer getAllIllegal() {
        return sAllIllegal;
    }

    public static final ValueSanitizer getAllButNulLegal() {
        return sAllButNulLegal;
    }

    public static final ValueSanitizer getAllButWhitespaceLegal() {
        return sAllButWhitespaceLegal;
    }

    public static final ValueSanitizer getUrlLegal() {
        return sURLLegal;
    }

    public static final ValueSanitizer getUrlAndSpaceLegal() {
        return sUrlAndSpaceLegal;
    }

    public static final ValueSanitizer getAmpLegal() {
        return sAmpLegal;
    }

    public static final ValueSanitizer getAmpAndSpaceLegal() {
        return sAmpAndSpaceLegal;
    }

    public static final ValueSanitizer getSpaceLegal() {
        return sSpaceLegal;
    }

    public static final ValueSanitizer getAllButNulAndAngleBracketsLegal() {
        return sAllButNulAndAngleBracketsLegal;
    }

    public UrlQuerySanitizer() {
    }

    public UrlQuerySanitizer(String url) {
        this.setAllowUnregisteredParamaters(true);
        this.parseUrl(url);
    }

    public void parseUrl(String url) {
        int queryIndex = url.indexOf(63);
        String query = queryIndex >= 0 ? url.substring(queryIndex + 1) : "";
        this.parseQuery(query);
    }

    public void parseQuery(String query) {
        this.clear();
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreElements()) {
            String attributeValuePair = tokenizer.nextToken();
            if (attributeValuePair.length() <= 0) continue;
            int assignmentIndex = attributeValuePair.indexOf(61);
            if (assignmentIndex < 0) {
                this.parseEntry(attributeValuePair, "");
                continue;
            }
            this.parseEntry(attributeValuePair.substring(0, assignmentIndex), attributeValuePair.substring(assignmentIndex + 1));
        }
    }

    public Set<String> getParameterSet() {
        return this.mEntries.keySet();
    }

    public List<ParameterValuePair> getParameterList() {
        return this.mEntriesList;
    }

    public boolean hasParameter(String parameter) {
        return this.mEntries.containsKey(parameter);
    }

    public String getValue(String parameter) {
        return this.mEntries.get(parameter);
    }

    public void registerParameter(String parameter, ValueSanitizer valueSanitizer) {
        if (valueSanitizer == null) {
            this.mSanitizers.remove(parameter);
        }
        this.mSanitizers.put(parameter, valueSanitizer);
    }

    public void registerParameters(String[] parameters, ValueSanitizer valueSanitizer) {
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            this.mSanitizers.put(parameters[i], valueSanitizer);
        }
    }

    public void setAllowUnregisteredParamaters(boolean allowUnregisteredParamaters) {
        this.mAllowUnregisteredParamaters = allowUnregisteredParamaters;
    }

    public boolean getAllowUnregisteredParamaters() {
        return this.mAllowUnregisteredParamaters;
    }

    public void setPreferFirstRepeatedParameter(boolean preferFirstRepeatedParameter) {
        this.mPreferFirstRepeatedParameter = preferFirstRepeatedParameter;
    }

    public boolean getPreferFirstRepeatedParameter() {
        return this.mPreferFirstRepeatedParameter;
    }

    protected void parseEntry(String parameter, String value) {
        String unescapedParameter = this.unescape(parameter);
        ValueSanitizer valueSanitizer = this.getEffectiveValueSanitizer(unescapedParameter);
        if (valueSanitizer == null) {
            return;
        }
        String unescapedValue = this.unescape(value);
        String sanitizedValue = valueSanitizer.sanitize(unescapedValue);
        this.addSanitizedEntry(unescapedParameter, sanitizedValue);
    }

    protected void addSanitizedEntry(String parameter, String value) {
        this.mEntriesList.add(new ParameterValuePair(parameter, value));
        if (this.mPreferFirstRepeatedParameter && this.mEntries.containsKey(parameter)) {
            return;
        }
        this.mEntries.put(parameter, value);
    }

    public ValueSanitizer getValueSanitizer(String parameter) {
        return this.mSanitizers.get(parameter);
    }

    public ValueSanitizer getEffectiveValueSanitizer(String parameter) {
        ValueSanitizer sanitizer = this.getValueSanitizer(parameter);
        if (sanitizer == null && this.mAllowUnregisteredParamaters) {
            sanitizer = this.getUnregisteredParameterValueSanitizer();
        }
        return sanitizer;
    }

    public String unescape(String string2) {
        int firstEscape = string2.indexOf(37);
        if (firstEscape < 0 && (firstEscape = string2.indexOf(43)) < 0) {
            return string2;
        }
        int length = string2.length();
        StringBuilder stringBuilder = new StringBuilder(length);
        stringBuilder.append(string2.substring(0, firstEscape));
        for (int i = firstEscape; i < length; ++i) {
            char c = string2.charAt(i);
            if (c == '+') {
                c = ' ';
            } else if (c == '%' && i + 2 < length) {
                char c1 = string2.charAt(i + 1);
                char c2 = string2.charAt(i + 2);
                if (this.isHexDigit(c1) && this.isHexDigit(c2)) {
                    c = (char)(this.decodeHexDigit(c1) * 16 + this.decodeHexDigit(c2));
                    i += 2;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    protected boolean isHexDigit(char c) {
        return this.decodeHexDigit(c) >= 0;
    }

    protected int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    protected void clear() {
        this.mEntries.clear();
        this.mEntriesList.clear();
    }

    public static class IllegalCharacterValueSanitizer
    implements ValueSanitizer {
        private int mFlags;
        public static final int SPACE_OK = 1;
        public static final int OTHER_WHITESPACE_OK = 2;
        public static final int NON_7_BIT_ASCII_OK = 4;
        public static final int DQUOTE_OK = 8;
        public static final int SQUOTE_OK = 16;
        public static final int LT_OK = 32;
        public static final int GT_OK = 64;
        public static final int AMP_OK = 128;
        public static final int PCT_OK = 256;
        public static final int NUL_OK = 512;
        public static final int SCRIPT_URL_OK = 1024;
        public static final int ALL_OK = 2047;
        public static final int ALL_WHITESPACE_OK = 3;
        public static final int ALL_ILLEGAL = 0;
        public static final int ALL_BUT_NUL_LEGAL = 1535;
        public static final int ALL_BUT_WHITESPACE_LEGAL = 1532;
        public static final int URL_LEGAL = 404;
        public static final int URL_AND_SPACE_LEGAL = 405;
        public static final int AMP_LEGAL = 128;
        public static final int AMP_AND_SPACE_LEGAL = 129;
        public static final int SPACE_LEGAL = 1;
        public static final int ALL_BUT_NUL_AND_ANGLE_BRACKETS_LEGAL = 1439;
        private static final String JAVASCRIPT_PREFIX = "javascript:";
        private static final String VBSCRIPT_PREFIX = "vbscript:";
        private static final int MIN_SCRIPT_PREFIX_LENGTH = Math.min("javascript:".length(), "vbscript:".length());

        public IllegalCharacterValueSanitizer(int flags) {
            this.mFlags = flags;
        }

        public String sanitize(String value) {
            String asLower;
            if (value == null) {
                return null;
            }
            int length = value.length();
            if ((this.mFlags & 0x400) != 0 && length >= MIN_SCRIPT_PREFIX_LENGTH && ((asLower = value.toLowerCase(Locale.ROOT)).startsWith(JAVASCRIPT_PREFIX) || asLower.startsWith(VBSCRIPT_PREFIX))) {
                return "";
            }
            if ((this.mFlags & 3) == 0) {
                value = this.trimWhitespace(value);
                length = value.length();
            }
            StringBuilder stringBuilder = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                int c = value.charAt(i);
                if (!this.characterIsLegal((char)c)) {
                    c = (this.mFlags & 1) != 0 ? 32 : 95;
                }
                stringBuilder.append((char)c);
            }
            return stringBuilder.toString();
        }

        private String trimWhitespace(String value) {
            int start;
            int last;
            int end = last = value.length() - 1;
            for (start = 0; start <= end && this.isWhitespace(value.charAt(start)); ++start) {
            }
            while (end >= start && this.isWhitespace(value.charAt(end))) {
                --end;
            }
            if (start == 0 && end == last) {
                return value;
            }
            return value.substring(start, end + 1);
        }

        private boolean isWhitespace(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        private boolean characterIsLegal(char c) {
            switch (c) {
                case ' ': {
                    return (this.mFlags & 1) != 0;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': {
                    return (this.mFlags & 2) != 0;
                }
                case '\"': {
                    return (this.mFlags & 8) != 0;
                }
                case '\'': {
                    return (this.mFlags & 0x10) != 0;
                }
                case '<': {
                    return (this.mFlags & 0x20) != 0;
                }
                case '>': {
                    return (this.mFlags & 0x40) != 0;
                }
                case '&': {
                    return (this.mFlags & 0x80) != 0;
                }
                case '%': {
                    return (this.mFlags & 0x100) != 0;
                }
                case '\u0000': {
                    return (this.mFlags & 0x200) != 0;
                }
            }
            return c >= ' ' && c < '\u007f' || c >= '\u0080' && (this.mFlags & 4) != 0;
        }
    }

    public static interface ValueSanitizer {
        public String sanitize(String var1);
    }

    public class ParameterValuePair {
        public String mParameter;
        public String mValue;

        public ParameterValuePair(String parameter, String value) {
            this.mParameter = parameter;
            this.mValue = value;
        }
    }
}

