/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import android.net.rtp.AudioCodec;
import android.net.rtp.AudioStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AudioGroup {
    public static final int MODE_ON_HOLD = 0;
    public static final int MODE_MUTED = 1;
    public static final int MODE_NORMAL = 2;
    public static final int MODE_ECHO_SUPPRESSION = 3;
    private static final int MODE_LAST = 3;
    private final Map<AudioStream, Long> mStreams = new HashMap<AudioStream, Long>();
    private int mMode = 0;
    private long mNative;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioStream[] getStreams() {
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            return this.mStreams.keySet().toArray(new AudioStream[this.mStreams.size()]);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException("Invalid mode");
        }
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.nativeSetMode(mode);
            this.mMode = mode;
        }
    }

    private native void nativeSetMode(int var1);

    synchronized void add(AudioStream stream) {
        if (!this.mStreams.containsKey(stream)) {
            try {
                AudioCodec codec = stream.getCodec();
                String codecSpec = String.format(Locale.US, "%d %s %s", codec.type, codec.rtpmap, codec.fmtp);
                long id2 = this.nativeAdd(stream.getMode(), stream.getSocket(), stream.getRemoteAddress().getHostAddress(), stream.getRemotePort(), codecSpec, stream.getDtmfType());
                this.mStreams.put(stream, id2);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private native long nativeAdd(int var1, int var2, String var3, int var4, String var5, int var6);

    synchronized void remove(AudioStream stream) {
        Long id2 = this.mStreams.remove(stream);
        if (id2 != null) {
            this.nativeRemove(id2);
        }
    }

    private native void nativeRemove(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDtmf(int event) {
        if (event < 0 || event > 15) {
            throw new IllegalArgumentException("Invalid event");
        }
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.nativeSendDtmf(event);
        }
    }

    private native void nativeSendDtmf(int var1);

    public void clear() {
        for (AudioStream stream : this.getStreams()) {
            stream.join(null);
        }
    }

    protected void finalize() throws Throwable {
        this.nativeRemove(0L);
        super.finalize();
    }

    static {
        System.loadLibrary("rtp_jni");
    }
}

