/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.content.Context;
import android.media.AudioManager;
import android.net.rtp.AudioCodec;
import android.net.rtp.AudioGroup;
import android.net.rtp.AudioStream;
import android.net.sip.SimpleSessionDescription;
import android.net.sip.SipErrorCode;
import android.net.sip.SipException;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.net.sip.SipSession;
import android.net.wifi.WifiManager;
import android.os.Message;
import android.telephony.Rlog;
import android.text.TextUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SipAudioCall {
    private static final String LOG_TAG = SipAudioCall.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean RELEASE_SOCKET = true;
    private static final boolean DONT_RELEASE_SOCKET = false;
    private static final int SESSION_TIMEOUT = 5;
    private static final int TRANSFER_TIMEOUT = 15;
    private Context mContext;
    private SipProfile mLocalProfile;
    private Listener mListener;
    private SipSession mSipSession;
    private SipSession mTransferringSession;
    private long mSessionId = System.currentTimeMillis();
    private String mPeerSd;
    private AudioStream mAudioStream;
    private AudioGroup mAudioGroup;
    private boolean mInCall = false;
    private boolean mMuted = false;
    private boolean mHold = false;
    private WifiManager mWm;
    private WifiManager.WifiLock mWifiHighPerfLock;
    private int mErrorCode = 0;
    private String mErrorMessage;

    public SipAudioCall(Context context, SipProfile localProfile) {
        this.mContext = context;
        this.mLocalProfile = localProfile;
        this.mWm = (WifiManager)context.getSystemService("wifi");
    }

    public void setListener(Listener listener) {
        this.setListener(listener, false);
    }

    public void setListener(Listener listener, boolean callbackImmediately) {
        this.mListener = listener;
        try {
            if (listener != null && callbackImmediately) {
                if (this.mErrorCode != 0) {
                    listener.onError(this, this.mErrorCode, this.mErrorMessage);
                } else if (this.mInCall) {
                    if (this.mHold) {
                        listener.onCallHeld(this);
                    } else {
                        listener.onCallEstablished(this);
                    }
                } else {
                    int state = this.getState();
                    switch (state) {
                        case 0: {
                            listener.onReadyToCall(this);
                            break;
                        }
                        case 3: {
                            listener.onRinging(this, this.getPeerProfile());
                            break;
                        }
                        case 5: {
                            listener.onCalling(this);
                            break;
                        }
                        case 6: {
                            listener.onRingingBack(this);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            this.loge("setListener()", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInCall() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            return this.mInCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnHold() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            return this.mHold;
        }
    }

    public void close() {
        this.close(true);
    }

    private synchronized void close(boolean closeRtp) {
        if (closeRtp) {
            this.stopCall(true);
        }
        this.mInCall = false;
        this.mHold = false;
        this.mSessionId = System.currentTimeMillis();
        this.mErrorCode = 0;
        this.mErrorMessage = null;
        if (this.mSipSession != null) {
            this.mSipSession.setListener(null);
            this.mSipSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipProfile getLocalProfile() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            return this.mLocalProfile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipProfile getPeerProfile() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            return this.mSipSession == null ? null : this.mSipSession.getPeerProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            if (this.mSipSession == null) {
                return 0;
            }
            return this.mSipSession.getState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipSession getSipSession() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            return this.mSipSession;
        }
    }

    private synchronized void transferToNewSession() {
        if (this.mTransferringSession == null) {
            return;
        }
        SipSession origin = this.mSipSession;
        this.mSipSession = this.mTransferringSession;
        this.mTransferringSession = null;
        if (this.mAudioStream != null) {
            this.mAudioStream.join(null);
        } else {
            try {
                this.mAudioStream = new AudioStream(InetAddress.getByName(this.getLocalIp()));
            }
            catch (Throwable t) {
                this.loge("transferToNewSession():", t);
            }
        }
        if (origin != null) {
            origin.endCall();
        }
        this.startAudio();
    }

    private SipSession.Listener createListener() {
        return new SipSession.Listener(){

            public void onCalling(SipSession session) {
                SipAudioCall.this.log("onCalling: session=" + session);
                Listener listener = SipAudioCall.this.mListener;
                if (listener != null) {
                    try {
                        listener.onCalling(SipAudioCall.this);
                    }
                    catch (Throwable t) {
                        SipAudioCall.this.loge("onCalling():", t);
                    }
                }
            }

            public void onRingingBack(SipSession session) {
                SipAudioCall.this.log("onRingingBackk: " + session);
                Listener listener = SipAudioCall.this.mListener;
                if (listener != null) {
                    try {
                        listener.onRingingBack(SipAudioCall.this);
                    }
                    catch (Throwable t) {
                        SipAudioCall.this.loge("onRingingBack():", t);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRinging(SipSession session, SipProfile peerProfile, String sessionDescription) {
                SipAudioCall sipAudioCall = SipAudioCall.this;
                synchronized (sipAudioCall) {
                    if (SipAudioCall.this.mSipSession == null || !SipAudioCall.this.mInCall || !session.getCallId().equals(SipAudioCall.this.mSipSession.getCallId())) {
                        session.endCall();
                        return;
                    }
                    try {
                        String answer = SipAudioCall.this.createAnswer(sessionDescription).encode();
                        SipAudioCall.this.mSipSession.answerCall(answer, 5);
                    }
                    catch (Throwable e) {
                        SipAudioCall.this.loge("onRinging():", e);
                        session.endCall();
                    }
                }
            }

            public void onCallEstablished(SipSession session, String sessionDescription) {
                SipAudioCall.this.mPeerSd = sessionDescription;
                SipAudioCall.this.log("onCallEstablished(): " + SipAudioCall.this.mPeerSd);
                if (SipAudioCall.this.mTransferringSession != null && session == SipAudioCall.this.mTransferringSession) {
                    SipAudioCall.this.transferToNewSession();
                    return;
                }
                Listener listener = SipAudioCall.this.mListener;
                if (listener != null) {
                    try {
                        if (SipAudioCall.this.mHold) {
                            listener.onCallHeld(SipAudioCall.this);
                        } else {
                            listener.onCallEstablished(SipAudioCall.this);
                        }
                    }
                    catch (Throwable t) {
                        SipAudioCall.this.loge("onCallEstablished(): ", t);
                    }
                }
            }

            public void onCallEnded(SipSession session) {
                SipAudioCall.this.log("onCallEnded: " + session + " mSipSession:" + SipAudioCall.this.mSipSession);
                if (session == SipAudioCall.this.mTransferringSession) {
                    SipAudioCall.this.mTransferringSession = null;
                    return;
                }
                if (SipAudioCall.this.mTransferringSession != null || session != SipAudioCall.this.mSipSession) {
                    return;
                }
                Listener listener = SipAudioCall.this.mListener;
                if (listener != null) {
                    try {
                        listener.onCallEnded(SipAudioCall.this);
                    }
                    catch (Throwable t) {
                        SipAudioCall.this.loge("onCallEnded(): ", t);
                    }
                }
                SipAudioCall.this.close();
            }

            public void onCallBusy(SipSession session) {
                SipAudioCall.this.log("onCallBusy: " + session);
                Listener listener = SipAudioCall.this.mListener;
                if (listener != null) {
                    try {
                        listener.onCallBusy(SipAudioCall.this);
                    }
                    catch (Throwable t) {
                        SipAudioCall.this.loge("onCallBusy(): ", t);
                    }
                }
                SipAudioCall.this.close(false);
            }

            public void onCallChangeFailed(SipSession session, int errorCode, String message) {
                SipAudioCall.this.log("onCallChangedFailed: " + message);
                SipAudioCall.this.mErrorCode = errorCode;
                SipAudioCall.this.mErrorMessage = message;
                Listener listener = SipAudioCall.this.mListener;
                if (listener != null) {
                    try {
                        listener.onError(SipAudioCall.this, SipAudioCall.this.mErrorCode, message);
                    }
                    catch (Throwable t) {
                        SipAudioCall.this.loge("onCallBusy():", t);
                    }
                }
            }

            public void onError(SipSession session, int errorCode, String message) {
                SipAudioCall.this.onError(errorCode, message);
            }

            public void onRegistering(SipSession session) {
            }

            public void onRegistrationTimeout(SipSession session) {
            }

            public void onRegistrationFailed(SipSession session, int errorCode, String message) {
            }

            public void onRegistrationDone(SipSession session, int duration) {
            }

            public void onCallTransferring(SipSession newSession, String sessionDescription) {
                SipAudioCall.this.log("onCallTransferring: mSipSession=" + SipAudioCall.this.mSipSession + " newSession=" + newSession);
                SipAudioCall.this.mTransferringSession = newSession;
                try {
                    if (sessionDescription == null) {
                        newSession.makeCall(newSession.getPeerProfile(), SipAudioCall.this.createOffer().encode(), 15);
                    } else {
                        String answer = SipAudioCall.this.createAnswer(sessionDescription).encode();
                        newSession.answerCall(answer, 5);
                    }
                }
                catch (Throwable e) {
                    SipAudioCall.this.loge("onCallTransferring()", e);
                    newSession.endCall();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(int errorCode, String message) {
        this.log("onError: " + SipErrorCode.toString(errorCode) + ": " + message);
        this.mErrorCode = errorCode;
        this.mErrorMessage = message;
        Listener listener = this.mListener;
        if (listener != null) {
            try {
                listener.onError(this, errorCode, message);
            }
            catch (Throwable t) {
                this.loge("onError():", t);
            }
        }
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            if (errorCode == -10 || !this.isInCall()) {
                this.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachCall(SipSession session, String sessionDescription) throws SipException {
        if (!SipManager.isVoipSupported(this.mContext)) {
            throw new SipException("VOIP API is not supported");
        }
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            this.mSipSession = session;
            this.mPeerSd = sessionDescription;
            this.log("attachCall(): " + this.mPeerSd);
            try {
                session.setListener(this.createListener());
            }
            catch (Throwable e) {
                this.loge("attachCall()", e);
                this.throwSipException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCall(SipProfile peerProfile, SipSession sipSession, int timeout) throws SipException {
        this.log("makeCall: " + peerProfile + " session=" + sipSession + " timeout=" + timeout);
        if (!SipManager.isVoipSupported(this.mContext)) {
            throw new SipException("VOIP API is not supported");
        }
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            this.mSipSession = sipSession;
            try {
                this.mAudioStream = new AudioStream(InetAddress.getByName(this.getLocalIp()));
                sipSession.setListener(this.createListener());
                sipSession.makeCall(peerProfile, this.createOffer().encode(), timeout);
            }
            catch (IOException e) {
                this.loge("makeCall:", e);
                throw new SipException("makeCall()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCall() throws SipException {
        this.log("endCall: mSipSession" + this.mSipSession);
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            this.stopCall(true);
            this.mInCall = false;
            if (this.mSipSession != null) {
                this.mSipSession.endCall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void holdCall(int timeout) throws SipException {
        this.log("holdCall: mSipSession" + this.mSipSession + " timeout=" + timeout);
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            if (this.mHold) {
                return;
            }
            if (this.mSipSession == null) {
                this.loge("holdCall:");
                throw new SipException("Not in a call to hold call");
            }
            this.mSipSession.changeCall(this.createHoldOffer().encode(), timeout);
            this.mHold = true;
            this.setAudioGroupMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void answerCall(int timeout) throws SipException {
        this.log("answerCall: mSipSession" + this.mSipSession + " timeout=" + timeout);
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            if (this.mSipSession == null) {
                throw new SipException("No call to answer");
            }
            try {
                this.mAudioStream = new AudioStream(InetAddress.getByName(this.getLocalIp()));
                this.mSipSession.answerCall(this.createAnswer(this.mPeerSd).encode(), timeout);
            }
            catch (IOException e) {
                this.loge("answerCall:", e);
                throw new SipException("answerCall()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueCall(int timeout) throws SipException {
        this.log("continueCall: mSipSession" + this.mSipSession + " timeout=" + timeout);
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            if (!this.mHold) {
                return;
            }
            this.mSipSession.changeCall(this.createContinueOffer().encode(), timeout);
            this.mHold = false;
            this.setAudioGroupMode();
        }
    }

    private SimpleSessionDescription createOffer() {
        SimpleSessionDescription offer = new SimpleSessionDescription(this.mSessionId, this.getLocalIp());
        AudioCodec[] codecs = AudioCodec.getCodecs();
        SimpleSessionDescription.Media media = offer.newMedia("audio", this.mAudioStream.getLocalPort(), 1, "RTP/AVP");
        for (AudioCodec codec : AudioCodec.getCodecs()) {
            media.setRtpPayload(codec.type, codec.rtpmap, codec.fmtp);
        }
        media.setRtpPayload(127, "telephone-event/8000", "0-15");
        this.log("createOffer: offer=" + offer);
        return offer;
    }

    private SimpleSessionDescription createAnswer(String offerSd) {
        if (TextUtils.isEmpty(offerSd)) {
            return this.createOffer();
        }
        SimpleSessionDescription offer = new SimpleSessionDescription(offerSd);
        SimpleSessionDescription answer = new SimpleSessionDescription(this.mSessionId, this.getLocalIp());
        AudioCodec codec = null;
        for (SimpleSessionDescription.Media media : offer.getMedia()) {
            SimpleSessionDescription.Media reply;
            if (codec == null && media.getPort() > 0 && "audio".equals(media.getType()) && "RTP/AVP".equals(media.getProtocol())) {
                int type;
                int[] arr$ = media.getRtpPayloadTypes();
                int n = arr$.length;
                for (int i$ = 0; i$ < n && (codec = AudioCodec.getCodec(type = arr$[i$], media.getRtpmap(type), media.getFmtp(type))) == null; ++i$) {
                }
                if (codec != null) {
                    reply = answer.newMedia("audio", this.mAudioStream.getLocalPort(), 1, "RTP/AVP");
                    reply.setRtpPayload(codec.type, codec.rtpmap, codec.fmtp);
                    for (int type2 : media.getRtpPayloadTypes()) {
                        String rtpmap = media.getRtpmap(type2);
                        if (type2 == codec.type || rtpmap == null || !rtpmap.startsWith("telephone-event")) continue;
                        reply.setRtpPayload(type2, rtpmap, media.getFmtp(type2));
                    }
                    if (media.getAttribute("recvonly") != null) {
                        answer.setAttribute("sendonly", "");
                        continue;
                    }
                    if (media.getAttribute("sendonly") != null) {
                        answer.setAttribute("recvonly", "");
                        continue;
                    }
                    if (offer.getAttribute("recvonly") != null) {
                        answer.setAttribute("sendonly", "");
                        continue;
                    }
                    if (offer.getAttribute("sendonly") == null) continue;
                    answer.setAttribute("recvonly", "");
                    continue;
                }
            }
            reply = answer.newMedia(media.getType(), 0, 1, media.getProtocol());
            for (String format : media.getFormats()) {
                reply.setFormat(format, null);
            }
        }
        if (codec == null) {
            this.loge("createAnswer: no suitable codes");
            throw new IllegalStateException("Reject SDP: no suitable codecs");
        }
        this.log("createAnswer: answer=" + answer);
        return answer;
    }

    private SimpleSessionDescription createHoldOffer() {
        SimpleSessionDescription offer = this.createContinueOffer();
        offer.setAttribute("sendonly", "");
        this.log("createHoldOffer: offer=" + offer);
        return offer;
    }

    private SimpleSessionDescription createContinueOffer() {
        this.log("createContinueOffer");
        SimpleSessionDescription offer = new SimpleSessionDescription(this.mSessionId, this.getLocalIp());
        SimpleSessionDescription.Media media = offer.newMedia("audio", this.mAudioStream.getLocalPort(), 1, "RTP/AVP");
        AudioCodec codec = this.mAudioStream.getCodec();
        media.setRtpPayload(codec.type, codec.rtpmap, codec.fmtp);
        int dtmfType = this.mAudioStream.getDtmfType();
        if (dtmfType != -1) {
            media.setRtpPayload(dtmfType, "telephone-event/8000", "0-15");
        }
        return offer;
    }

    private void grabWifiHighPerfLock() {
        if (this.mWifiHighPerfLock == null) {
            this.log("grabWifiHighPerfLock:");
            this.mWifiHighPerfLock = ((WifiManager)this.mContext.getSystemService("wifi")).createWifiLock(3, LOG_TAG);
            this.mWifiHighPerfLock.acquire();
        }
    }

    private void releaseWifiHighPerfLock() {
        if (this.mWifiHighPerfLock != null) {
            this.log("releaseWifiHighPerfLock:");
            this.mWifiHighPerfLock.release();
            this.mWifiHighPerfLock = null;
        }
    }

    private boolean isWifiOn() {
        return this.mWm.getConnectionInfo().getBSSID() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleMute() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            this.mMuted = !this.mMuted;
            this.setAudioGroupMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMuted() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            return this.mMuted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeakerMode(boolean speakerMode) {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            ((AudioManager)this.mContext.getSystemService("audio")).setSpeakerphoneOn(speakerMode);
            this.setAudioGroupMode();
        }
    }

    private boolean isSpeakerOn() {
        return ((AudioManager)this.mContext.getSystemService("audio")).isSpeakerphoneOn();
    }

    public void sendDtmf(int code) {
        this.sendDtmf(code, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDtmf(int code, Message result) {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup != null && this.mSipSession != null && 8 == this.getState()) {
                this.log("sendDtmf: code=" + code + " result=" + result);
                audioGroup.sendDtmf(code);
            }
            if (result != null) {
                result.sendToTarget();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioStream getAudioStream() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            return this.mAudioStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioGroup getAudioGroup() {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            if (this.mAudioGroup != null) {
                return this.mAudioGroup;
            }
            return this.mAudioStream == null ? null : this.mAudioStream.getGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAudioGroup(AudioGroup group) {
        SipAudioCall sipAudioCall = this;
        synchronized (sipAudioCall) {
            this.log("setAudioGroup: group=" + group);
            if (this.mAudioStream != null && this.mAudioStream.getGroup() != null) {
                this.mAudioStream.join(group);
            }
            this.mAudioGroup = group;
        }
    }

    public void startAudio() {
        try {
            this.startAudioInternal();
        }
        catch (UnknownHostException e) {
            this.onError(-7, e.getMessage());
        }
        catch (Throwable e) {
            this.onError(-4, e.getMessage());
        }
    }

    private synchronized void startAudioInternal() throws UnknownHostException {
        this.loge("startAudioInternal: mPeerSd=" + this.mPeerSd);
        if (this.mPeerSd == null) {
            throw new IllegalStateException("mPeerSd = null");
        }
        this.stopCall(false);
        this.mInCall = true;
        SimpleSessionDescription offer = new SimpleSessionDescription(this.mPeerSd);
        AudioStream stream = this.mAudioStream;
        AudioCodec codec = null;
        for (SimpleSessionDescription.Media media : offer.getMedia()) {
            int type;
            if (codec != null || media.getPort() <= 0 || !"audio".equals(media.getType()) || !"RTP/AVP".equals(media.getProtocol())) continue;
            int[] arr$ = media.getRtpPayloadTypes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (codec = AudioCodec.getCodec(type = arr$[i$], media.getRtpmap(type), media.getFmtp(type))) == null; ++i$) {
            }
            if (codec == null) continue;
            String address = media.getAddress();
            if (address == null) {
                address = offer.getAddress();
            }
            stream.associate(InetAddress.getByName(address), media.getPort());
            stream.setDtmfType(-1);
            stream.setCodec(codec);
            for (int type2 : media.getRtpPayloadTypes()) {
                String rtpmap = media.getRtpmap(type2);
                if (type2 == codec.type || rtpmap == null || !rtpmap.startsWith("telephone-event")) continue;
                stream.setDtmfType(type2);
            }
            if (this.mHold) {
                stream.setMode(0);
                break;
            }
            if (media.getAttribute("recvonly") != null) {
                stream.setMode(1);
                break;
            }
            if (media.getAttribute("sendonly") != null) {
                stream.setMode(2);
                break;
            }
            if (offer.getAttribute("recvonly") != null) {
                stream.setMode(1);
                break;
            }
            if (offer.getAttribute("sendonly") != null) {
                stream.setMode(2);
                break;
            }
            stream.setMode(0);
            break;
        }
        if (codec == null) {
            throw new IllegalStateException("Reject SDP: no suitable codecs");
        }
        if (this.isWifiOn()) {
            this.grabWifiHighPerfLock();
        }
        AudioGroup audioGroup = this.getAudioGroup();
        if (!this.mHold) {
            if (audioGroup == null) {
                audioGroup = new AudioGroup();
            }
            stream.join(audioGroup);
        }
        this.setAudioGroupMode();
    }

    private void setAudioGroupMode() {
        AudioGroup audioGroup = this.getAudioGroup();
        this.log("setAudioGroupMode: audioGroup=" + audioGroup);
        if (audioGroup != null) {
            if (this.mHold) {
                audioGroup.setMode(0);
            } else if (this.mMuted) {
                audioGroup.setMode(1);
            } else if (this.isSpeakerOn()) {
                audioGroup.setMode(3);
            } else {
                audioGroup.setMode(2);
            }
        }
    }

    private void stopCall(boolean releaseSocket) {
        this.log("stopCall: releaseSocket=" + releaseSocket);
        this.releaseWifiHighPerfLock();
        if (this.mAudioStream != null) {
            this.mAudioStream.join(null);
            if (releaseSocket) {
                this.mAudioStream.release();
                this.mAudioStream = null;
            }
        }
    }

    private String getLocalIp() {
        return this.mSipSession.getLocalIp();
    }

    private void throwSipException(Throwable throwable) throws SipException {
        if (throwable instanceof SipException) {
            throw (SipException)throwable;
        }
        throw new SipException("", throwable);
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private void loge(String s) {
        Rlog.e(LOG_TAG, s);
    }

    private void loge(String s, Throwable t) {
        Rlog.e(LOG_TAG, s, t);
    }

    public static class Listener {
        public void onReadyToCall(SipAudioCall call) {
            this.onChanged(call);
        }

        public void onCalling(SipAudioCall call) {
            this.onChanged(call);
        }

        public void onRinging(SipAudioCall call, SipProfile caller) {
            this.onChanged(call);
        }

        public void onRingingBack(SipAudioCall call) {
            this.onChanged(call);
        }

        public void onCallEstablished(SipAudioCall call) {
            this.onChanged(call);
        }

        public void onCallEnded(SipAudioCall call) {
            this.onChanged(call);
        }

        public void onCallBusy(SipAudioCall call) {
            this.onChanged(call);
        }

        public void onCallHeld(SipAudioCall call) {
            this.onChanged(call);
        }

        public void onError(SipAudioCall call, int errorCode, String errorMessage) {
        }

        public void onChanged(SipAudioCall call) {
        }
    }
}

