/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.WifiConfiguration;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.UUID;

class WifiApConfigStore
extends StateMachine {
    private Context mContext;
    private static final String TAG = "WifiApConfigStore";
    private static final String AP_CONFIG_FILE = Environment.getDataDirectory() + "/misc/wifi/softap.conf";
    private static final int AP_CONFIG_FILE_VERSION = 1;
    private State mDefaultState = new DefaultState();
    private State mInactiveState = new InactiveState();
    private State mActiveState = new ActiveState();
    private WifiConfiguration mWifiApConfig = null;
    private AsyncChannel mReplyChannel = new AsyncChannel();

    WifiApConfigStore(Context context, Handler target) {
        super(TAG, target.getLooper());
        this.mContext = context;
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
    }

    public static WifiApConfigStore makeWifiApConfigStore(Context context, Handler target) {
        WifiApConfigStore s = new WifiApConfigStore(context, target);
        s.start();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadApConfiguration() {
        FilterInputStream in = null;
        try {
            WifiConfiguration config = new WifiConfiguration();
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(AP_CONFIG_FILE)));
            int version = ((DataInputStream)in).readInt();
            if (version != 1) {
                Log.e(TAG, "Bad version on hotspot configuration file, set defaults");
                this.setDefaultApConfiguration();
                return;
            }
            config.SSID = ((DataInputStream)in).readUTF();
            int authType = ((DataInputStream)in).readInt();
            config.allowedKeyManagement.set(authType);
            if (authType != 0) {
                config.preSharedKey = ((DataInputStream)in).readUTF();
            }
            this.mWifiApConfig = config;
        }
        catch (IOException ignore) {
            this.setDefaultApConfiguration();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    Messenger getMessenger() {
        return new Messenger(this.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeApConfiguration(WifiConfiguration config) {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(AP_CONFIG_FILE)));
            ((DataOutputStream)out).writeInt(1);
            ((DataOutputStream)out).writeUTF(config.SSID);
            int authType = config.getAuthType();
            ((DataOutputStream)out).writeInt(authType);
            if (authType != 0) {
                ((DataOutputStream)out).writeUTF(config.preSharedKey);
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Error writing hotspot configuration" + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setDefaultApConfiguration() {
        WifiConfiguration config = new WifiConfiguration();
        config.SSID = this.mContext.getString(17040437);
        config.allowedKeyManagement.set(4);
        String randomUUID = UUID.randomUUID().toString();
        config.preSharedKey = randomUUID.substring(0, 8) + randomUUID.substring(9, 13);
        this.sendMessage(131097, config);
    }

    class ActiveState
    extends State {
        ActiveState() {
        }

        public void enter() {
            new Thread(new Runnable(){

                public void run() {
                    WifiApConfigStore.this.writeApConfiguration(WifiApConfigStore.this.mWifiApConfig);
                    WifiApConfigStore.this.sendMessage(131098);
                }
            }).start();
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131097: {
                    WifiApConfigStore.this.deferMessage(message);
                    break;
                }
                case 131098: {
                    WifiApConfigStore.this.transitionTo(WifiApConfigStore.this.mInactiveState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class InactiveState
    extends State {
        InactiveState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131097: {
                    WifiApConfigStore.this.mWifiApConfig = (WifiConfiguration)message.obj;
                    WifiApConfigStore.this.transitionTo(WifiApConfigStore.this.mActiveState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131097: 
                case 131098: {
                    Log.e(WifiApConfigStore.TAG, "Unexpected message: " + message);
                    break;
                }
                case 131099: {
                    WifiApConfigStore.this.mReplyChannel.replyToMessage(message, 131100, WifiApConfigStore.this.mWifiApConfig);
                    break;
                }
                default: {
                    Log.e(WifiApConfigStore.TAG, "Failed to handle " + message);
                }
            }
            return true;
        }
    }
}

