/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.backup.IBackupManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.DhcpResults;
import android.net.DhcpStateMachine;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.wifi.BatchedScanResult;
import android.net.wifi.BatchedScanSettings;
import android.net.wifi.NetworkUpdateResult;
import android.net.wifi.RssiPacketCountInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.StateChangeResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.SupplicantStateTracker;
import android.net.wifi.WifiApConfigStore;
import android.net.wifi.WifiConfigStore;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiMonitor;
import android.net.wifi.WifiNative;
import android.net.wifi.WifiSsid;
import android.net.wifi.WpsInfo;
import android.net.wifi.WpsResult;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.Messenger;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.LruCache;
import com.android.internal.app.IBatteryStats;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.net.BaseNetworkObserver;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WifiStateMachine
extends StateMachine {
    private static final String NETWORKTYPE = "WIFI";
    private static final boolean DBG = false;
    private WifiMonitor mWifiMonitor;
    private WifiNative mWifiNative;
    private WifiConfigStore mWifiConfigStore;
    private INetworkManagementService mNwService;
    private ConnectivityManager mCm;
    private final boolean mP2pSupported;
    private final AtomicBoolean mP2pConnected = new AtomicBoolean(false);
    private boolean mTemporarilyDisconnectWifi = false;
    private final String mPrimaryDeviceType;
    private List<ScanResult> mScanResults = new ArrayList<ScanResult>();
    private static final Pattern scanResultPattern = Pattern.compile("\t+");
    private static final int SCAN_RESULT_CACHE_SIZE = 80;
    private final LruCache<String, ScanResult> mScanResultCache;
    private final List<BatchedScanResult> mBatchedScanResults = new ArrayList<BatchedScanResult>();
    private int mBatchedScanOwnerUid = -1;
    private int mExpectedBatchedScans = 0;
    private long mBatchedScanMinPollTime = 0L;
    private final boolean mBackgroundScanSupported;
    private String mInterfaceName;
    private String mTetherInterfaceName;
    private int mLastSignalLevel = -1;
    private String mLastBssid;
    private int mLastNetworkId;
    private boolean mEnableRssiPolling = false;
    private boolean mEnableBackgroundScan = false;
    private int mRssiPollToken = 0;
    private int mReconnectCount = 0;
    private int mOperationalMode = 1;
    private boolean mScanResultIsPending = false;
    private WorkSource mScanWorkSource = null;
    private static final int UNKNOWN_SCAN_SOURCE = -1;
    private AtomicBoolean mScreenBroadcastReceived = new AtomicBoolean(false);
    private boolean mBluetoothConnectionActive = false;
    private PowerManager.WakeLock mSuspendWakeLock;
    private static final int POLL_RSSI_INTERVAL_MSECS = 3000;
    private static final int SUPPLICANT_RESTART_INTERVAL_MSECS = 5000;
    private static final int SUPPLICANT_RESTART_TRIES = 5;
    private int mSupplicantRestartCount = 0;
    private int mSupplicantStopFailureToken = 0;
    private static final int TETHER_NOTIFICATION_TIME_OUT_MSECS = 5000;
    private int mTetherToken = 0;
    private static final int DRIVER_START_TIME_OUT_MSECS = 10000;
    private int mDriverStartToken = 0;
    private LinkProperties mLinkProperties;
    private final LinkProperties mNetlinkLinkProperties;
    private int mPeriodicScanToken = 0;
    private PowerManager.WakeLock mWakeLock;
    private Context mContext;
    private final Object mDhcpResultsLock = new Object();
    private DhcpResults mDhcpResults;
    private WifiInfo mWifiInfo;
    private NetworkInfo mNetworkInfo;
    private SupplicantStateTracker mSupplicantStateTracker;
    private DhcpStateMachine mDhcpStateMachine;
    private boolean mDhcpActive = false;
    private InterfaceObserver mInterfaceObserver;
    private AlarmManager mAlarmManager;
    private PendingIntent mScanIntent;
    private PendingIntent mDriverStopIntent;
    private PendingIntent mBatchedScanIntervalIntent;
    private AtomicInteger mFrequencyBand = new AtomicInteger(0);
    private AtomicBoolean mFilteringMulticastV4Packets = new AtomicBoolean(true);
    private AsyncChannel mReplyChannel = new AsyncChannel();
    private WifiP2pManager mWifiP2pManager;
    private AsyncChannel mWifiP2pChannel;
    private AsyncChannel mWifiApConfigChannel;
    static final int BASE = 131072;
    static final int CMD_START_SUPPLICANT = 131083;
    static final int CMD_STOP_SUPPLICANT = 131084;
    static final int CMD_START_DRIVER = 131085;
    static final int CMD_STOP_DRIVER = 131086;
    static final int CMD_STATIC_IP_SUCCESS = 131087;
    static final int CMD_STATIC_IP_FAILURE = 131088;
    static final int CMD_STOP_SUPPLICANT_FAILED = 131089;
    static final int CMD_DELAYED_STOP_DRIVER = 131090;
    static final int CMD_DRIVER_START_TIMED_OUT = 131091;
    static final int CMD_CAPTIVE_CHECK_COMPLETE = 131092;
    static final int CMD_START_AP = 131093;
    static final int CMD_START_AP_SUCCESS = 131094;
    static final int CMD_START_AP_FAILURE = 131095;
    static final int CMD_STOP_AP = 131096;
    static final int CMD_SET_AP_CONFIG = 131097;
    static final int CMD_SET_AP_CONFIG_COMPLETED = 131098;
    static final int CMD_REQUEST_AP_CONFIG = 131099;
    static final int CMD_RESPONSE_AP_CONFIG = 131100;
    static final int CMD_TETHER_STATE_CHANGE = 131101;
    static final int CMD_TETHER_NOTIFICATION_TIMED_OUT = 131102;
    static final int CMD_BLUETOOTH_ADAPTER_STATE_CHANGE = 131103;
    static final int CMD_PING_SUPPLICANT = 131123;
    static final int CMD_ADD_OR_UPDATE_NETWORK = 131124;
    static final int CMD_REMOVE_NETWORK = 131125;
    static final int CMD_ENABLE_NETWORK = 131126;
    static final int CMD_ENABLE_ALL_NETWORKS = 131127;
    static final int CMD_BLACKLIST_NETWORK = 131128;
    static final int CMD_CLEAR_BLACKLIST = 131129;
    static final int CMD_SAVE_CONFIG = 131130;
    static final int CMD_GET_CONFIGURED_NETWORKS = 131131;
    static final int CMD_START_SCAN = 131143;
    static final int CMD_SET_OPERATIONAL_MODE = 131144;
    static final int CMD_DISCONNECT = 131145;
    static final int CMD_RECONNECT = 131146;
    static final int CMD_REASSOCIATE = 131147;
    static final int CMD_SET_HIGH_PERF_MODE = 131149;
    static final int CMD_SET_COUNTRY_CODE = 131152;
    static final int CMD_ENABLE_RSSI_POLL = 131154;
    static final int CMD_RSSI_POLL = 131155;
    static final int CMD_START_PACKET_FILTERING = 131156;
    static final int CMD_STOP_PACKET_FILTERING = 131157;
    static final int CMD_SET_SUSPEND_OPT_ENABLED = 131158;
    static final int CMD_NO_NETWORKS_PERIODIC_SCAN = 131160;
    static final int MULTICAST_V6 = 1;
    static final int MULTICAST_V4 = 0;
    static final int CMD_SET_FREQUENCY_BAND = 131162;
    static final int CMD_ENABLE_BACKGROUND_SCAN = 131163;
    static final int CMD_ENABLE_TDLS = 131164;
    static final int CMD_RESET_SUPPLICANT_STATE = 131183;
    public static final int CMD_ENABLE_P2P = 131203;
    public static final int CMD_DISABLE_P2P_REQ = 131204;
    public static final int CMD_DISABLE_P2P_RSP = 131205;
    public static final int CMD_BOOT_COMPLETED = 131206;
    public static final int CMD_SET_BATCHED_SCAN = 131207;
    public static final int CMD_START_NEXT_BATCHED_SCAN = 131208;
    public static final int CMD_POLL_BATCHED_SCAN = 131209;
    static final int CMD_IP_ADDRESS_UPDATED = 131212;
    static final int CMD_IP_ADDRESS_REMOVED = 131213;
    static final int CMD_RELOAD_TLS_AND_RECONNECT = 131214;
    public static final int CONNECT_MODE = 1;
    public static final int SCAN_ONLY_MODE = 2;
    public static final int SCAN_ONLY_WITH_WIFI_OFF_MODE = 3;
    private static final int SUCCESS = 1;
    private static final int FAILURE = -1;
    private static final int DEFAULT_MAX_DHCP_RETRIES = 9;
    private int mSuspendOptNeedsDisabled = 0;
    private static final int SUSPEND_DUE_TO_DHCP = 1;
    private static final int SUSPEND_DUE_TO_HIGH_PERF = 2;
    private static final int SUSPEND_DUE_TO_SCREEN = 4;
    private AtomicBoolean mUserWantsSuspendOpt = new AtomicBoolean(true);
    private final int mDefaultFrameworkScanIntervalMs;
    private long mSupplicantScanIntervalMs;
    private static final int MIN_INTERVAL_ENABLE_ALL_NETWORKS_MS = 600000;
    private long mLastEnableAllNetworksTime;
    private final int mDriverStopDelayMs;
    private int mDelayedStopCounter;
    private boolean mInDelayedStop = false;
    private volatile String mPersistedCountryCode;
    private String mLastSetCountryCode;
    private static final int MIN_RSSI = -200;
    private static final int MAX_RSSI = 256;
    private State mDefaultState = new DefaultState();
    private State mInitialState = new InitialState();
    private State mSupplicantStartingState = new SupplicantStartingState();
    private State mSupplicantStartedState = new SupplicantStartedState();
    private State mSupplicantStoppingState = new SupplicantStoppingState();
    private State mDriverStartingState = new DriverStartingState();
    private State mDriverStartedState = new DriverStartedState();
    private State mWaitForP2pDisableState = new WaitForP2pDisableState();
    private State mDriverStoppingState = new DriverStoppingState();
    private State mDriverStoppedState = new DriverStoppedState();
    private State mScanModeState = new ScanModeState();
    private State mConnectModeState = new ConnectModeState();
    private State mL2ConnectedState = new L2ConnectedState();
    private State mObtainingIpState = new ObtainingIpState();
    private State mVerifyingLinkState = new VerifyingLinkState();
    private State mCaptivePortalCheckState = new CaptivePortalCheckState();
    private State mConnectedState = new ConnectedState();
    private State mDisconnectingState = new DisconnectingState();
    private State mDisconnectedState = new DisconnectedState();
    private State mWpsRunningState = new WpsRunningState();
    private State mSoftApStartingState = new SoftApStartingState();
    private State mSoftApStartedState = new SoftApStartedState();
    private State mTetheringState = new TetheringState();
    private State mTetheredState = new TetheredState();
    private State mUntetheringState = new UntetheringState();
    private final AtomicInteger mWifiState = new AtomicInteger(1);
    private final AtomicInteger mWifiApState = new AtomicInteger(11);
    private static final int SCAN_REQUEST = 0;
    private static final String ACTION_START_SCAN = "com.android.server.WifiManager.action.START_SCAN";
    private static final String DELAYED_STOP_COUNTER = "DelayedStopCounter";
    private static final int DRIVER_STOP_REQUEST = 0;
    private static final String ACTION_DELAYED_DRIVER_STOP = "com.android.server.WifiManager.action.DELAYED_DRIVER_STOP";
    private static final String ACTION_REFRESH_BATCHED_SCAN = "com.android.server.WifiManager.action.REFRESH_BATCHED_SCAN";
    private boolean mIsRunning = false;
    private boolean mReportedRunning = false;
    private final WorkSource mRunningWifiUids = new WorkSource();
    private final WorkSource mLastRunningWifiUids = new WorkSource();
    private final IBatteryStats mBatteryStats;
    private BatchedScanSettings mBatchedScanSettings = null;
    private WorkSource mBatchedScanWorkSource = null;
    private int mBatchedScanCsph = 0;
    private WorkSource mNotedBatchedScanWorkSource = null;
    private int mNotedBatchedScanCsph = 0;
    private static final String BATCHED_SETTING = "batched_settings";
    private static final String BATCHED_WORKSOURCE = "batched_worksource";
    private static final boolean DEBUG_PARSE = false;
    private static final String ID_STR = "id=";
    private static final String BSSID_STR = "bssid=";
    private static final String FREQ_STR = "freq=";
    private static final String LEVEL_STR = "level=";
    private static final String TSF_STR = "tsf=";
    private static final String FLAGS_STR = "flags=";
    private static final String SSID_STR = "ssid=";
    private static final String DELIMITER_STR = "====";
    private static final String END_STR = "####";

    public WifiStateMachine(Context context, String wlanInterface) {
        super("WifiStateMachine");
        this.mContext = context;
        this.mInterfaceName = wlanInterface;
        this.mNetworkInfo = new NetworkInfo(1, 0, NETWORKTYPE, "");
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        IBinder b = ServiceManager.getService("network_management");
        this.mNwService = INetworkManagementService.Stub.asInterface(b);
        this.mP2pSupported = this.mContext.getPackageManager().hasSystemFeature("android.hardware.wifi.direct");
        this.mWifiNative = new WifiNative(this.mInterfaceName);
        this.mWifiConfigStore = new WifiConfigStore(context, this.mWifiNative);
        this.mWifiMonitor = new WifiMonitor(this, this.mWifiNative);
        this.mWifiInfo = new WifiInfo();
        this.mSupplicantStateTracker = new SupplicantStateTracker(context, this, this.mWifiConfigStore, this.getHandler());
        this.mLinkProperties = new LinkProperties();
        this.mNetlinkLinkProperties = new LinkProperties();
        this.mWifiP2pManager = (WifiP2pManager)this.mContext.getSystemService("wifip2p");
        this.mNetworkInfo.setIsAvailable(false);
        this.mLastBssid = null;
        this.mLastNetworkId = -1;
        this.mLastSignalLevel = -1;
        this.mInterfaceObserver = new InterfaceObserver(this);
        try {
            this.mNwService.registerObserver(this.mInterfaceObserver);
        }
        catch (RemoteException e) {
            this.loge("Couldn't register interface observer: " + e.toString());
        }
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent scanIntent = new Intent(ACTION_START_SCAN, null);
        this.mScanIntent = PendingIntent.getBroadcast(this.mContext, 0, scanIntent, 0);
        Intent batchedIntent = new Intent(ACTION_REFRESH_BATCHED_SCAN, null);
        this.mBatchedScanIntervalIntent = PendingIntent.getBroadcast(this.mContext, 0, batchedIntent, 0);
        this.mDefaultFrameworkScanIntervalMs = this.mContext.getResources().getInteger(0x10E0011);
        this.mDriverStopDelayMs = this.mContext.getResources().getInteger(17694738);
        this.mBackgroundScanSupported = this.mContext.getResources().getBoolean(0x1110018);
        this.mPrimaryDeviceType = this.mContext.getResources().getString(17039386);
        this.mUserWantsSuspendOpt.set(Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_suspend_optimizations_enabled", 1) == 1);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ArrayList<String> available = intent.getStringArrayListExtra("availableArray");
                ArrayList<String> active = intent.getStringArrayListExtra("activeArray");
                WifiStateMachine.this.sendMessage(131101, new TetherStateChange(available, active));
            }
        }, new IntentFilter("android.net.conn.TETHER_STATE_CHANGED"));
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                WorkSource workSource = null;
                WifiStateMachine.this.startScan(-1, workSource);
            }
        }, new IntentFilter(ACTION_START_SCAN));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction(ACTION_REFRESH_BATCHED_SCAN);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.intent.action.SCREEN_ON")) {
                    WifiStateMachine.this.handleScreenStateChanged(true);
                } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                    WifiStateMachine.this.handleScreenStateChanged(false);
                } else if (action.equals(WifiStateMachine.ACTION_REFRESH_BATCHED_SCAN)) {
                    WifiStateMachine.this.startNextBatchedScanAsync();
                }
            }
        }, filter);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                int counter = intent.getIntExtra(WifiStateMachine.DELAYED_STOP_COUNTER, 0);
                WifiStateMachine.this.sendMessage(131090, counter, 0);
            }
        }, new IntentFilter(ACTION_DELAYED_DRIVER_STOP));
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("wifi_suspend_optimizations_enabled"), false, new ContentObserver(this.getHandler()){

            public void onChange(boolean selfChange) {
                WifiStateMachine.this.mUserWantsSuspendOpt.set(Settings.Global.getInt(WifiStateMachine.this.mContext.getContentResolver(), "wifi_suspend_optimizations_enabled", 1) == 1);
            }
        });
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                WifiStateMachine.this.sendMessage(131206);
            }
        }, new IntentFilter("android.intent.action.BOOT_COMPLETED"));
        this.mScanResultCache = new LruCache(80);
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, this.getName());
        this.mSuspendWakeLock = powerManager.newWakeLock(1, "WifiSuspend");
        this.mSuspendWakeLock.setReferenceCounted(false);
        this.addState(this.mDefaultState);
        this.addState(this.mInitialState, this.mDefaultState);
        this.addState(this.mSupplicantStartingState, this.mDefaultState);
        this.addState(this.mSupplicantStartedState, this.mDefaultState);
        this.addState(this.mDriverStartingState, this.mSupplicantStartedState);
        this.addState(this.mDriverStartedState, this.mSupplicantStartedState);
        this.addState(this.mScanModeState, this.mDriverStartedState);
        this.addState(this.mConnectModeState, this.mDriverStartedState);
        this.addState(this.mL2ConnectedState, this.mConnectModeState);
        this.addState(this.mObtainingIpState, this.mL2ConnectedState);
        this.addState(this.mVerifyingLinkState, this.mL2ConnectedState);
        this.addState(this.mCaptivePortalCheckState, this.mL2ConnectedState);
        this.addState(this.mConnectedState, this.mL2ConnectedState);
        this.addState(this.mDisconnectingState, this.mConnectModeState);
        this.addState(this.mDisconnectedState, this.mConnectModeState);
        this.addState(this.mWpsRunningState, this.mConnectModeState);
        this.addState(this.mWaitForP2pDisableState, this.mSupplicantStartedState);
        this.addState(this.mDriverStoppingState, this.mSupplicantStartedState);
        this.addState(this.mDriverStoppedState, this.mSupplicantStartedState);
        this.addState(this.mSupplicantStoppingState, this.mDefaultState);
        this.addState(this.mSoftApStartingState, this.mDefaultState);
        this.addState(this.mSoftApStartedState, this.mDefaultState);
        this.addState(this.mTetheringState, this.mSoftApStartedState);
        this.addState(this.mTetheredState, this.mSoftApStartedState);
        this.addState(this.mUntetheringState, this.mSoftApStartedState);
        this.setInitialState(this.mInitialState);
        this.setLogRecSize(2000);
        this.setLogOnlyTransitions(false);
        this.start();
        Intent intent = new Intent("wifi_scan_available");
        intent.addFlags(0x4000000);
        intent.putExtra("scan_enabled", 1);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    public Messenger getMessenger() {
        return new Messenger(this.getHandler());
    }

    public boolean syncPingSupplicant(AsyncChannel channel) {
        Message resultMsg = channel.sendMessageSynchronously(131123);
        boolean result = resultMsg.arg1 != -1;
        resultMsg.recycle();
        return result;
    }

    public void startScan(int callingUid, WorkSource workSource) {
        this.sendMessage(131143, callingUid, 0, workSource);
    }

    public void setBatchedScanSettings(BatchedScanSettings settings, int callingUid, int csph, WorkSource workSource) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(BATCHED_SETTING, settings);
        bundle.putParcelable(BATCHED_WORKSOURCE, workSource);
        this.sendMessage(131207, callingUid, csph, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BatchedScanResult> syncGetBatchedScanResultsList() {
        List<BatchedScanResult> list = this.mBatchedScanResults;
        synchronized (list) {
            ArrayList<BatchedScanResult> batchedScanList = new ArrayList<BatchedScanResult>(this.mBatchedScanResults.size());
            for (BatchedScanResult result : this.mBatchedScanResults) {
                batchedScanList.add(new BatchedScanResult(result));
            }
            return batchedScanList;
        }
    }

    public void requestBatchedScanPoll() {
        this.sendMessage(131209);
    }

    private void startBatchedScan() {
        if (this.mBatchedScanSettings == null) {
            return;
        }
        if (this.mDhcpActive) {
            return;
        }
        this.retrieveBatchedScanData();
        this.mAlarmManager.cancel(this.mBatchedScanIntervalIntent);
        String scansExpected = this.mWifiNative.setBatchedScanSettings(this.mBatchedScanSettings);
        try {
            this.mExpectedBatchedScans = Integer.parseInt(scansExpected);
            this.setNextBatchedAlarm(this.mExpectedBatchedScans);
            if (this.mExpectedBatchedScans > 0) {
                this.noteBatchedScanStart();
            }
        }
        catch (NumberFormatException e) {
            this.stopBatchedScan();
            this.loge("Exception parsing WifiNative.setBatchedScanSettings response " + e);
        }
    }

    private void startNextBatchedScanAsync() {
        this.sendMessage(131208);
    }

    private void startNextBatchedScan() {
        this.retrieveBatchedScanData();
        this.setNextBatchedAlarm(this.mExpectedBatchedScans);
    }

    private void handleBatchedScanPollRequest() {
        if (this.mBatchedScanMinPollTime == 0L) {
            return;
        }
        if (this.mBatchedScanSettings == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now > this.mBatchedScanMinPollTime) {
            this.startNextBatchedScan();
        } else {
            this.mAlarmManager.setExact(0, this.mBatchedScanMinPollTime, this.mBatchedScanIntervalIntent);
            this.mBatchedScanMinPollTime = 0L;
        }
    }

    private boolean recordBatchedScanSettings(int responsibleUid, int csph, Bundle bundle) {
        BatchedScanSettings settings = (BatchedScanSettings)bundle.getParcelable(BATCHED_SETTING);
        WorkSource responsibleWorkSource = (WorkSource)bundle.getParcelable(BATCHED_WORKSOURCE);
        if (settings != null ? settings.equals(this.mBatchedScanSettings) : this.mBatchedScanSettings == null) {
            return false;
        }
        this.mBatchedScanSettings = settings;
        if (responsibleWorkSource == null) {
            responsibleWorkSource = new WorkSource(responsibleUid);
        }
        this.mBatchedScanWorkSource = responsibleWorkSource;
        this.mBatchedScanCsph = csph;
        return true;
    }

    private void stopBatchedScan() {
        this.mAlarmManager.cancel(this.mBatchedScanIntervalIntent);
        this.retrieveBatchedScanData();
        this.mWifiNative.setBatchedScanSettings(null);
        this.noteBatchedScanStop();
    }

    private void setNextBatchedAlarm(int scansExpected) {
        if (this.mBatchedScanSettings == null || scansExpected < 1) {
            return;
        }
        this.mBatchedScanMinPollTime = System.currentTimeMillis() + (long)(this.mBatchedScanSettings.scanIntervalSec * 1000);
        if (this.mBatchedScanSettings.maxScansPerBatch < scansExpected) {
            scansExpected = this.mBatchedScanSettings.maxScansPerBatch;
        }
        int secToFull = this.mBatchedScanSettings.scanIntervalSec;
        secToFull *= scansExpected;
        int debugPeriod = SystemProperties.getInt("wifi.batchedScan.pollPeriod", 0);
        if (debugPeriod > 0) {
            secToFull = debugPeriod;
        }
        this.mAlarmManager.setExact(0, System.currentTimeMillis() + (long)((secToFull - this.mBatchedScanSettings.scanIntervalSec / 2) * 1000), this.mBatchedScanIntervalIntent);
    }

    private void retrieveBatchedScanData() {
        int n;
        String rawData = this.mWifiNative.getBatchedScanResults();
        this.mBatchedScanMinPollTime = 0L;
        if (rawData == null || rawData.equalsIgnoreCase("OK")) {
            this.loge("Unexpected BatchedScanResults :" + rawData);
            return;
        }
        int scanCount = 0;
        String END_OF_BATCHES = "----";
        String SCANCOUNT = "scancount=";
        String TRUNCATED = "trunc";
        String AGE = "age=";
        String DIST = "dist=";
        String DISTSD = "distSd=";
        String[] splitData = rawData.split("\n");
        if (splitData[n = 0].startsWith("scancount=")) {
            try {
                scanCount = Integer.parseInt(splitData[n++].substring("scancount=".length()));
            }
            catch (NumberFormatException e) {
                this.loge("scancount parseInt Exception from " + splitData[n]);
            }
        } else {
            this.log("scancount not found");
        }
        if (scanCount == 0) {
            this.loge("scanCount==0 - aborting");
            return;
        }
        Intent intent = new Intent("android.net.wifi.BATCHED_RESULTS");
        intent.addFlags(0x4000000);
        List<BatchedScanResult> list = this.mBatchedScanResults;
        synchronized (list) {
            this.mBatchedScanResults.clear();
            BatchedScanResult batchedScanResult = new BatchedScanResult();
            String bssid = null;
            WifiSsid wifiSsid = null;
            int level = 0;
            int freq = 0;
            long tsf = 0L;
            int distSd = -1;
            int dist = -1;
            long now = SystemClock.elapsedRealtime();
            int bssidStrLen = BSSID_STR.length();
            while (true) {
                if (n < splitData.length) {
                    if (splitData[n].equals("----")) {
                        if (n + 1 != splitData.length) {
                            this.loge("didn't consume " + (splitData.length - n));
                        }
                        if (this.mBatchedScanResults.size() > 0) {
                            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
                        }
                        this.logd("retrieveBatchedScanResults X");
                        return;
                    }
                    if (splitData[n].equals(END_STR) || splitData[n].equals(DELIMITER_STR)) {
                        if (bssid != null) {
                            batchedScanResult.scanResults.add(new ScanResult(wifiSsid, bssid, "", level, freq, tsf, dist, distSd));
                            wifiSsid = null;
                            bssid = null;
                            level = 0;
                            freq = 0;
                            tsf = 0L;
                            distSd = -1;
                            dist = -1;
                        }
                        if (splitData[n].equals(END_STR)) {
                            if (batchedScanResult.scanResults.size() != 0) {
                                this.mBatchedScanResults.add(batchedScanResult);
                                batchedScanResult = new BatchedScanResult();
                            } else {
                                this.logd("Found empty batch");
                            }
                        }
                    } else if (splitData[n].equals("trunc")) {
                        batchedScanResult.truncated = true;
                    } else if (splitData[n].startsWith(BSSID_STR)) {
                        bssid = new String(splitData[n].getBytes(), bssidStrLen, splitData[n].length() - bssidStrLen);
                    } else if (splitData[n].startsWith(FREQ_STR)) {
                        try {
                            freq = Integer.parseInt(splitData[n].substring(FREQ_STR.length()));
                        }
                        catch (NumberFormatException e) {
                            this.loge("Invalid freqency: " + splitData[n]);
                            freq = 0;
                        }
                    } else if (splitData[n].startsWith("age=")) {
                        try {
                            tsf = now - Long.parseLong(splitData[n].substring("age=".length()));
                            tsf *= 1000L;
                        }
                        catch (NumberFormatException e) {
                            this.loge("Invalid timestamp: " + splitData[n]);
                            tsf = 0L;
                        }
                    } else if (splitData[n].startsWith(SSID_STR)) {
                        wifiSsid = WifiSsid.createFromAsciiEncoded(splitData[n].substring(SSID_STR.length()));
                    } else if (splitData[n].startsWith(LEVEL_STR)) {
                        try {
                            level = Integer.parseInt(splitData[n].substring(LEVEL_STR.length()));
                            if (level > 0) {
                                level -= 256;
                            }
                        }
                        catch (NumberFormatException e) {
                            this.loge("Invalid level: " + splitData[n]);
                            level = 0;
                        }
                    } else if (splitData[n].startsWith("dist=")) {
                        try {
                            dist = Integer.parseInt(splitData[n].substring("dist=".length()));
                        }
                        catch (NumberFormatException e) {
                            this.loge("Invalid distance: " + splitData[n]);
                            dist = -1;
                        }
                    } else if (splitData[n].startsWith("distSd=")) {
                        try {
                            distSd = Integer.parseInt(splitData[n].substring("distSd=".length()));
                        }
                        catch (NumberFormatException e) {
                            this.loge("Invalid distanceSd: " + splitData[n]);
                            distSd = -1;
                        }
                    } else {
                        this.loge("Unable to parse batched scan result line: " + splitData[n]);
                    }
                    ++n;
                    continue;
                }
                rawData = this.mWifiNative.getBatchedScanResults();
                if (rawData == null) {
                    this.loge("Unexpected null BatchedScanResults");
                    return;
                }
                splitData = rawData.split("\n");
                if (splitData.length == 0 || splitData[0].equals("ok")) {
                    this.loge("batch scan results just ended!");
                    if (this.mBatchedScanResults.size() > 0) {
                        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
                    }
                    return;
                }
                n = 0;
            }
        }
    }

    private void noteScanStart(int callingUid, WorkSource workSource) {
        if (this.mScanWorkSource == null && (callingUid != -1 || workSource != null)) {
            this.mScanWorkSource = workSource != null ? workSource : new WorkSource(callingUid);
            try {
                this.mBatteryStats.noteWifiScanStartedFromSource(this.mScanWorkSource);
            }
            catch (RemoteException e) {
                this.log(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteScanEnd() {
        if (this.mScanWorkSource != null) {
            try {
                this.mBatteryStats.noteWifiScanStoppedFromSource(this.mScanWorkSource);
            }
            catch (RemoteException e) {
                this.log(e.toString());
            }
            finally {
                this.mScanWorkSource = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteBatchedScanStart() {
        if (!(this.mNotedBatchedScanWorkSource == null || this.mNotedBatchedScanWorkSource.equals(this.mBatchedScanWorkSource) && this.mNotedBatchedScanCsph == this.mBatchedScanCsph)) {
            try {
                this.mBatteryStats.noteWifiBatchedScanStoppedFromSource(this.mNotedBatchedScanWorkSource);
            }
            catch (RemoteException e) {
                this.log(e.toString());
            }
            finally {
                this.mNotedBatchedScanWorkSource = null;
                this.mNotedBatchedScanCsph = 0;
            }
        }
        try {
            this.mBatteryStats.noteWifiBatchedScanStartedFromSource(this.mBatchedScanWorkSource, this.mBatchedScanCsph);
            this.mNotedBatchedScanWorkSource = this.mBatchedScanWorkSource;
            this.mNotedBatchedScanCsph = this.mBatchedScanCsph;
        }
        catch (RemoteException e) {
            this.log(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteBatchedScanStop() {
        if (this.mNotedBatchedScanWorkSource != null) {
            try {
                this.mBatteryStats.noteWifiBatchedScanStoppedFromSource(this.mNotedBatchedScanWorkSource);
            }
            catch (RemoteException e) {
                this.log(e.toString());
            }
            finally {
                this.mNotedBatchedScanWorkSource = null;
                this.mNotedBatchedScanCsph = 0;
            }
        }
    }

    private void startScanNative(int type) {
        this.mWifiNative.scan(type);
        this.mScanResultIsPending = true;
    }

    public void setSupplicantRunning(boolean enable) {
        if (enable) {
            this.sendMessage(131083);
        } else {
            this.sendMessage(131084);
        }
    }

    public void setHostApRunning(WifiConfiguration wifiConfig, boolean enable) {
        if (enable) {
            this.sendMessage(131093, wifiConfig);
        } else {
            this.sendMessage(131096);
        }
    }

    public void setWifiApConfiguration(WifiConfiguration config) {
        this.mWifiApConfigChannel.sendMessage(131097, config);
    }

    public WifiConfiguration syncGetWifiApConfiguration() {
        Message resultMsg = this.mWifiApConfigChannel.sendMessageSynchronously(131099);
        WifiConfiguration ret = (WifiConfiguration)resultMsg.obj;
        resultMsg.recycle();
        return ret;
    }

    public int syncGetWifiState() {
        return this.mWifiState.get();
    }

    public String syncGetWifiStateByName() {
        switch (this.mWifiState.get()) {
            case 0: {
                return "disabling";
            }
            case 1: {
                return "disabled";
            }
            case 2: {
                return "enabling";
            }
            case 3: {
                return "enabled";
            }
            case 4: {
                return "unknown state";
            }
        }
        return "[invalid state]";
    }

    public int syncGetWifiApState() {
        return this.mWifiApState.get();
    }

    public String syncGetWifiApStateByName() {
        switch (this.mWifiApState.get()) {
            case 10: {
                return "disabling";
            }
            case 11: {
                return "disabled";
            }
            case 12: {
                return "enabling";
            }
            case 13: {
                return "enabled";
            }
            case 14: {
                return "failed";
            }
        }
        return "[invalid state]";
    }

    public WifiInfo syncRequestConnectionInfo() {
        return this.mWifiInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DhcpResults syncGetDhcpResults() {
        Object object = this.mDhcpResultsLock;
        synchronized (object) {
            return new DhcpResults(this.mDhcpResults);
        }
    }

    public void setDriverStart(boolean enable) {
        if (enable) {
            this.sendMessage(131085);
        } else {
            this.sendMessage(131086);
        }
    }

    public void captivePortalCheckComplete() {
        this.sendMessage(131092);
    }

    public void setOperationalMode(int mode) {
        this.sendMessage(131144, mode, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScanResult> syncGetScanResultsList() {
        LruCache<String, ScanResult> lruCache = this.mScanResultCache;
        synchronized (lruCache) {
            ArrayList<ScanResult> scanList = new ArrayList<ScanResult>();
            for (ScanResult result : this.mScanResults) {
                scanList.add(new ScanResult(result));
            }
            return scanList;
        }
    }

    public void disconnectCommand() {
        this.sendMessage(131145);
    }

    public void reconnectCommand() {
        this.sendMessage(131146);
    }

    public void reassociateCommand() {
        this.sendMessage(131147);
    }

    public void reloadTlsNetworksAndReconnect() {
        this.sendMessage(131214);
    }

    public int syncAddOrUpdateNetwork(AsyncChannel channel, WifiConfiguration config) {
        Message resultMsg = channel.sendMessageSynchronously(131124, config);
        int result = resultMsg.arg1;
        resultMsg.recycle();
        return result;
    }

    public List<WifiConfiguration> syncGetConfiguredNetworks(AsyncChannel channel) {
        Message resultMsg = channel.sendMessageSynchronously(131131);
        List result = (List)resultMsg.obj;
        resultMsg.recycle();
        return result;
    }

    public boolean syncRemoveNetwork(AsyncChannel channel, int networkId) {
        Message resultMsg = channel.sendMessageSynchronously(131125, networkId);
        boolean result = resultMsg.arg1 != -1;
        resultMsg.recycle();
        return result;
    }

    public boolean syncEnableNetwork(AsyncChannel channel, int netId, boolean disableOthers) {
        Message resultMsg = channel.sendMessageSynchronously(131126, netId, disableOthers ? 1 : 0);
        boolean result = resultMsg.arg1 != -1;
        resultMsg.recycle();
        return result;
    }

    public boolean syncDisableNetwork(AsyncChannel channel, int netId) {
        Message resultMsg = channel.sendMessageSynchronously(151569, netId);
        boolean result = resultMsg.arg1 != 151570;
        resultMsg.recycle();
        return result;
    }

    public void addToBlacklist(String bssid) {
        this.sendMessage(131128, bssid);
    }

    public void clearBlacklist() {
        this.sendMessage(131129);
    }

    public void enableRssiPolling(boolean enabled) {
        this.sendMessage(131154, enabled ? 1 : 0, 0);
    }

    public void enableBackgroundScanCommand(boolean enabled) {
        this.sendMessage(131163, enabled ? 1 : 0, 0);
    }

    public void enableAllNetworks() {
        this.sendMessage(131127);
    }

    public void startFilteringMulticastV4Packets() {
        this.mFilteringMulticastV4Packets.set(true);
        this.sendMessage(131156, 0, 0);
    }

    public void stopFilteringMulticastV4Packets() {
        this.mFilteringMulticastV4Packets.set(false);
        this.sendMessage(131157, 0, 0);
    }

    public void startFilteringMulticastV6Packets() {
        this.sendMessage(131156, 1, 0);
    }

    public void stopFilteringMulticastV6Packets() {
        this.sendMessage(131157, 1, 0);
    }

    public void setHighPerfModeEnabled(boolean enable) {
        this.sendMessage(131149, enable ? 1 : 0, 0);
    }

    public void setCountryCode(String countryCode, boolean persist) {
        if (persist) {
            this.mPersistedCountryCode = countryCode;
            Settings.Global.putString(this.mContext.getContentResolver(), "wifi_country_code", countryCode);
        }
        this.sendMessage(131152, countryCode);
        this.mWifiP2pChannel.sendMessage(143376, countryCode);
    }

    public void setFrequencyBand(int band, boolean persist) {
        if (persist) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "wifi_frequency_band", band);
        }
        this.sendMessage(131162, band, 0);
    }

    public void enableTdls(String remoteMacAddress, boolean enable) {
        int enabler = enable ? 1 : 0;
        this.sendMessage(131164, enabler, 0, remoteMacAddress);
    }

    public int getFrequencyBand() {
        return this.mFrequencyBand.get();
    }

    public String getConfigFile() {
        return this.mWifiConfigStore.getConfigFile();
    }

    public void sendBluetoothAdapterStateChange(int state) {
        this.sendMessage(131103, state, 0);
    }

    public boolean syncSaveConfig(AsyncChannel channel) {
        Message resultMsg = channel.sendMessageSynchronously(131130);
        boolean result = resultMsg.arg1 != -1;
        resultMsg.recycle();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBatteryWorkSource(WorkSource newSource) {
        WorkSource workSource = this.mRunningWifiUids;
        synchronized (workSource) {
            try {
                if (newSource != null) {
                    this.mRunningWifiUids.set(newSource);
                }
                if (this.mIsRunning) {
                    if (this.mReportedRunning) {
                        if (this.mLastRunningWifiUids.diff(this.mRunningWifiUids)) {
                            this.mBatteryStats.noteWifiRunningChanged(this.mLastRunningWifiUids, this.mRunningWifiUids);
                            this.mLastRunningWifiUids.set(this.mRunningWifiUids);
                        }
                    } else {
                        this.mBatteryStats.noteWifiRunning(this.mRunningWifiUids);
                        this.mLastRunningWifiUids.set(this.mRunningWifiUids);
                        this.mReportedRunning = true;
                    }
                } else if (this.mReportedRunning) {
                    this.mBatteryStats.noteWifiStopped(this.mLastRunningWifiUids);
                    this.mLastRunningWifiUids.clear();
                    this.mReportedRunning = false;
                }
                this.mWakeLock.setWorkSource(newSource);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        this.mSupplicantStateTracker.dump(fd, pw, args);
        pw.println("mLinkProperties " + this.mLinkProperties);
        pw.println("mWifiInfo " + this.mWifiInfo);
        pw.println("mDhcpResults " + this.mDhcpResults);
        pw.println("mNetworkInfo " + this.mNetworkInfo);
        pw.println("mLastSignalLevel " + this.mLastSignalLevel);
        pw.println("mLastBssid " + this.mLastBssid);
        pw.println("mLastNetworkId " + this.mLastNetworkId);
        pw.println("mReconnectCount " + this.mReconnectCount);
        pw.println("mOperationalMode " + this.mOperationalMode);
        pw.println("mUserWantsSuspendOpt " + this.mUserWantsSuspendOpt);
        pw.println("mSuspendOptNeedsDisabled " + this.mSuspendOptNeedsDisabled);
        pw.println("Supplicant status " + this.mWifiNative.status());
        pw.println("mEnableBackgroundScan " + this.mEnableBackgroundScan);
        pw.println();
        this.mWifiConfigStore.dump(fd, pw, args);
    }

    private void handleScreenStateChanged(boolean screenOn) {
        this.enableRssiPolling(screenOn);
        if (this.mBackgroundScanSupported) {
            this.enableBackgroundScanCommand(!screenOn);
        }
        if (screenOn) {
            this.enableAllNetworks();
        }
        if (this.mUserWantsSuspendOpt.get()) {
            if (screenOn) {
                this.sendMessage(131158, 0, 0);
            } else {
                this.mSuspendWakeLock.acquire(2000L);
                this.sendMessage(131158, 1, 0);
            }
        }
        this.mScreenBroadcastReceived.set(true);
    }

    private void checkAndSetConnectivityInstance() {
        if (this.mCm == null) {
            this.mCm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
    }

    private boolean startTethering(ArrayList<String> available) {
        boolean wifiAvailable = false;
        this.checkAndSetConnectivityInstance();
        String[] wifiRegexs = this.mCm.getTetherableWifiRegexs();
        for (String intf : available) {
            for (String regex : wifiRegexs) {
                if (!intf.matches(regex)) continue;
                InterfaceConfiguration ifcg = null;
                try {
                    ifcg = this.mNwService.getInterfaceConfig(intf);
                    if (ifcg != null) {
                        ifcg.setLinkAddress(new LinkAddress(NetworkUtils.numericToInetAddress("192.168.43.1"), 24));
                        ifcg.setInterfaceUp();
                        this.mNwService.setInterfaceConfig(intf, ifcg);
                    }
                }
                catch (Exception e) {
                    this.loge("Error configuring interface " + intf + ", :" + e);
                    return false;
                }
                if (this.mCm.tether(intf) != 0) {
                    this.loge("Error tethering on " + intf);
                    return false;
                }
                this.mTetherInterfaceName = intf;
                return true;
            }
        }
        return false;
    }

    private void stopTethering() {
        this.checkAndSetConnectivityInstance();
        InterfaceConfiguration ifcg = null;
        try {
            ifcg = this.mNwService.getInterfaceConfig(this.mTetherInterfaceName);
            if (ifcg != null) {
                ifcg.setLinkAddress(new LinkAddress(NetworkUtils.numericToInetAddress("0.0.0.0"), 0));
                this.mNwService.setInterfaceConfig(this.mTetherInterfaceName, ifcg);
            }
        }
        catch (Exception e) {
            this.loge("Error resetting interface " + this.mTetherInterfaceName + ", :" + e);
        }
        if (this.mCm.untether(this.mTetherInterfaceName) != 0) {
            this.loge("Untether initiate failed!");
        }
    }

    private boolean isWifiTethered(ArrayList<String> active) {
        this.checkAndSetConnectivityInstance();
        String[] wifiRegexs = this.mCm.getTetherableWifiRegexs();
        for (String intf : active) {
            for (String regex : wifiRegexs) {
                if (!intf.matches(regex)) continue;
                return true;
            }
        }
        return false;
    }

    private void setCountryCode() {
        String countryCode = Settings.Global.getString(this.mContext.getContentResolver(), "wifi_country_code");
        if (countryCode != null && !countryCode.isEmpty()) {
            this.setCountryCode(countryCode, false);
        }
    }

    private void setFrequencyBand() {
        int band = Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_frequency_band", 0);
        this.setFrequencyBand(band, false);
    }

    private void setSuspendOptimizationsNative(int reason, boolean enabled) {
        if (enabled) {
            this.mSuspendOptNeedsDisabled &= ~reason;
            if (this.mSuspendOptNeedsDisabled == 0 && this.mUserWantsSuspendOpt.get()) {
                this.mWifiNative.setSuspendOptimizations(true);
            }
        } else {
            this.mSuspendOptNeedsDisabled |= reason;
            this.mWifiNative.setSuspendOptimizations(false);
        }
    }

    private void setSuspendOptimizations(int reason, boolean enabled) {
        this.mSuspendOptNeedsDisabled = enabled ? (this.mSuspendOptNeedsDisabled &= ~reason) : (this.mSuspendOptNeedsDisabled |= reason);
    }

    private void setWifiState(int wifiState) {
        int previousWifiState = this.mWifiState.get();
        try {
            if (wifiState == 3) {
                this.mBatteryStats.noteWifiOn();
            } else if (wifiState == 1) {
                this.mBatteryStats.noteWifiOff();
            }
        }
        catch (RemoteException e) {
            this.loge("Failed to note battery stats in wifi");
        }
        this.mWifiState.set(wifiState);
        Intent intent = new Intent("android.net.wifi.WIFI_STATE_CHANGED");
        intent.addFlags(0x4000000);
        intent.putExtra("wifi_state", wifiState);
        intent.putExtra("previous_wifi_state", previousWifiState);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void setWifiApState(int wifiApState) {
        int previousWifiApState = this.mWifiApState.get();
        try {
            if (wifiApState == 13) {
                this.mBatteryStats.noteWifiOn();
            } else if (wifiApState == 11) {
                this.mBatteryStats.noteWifiOff();
            }
        }
        catch (RemoteException e) {
            this.loge("Failed to note battery stats in wifi");
        }
        this.mWifiApState.set(wifiApState);
        Intent intent = new Intent("android.net.wifi.WIFI_AP_STATE_CHANGED");
        intent.addFlags(0x4000000);
        intent.putExtra("wifi_state", wifiApState);
        intent.putExtra("previous_wifi_state", previousWifiApState);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScanResults() {
        String tmpResults;
        String bssid = "";
        int level = 0;
        int freq = 0;
        long tsf = 0L;
        String flags = "";
        WifiSsid wifiSsid = null;
        StringBuffer scanResultsBuf = new StringBuffer();
        int sid = 0;
        while (!TextUtils.isEmpty(tmpResults = this.mWifiNative.scanResults(sid))) {
            scanResultsBuf.append(tmpResults);
            scanResultsBuf.append("\n");
            String[] lines = tmpResults.split("\n");
            sid = -1;
            for (int i = lines.length - 1; i >= 0 && !lines[i].startsWith(END_STR); --i) {
                if (!lines[i].startsWith(ID_STR)) continue;
                try {
                    sid = Integer.parseInt(lines[i].substring(ID_STR.length())) + 1;
                }
                catch (NumberFormatException e) {}
                break;
            }
            if (sid != -1) continue;
            break;
        }
        String scanResults = scanResultsBuf.toString();
        if (TextUtils.isEmpty(scanResults)) {
            return;
        }
        LruCache<String, ScanResult> lruCache = this.mScanResultCache;
        synchronized (lruCache) {
            this.mScanResults = new ArrayList<ScanResult>();
            String[] lines = scanResults.split("\n");
            int bssidStrLen = BSSID_STR.length();
            int flagLen = FLAGS_STR.length();
            for (String line : lines) {
                if (line.startsWith(BSSID_STR)) {
                    bssid = new String(line.getBytes(), bssidStrLen, line.length() - bssidStrLen);
                    continue;
                }
                if (line.startsWith(FREQ_STR)) {
                    try {
                        freq = Integer.parseInt(line.substring(FREQ_STR.length()));
                    }
                    catch (NumberFormatException e) {
                        freq = 0;
                    }
                    continue;
                }
                if (line.startsWith(LEVEL_STR)) {
                    try {
                        level = Integer.parseInt(line.substring(LEVEL_STR.length()));
                        if (level <= 0) continue;
                        level -= 256;
                    }
                    catch (NumberFormatException e) {
                        level = 0;
                    }
                    continue;
                }
                if (line.startsWith(TSF_STR)) {
                    try {
                        tsf = Long.parseLong(line.substring(TSF_STR.length()));
                    }
                    catch (NumberFormatException e) {
                        tsf = 0L;
                    }
                    continue;
                }
                if (line.startsWith(FLAGS_STR)) {
                    flags = new String(line.getBytes(), flagLen, line.length() - flagLen);
                    continue;
                }
                if (line.startsWith(SSID_STR)) {
                    wifiSsid = WifiSsid.createFromAsciiEncoded(line.substring(SSID_STR.length()));
                    continue;
                }
                if (!line.startsWith(DELIMITER_STR) && !line.startsWith(END_STR)) continue;
                if (bssid != null) {
                    String ssid = wifiSsid != null ? wifiSsid.toString() : "<unknown ssid>";
                    String key = bssid + ssid;
                    ScanResult scanResult = this.mScanResultCache.get(key);
                    if (scanResult != null) {
                        scanResult.level = level;
                        scanResult.wifiSsid = wifiSsid;
                        scanResult.SSID = wifiSsid != null ? wifiSsid.toString() : "<unknown ssid>";
                        scanResult.capabilities = flags;
                        scanResult.frequency = freq;
                        scanResult.timestamp = tsf;
                    } else {
                        scanResult = new ScanResult(wifiSsid, bssid, flags, level, freq, tsf);
                        this.mScanResultCache.put(key, scanResult);
                    }
                    this.mScanResults.add(scanResult);
                }
                bssid = null;
                level = 0;
                freq = 0;
                tsf = 0L;
                flags = "";
                wifiSsid = null;
            }
        }
    }

    private void fetchRssiAndLinkSpeedNative() {
        int newRssi = -1;
        int newLinkSpeed = -1;
        String signalPoll = this.mWifiNative.signalPoll();
        if (signalPoll != null) {
            String[] lines;
            for (String line : lines = signalPoll.split("\n")) {
                String[] prop = line.split("=");
                if (prop.length < 2) continue;
                try {
                    if (prop[0].equals("RSSI")) {
                        newRssi = Integer.parseInt(prop[1]);
                        continue;
                    }
                    if (!prop[0].equals("LINKSPEED")) continue;
                    newLinkSpeed = Integer.parseInt(prop[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (newRssi != -1 && -200 < newRssi && newRssi < 256) {
            if (newRssi > 0) {
                newRssi -= 256;
            }
            this.mWifiInfo.setRssi(newRssi);
            int newSignalLevel = WifiManager.calculateSignalLevel(newRssi, 5);
            if (newSignalLevel != this.mLastSignalLevel) {
                this.sendRssiChangeBroadcast(newRssi);
            }
            this.mLastSignalLevel = newSignalLevel;
        } else {
            this.mWifiInfo.setRssi(-200);
        }
        if (newLinkSpeed != -1) {
            this.mWifiInfo.setLinkSpeed(newLinkSpeed);
        }
    }

    private void fetchPktcntNative(RssiPacketCountInfo info) {
        String pktcntPoll = this.mWifiNative.pktcntPoll();
        if (pktcntPoll != null) {
            String[] lines;
            for (String line : lines = pktcntPoll.split("\n")) {
                String[] prop = line.split("=");
                if (prop.length < 2) continue;
                try {
                    if (prop[0].equals("TXGOOD")) {
                        info.txgood = Integer.parseInt(prop[1]);
                        continue;
                    }
                    if (!prop[0].equals("TXBAD")) continue;
                    info.txbad = Integer.parseInt(prop[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkProperties() {
        LinkProperties newLp = new LinkProperties();
        newLp.setInterfaceName(this.mInterfaceName);
        newLp.setHttpProxy(this.mWifiConfigStore.getProxyProperties(this.mLastNetworkId));
        newLp.setLinkAddresses(this.mNetlinkLinkProperties.getLinkAddresses());
        Object object = this.mDhcpResultsLock;
        synchronized (object) {
            if (this.mDhcpResults != null && this.mDhcpResults.linkProperties != null) {
                LinkProperties lp = this.mDhcpResults.linkProperties;
                for (RouteInfo route : lp.getRoutes()) {
                    newLp.addRoute(route);
                }
                for (InetAddress dns : lp.getDnses()) {
                    newLp.addDns(dns);
                }
                newLp.setDomains(lp.getDomains());
            }
        }
        if (!newLp.equals(this.mLinkProperties)) {
            this.mLinkProperties = newLp;
            if (this.getNetworkDetailedState() == NetworkInfo.DetailedState.CONNECTED) {
                this.sendLinkConfigurationChangedBroadcast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLinkProperties() {
        if (!this.mWifiConfigStore.isUsingStaticIp(this.mLastNetworkId)) {
            this.mWifiConfigStore.clearLinkProperties(this.mLastNetworkId);
        }
        Object object = this.mDhcpResultsLock;
        synchronized (object) {
            if (this.mDhcpResults != null && this.mDhcpResults.linkProperties != null) {
                this.mDhcpResults.linkProperties.clear();
            }
        }
        this.mNetlinkLinkProperties.clear();
        this.mLinkProperties.clear();
    }

    private int getMaxDhcpRetries() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_max_dhcp_retry_count", 9);
    }

    private void sendScanResultsAvailableBroadcast() {
        this.noteScanEnd();
        Intent intent = new Intent("android.net.wifi.SCAN_RESULTS");
        intent.addFlags(0x4000000);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void sendRssiChangeBroadcast(int newRssi) {
        Intent intent = new Intent("android.net.wifi.RSSI_CHANGED");
        intent.addFlags(0x4000000);
        intent.putExtra("newRssi", newRssi);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void sendNetworkStateChangeBroadcast(String bssid) {
        Intent intent = new Intent("android.net.wifi.STATE_CHANGE");
        intent.addFlags(0x4000000);
        intent.putExtra("networkInfo", new NetworkInfo(this.mNetworkInfo));
        intent.putExtra("linkProperties", new LinkProperties(this.mLinkProperties));
        if (bssid != null) {
            intent.putExtra("bssid", bssid);
        }
        if (this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.VERIFYING_POOR_LINK || this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTED) {
            intent.putExtra("wifiInfo", new WifiInfo(this.mWifiInfo));
        }
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void sendLinkConfigurationChangedBroadcast() {
        Intent intent = new Intent("android.net.wifi.LINK_CONFIGURATION_CHANGED");
        intent.addFlags(0x4000000);
        intent.putExtra("linkProperties", new LinkProperties(this.mLinkProperties));
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void sendSupplicantConnectionChangedBroadcast(boolean connected) {
        Intent intent = new Intent("android.net.wifi.supplicant.CONNECTION_CHANGE");
        intent.addFlags(0x4000000);
        intent.putExtra("connected", connected);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void setNetworkDetailedState(NetworkInfo.DetailedState state) {
        if (state != this.mNetworkInfo.getDetailedState()) {
            this.mNetworkInfo.setDetailedState(state, null, this.mWifiInfo.getSSID());
        }
    }

    private NetworkInfo.DetailedState getNetworkDetailedState() {
        return this.mNetworkInfo.getDetailedState();
    }

    private SupplicantState handleSupplicantStateChange(Message message) {
        StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
        SupplicantState state = stateChangeResult.state;
        this.mWifiInfo.setSupplicantState(state);
        if (SupplicantState.isConnecting(state)) {
            this.mWifiInfo.setNetworkId(stateChangeResult.networkId);
        } else {
            this.mWifiInfo.setNetworkId(-1);
        }
        this.mWifiInfo.setBSSID(stateChangeResult.BSSID);
        this.mWifiInfo.setSSID(stateChangeResult.wifiSsid);
        this.mSupplicantStateTracker.sendMessage(Message.obtain(message));
        return state;
    }

    private void handleNetworkDisconnect() {
        this.stopDhcp();
        try {
            this.mNwService.clearInterfaceAddresses(this.mInterfaceName);
            this.mNwService.disableIpv6(this.mInterfaceName);
        }
        catch (Exception e) {
            this.loge("Failed to clear addresses or disable ipv6" + e);
        }
        this.mWifiInfo.setInetAddress(null);
        this.mWifiInfo.setBSSID(null);
        this.mWifiInfo.setSSID(null);
        this.mWifiInfo.setNetworkId(-1);
        this.mWifiInfo.setRssi(-200);
        this.mWifiInfo.setLinkSpeed(-1);
        this.mWifiInfo.setMeteredHint(false);
        this.setNetworkDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
        this.mWifiConfigStore.updateStatus(this.mLastNetworkId, NetworkInfo.DetailedState.DISCONNECTED);
        this.clearLinkProperties();
        this.sendNetworkStateChangeBroadcast(this.mLastBssid);
        this.mLastBssid = null;
        this.mLastNetworkId = -1;
    }

    private void handleSupplicantConnectionLoss() {
        this.mWifiMonitor.killSupplicant(this.mP2pSupported);
        this.sendSupplicantConnectionChangedBroadcast(false);
        this.setWifiState(1);
    }

    void handlePreDhcpSetup() {
        this.mDhcpActive = true;
        if (!this.mBluetoothConnectionActive) {
            this.mWifiNative.setBluetoothCoexistenceMode(1);
        }
        this.setSuspendOptimizationsNative(1, false);
        this.mWifiNative.setPowerSave(false);
        this.stopBatchedScan();
        Message msg = new Message();
        msg.what = 143375;
        msg.arg1 = 1;
        msg.arg2 = 196615;
        msg.obj = this.mDhcpStateMachine;
        this.mWifiP2pChannel.sendMessage(msg);
    }

    void startDhcp() {
        if (this.mDhcpStateMachine == null) {
            this.mDhcpStateMachine = DhcpStateMachine.makeDhcpStateMachine(this.mContext, this, this.mInterfaceName);
        }
        this.mDhcpStateMachine.registerForPreDhcpNotification();
        this.mDhcpStateMachine.sendMessage(196609);
    }

    void stopDhcp() {
        if (this.mDhcpStateMachine != null) {
            this.handlePostDhcpSetup();
            this.mDhcpStateMachine.sendMessage(196610);
        }
    }

    void handlePostDhcpSetup() {
        this.setSuspendOptimizationsNative(1, true);
        this.mWifiNative.setPowerSave(true);
        this.mWifiP2pChannel.sendMessage(143375, 0);
        this.mWifiNative.setBluetoothCoexistenceMode(2);
        this.mDhcpActive = false;
        this.startBatchedScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSuccessfulIpConfiguration(DhcpResults dhcpResults) {
        this.mLastSignalLevel = -1;
        this.mReconnectCount = 0;
        Object object = this.mDhcpResultsLock;
        synchronized (object) {
            this.mDhcpResults = dhcpResults;
        }
        LinkProperties linkProperties = dhcpResults.linkProperties;
        this.mWifiConfigStore.setLinkProperties(this.mLastNetworkId, new LinkProperties(linkProperties));
        InetAddress addr = null;
        Iterator<InetAddress> addrs = linkProperties.getAddresses().iterator();
        if (addrs.hasNext()) {
            addr = addrs.next();
        }
        this.mWifiInfo.setInetAddress(addr);
        this.mWifiInfo.setMeteredHint(dhcpResults.hasMeteredHint());
        this.updateLinkProperties();
    }

    private void handleFailedIpConfiguration() {
        this.loge("IP configuration failed");
        this.mWifiInfo.setInetAddress(null);
        this.mWifiInfo.setMeteredHint(false);
        int maxRetries = this.getMaxDhcpRetries();
        if (maxRetries > 0 && ++this.mReconnectCount > maxRetries) {
            this.loge("Failed " + this.mReconnectCount + " times, Disabling " + this.mLastNetworkId);
            this.mWifiConfigStore.disableNetwork(this.mLastNetworkId, 2);
            this.mReconnectCount = 0;
        }
        this.mWifiNative.disconnect();
        this.mWifiNative.reconnect();
    }

    private void startSoftApWithConfig(final WifiConfiguration config) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    WifiStateMachine.this.mNwService.startAccessPoint(config, WifiStateMachine.this.mInterfaceName);
                }
                catch (Exception e) {
                    WifiStateMachine.this.loge("Exception in softap start " + e);
                    try {
                        WifiStateMachine.this.mNwService.stopAccessPoint(WifiStateMachine.this.mInterfaceName);
                        WifiStateMachine.this.mNwService.startAccessPoint(config, WifiStateMachine.this.mInterfaceName);
                    }
                    catch (Exception e1) {
                        WifiStateMachine.this.loge("Exception in softap re-start " + e1);
                        WifiStateMachine.this.sendMessage(131095);
                        return;
                    }
                }
                WifiStateMachine.this.sendMessage(131094);
            }
        }).start();
    }

    private void replyToMessage(Message msg, int what) {
        if (msg.replyTo == null) {
            return;
        }
        Message dstMsg = this.obtainMessageWithArg2(msg);
        dstMsg.what = what;
        this.mReplyChannel.replyToMessage(msg, dstMsg);
    }

    private void replyToMessage(Message msg, int what, int arg1) {
        if (msg.replyTo == null) {
            return;
        }
        Message dstMsg = this.obtainMessageWithArg2(msg);
        dstMsg.what = what;
        dstMsg.arg1 = arg1;
        this.mReplyChannel.replyToMessage(msg, dstMsg);
    }

    private void replyToMessage(Message msg, int what, Object obj) {
        if (msg.replyTo == null) {
            return;
        }
        Message dstMsg = this.obtainMessageWithArg2(msg);
        dstMsg.what = what;
        dstMsg.obj = obj;
        this.mReplyChannel.replyToMessage(msg, dstMsg);
    }

    private Message obtainMessageWithArg2(Message srcMsg) {
        Message msg = Message.obtain();
        msg.arg2 = srcMsg.arg2;
        return msg;
    }

    static /* synthetic */ int access$20700(WifiStateMachine x0) {
        return x0.mPeriodicScanToken;
    }

    static /* synthetic */ void access$20800(WifiStateMachine x0, IState x1) {
        x0.transitionTo(x1);
    }

    class UntetheringState
    extends State {
        UntetheringState() {
        }

        public void enter() {
            WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131102, ++WifiStateMachine.this.mTetherToken, 0), 5000L);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131101: {
                    TetherStateChange stateChange = (TetherStateChange)message.obj;
                    if (WifiStateMachine.this.isWifiTethered(stateChange.active)) break;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSoftApStartedState);
                    break;
                }
                case 131102: {
                    if (message.arg1 != WifiStateMachine.this.mTetherToken) break;
                    WifiStateMachine.this.loge("Failed to get tether update, force stop access point");
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSoftApStartedState);
                    break;
                }
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class TetheredState
    extends State {
        TetheredState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131101: {
                    TetherStateChange stateChange = (TetherStateChange)message.obj;
                    if (!WifiStateMachine.this.isWifiTethered(stateChange.active)) {
                        WifiStateMachine.this.loge("Tethering reports wifi as untethered!, shut down soft Ap");
                        WifiStateMachine.this.setHostApRunning(null, false);
                        WifiStateMachine.this.setHostApRunning(null, true);
                    }
                    return true;
                }
                case 131096: {
                    WifiStateMachine.this.setWifiApState(10);
                    WifiStateMachine.this.stopTethering();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mUntetheringState);
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class TetheringState
    extends State {
        TetheringState() {
        }

        public void enter() {
            WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131102, ++WifiStateMachine.this.mTetherToken, 0), 5000L);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131101: {
                    TetherStateChange stateChange = (TetherStateChange)message.obj;
                    if (WifiStateMachine.this.isWifiTethered(stateChange.active)) {
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mTetheredState);
                    }
                    return true;
                }
                case 131102: {
                    if (message.arg1 != WifiStateMachine.this.mTetherToken) break;
                    WifiStateMachine.this.loge("Failed to get tether update, shutdown soft access point");
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSoftApStartedState);
                    WifiStateMachine.this.sendMessageAtFrontOfQueue(131096);
                    break;
                }
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class SoftApStartedState
    extends State {
        SoftApStartedState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131096: {
                    try {
                        WifiStateMachine.this.mNwService.stopAccessPoint(WifiStateMachine.this.mInterfaceName);
                    }
                    catch (Exception e) {
                        WifiStateMachine.this.loge("Exception in stopAccessPoint()");
                    }
                    WifiStateMachine.this.setWifiApState(11);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mInitialState);
                    break;
                }
                case 131093: {
                    break;
                }
                case 131083: {
                    WifiStateMachine.this.loge("Cannot start supplicant with a running soft AP");
                    WifiStateMachine.this.setWifiState(4);
                    break;
                }
                case 131101: {
                    TetherStateChange stateChange = (TetherStateChange)message.obj;
                    if (!WifiStateMachine.this.startTethering(stateChange.available)) break;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mTetheringState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class SoftApStartingState
    extends State {
        SoftApStartingState() {
        }

        public void enter() {
            Message message = WifiStateMachine.this.getCurrentMessage();
            if (message.what == 131093) {
                WifiConfiguration config = (WifiConfiguration)message.obj;
                if (config == null) {
                    WifiStateMachine.this.mWifiApConfigChannel.sendMessage(131099);
                } else {
                    WifiStateMachine.this.mWifiApConfigChannel.sendMessage(131097, config);
                    WifiStateMachine.this.startSoftApWithConfig(config);
                }
            } else {
                throw new RuntimeException("Illegal transition to SoftApStartingState: " + message);
            }
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131101: 
                case 131144: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 131100: {
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    if (config != null) {
                        WifiStateMachine.this.startSoftApWithConfig(config);
                        break;
                    }
                    WifiStateMachine.this.loge("Softap config is null!");
                    WifiStateMachine.this.sendMessage(131095);
                    break;
                }
                case 131094: {
                    WifiStateMachine.this.setWifiApState(13);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSoftApStartedState);
                    break;
                }
                case 131095: {
                    WifiStateMachine.this.setWifiApState(14);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mInitialState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class WpsRunningState
    extends State {
        private Message mSourceMessage;

        WpsRunningState() {
        }

        public void enter() {
            this.mSourceMessage = Message.obtain(WifiStateMachine.this.getCurrentMessage());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147464: {
                    break;
                }
                case 147459: {
                    WifiStateMachine.this.replyToMessage(this.mSourceMessage, 151565);
                    this.mSourceMessage.recycle();
                    this.mSourceMessage = null;
                    WifiStateMachine.this.deferMessage(message);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                case 147466: {
                    WifiStateMachine.this.replyToMessage(this.mSourceMessage, 151564, 3);
                    this.mSourceMessage.recycle();
                    this.mSourceMessage = null;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                case 147465: {
                    WifiStateMachine.this.replyToMessage(this.mSourceMessage, 151564, message.arg1);
                    this.mSourceMessage.recycle();
                    this.mSourceMessage = null;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                case 147467: {
                    WifiStateMachine.this.replyToMessage(this.mSourceMessage, 151564, 7);
                    this.mSourceMessage.recycle();
                    this.mSourceMessage = null;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                case 151562: {
                    WifiStateMachine.this.replyToMessage(message, 151564, 1);
                    break;
                }
                case 151566: {
                    if (WifiStateMachine.this.mWifiNative.cancelWps()) {
                        WifiStateMachine.this.replyToMessage(message, 151568);
                    } else {
                        WifiStateMachine.this.replyToMessage(message, 151567, 0);
                    }
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                case 131086: 
                case 131126: 
                case 131144: 
                case 131146: 
                case 131147: 
                case 151553: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 147460: {
                    WifiStateMachine.this.handleNetworkDisconnect();
                    break;
                }
                case 147499: {
                    break;
                }
                case 147463: {
                    break;
                }
                case 147462: {
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public void exit() {
            WifiStateMachine.this.mWifiConfigStore.enableAllNetworks();
            WifiStateMachine.this.mWifiConfigStore.loadConfiguredNetworks();
        }
    }

    class DisconnectedState
    extends State {
        private boolean mAlarmEnabled = false;
        private long mFrameworkScanIntervalMs;

        DisconnectedState() {
        }

        private void setScanAlarm(boolean enabled) {
            if (enabled == this.mAlarmEnabled) {
                return;
            }
            if (enabled) {
                if (this.mFrameworkScanIntervalMs > 0L) {
                    WifiStateMachine.this.mAlarmManager.setRepeating(0, System.currentTimeMillis() + this.mFrameworkScanIntervalMs, this.mFrameworkScanIntervalMs, WifiStateMachine.this.mScanIntent);
                    this.mAlarmEnabled = true;
                }
            } else {
                WifiStateMachine.this.mAlarmManager.cancel(WifiStateMachine.this.mScanIntent);
                this.mAlarmEnabled = false;
            }
        }

        public void enter() {
            if (WifiStateMachine.this.mTemporarilyDisconnectWifi) {
                WifiStateMachine.this.mWifiP2pChannel.sendMessage(143373);
                return;
            }
            this.mFrameworkScanIntervalMs = Settings.Global.getLong(WifiStateMachine.this.mContext.getContentResolver(), "wifi_framework_scan_interval_ms", WifiStateMachine.this.mDefaultFrameworkScanIntervalMs);
            if (WifiStateMachine.this.mEnableBackgroundScan) {
                if (!WifiStateMachine.this.mScanResultIsPending) {
                    WifiStateMachine.this.mWifiNative.enableBackgroundScan(true);
                }
            } else {
                this.setScanAlarm(true);
            }
            if (!WifiStateMachine.this.mP2pConnected.get() && WifiStateMachine.this.mWifiConfigStore.getConfiguredNetworks().size() == 0) {
                WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131160, ++WifiStateMachine.this.mPeriodicScanToken, 0), WifiStateMachine.this.mSupplicantScanIntervalMs);
            }
        }

        /*
         * Unable to fully structure code
         */
        public boolean processMessage(Message message) {
            ret = true;
            switch (message.what) {
                case 131160: {
                    if (WifiStateMachine.access$2400(WifiStateMachine.this).get() || message.arg1 != WifiStateMachine.access$20700(WifiStateMachine.this) || WifiStateMachine.access$6100(WifiStateMachine.this).getConfiguredNetworks().size() != 0) break;
                    WifiStateMachine.this.sendMessage(131143, -1, 0, null);
                    WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131160, WifiStateMachine.access$20704(WifiStateMachine.this), 0), WifiStateMachine.access$7200(WifiStateMachine.this));
                    break;
                }
                case 131125: 
                case 151556: {
                    WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131160, WifiStateMachine.access$20704(WifiStateMachine.this), 0), WifiStateMachine.access$7200(WifiStateMachine.this));
                    ret = false;
                    break;
                }
                case 131144: {
                    if (message.arg1 == 1) break;
                    WifiStateMachine.access$8602(WifiStateMachine.this, message.arg1);
                    WifiStateMachine.access$6100(WifiStateMachine.this).disableAllNetworks();
                    if (WifiStateMachine.access$8600(WifiStateMachine.this) == 3) {
                        WifiStateMachine.access$800(WifiStateMachine.this).sendMessage(131204);
                        WifiStateMachine.access$3800(WifiStateMachine.this, 1);
                    }
                    WifiStateMachine.access$20800(WifiStateMachine.this, WifiStateMachine.access$11100(WifiStateMachine.this));
                    break;
                }
                case 131163: {
                    WifiStateMachine.access$1502(WifiStateMachine.this, message.arg1 == 1);
                    if (WifiStateMachine.access$1500(WifiStateMachine.this)) {
                        WifiStateMachine.access$3000(WifiStateMachine.this).enableBackgroundScan(true);
                        this.setScanAlarm(false);
                        break;
                    }
                    WifiStateMachine.access$3000(WifiStateMachine.this).enableBackgroundScan(false);
                    this.setScanAlarm(true);
                    break;
                }
                case 147460: {
                    break;
                }
                case 147462: {
                    stateChangeResult = (StateChangeResult)message.obj;
                    WifiStateMachine.access$10700(WifiStateMachine.this, WifiInfo.getDetailedStateOf(stateChangeResult.state));
                    ret = false;
                    break;
                }
                case 131143: {
                    if (WifiStateMachine.access$1500(WifiStateMachine.this)) {
                        WifiStateMachine.access$3000(WifiStateMachine.this).enableBackgroundScan(false);
                    }
                    ret = false;
                    break;
                }
                case 147461: {
                    if (WifiStateMachine.access$1500(WifiStateMachine.this) && WifiStateMachine.access$8400(WifiStateMachine.this)) {
                        WifiStateMachine.access$3000(WifiStateMachine.this).enableBackgroundScan(true);
                    }
                    ret = false;
                    break;
                }
                case 143371: {
                    info = (NetworkInfo)message.obj;
                    WifiStateMachine.access$2400(WifiStateMachine.this).set(info.isConnected());
                    if (!WifiStateMachine.access$2400(WifiStateMachine.this).get()) ** GOTO lbl57
                    defaultInterval = WifiStateMachine.access$300(WifiStateMachine.this).getResources().getInteger(0x10E0010);
                    scanIntervalMs = Settings.Global.getLong(WifiStateMachine.access$300(WifiStateMachine.this).getContentResolver(), "wifi_scan_interval_p2p_connected_ms", defaultInterval);
                    WifiStateMachine.access$3000(WifiStateMachine.this).setScanInterval((int)scanIntervalMs / 1000);
                    ** GOTO lbl59
lbl57:
                    // 1 sources

                    if (WifiStateMachine.access$6100(WifiStateMachine.this).getConfiguredNetworks().size() == 0) {
                        WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131160, WifiStateMachine.access$20704(WifiStateMachine.this), 0), WifiStateMachine.access$7200(WifiStateMachine.this));
                    }
                }
lbl59:
                // 5 sources

                case 131146: 
                case 131147: {
                    if (WifiStateMachine.access$2500(WifiStateMachine.this)) break;
                    ret = false;
                    break;
                }
                default: {
                    ret = false;
                }
            }
            return ret;
        }

        public void exit() {
            if (WifiStateMachine.this.mEnableBackgroundScan) {
                WifiStateMachine.this.mWifiNative.enableBackgroundScan(false);
            }
            this.setScanAlarm(false);
        }
    }

    class DisconnectingState
    extends State {
        DisconnectingState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131144: {
                    if (message.arg1 == 1) break;
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 147462: {
                    WifiStateMachine.this.deferMessage(message);
                    WifiStateMachine.this.handleNetworkDisconnect();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class ConnectedState
    extends State {
        ConnectedState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 135189: {
                    try {
                        WifiStateMachine.this.mNwService.disableIpv6(WifiStateMachine.this.mInterfaceName);
                    }
                    catch (RemoteException re) {
                        WifiStateMachine.this.loge("Failed to disable IPv6: " + re);
                    }
                    catch (IllegalStateException e) {
                        WifiStateMachine.this.loge("Failed to disable IPv6: " + e);
                    }
                    WifiStateMachine.this.setNetworkDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
                    WifiStateMachine.this.mWifiConfigStore.updateStatus(WifiStateMachine.this.mLastNetworkId, NetworkInfo.DetailedState.DISCONNECTED);
                    WifiStateMachine.this.sendNetworkStateChangeBroadcast(WifiStateMachine.this.mLastBssid);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mVerifyingLinkState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public void exit() {
            WifiStateMachine.this.checkAndSetConnectivityInstance();
            WifiStateMachine.this.mCm.requestNetworkTransitionWakelock(this.getName());
        }
    }

    class CaptivePortalCheckState
    extends State {
        CaptivePortalCheckState() {
        }

        public void enter() {
            WifiStateMachine.this.log(this.getName() + " enter");
            WifiStateMachine.this.setNetworkDetailedState(NetworkInfo.DetailedState.CAPTIVE_PORTAL_CHECK);
            WifiStateMachine.this.mWifiConfigStore.updateStatus(WifiStateMachine.this.mLastNetworkId, NetworkInfo.DetailedState.CAPTIVE_PORTAL_CHECK);
            WifiStateMachine.this.sendNetworkStateChangeBroadcast(WifiStateMachine.this.mLastBssid);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131092: {
                    WifiStateMachine.this.log(this.getName() + " CMD_CAPTIVE_CHECK_COMPLETE");
                    try {
                        WifiStateMachine.this.mNwService.enableIpv6(WifiStateMachine.this.mInterfaceName);
                    }
                    catch (RemoteException re) {
                        WifiStateMachine.this.loge("Failed to enable IPv6: " + re);
                    }
                    catch (IllegalStateException e) {
                        WifiStateMachine.this.loge("Failed to enable IPv6: " + e);
                    }
                    WifiStateMachine.this.setNetworkDetailedState(NetworkInfo.DetailedState.CONNECTED);
                    WifiStateMachine.this.mWifiConfigStore.updateStatus(WifiStateMachine.this.mLastNetworkId, NetworkInfo.DetailedState.CONNECTED);
                    WifiStateMachine.this.sendNetworkStateChangeBroadcast(WifiStateMachine.this.mLastBssid);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mConnectedState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class VerifyingLinkState
    extends State {
        VerifyingLinkState() {
        }

        public void enter() {
            WifiStateMachine.this.log(this.getName() + " enter");
            WifiStateMachine.this.setNetworkDetailedState(NetworkInfo.DetailedState.VERIFYING_POOR_LINK);
            WifiStateMachine.this.mWifiConfigStore.updateStatus(WifiStateMachine.this.mLastNetworkId, NetworkInfo.DetailedState.VERIFYING_POOR_LINK);
            WifiStateMachine.this.sendNetworkStateChangeBroadcast(WifiStateMachine.this.mLastBssid);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 135189: {
                    WifiStateMachine.this.log(this.getName() + " POOR_LINK_DETECTED: no transition");
                    break;
                }
                case 135190: {
                    WifiStateMachine.this.log(this.getName() + " GOOD_LINK_DETECTED: transition to captive portal check");
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mCaptivePortalCheckState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class ObtainingIpState
    extends State {
        ObtainingIpState() {
        }

        public void enter() {
            if (!WifiStateMachine.this.mWifiConfigStore.isUsingStaticIp(WifiStateMachine.this.mLastNetworkId)) {
                WifiStateMachine.this.startDhcp();
            } else {
                WifiStateMachine.this.stopDhcp();
                DhcpResults dhcpResults = new DhcpResults(WifiStateMachine.this.mWifiConfigStore.getLinkProperties(WifiStateMachine.this.mLastNetworkId));
                InterfaceConfiguration ifcg = new InterfaceConfiguration();
                Iterator<LinkAddress> addrs = dhcpResults.linkProperties.getLinkAddresses().iterator();
                if (!addrs.hasNext()) {
                    WifiStateMachine.this.loge("Static IP lacks address");
                    WifiStateMachine.this.sendMessage(131088);
                } else {
                    ifcg.setLinkAddress(addrs.next());
                    ifcg.setInterfaceUp();
                    try {
                        WifiStateMachine.this.mNwService.setInterfaceConfig(WifiStateMachine.this.mInterfaceName, ifcg);
                        WifiStateMachine.this.sendMessage(131087, dhcpResults);
                    }
                    catch (RemoteException re) {
                        WifiStateMachine.this.loge("Static IP configuration failed: " + re);
                        WifiStateMachine.this.sendMessage(131088);
                    }
                    catch (IllegalStateException e) {
                        WifiStateMachine.this.loge("Static IP configuration failed: " + e);
                        WifiStateMachine.this.sendMessage(131088);
                    }
                }
            }
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131087: {
                    WifiStateMachine.this.handleSuccessfulIpConfiguration((DhcpResults)message.obj);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mVerifyingLinkState);
                    break;
                }
                case 131088: {
                    WifiStateMachine.this.handleFailedIpConfiguration();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 151559: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 131149: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 131143: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class L2ConnectedState
    extends State {
        L2ConnectedState() {
        }

        public void enter() {
            WifiStateMachine.this.mRssiPollToken++;
            if (WifiStateMachine.this.mEnableRssiPolling) {
                WifiStateMachine.this.sendMessage(131155, WifiStateMachine.this.mRssiPollToken, 0);
            }
        }

        public void exit() {
            WifiStateMachine.this.handleNetworkDisconnect();
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 196612: {
                    WifiStateMachine.this.handlePreDhcpSetup();
                    break;
                }
                case 196613: {
                    WifiStateMachine.this.handlePostDhcpSetup();
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.handleSuccessfulIpConfiguration((DhcpResults)message.obj);
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mVerifyingLinkState);
                        break;
                    }
                    if (message.arg1 != 2) break;
                    WifiStateMachine.this.handleFailedIpConfiguration();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 131145: {
                    WifiStateMachine.this.mWifiNative.disconnect();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 143372: {
                    if (message.arg1 != 1) break;
                    WifiStateMachine.this.mWifiNative.disconnect();
                    WifiStateMachine.this.mTemporarilyDisconnectWifi = true;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 131144: {
                    if (message.arg1 == 1) break;
                    WifiStateMachine.this.sendMessage(131145);
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 131143: {
                    WifiStateMachine.this.noteScanStart(message.arg1, (WorkSource)message.obj);
                    WifiStateMachine.this.startScanNative(1);
                    break;
                }
                case 151553: {
                    int netId = message.arg1;
                    if (WifiStateMachine.this.mWifiInfo.getNetworkId() == netId) break;
                    return false;
                }
                case 151559: {
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    NetworkUpdateResult result = WifiStateMachine.this.mWifiConfigStore.saveNetwork(config);
                    if (WifiStateMachine.this.mWifiInfo.getNetworkId() == result.getNetworkId()) {
                        if (result.hasIpChanged()) {
                            WifiStateMachine.this.log("Reconfiguring IP on connection");
                            WifiStateMachine.this.transitionTo(WifiStateMachine.this.mObtainingIpState);
                        }
                        if (result.hasProxyChanged()) {
                            WifiStateMachine.this.log("Reconfiguring proxy on connection");
                            WifiStateMachine.this.updateLinkProperties();
                        }
                    }
                    if (result.getNetworkId() != -1) {
                        WifiStateMachine.this.replyToMessage(message, 151561);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to save network");
                    WifiStateMachine.this.replyToMessage(message, 151560, 0);
                    break;
                }
                case 147459: {
                    break;
                }
                case 131155: {
                    if (message.arg1 != WifiStateMachine.this.mRssiPollToken) break;
                    WifiStateMachine.this.fetchRssiAndLinkSpeedNative();
                    WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131155, WifiStateMachine.this.mRssiPollToken, 0), 3000L);
                    break;
                }
                case 131154: {
                    WifiStateMachine.this.mEnableRssiPolling = message.arg1 == 1;
                    WifiStateMachine.this.mRssiPollToken++;
                    if (!WifiStateMachine.this.mEnableRssiPolling) break;
                    WifiStateMachine.this.fetchRssiAndLinkSpeedNative();
                    WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131155, WifiStateMachine.this.mRssiPollToken, 0), 3000L);
                    break;
                }
                case 151572: {
                    RssiPacketCountInfo info = new RssiPacketCountInfo();
                    WifiStateMachine.this.fetchRssiAndLinkSpeedNative();
                    info.rssi = WifiStateMachine.this.mWifiInfo.getRssi();
                    WifiStateMachine.this.fetchPktcntNative(info);
                    WifiStateMachine.this.replyToMessage(message, 151573, info);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class ConnectModeState
    extends State {
        ConnectModeState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147499: {
                    WifiStateMachine.this.mSupplicantStateTracker.sendMessage(147499);
                    break;
                }
                case 147463: {
                    WifiStateMachine.this.mSupplicantStateTracker.sendMessage(147463);
                    break;
                }
                case 147462: {
                    SupplicantState state = WifiStateMachine.this.handleSupplicantStateChange(message);
                    if (!SupplicantState.isDriverActive(state)) {
                        if (WifiStateMachine.this.mNetworkInfo.getState() != NetworkInfo.State.DISCONNECTED) {
                            WifiStateMachine.this.handleNetworkDisconnect();
                        }
                        WifiStateMachine.this.log("Detected an interface down, restart driver");
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStoppedState);
                        WifiStateMachine.this.sendMessage(131085);
                        break;
                    }
                    if (state != SupplicantState.DISCONNECTED || WifiStateMachine.this.mNetworkInfo.getState() == NetworkInfo.State.DISCONNECTED) break;
                    WifiStateMachine.this.handleNetworkDisconnect();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                case 143372: {
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.mWifiNative.disconnect();
                        WifiStateMachine.this.mTemporarilyDisconnectWifi = true;
                        break;
                    }
                    WifiStateMachine.this.mWifiNative.reconnect();
                    WifiStateMachine.this.mTemporarilyDisconnectWifi = false;
                    break;
                }
                case 131124: {
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    WifiStateMachine.this.replyToMessage(message, 131124, WifiStateMachine.this.mWifiConfigStore.addOrUpdateNetwork(config));
                    break;
                }
                case 131125: {
                    boolean ok = WifiStateMachine.this.mWifiConfigStore.removeNetwork(message.arg1);
                    WifiStateMachine.this.replyToMessage(message, message.what, ok ? 1 : -1);
                    break;
                }
                case 131126: {
                    boolean ok = WifiStateMachine.this.mWifiConfigStore.enableNetwork(message.arg1, message.arg2 == 1);
                    WifiStateMachine.this.replyToMessage(message, message.what, ok ? 1 : -1);
                    break;
                }
                case 131127: {
                    long time = SystemClock.elapsedRealtime();
                    if (time - WifiStateMachine.this.mLastEnableAllNetworksTime <= 600000L) break;
                    WifiStateMachine.this.mWifiConfigStore.enableAllNetworks();
                    WifiStateMachine.this.mLastEnableAllNetworksTime = time;
                    break;
                }
                case 151569: {
                    if (WifiStateMachine.this.mWifiConfigStore.disableNetwork(message.arg1, 0)) {
                        WifiStateMachine.this.replyToMessage(message, 151571);
                        break;
                    }
                    WifiStateMachine.this.replyToMessage(message, 151570, 0);
                    break;
                }
                case 131128: {
                    WifiStateMachine.this.mWifiNative.addToBlacklist((String)message.obj);
                    break;
                }
                case 131129: {
                    WifiStateMachine.this.mWifiNative.clearBlacklist();
                    break;
                }
                case 131130: {
                    boolean ok = WifiStateMachine.this.mWifiConfigStore.saveConfig();
                    WifiStateMachine.this.replyToMessage(message, 131130, ok ? 1 : -1);
                    IBackupManager ibm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                    if (ibm == null) break;
                    try {
                        ibm.dataChanged("com.android.providers.settings");
                    }
                    catch (Exception e) {}
                    break;
                }
                case 131131: {
                    WifiStateMachine.this.replyToMessage(message, message.what, WifiStateMachine.this.mWifiConfigStore.getConfiguredNetworks());
                    break;
                }
                case 131145: {
                    WifiStateMachine.this.mWifiNative.disconnect();
                    break;
                }
                case 131146: {
                    WifiStateMachine.this.mWifiNative.reconnect();
                    break;
                }
                case 131147: {
                    WifiStateMachine.this.mWifiNative.reassociate();
                    break;
                }
                case 131214: {
                    if (!WifiStateMachine.this.mWifiConfigStore.needsUnlockedKeyStore()) break;
                    WifiStateMachine.this.logd("Reconnecting to give a chance to un-connected TLS networks");
                    WifiStateMachine.this.mWifiNative.disconnect();
                    WifiStateMachine.this.mWifiNative.reconnect();
                    break;
                }
                case 151553: {
                    int netId = message.arg1;
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    if (config != null) {
                        NetworkUpdateResult result = WifiStateMachine.this.mWifiConfigStore.saveNetwork(config);
                        netId = result.getNetworkId();
                    }
                    if (WifiStateMachine.this.mWifiConfigStore.selectNetwork(netId) && WifiStateMachine.this.mWifiNative.reconnect()) {
                        WifiStateMachine.this.mSupplicantStateTracker.sendMessage(151553);
                        WifiStateMachine.this.replyToMessage(message, 151555);
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to connect config: " + config + " netId: " + netId);
                    WifiStateMachine.this.replyToMessage(message, 151554, 0);
                    break;
                }
                case 151559: {
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    NetworkUpdateResult result = WifiStateMachine.this.mWifiConfigStore.saveNetwork(config);
                    if (result.getNetworkId() != -1) {
                        WifiStateMachine.this.replyToMessage(message, 151561);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to save network");
                    WifiStateMachine.this.replyToMessage(message, 151560, 0);
                    break;
                }
                case 151556: {
                    if (WifiStateMachine.this.mWifiConfigStore.forgetNetwork(message.arg1)) {
                        WifiStateMachine.this.replyToMessage(message, 151558);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to forget network");
                    WifiStateMachine.this.replyToMessage(message, 151557, 0);
                    break;
                }
                case 151562: {
                    WpsResult wpsResult;
                    WpsInfo wpsInfo = (WpsInfo)message.obj;
                    switch (wpsInfo.setup) {
                        case 0: {
                            wpsResult = WifiStateMachine.this.mWifiConfigStore.startWpsPbc(wpsInfo);
                            break;
                        }
                        case 2: {
                            wpsResult = WifiStateMachine.this.mWifiConfigStore.startWpsWithPinFromAccessPoint(wpsInfo);
                            break;
                        }
                        case 1: {
                            wpsResult = WifiStateMachine.this.mWifiConfigStore.startWpsWithPinFromDevice(wpsInfo);
                            break;
                        }
                        default: {
                            wpsResult = new WpsResult(WpsResult.Status.FAILURE);
                            WifiStateMachine.this.loge("Invalid setup for WPS");
                        }
                    }
                    if (wpsResult.status == WpsResult.Status.SUCCESS) {
                        WifiStateMachine.this.replyToMessage(message, 151563, wpsResult);
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mWpsRunningState);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to start WPS with config " + wpsInfo.toString());
                    WifiStateMachine.this.replyToMessage(message, 151564, 0);
                    break;
                }
                case 147459: {
                    WifiStateMachine.this.mLastNetworkId = message.arg1;
                    WifiStateMachine.this.mLastBssid = (String)message.obj;
                    WifiStateMachine.this.mWifiInfo.setBSSID(WifiStateMachine.this.mLastBssid);
                    WifiStateMachine.this.mWifiInfo.setNetworkId(WifiStateMachine.this.mLastNetworkId);
                    WifiStateMachine.this.setNetworkDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR);
                    WifiStateMachine.this.sendNetworkStateChangeBroadcast(WifiStateMachine.this.mLastBssid);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mObtainingIpState);
                    break;
                }
                case 147460: {
                    WifiStateMachine.this.handleNetworkDisconnect();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class ScanModeState
    extends State {
        private int mLastOperationMode;

        ScanModeState() {
        }

        public void enter() {
            this.mLastOperationMode = WifiStateMachine.this.mOperationalMode;
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131144: {
                    if (message.arg1 == 1) {
                        if (this.mLastOperationMode == 3) {
                            WifiStateMachine.this.setWifiState(3);
                            WifiStateMachine.this.mWifiConfigStore.loadAndEnableAllNetworks();
                            WifiStateMachine.this.mWifiP2pChannel.sendMessage(131203);
                        } else {
                            WifiStateMachine.this.mWifiConfigStore.enableAllNetworks();
                        }
                        WifiStateMachine.this.mWifiNative.reconnect();
                        WifiStateMachine.this.mOperationalMode = 1;
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                        break;
                    }
                    return true;
                }
                case 131143: {
                    WifiStateMachine.this.noteScanStart(message.arg1, (WorkSource)message.obj);
                    WifiStateMachine.this.startScanNative(1);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class DriverStoppedState
    extends State {
        DriverStoppedState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147462: {
                    StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
                    SupplicantState state = stateChangeResult.state;
                    if (!SupplicantState.isDriverActive(state)) break;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStartedState);
                    break;
                }
                case 131085: {
                    WifiStateMachine.this.mWakeLock.acquire();
                    WifiStateMachine.this.mWifiNative.startDriver();
                    WifiStateMachine.this.mWakeLock.release();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStartingState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class DriverStoppingState
    extends State {
        DriverStoppingState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147462: {
                    SupplicantState state = WifiStateMachine.this.handleSupplicantStateChange(message);
                    if (state != SupplicantState.INTERFACE_DISABLED) break;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStoppedState);
                    break;
                }
                case 131085: 
                case 131086: 
                case 131143: 
                case 131145: 
                case 131146: 
                case 131147: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class WaitForP2pDisableState
    extends State {
        private State mTransitionToState;

        WaitForP2pDisableState() {
        }

        public void enter() {
            switch (((WifiStateMachine)WifiStateMachine.this).getCurrentMessage().what) {
                case 147458: {
                    this.mTransitionToState = WifiStateMachine.this.mInitialState;
                    break;
                }
                case 131090: {
                    this.mTransitionToState = WifiStateMachine.this.mDriverStoppingState;
                    break;
                }
                case 131084: {
                    this.mTransitionToState = WifiStateMachine.this.mSupplicantStoppingState;
                    break;
                }
                default: {
                    this.mTransitionToState = WifiStateMachine.this.mDriverStoppingState;
                }
            }
            WifiStateMachine.this.mWifiP2pChannel.sendMessage(131204);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131205: {
                    WifiStateMachine.this.transitionTo(this.mTransitionToState);
                    break;
                }
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131143: 
                case 131144: 
                case 131145: 
                case 131146: 
                case 131147: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: 
                case 147462: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class DriverStartedState
    extends State {
        DriverStartedState() {
        }

        public void enter() {
            WifiStateMachine.this.mIsRunning = true;
            WifiStateMachine.this.mInDelayedStop = false;
            WifiStateMachine.this.mDelayedStopCounter++;
            WifiStateMachine.this.updateBatteryWorkSource(null);
            WifiStateMachine.this.mWifiNative.setBluetoothCoexistenceScanMode(WifiStateMachine.this.mBluetoothConnectionActive);
            WifiStateMachine.this.setCountryCode();
            WifiStateMachine.this.setFrequencyBand();
            WifiStateMachine.this.setNetworkDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
            WifiStateMachine.this.mWifiNative.stopFilteringMulticastV6Packets();
            if (WifiStateMachine.this.mFilteringMulticastV4Packets.get()) {
                WifiStateMachine.this.mWifiNative.startFilteringMulticastV4Packets();
            } else {
                WifiStateMachine.this.mWifiNative.stopFilteringMulticastV4Packets();
            }
            WifiStateMachine.this.mDhcpActive = false;
            WifiStateMachine.this.startBatchedScan();
            if (WifiStateMachine.this.mOperationalMode != 1) {
                WifiStateMachine.this.mWifiNative.disconnect();
                WifiStateMachine.this.mWifiConfigStore.disableAllNetworks();
                if (WifiStateMachine.this.mOperationalMode == 3) {
                    WifiStateMachine.this.setWifiState(1);
                }
                WifiStateMachine.this.transitionTo(WifiStateMachine.this.mScanModeState);
            } else {
                WifiStateMachine.this.mWifiConfigStore.enableAllNetworks();
                WifiStateMachine.this.mWifiNative.reconnect();
                WifiStateMachine.this.mWifiNative.status();
                WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
            }
            if (!WifiStateMachine.this.mScreenBroadcastReceived.get()) {
                PowerManager powerManager = (PowerManager)WifiStateMachine.this.mContext.getSystemService("power");
                WifiStateMachine.this.handleScreenStateChanged(powerManager.isScreenOn());
            } else {
                WifiStateMachine.this.mWifiNative.setSuspendOptimizations(WifiStateMachine.this.mSuspendOptNeedsDisabled == 0 && WifiStateMachine.this.mUserWantsSuspendOpt.get());
            }
            WifiStateMachine.this.mWifiNative.setPowerSave(true);
            if (WifiStateMachine.this.mP2pSupported && WifiStateMachine.this.mOperationalMode == 1) {
                WifiStateMachine.this.mWifiP2pChannel.sendMessage(131203);
            }
            Intent intent = new Intent("wifi_scan_available");
            intent.addFlags(0x4000000);
            intent.putExtra("scan_enabled", 3);
            WifiStateMachine.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131143: {
                    WifiStateMachine.this.noteScanStart(message.arg1, (WorkSource)message.obj);
                    WifiStateMachine.this.startScanNative(2);
                    break;
                }
                case 131207: {
                    if (!WifiStateMachine.this.recordBatchedScanSettings(message.arg1, message.arg2, (Bundle)message.obj)) break;
                    WifiStateMachine.this.startBatchedScan();
                    break;
                }
                case 131152: {
                    String country = (String)message.obj;
                    if (country == null) break;
                    country = country.toUpperCase(Locale.ROOT);
                    if (WifiStateMachine.this.mLastSetCountryCode != null && country.equals(WifiStateMachine.this.mLastSetCountryCode)) break;
                    if (WifiStateMachine.this.mWifiNative.setCountryCode(country)) {
                        WifiStateMachine.this.mLastSetCountryCode = country;
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to set country code " + country);
                    break;
                }
                case 131162: {
                    int band = message.arg1;
                    if (WifiStateMachine.this.mWifiNative.setBand(band)) {
                        WifiStateMachine.this.mFrequencyBand.set(band);
                        WifiStateMachine.this.mWifiNative.bssFlush();
                        WifiStateMachine.this.startScanNative(2);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to set frequency band " + band);
                    break;
                }
                case 131103: {
                    WifiStateMachine.this.mBluetoothConnectionActive = message.arg1 != 0;
                    WifiStateMachine.this.mWifiNative.setBluetoothCoexistenceScanMode(WifiStateMachine.this.mBluetoothConnectionActive);
                    break;
                }
                case 131086: {
                    int mode = message.arg1;
                    if (WifiStateMachine.this.mInDelayedStop) break;
                    WifiStateMachine.this.mWifiConfigStore.disableAllNetworks();
                    WifiStateMachine.this.mInDelayedStop = true;
                    WifiStateMachine.this.mDelayedStopCounter++;
                    Intent driverStopIntent = new Intent(WifiStateMachine.ACTION_DELAYED_DRIVER_STOP, null);
                    driverStopIntent.putExtra(WifiStateMachine.DELAYED_STOP_COUNTER, WifiStateMachine.this.mDelayedStopCounter);
                    WifiStateMachine.this.mDriverStopIntent = PendingIntent.getBroadcast(WifiStateMachine.this.mContext, 0, driverStopIntent, 0x8000000);
                    WifiStateMachine.this.mAlarmManager.set(0, System.currentTimeMillis() + (long)WifiStateMachine.this.mDriverStopDelayMs, WifiStateMachine.this.mDriverStopIntent);
                    break;
                }
                case 131085: {
                    if (!WifiStateMachine.this.mInDelayedStop) break;
                    WifiStateMachine.this.mInDelayedStop = false;
                    WifiStateMachine.this.mDelayedStopCounter++;
                    WifiStateMachine.this.mAlarmManager.cancel(WifiStateMachine.this.mDriverStopIntent);
                    if (WifiStateMachine.this.mOperationalMode != 1) break;
                    WifiStateMachine.this.mWifiConfigStore.enableAllNetworks();
                    break;
                }
                case 131090: {
                    if (message.arg1 != WifiStateMachine.this.mDelayedStopCounter) break;
                    if (WifiStateMachine.this.getCurrentState() != WifiStateMachine.this.mDisconnectedState) {
                        WifiStateMachine.this.mWifiNative.disconnect();
                        WifiStateMachine.this.handleNetworkDisconnect();
                    }
                    WifiStateMachine.this.mWakeLock.acquire();
                    WifiStateMachine.this.mWifiNative.stopDriver();
                    WifiStateMachine.this.mWakeLock.release();
                    if (WifiStateMachine.this.mP2pSupported) {
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mWaitForP2pDisableState);
                        break;
                    }
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStoppingState);
                    break;
                }
                case 131156: {
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.mWifiNative.startFilteringMulticastV6Packets();
                        break;
                    }
                    if (message.arg1 == 0) {
                        WifiStateMachine.this.mWifiNative.startFilteringMulticastV4Packets();
                        break;
                    }
                    WifiStateMachine.this.loge("Illegal arugments to CMD_START_PACKET_FILTERING");
                    break;
                }
                case 131157: {
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.mWifiNative.stopFilteringMulticastV6Packets();
                        break;
                    }
                    if (message.arg1 == 0) {
                        WifiStateMachine.this.mWifiNative.stopFilteringMulticastV4Packets();
                        break;
                    }
                    WifiStateMachine.this.loge("Illegal arugments to CMD_STOP_PACKET_FILTERING");
                    break;
                }
                case 131158: {
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.setSuspendOptimizationsNative(4, true);
                        WifiStateMachine.this.mSuspendWakeLock.release();
                        break;
                    }
                    WifiStateMachine.this.setSuspendOptimizationsNative(4, false);
                    break;
                }
                case 131149: {
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.setSuspendOptimizationsNative(2, false);
                        break;
                    }
                    WifiStateMachine.this.setSuspendOptimizationsNative(2, true);
                    break;
                }
                case 131164: {
                    if (message.obj == null) break;
                    String remoteAddress = (String)message.obj;
                    boolean enable = message.arg1 == 1;
                    WifiStateMachine.this.mWifiNative.startTdls(remoteAddress, enable);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public void exit() {
            WifiStateMachine.this.mIsRunning = false;
            WifiStateMachine.this.updateBatteryWorkSource(null);
            WifiStateMachine.this.mScanResults = new ArrayList();
            WifiStateMachine.this.stopBatchedScan();
            Intent intent = new Intent("wifi_scan_available");
            intent.addFlags(0x4000000);
            intent.putExtra("scan_enabled", 1);
            WifiStateMachine.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            WifiStateMachine.this.noteScanEnd();
            WifiStateMachine.this.mLastSetCountryCode = null;
        }
    }

    class DriverStartingState
    extends State {
        private int mTries;

        DriverStartingState() {
        }

        public void enter() {
            this.mTries = 1;
            WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131091, ++WifiStateMachine.this.mDriverStartToken, 0), 10000L);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147462: {
                    SupplicantState state = WifiStateMachine.this.handleSupplicantStateChange(message);
                    if (!SupplicantState.isDriverActive(state)) break;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStartedState);
                    break;
                }
                case 131091: {
                    if (message.arg1 != WifiStateMachine.this.mDriverStartToken) break;
                    if (this.mTries >= 2) {
                        WifiStateMachine.this.loge("Failed to start driver after " + this.mTries);
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStoppedState);
                        break;
                    }
                    WifiStateMachine.this.loge("Driver start failed, retrying");
                    WifiStateMachine.this.mWakeLock.acquire();
                    WifiStateMachine.this.mWifiNative.startDriver();
                    WifiStateMachine.this.mWakeLock.release();
                    ++this.mTries;
                    WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131091, ++WifiStateMachine.this.mDriverStartToken, 0), 10000L);
                    break;
                }
                case 131085: 
                case 131086: 
                case 131143: 
                case 131145: 
                case 131146: 
                case 131147: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: 
                case 147459: 
                case 147460: 
                case 147463: 
                case 147466: 
                case 147499: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class SupplicantStoppingState
    extends State {
        SupplicantStoppingState() {
        }

        public void enter() {
            WifiStateMachine.this.handleNetworkDisconnect();
            if (WifiStateMachine.this.mDhcpStateMachine != null) {
                WifiStateMachine.this.mDhcpStateMachine.doQuit();
            }
            WifiStateMachine.this.mWifiMonitor.stopSupplicant();
            WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131089, ++WifiStateMachine.this.mSupplicantStopFailureToken, 0), 5000L);
            WifiStateMachine.this.setWifiState(0);
            WifiStateMachine.this.mSupplicantStateTracker.sendMessage(131183);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147457: {
                    WifiStateMachine.this.loge("Supplicant connection received while stopping");
                    break;
                }
                case 147458: {
                    WifiStateMachine.this.handleSupplicantConnectionLoss();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mInitialState);
                    break;
                }
                case 131089: {
                    if (message.arg1 != WifiStateMachine.this.mSupplicantStopFailureToken) break;
                    WifiStateMachine.this.loge("Timed out on a supplicant stop, kill and proceed");
                    WifiStateMachine.this.handleSupplicantConnectionLoss();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mInitialState);
                    break;
                }
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class SupplicantStartedState
    extends State {
        SupplicantStartedState() {
        }

        public void enter() {
            WifiStateMachine.this.mNetworkInfo.setIsAvailable(true);
            int defaultInterval = WifiStateMachine.this.mContext.getResources().getInteger(17694735);
            WifiStateMachine.this.mSupplicantScanIntervalMs = Settings.Global.getLong(WifiStateMachine.this.mContext.getContentResolver(), "wifi_supplicant_scan_interval_ms", defaultInterval);
            WifiStateMachine.this.mWifiNative.setScanInterval((int)WifiStateMachine.this.mSupplicantScanIntervalMs / 1000);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131084: {
                    if (WifiStateMachine.this.mP2pSupported) {
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mWaitForP2pDisableState);
                        break;
                    }
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSupplicantStoppingState);
                    break;
                }
                case 147458: {
                    WifiStateMachine.this.loge("Connection lost, restart supplicant");
                    WifiStateMachine.this.handleSupplicantConnectionLoss();
                    WifiStateMachine.this.handleNetworkDisconnect();
                    WifiStateMachine.this.mSupplicantStateTracker.sendMessage(131183);
                    if (WifiStateMachine.this.mP2pSupported) {
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mWaitForP2pDisableState);
                    } else {
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mInitialState);
                    }
                    WifiStateMachine.this.sendMessageDelayed(131083, 5000L);
                    break;
                }
                case 147461: {
                    WifiStateMachine.this.setScanResults();
                    WifiStateMachine.this.sendScanResultsAvailableBroadcast();
                    WifiStateMachine.this.mScanResultIsPending = false;
                    break;
                }
                case 131123: {
                    boolean ok = WifiStateMachine.this.mWifiNative.ping();
                    WifiStateMachine.this.replyToMessage(message, message.what, ok ? 1 : -1);
                    break;
                }
                case 131093: {
                    WifiStateMachine.this.loge("Failed to start soft AP with a running supplicant");
                    WifiStateMachine.this.setWifiApState(14);
                    break;
                }
                case 131144: {
                    WifiStateMachine.this.mOperationalMode = message.arg1;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public void exit() {
            WifiStateMachine.this.mNetworkInfo.setIsAvailable(false);
        }
    }

    class SupplicantStartingState
    extends State {
        SupplicantStartingState() {
        }

        private void initializeWpsDetails() {
            String detail = SystemProperties.get("ro.product.name", "");
            if (!WifiStateMachine.this.mWifiNative.setDeviceName(detail)) {
                WifiStateMachine.this.loge("Failed to set device name " + detail);
            }
            detail = SystemProperties.get("ro.product.manufacturer", "");
            if (!WifiStateMachine.this.mWifiNative.setManufacturer(detail)) {
                WifiStateMachine.this.loge("Failed to set manufacturer " + detail);
            }
            detail = SystemProperties.get("ro.product.model", "");
            if (!WifiStateMachine.this.mWifiNative.setModelName(detail)) {
                WifiStateMachine.this.loge("Failed to set model name " + detail);
            }
            detail = SystemProperties.get("ro.product.model", "");
            if (!WifiStateMachine.this.mWifiNative.setModelNumber(detail)) {
                WifiStateMachine.this.loge("Failed to set model number " + detail);
            }
            detail = SystemProperties.get("ro.serialno", "");
            if (!WifiStateMachine.this.mWifiNative.setSerialNumber(detail)) {
                WifiStateMachine.this.loge("Failed to set serial number " + detail);
            }
            if (!WifiStateMachine.this.mWifiNative.setConfigMethods("physical_display virtual_push_button")) {
                WifiStateMachine.this.loge("Failed to set WPS config methods");
            }
            if (!WifiStateMachine.this.mWifiNative.setDeviceType(WifiStateMachine.this.mPrimaryDeviceType)) {
                WifiStateMachine.this.loge("Failed to set primary device type " + WifiStateMachine.this.mPrimaryDeviceType);
            }
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147457: {
                    WifiStateMachine.this.setWifiState(3);
                    WifiStateMachine.this.mSupplicantRestartCount = 0;
                    WifiStateMachine.this.mSupplicantStateTracker.sendMessage(131183);
                    WifiStateMachine.this.mLastBssid = null;
                    WifiStateMachine.this.mLastNetworkId = -1;
                    WifiStateMachine.this.mLastSignalLevel = -1;
                    WifiStateMachine.this.mWifiInfo.setMacAddress(WifiStateMachine.this.mWifiNative.getMacAddress());
                    WifiStateMachine.this.mWifiConfigStore.loadAndEnableAllNetworks();
                    this.initializeWpsDetails();
                    WifiStateMachine.this.sendSupplicantConnectionChangedBroadcast(true);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStartedState);
                    break;
                }
                case 147458: {
                    if (++WifiStateMachine.this.mSupplicantRestartCount <= 5) {
                        WifiStateMachine.this.loge("Failed to setup control channel, restart supplicant");
                        WifiStateMachine.this.mWifiMonitor.killSupplicant(WifiStateMachine.this.mP2pSupported);
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mInitialState);
                        WifiStateMachine.this.sendMessageDelayed(131083, 5000L);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed " + WifiStateMachine.this.mSupplicantRestartCount + " times to start supplicant, unload driver");
                    WifiStateMachine.this.mSupplicantRestartCount = 0;
                    WifiStateMachine.this.setWifiState(4);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mInitialState);
                    break;
                }
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class InitialState
    extends State {
        InitialState() {
        }

        public void enter() {
            WifiStateMachine.this.mWifiNative;
            WifiNative.unloadDriver();
            if (WifiStateMachine.this.mWifiP2pChannel == null) {
                WifiStateMachine.this.mWifiP2pChannel = new AsyncChannel();
                WifiStateMachine.this.mWifiP2pChannel.connect(WifiStateMachine.this.mContext, WifiStateMachine.this.getHandler(), WifiStateMachine.this.mWifiP2pManager.getMessenger());
            }
            if (WifiStateMachine.this.mWifiApConfigChannel == null) {
                WifiStateMachine.this.mWifiApConfigChannel = new AsyncChannel();
                WifiApConfigStore wifiApConfigStore = WifiApConfigStore.makeWifiApConfigStore(WifiStateMachine.this.mContext, WifiStateMachine.this.getHandler());
                wifiApConfigStore.loadApConfiguration();
                WifiStateMachine.this.mWifiApConfigChannel.connectSync(WifiStateMachine.this.mContext, WifiStateMachine.this.getHandler(), wifiApConfigStore.getMessenger());
            }
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131083: {
                    WifiStateMachine.this.mWifiNative;
                    if (WifiNative.loadDriver()) {
                        try {
                            WifiStateMachine.this.mNwService.wifiFirmwareReload(WifiStateMachine.this.mInterfaceName, "STA");
                        }
                        catch (Exception e) {
                            WifiStateMachine.this.loge("Failed to reload STA firmware " + e);
                        }
                        try {
                            WifiStateMachine.this.mNwService.setInterfaceDown(WifiStateMachine.this.mInterfaceName);
                            WifiStateMachine.this.mNwService.setInterfaceIpv6PrivacyExtensions(WifiStateMachine.this.mInterfaceName, true);
                            WifiStateMachine.this.mNwService.disableIpv6(WifiStateMachine.this.mInterfaceName);
                        }
                        catch (RemoteException re) {
                            WifiStateMachine.this.loge("Unable to change interface settings: " + re);
                        }
                        catch (IllegalStateException ie) {
                            WifiStateMachine.this.loge("Unable to change interface settings: " + ie);
                        }
                        WifiStateMachine.this.mWifiMonitor.killSupplicant(WifiStateMachine.this.mP2pSupported);
                        WifiStateMachine.this.mWifiNative;
                        if (WifiNative.startSupplicant(WifiStateMachine.this.mP2pSupported)) {
                            WifiStateMachine.this.setWifiState(2);
                            WifiStateMachine.this.mWifiMonitor.startMonitoring();
                            WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSupplicantStartingState);
                            break;
                        }
                        WifiStateMachine.this.loge("Failed to start supplicant!");
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to load driver");
                    break;
                }
                case 131093: {
                    WifiStateMachine.this.mWifiNative;
                    if (WifiNative.loadDriver()) {
                        WifiStateMachine.this.setWifiApState(12);
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSoftApStartingState);
                    } else {
                        WifiStateMachine.this.loge("Failed to load driver for softap");
                    }
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 69632: {
                    if (message.arg1 == 0) {
                        WifiStateMachine.this.mWifiP2pChannel.sendMessage(69633);
                        break;
                    }
                    WifiStateMachine.this.loge("WifiP2pService connection failure, error=" + message.arg1);
                    break;
                }
                case 69636: {
                    WifiStateMachine.this.loge("WifiP2pService channel lost, message.arg1 =" + message.arg1);
                    break;
                }
                case 131103: {
                    WifiStateMachine.this.mBluetoothConnectionActive = message.arg1 != 0;
                    break;
                }
                case 131123: 
                case 131124: 
                case 131125: 
                case 131126: 
                case 131130: {
                    WifiStateMachine.this.replyToMessage(message, message.what, -1);
                    break;
                }
                case 131131: {
                    WifiStateMachine.this.replyToMessage(message, message.what, null);
                    break;
                }
                case 131154: {
                    WifiStateMachine.this.mEnableRssiPolling = message.arg1 == 1;
                    break;
                }
                case 131163: {
                    WifiStateMachine.this.mEnableBackgroundScan = message.arg1 == 1;
                    break;
                }
                case 131149: {
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.setSuspendOptimizations(2, false);
                        break;
                    }
                    WifiStateMachine.this.setSuspendOptimizations(2, true);
                    break;
                }
                case 131206: {
                    String countryCode = WifiStateMachine.this.mPersistedCountryCode;
                    if (TextUtils.isEmpty(countryCode)) break;
                    Settings.Global.putString(WifiStateMachine.this.mContext.getContentResolver(), "wifi_country_code", countryCode);
                    WifiStateMachine.this.sendMessageAtFrontOfQueue(131152, countryCode);
                    break;
                }
                case 131207: {
                    WifiStateMachine.this.recordBatchedScanSettings(message.arg1, message.arg2, (Bundle)message.obj);
                    break;
                }
                case 131209: {
                    WifiStateMachine.this.handleBatchedScanPollRequest();
                    break;
                }
                case 131208: {
                    WifiStateMachine.this.startNextBatchedScan();
                    break;
                }
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131089: 
                case 131090: 
                case 131091: 
                case 131092: 
                case 131093: 
                case 131094: 
                case 131095: 
                case 131096: 
                case 131097: 
                case 131098: 
                case 131099: 
                case 131100: 
                case 131101: 
                case 131102: 
                case 131127: 
                case 131128: 
                case 131129: 
                case 131143: 
                case 131144: 
                case 131145: 
                case 131146: 
                case 131147: 
                case 131152: 
                case 131155: 
                case 131160: 
                case 131162: 
                case 131205: 
                case 131214: 
                case 135189: 
                case 135190: 
                case 147457: 
                case 147458: 
                case 147459: 
                case 147460: 
                case 147461: 
                case 147462: 
                case 147463: 
                case 147466: 
                case 147499: 
                case 196612: 
                case 196613: {
                    break;
                }
                case 196614: {
                    WifiStateMachine.this.mDhcpStateMachine = null;
                    break;
                }
                case 131158: {
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.mSuspendWakeLock.release();
                        WifiStateMachine.this.setSuspendOptimizations(4, true);
                        break;
                    }
                    WifiStateMachine.this.setSuspendOptimizations(4, false);
                    break;
                }
                case 147468: {
                    WifiStateMachine.this.setSupplicantRunning(false);
                    WifiStateMachine.this.setSupplicantRunning(true);
                    break;
                }
                case 151553: {
                    WifiStateMachine.this.replyToMessage(message, 151554, 2);
                    break;
                }
                case 151556: {
                    WifiStateMachine.this.replyToMessage(message, 151557, 2);
                    break;
                }
                case 151559: {
                    WifiStateMachine.this.replyToMessage(message, 151560, 2);
                    break;
                }
                case 151562: {
                    WifiStateMachine.this.replyToMessage(message, 151564, 2);
                    break;
                }
                case 151566: {
                    WifiStateMachine.this.replyToMessage(message, 151567, 2);
                    break;
                }
                case 151569: {
                    WifiStateMachine.this.replyToMessage(message, 151570, 2);
                    break;
                }
                case 151572: {
                    WifiStateMachine.this.replyToMessage(message, 151574, 2);
                    break;
                }
                case 143371: {
                    NetworkInfo info = (NetworkInfo)message.obj;
                    WifiStateMachine.this.mP2pConnected.set(info.isConnected());
                    break;
                }
                case 143372: {
                    WifiStateMachine.this.mTemporarilyDisconnectWifi = message.arg1 == 1;
                    WifiStateMachine.this.replyToMessage(message, 143373);
                    break;
                }
                case 131212: {
                    if (!WifiStateMachine.this.mNetlinkLinkProperties.addLinkAddress((LinkAddress)message.obj)) break;
                    WifiStateMachine.this.updateLinkProperties();
                    break;
                }
                case 131213: {
                    if (!WifiStateMachine.this.mNetlinkLinkProperties.removeLinkAddress((LinkAddress)message.obj)) break;
                    WifiStateMachine.this.updateLinkProperties();
                    break;
                }
                default: {
                    WifiStateMachine.this.loge("Error! unhandled message" + message);
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TetherStateChange {
        ArrayList<String> available;
        ArrayList<String> active;

        TetherStateChange(ArrayList<String> av, ArrayList<String> ac) {
            this.available = av;
            this.active = ac;
        }
    }

    private class InterfaceObserver
    extends BaseNetworkObserver {
        private WifiStateMachine mWifiStateMachine;

        InterfaceObserver(WifiStateMachine wifiStateMachine2) {
            this.mWifiStateMachine = wifiStateMachine2;
        }

        private void maybeLog(String operation, String iface, LinkAddress address) {
        }

        public void addressUpdated(String iface, LinkAddress address) {
            if (this.mWifiStateMachine.mInterfaceName.equals(iface)) {
                this.maybeLog("addressUpdated", iface, address);
                this.mWifiStateMachine.sendMessage(131212, address);
            }
        }

        public void addressRemoved(String iface, LinkAddress address) {
            if (this.mWifiStateMachine.mInterfaceName.equals(iface)) {
                this.maybeLog("addressRemoved", iface, address);
                this.mWifiStateMachine.sendMessage(131213, address);
            }
        }
    }
}

