/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.app.AlertDialog;
import android.app.Notification;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.DhcpResults;
import android.net.DhcpStateMachine;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.net.wifi.WifiMonitor;
import android.net.wifi.WifiNative;
import android.net.wifi.WpsInfo;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pGroupList;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pProvDiscEvent;
import android.net.wifi.p2p.WifiP2pWfdInfo;
import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import android.net.wifi.p2p.nsd.WifiP2pServiceRequest;
import android.net.wifi.p2p.nsd.WifiP2pServiceResponse;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class WifiP2pService
extends IWifiP2pManager.Stub {
    private static final String TAG = "WifiP2pService";
    private static final boolean DBG = false;
    private static final String NETWORKTYPE = "WIFI_P2P";
    private Context mContext;
    private String mInterface;
    private Notification mNotification;
    INetworkManagementService mNwService;
    private DhcpStateMachine mDhcpStateMachine;
    private P2pStateMachine mP2pStateMachine;
    private AsyncChannel mReplyChannel = new AsyncChannel();
    private AsyncChannel mWifiChannel;
    private static final Boolean JOIN_GROUP = true;
    private static final Boolean FORM_GROUP = false;
    private static final Boolean RELOAD = true;
    private static final Boolean NO_RELOAD = false;
    private static final int GROUP_CREATING_WAIT_TIME_MS = 120000;
    private static int mGroupCreatingTimeoutIndex = 0;
    private static final int DISABLE_P2P_WAIT_TIME_MS = 5000;
    private static int mDisableP2pTimeoutIndex = 0;
    private static final int DISCOVER_TIMEOUT_S = 120;
    private static final int GROUP_IDLE_TIME_S = 10;
    private static final int BASE = 143360;
    public static final int GROUP_CREATING_TIMED_OUT = 143361;
    private static final int PEER_CONNECTION_USER_ACCEPT = 143362;
    private static final int PEER_CONNECTION_USER_REJECT = 143363;
    private static final int DROP_WIFI_USER_ACCEPT = 143364;
    private static final int DROP_WIFI_USER_REJECT = 143365;
    public static final int DISABLE_P2P_TIMED_OUT = 143366;
    public static final int P2P_CONNECTION_CHANGED = 143371;
    public static final int DISCONNECT_WIFI_REQUEST = 143372;
    public static final int DISCONNECT_WIFI_RESPONSE = 143373;
    public static final int SET_MIRACAST_MODE = 143374;
    public static final int BLOCK_DISCOVERY = 143375;
    public static final int SET_COUNTRY_CODE = 143376;
    public static final int ENABLED = 1;
    public static final int DISABLED = 0;
    private final boolean mP2pSupported;
    private WifiP2pDevice mThisDevice = new WifiP2pDevice();
    private boolean mAutonomousGroup;
    private boolean mJoinExistingGroup;
    private boolean mDiscoveryStarted;
    private boolean mDiscoveryBlocked;
    private String mLastSetCountryCode;
    private boolean mDiscoveryPostponed = false;
    private NetworkInfo mNetworkInfo;
    private boolean mTempoarilyDisconnectedWifi = false;
    private byte mServiceTransactionId = 0;
    private String mServiceDiscReqId;
    private HashMap<Messenger, ClientInfo> mClientInfoList = new HashMap();
    private static final String[] DHCP_RANGE = new String[]{"192.168.49.2", "192.168.49.254"};
    private static final String SERVER_ADDRESS = "192.168.49.1";

    public WifiP2pService(Context context) {
        this.mContext = context;
        this.mInterface = "p2p0";
        this.mNetworkInfo = new NetworkInfo(13, 0, NETWORKTYPE, "");
        this.mP2pSupported = this.mContext.getPackageManager().hasSystemFeature("android.hardware.wifi.direct");
        this.mThisDevice.primaryDeviceType = this.mContext.getResources().getString(17039386);
        this.mP2pStateMachine = new P2pStateMachine(TAG, this.mP2pSupported);
        this.mP2pStateMachine.start();
    }

    public void connectivityServiceReady() {
        IBinder b = ServiceManager.getService("network_management");
        this.mNwService = INetworkManagementService.Stub.asInterface(b);
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE", TAG);
    }

    private void enforceChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_STATE", TAG);
    }

    private void enforceConnectivityInternalPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
    }

    public Messenger getMessenger() {
        this.enforceAccessPermission();
        this.enforceChangePermission();
        return new Messenger(this.mP2pStateMachine.getHandler());
    }

    public void setMiracastMode(int mode) {
        this.enforceConnectivityInternalPermission();
        this.mP2pStateMachine.sendMessage(143374, mode);
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WifiP2pService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        this.mP2pStateMachine.dump(fd, pw, args);
        pw.println("mAutonomousGroup " + this.mAutonomousGroup);
        pw.println("mJoinExistingGroup " + this.mJoinExistingGroup);
        pw.println("mDiscoveryStarted " + this.mDiscoveryStarted);
        pw.println("mNetworkInfo " + this.mNetworkInfo);
        pw.println("mTempoarilyDisconnectedWifi " + this.mTempoarilyDisconnectedWifi);
        pw.println("mServiceDiscReqId " + this.mServiceDiscReqId);
        pw.println();
    }

    private class ClientInfo {
        private Messenger mMessenger;
        private SparseArray<WifiP2pServiceRequest> mReqList;
        private List<WifiP2pServiceInfo> mServList;

        private ClientInfo(Messenger m) {
            this.mMessenger = m;
            this.mReqList = new SparseArray();
            this.mServList = new ArrayList<WifiP2pServiceInfo>();
        }
    }

    private class P2pStateMachine
    extends StateMachine {
        private DefaultState mDefaultState;
        private P2pNotSupportedState mP2pNotSupportedState;
        private P2pDisablingState mP2pDisablingState;
        private P2pDisabledState mP2pDisabledState;
        private P2pEnablingState mP2pEnablingState;
        private P2pEnabledState mP2pEnabledState;
        private InactiveState mInactiveState;
        private GroupCreatingState mGroupCreatingState;
        private UserAuthorizingInviteRequestState mUserAuthorizingInviteRequestState;
        private UserAuthorizingNegotiationRequestState mUserAuthorizingNegotiationRequestState;
        private ProvisionDiscoveryState mProvisionDiscoveryState;
        private GroupNegotiationState mGroupNegotiationState;
        private FrequencyConflictState mFrequencyConflictState;
        private GroupCreatedState mGroupCreatedState;
        private UserAuthorizingJoinState mUserAuthorizingJoinState;
        private OngoingGroupRemovalState mOngoingGroupRemovalState;
        private WifiNative mWifiNative;
        private WifiMonitor mWifiMonitor;
        private final WifiP2pDeviceList mPeers;
        private final WifiP2pDeviceList mPeersLostDuringConnection;
        private final WifiP2pGroupList mGroups;
        private final WifiP2pInfo mWifiP2pInfo;
        private WifiP2pGroup mGroup;
        private WifiP2pConfig mSavedPeerConfig;
        private WifiP2pGroup mSavedP2pGroup;

        P2pStateMachine(String name, boolean p2pSupported) {
            super(name);
            this.mDefaultState = new DefaultState();
            this.mP2pNotSupportedState = new P2pNotSupportedState();
            this.mP2pDisablingState = new P2pDisablingState();
            this.mP2pDisabledState = new P2pDisabledState();
            this.mP2pEnablingState = new P2pEnablingState();
            this.mP2pEnabledState = new P2pEnabledState();
            this.mInactiveState = new InactiveState();
            this.mGroupCreatingState = new GroupCreatingState();
            this.mUserAuthorizingInviteRequestState = new UserAuthorizingInviteRequestState();
            this.mUserAuthorizingNegotiationRequestState = new UserAuthorizingNegotiationRequestState();
            this.mProvisionDiscoveryState = new ProvisionDiscoveryState();
            this.mGroupNegotiationState = new GroupNegotiationState();
            this.mFrequencyConflictState = new FrequencyConflictState();
            this.mGroupCreatedState = new GroupCreatedState();
            this.mUserAuthorizingJoinState = new UserAuthorizingJoinState();
            this.mOngoingGroupRemovalState = new OngoingGroupRemovalState();
            this.mWifiNative = new WifiNative(WifiP2pService.this.mInterface);
            this.mWifiMonitor = new WifiMonitor(this, this.mWifiNative);
            this.mPeers = new WifiP2pDeviceList();
            this.mPeersLostDuringConnection = new WifiP2pDeviceList();
            this.mGroups = new WifiP2pGroupList(null, new WifiP2pGroupList.GroupDeleteListener(){

                public void onDeleteGroup(int netId) {
                    P2pStateMachine.this.mWifiNative.removeNetwork(netId);
                    P2pStateMachine.this.mWifiNative.saveConfig();
                    P2pStateMachine.this.sendP2pPersistentGroupsChangedBroadcast();
                }
            });
            this.mWifiP2pInfo = new WifiP2pInfo();
            this.mSavedPeerConfig = new WifiP2pConfig();
            this.addState(this.mDefaultState);
            this.addState(this.mP2pNotSupportedState, this.mDefaultState);
            this.addState(this.mP2pDisablingState, this.mDefaultState);
            this.addState(this.mP2pDisabledState, this.mDefaultState);
            this.addState(this.mP2pEnablingState, this.mDefaultState);
            this.addState(this.mP2pEnabledState, this.mDefaultState);
            this.addState(this.mInactiveState, this.mP2pEnabledState);
            this.addState(this.mGroupCreatingState, this.mP2pEnabledState);
            this.addState(this.mUserAuthorizingInviteRequestState, this.mGroupCreatingState);
            this.addState(this.mUserAuthorizingNegotiationRequestState, this.mGroupCreatingState);
            this.addState(this.mProvisionDiscoveryState, this.mGroupCreatingState);
            this.addState(this.mGroupNegotiationState, this.mGroupCreatingState);
            this.addState(this.mFrequencyConflictState, this.mGroupCreatingState);
            this.addState(this.mGroupCreatedState, this.mP2pEnabledState);
            this.addState(this.mUserAuthorizingJoinState, this.mGroupCreatedState);
            this.addState(this.mOngoingGroupRemovalState, this.mGroupCreatedState);
            if (p2pSupported) {
                this.setInitialState(this.mP2pDisabledState);
            } else {
                this.setInitialState(this.mP2pNotSupportedState);
            }
            this.setLogRecSize(50);
            this.setLogOnlyTransitions(true);
        }

        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            super.dump(fd, pw, args);
            pw.println("mWifiP2pInfo " + this.mWifiP2pInfo);
            pw.println("mGroup " + this.mGroup);
            pw.println("mSavedPeerConfig " + this.mSavedPeerConfig);
            pw.println("mSavedP2pGroup " + this.mSavedP2pGroup);
            pw.println();
        }

        private void sendP2pStateChangedBroadcast(boolean enabled) {
            Intent intent = new Intent("android.net.wifi.p2p.STATE_CHANGED");
            intent.addFlags(0x4000000);
            if (enabled) {
                intent.putExtra("wifi_p2p_state", 2);
            } else {
                intent.putExtra("wifi_p2p_state", 1);
            }
            WifiP2pService.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }

        private void sendP2pDiscoveryChangedBroadcast(boolean started) {
            if (WifiP2pService.this.mDiscoveryStarted == started) {
                return;
            }
            WifiP2pService.this.mDiscoveryStarted = started;
            Intent intent = new Intent("android.net.wifi.p2p.DISCOVERY_STATE_CHANGE");
            intent.addFlags(0x4000000);
            intent.putExtra("discoveryState", started ? 2 : 1);
            WifiP2pService.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }

        private void sendThisDeviceChangedBroadcast() {
            Intent intent = new Intent("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
            intent.addFlags(0x4000000);
            intent.putExtra("wifiP2pDevice", new WifiP2pDevice(WifiP2pService.this.mThisDevice));
            WifiP2pService.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }

        private void sendPeersChangedBroadcast() {
            Intent intent = new Intent("android.net.wifi.p2p.PEERS_CHANGED");
            intent.putExtra("wifiP2pDeviceList", new WifiP2pDeviceList(this.mPeers));
            intent.addFlags(0x4000000);
            WifiP2pService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }

        private void sendP2pConnectionChangedBroadcast() {
            Intent intent = new Intent("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
            intent.addFlags(0x24000000);
            intent.putExtra("wifiP2pInfo", new WifiP2pInfo(this.mWifiP2pInfo));
            intent.putExtra("networkInfo", new NetworkInfo(WifiP2pService.this.mNetworkInfo));
            intent.putExtra("p2pGroupInfo", new WifiP2pGroup(this.mGroup));
            WifiP2pService.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            WifiP2pService.this.mWifiChannel.sendMessage(143371, new NetworkInfo(WifiP2pService.this.mNetworkInfo));
        }

        private void sendP2pPersistentGroupsChangedBroadcast() {
            Intent intent = new Intent("android.net.wifi.p2p.PERSISTENT_GROUPS_CHANGED");
            intent.addFlags(0x4000000);
            WifiP2pService.this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }

        private void startDhcpServer(String intf) {
            InterfaceConfiguration ifcg = null;
            try {
                ifcg = WifiP2pService.this.mNwService.getInterfaceConfig(intf);
                ifcg.setLinkAddress(new LinkAddress(NetworkUtils.numericToInetAddress(WifiP2pService.SERVER_ADDRESS), 24));
                ifcg.setInterfaceUp();
                WifiP2pService.this.mNwService.setInterfaceConfig(intf, ifcg);
                WifiP2pService.this.mNwService.startTethering(DHCP_RANGE);
            }
            catch (Exception e) {
                this.loge("Error configuring interface " + intf + ", :" + e);
                return;
            }
            this.logd("Started Dhcp server on " + intf);
        }

        private void stopDhcpServer(String intf) {
            try {
                WifiP2pService.this.mNwService.stopTethering();
            }
            catch (Exception e) {
                this.loge("Error stopping Dhcp server" + e);
                return;
            }
            this.logd("Stopped Dhcp server");
        }

        private void notifyP2pEnableFailure() {
            Resources r = Resources.getSystem();
            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040438)).setMessage(r.getString(17040440)).setPositiveButton(r.getString(17039370), null).create();
            dialog.getWindow().setType(2003);
            dialog.show();
        }

        private void addRowToDialog(ViewGroup group, int stringId, String value) {
            Resources r = Resources.getSystem();
            View row = LayoutInflater.from(WifiP2pService.this.mContext).inflate(17367238, group, false);
            ((TextView)row.findViewById(16909180)).setText(r.getString(stringId));
            ((TextView)row.findViewById(16908984)).setText(value);
            group.addView(row);
        }

        private void notifyInvitationSent(String pin, String peerAddress) {
            Resources r = Resources.getSystem();
            View textEntryView = LayoutInflater.from(WifiP2pService.this.mContext).inflate(17367237, null);
            ViewGroup group = (ViewGroup)textEntryView.findViewById(16909018);
            this.addRowToDialog(group, 0x1040440, this.getDeviceName(peerAddress));
            this.addRowToDialog(group, 17040450, pin);
            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040445)).setView(textEntryView).setPositiveButton(r.getString(17039370), null).create();
            dialog.getWindow().setType(2003);
            dialog.show();
        }

        private void notifyInvitationReceived() {
            Resources r = Resources.getSystem();
            final WpsInfo wps = this.mSavedPeerConfig.wps;
            View textEntryView = LayoutInflater.from(WifiP2pService.this.mContext).inflate(17367237, null);
            ViewGroup group = (ViewGroup)textEntryView.findViewById(16909018);
            this.addRowToDialog(group, 17040447, this.getDeviceName(this.mSavedPeerConfig.deviceAddress));
            final EditText pin = (EditText)textEntryView.findViewById(16909179);
            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040446)).setView(textEntryView).setPositiveButton(r.getString(17040443), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (wps.setup == 2) {
                        ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.pin = pin.getText().toString();
                    }
                    P2pStateMachine.this.sendMessage(143362);
                }
            }).setNegativeButton(r.getString(17040444), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    P2pStateMachine.this.sendMessage(143363);
                }
            }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface arg0) {
                    P2pStateMachine.this.sendMessage(143363);
                }
            }).create();
            switch (wps.setup) {
                case 2: {
                    textEntryView.findViewById(16909178).setVisibility(0);
                    break;
                }
                case 1: {
                    this.addRowToDialog(group, 17040450, wps.pin);
                    break;
                }
            }
            if ((r.getConfiguration().uiMode & 5) == 5) {
                dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                        if (keyCode == 164) {
                            P2pStateMachine.this.sendMessage(143362);
                            dialog.dismiss();
                            return true;
                        }
                        return false;
                    }
                });
            }
            dialog.getWindow().setType(2003);
            dialog.show();
        }

        private void updatePersistentNetworks(boolean reload) {
            String listStr = this.mWifiNative.listNetworks();
            if (listStr == null) {
                return;
            }
            boolean isSaveRequired = false;
            String[] lines = listStr.split("\n");
            if (lines == null) {
                return;
            }
            if (reload) {
                this.mGroups.clear();
            }
            for (int i = 1; i < lines.length; ++i) {
                String[] result = lines[i].split("\t");
                if (result == null || result.length < 4) continue;
                int netId = -1;
                String ssid = result[1];
                String bssid = result[2];
                String flags = result[3];
                try {
                    netId = Integer.parseInt(result[0]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    continue;
                }
                if (flags.indexOf("[CURRENT]") != -1) continue;
                if (flags.indexOf("[P2P-PERSISTENT]") == -1) {
                    this.mWifiNative.removeNetwork(netId);
                    isSaveRequired = true;
                    continue;
                }
                if (this.mGroups.contains(netId)) continue;
                WifiP2pGroup group = new WifiP2pGroup();
                group.setNetworkId(netId);
                group.setNetworkName(ssid);
                String mode = this.mWifiNative.getNetworkVariable(netId, "mode");
                if (mode != null && mode.equals("3")) {
                    group.setIsGroupOwner(true);
                }
                if (bssid.equalsIgnoreCase(((WifiP2pService)WifiP2pService.this).mThisDevice.deviceAddress)) {
                    group.setOwner(WifiP2pService.this.mThisDevice);
                } else {
                    WifiP2pDevice device = new WifiP2pDevice();
                    device.deviceAddress = bssid;
                    group.setOwner(device);
                }
                this.mGroups.add(group);
                isSaveRequired = true;
            }
            if (reload || isSaveRequired) {
                this.mWifiNative.saveConfig();
                this.sendP2pPersistentGroupsChangedBroadcast();
            }
        }

        private boolean isConfigInvalid(WifiP2pConfig config) {
            if (config == null) {
                return true;
            }
            if (TextUtils.isEmpty(config.deviceAddress)) {
                return true;
            }
            return this.mPeers.get(config.deviceAddress) == null;
        }

        private WifiP2pDevice fetchCurrentDeviceDetails(WifiP2pConfig config) {
            int gc = this.mWifiNative.getGroupCapability(config.deviceAddress);
            this.mPeers.updateGroupCapability(config.deviceAddress, gc);
            return this.mPeers.get(config.deviceAddress);
        }

        private void p2pConnectWithPinDisplay(WifiP2pConfig config) {
            WifiP2pDevice dev = this.fetchCurrentDeviceDetails(config);
            String pin = this.mWifiNative.p2pConnect(config, dev.isGroupOwner());
            try {
                Integer.parseInt(pin);
                this.notifyInvitationSent(pin, config.deviceAddress);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }

        private boolean reinvokePersistentGroup(WifiP2pConfig config) {
            int netId;
            WifiP2pDevice dev = this.fetchCurrentDeviceDetails(config);
            boolean join = dev.isGroupOwner();
            String ssid = this.mWifiNative.p2pGetSsid(dev.deviceAddress);
            if (join && dev.isGroupLimit()) {
                join = false;
            } else if (join && (netId = this.mGroups.getNetworkId(dev.deviceAddress, ssid)) >= 0) {
                return this.mWifiNative.p2pGroupAdd(netId);
            }
            if (!join && dev.isDeviceLimit()) {
                this.loge("target device reaches the device limit.");
                return false;
            }
            if (!join && dev.isInvitationCapable()) {
                netId = -2;
                if (config.netId >= 0) {
                    if (config.deviceAddress.equals(this.mGroups.getOwnerAddr(config.netId))) {
                        netId = config.netId;
                    }
                } else {
                    netId = this.mGroups.getNetworkId(dev.deviceAddress);
                }
                if (netId < 0) {
                    netId = this.getNetworkIdFromClientList(dev.deviceAddress);
                }
                if (netId >= 0) {
                    if (this.mWifiNative.p2pReinvoke(netId, dev.deviceAddress)) {
                        config.netId = netId;
                        return true;
                    }
                    this.loge("p2pReinvoke() failed, update networks");
                    this.updatePersistentNetworks(RELOAD);
                    return false;
                }
            }
            return false;
        }

        private int getNetworkIdFromClientList(String deviceAddress) {
            if (deviceAddress == null) {
                return -1;
            }
            Collection<WifiP2pGroup> groups = this.mGroups.getGroupList();
            for (WifiP2pGroup group : groups) {
                int netId = group.getNetworkId();
                String[] p2pClientList = this.getClientList(netId);
                if (p2pClientList == null) continue;
                for (String client : p2pClientList) {
                    if (!deviceAddress.equalsIgnoreCase(client)) continue;
                    return netId;
                }
            }
            return -1;
        }

        private String[] getClientList(int netId) {
            String p2pClients = this.mWifiNative.getNetworkVariable(netId, "p2p_client_list");
            if (p2pClients == null) {
                return null;
            }
            return p2pClients.split(" ");
        }

        private boolean removeClientFromList(int netId, String addr, boolean isRemovable) {
            StringBuilder modifiedClientList = new StringBuilder();
            String[] currentClientList = this.getClientList(netId);
            boolean isClientRemoved = false;
            if (currentClientList != null) {
                for (String client : currentClientList) {
                    if (!client.equalsIgnoreCase(addr)) {
                        modifiedClientList.append(" ");
                        modifiedClientList.append(client);
                        continue;
                    }
                    isClientRemoved = true;
                }
            }
            if (modifiedClientList.length() == 0 && isRemovable) {
                this.mGroups.remove(netId);
                return true;
            }
            if (!isClientRemoved) {
                return false;
            }
            if (modifiedClientList.length() == 0) {
                modifiedClientList.append("\"\"");
            }
            this.mWifiNative.setNetworkVariable(netId, "p2p_client_list", modifiedClientList.toString());
            this.mWifiNative.saveConfig();
            return true;
        }

        private void setWifiP2pInfoOnGroupFormation(InetAddress serverInetAddress) {
            this.mWifiP2pInfo.groupFormed = true;
            this.mWifiP2pInfo.isGroupOwner = this.mGroup.isGroupOwner();
            this.mWifiP2pInfo.groupOwnerAddress = serverInetAddress;
        }

        private void resetWifiP2pInfo() {
            this.mWifiP2pInfo.groupFormed = false;
            this.mWifiP2pInfo.isGroupOwner = false;
            this.mWifiP2pInfo.groupOwnerAddress = null;
        }

        private String getDeviceName(String deviceAddress) {
            WifiP2pDevice d = this.mPeers.get(deviceAddress);
            if (d != null) {
                return d.deviceName;
            }
            return deviceAddress;
        }

        private String getPersistedDeviceName() {
            String deviceName = Settings.Global.getString(WifiP2pService.this.mContext.getContentResolver(), "wifi_p2p_device_name");
            if (deviceName == null) {
                String id2 = Settings.Secure.getString(WifiP2pService.this.mContext.getContentResolver(), "android_id");
                return "Android_" + id2.substring(0, 4);
            }
            return deviceName;
        }

        private boolean setAndPersistDeviceName(String devName) {
            if (devName == null) {
                return false;
            }
            if (!this.mWifiNative.setDeviceName(devName)) {
                this.loge("Failed to set device name " + devName);
                return false;
            }
            ((WifiP2pService)WifiP2pService.this).mThisDevice.deviceName = devName;
            this.mWifiNative.setP2pSsidPostfix("-" + ((WifiP2pService)WifiP2pService.this).mThisDevice.deviceName);
            Settings.Global.putString(WifiP2pService.this.mContext.getContentResolver(), "wifi_p2p_device_name", devName);
            this.sendThisDeviceChangedBroadcast();
            return true;
        }

        private boolean setWfdInfo(WifiP2pWfdInfo wfdInfo) {
            boolean success;
            if (!wfdInfo.isWfdEnabled()) {
                success = this.mWifiNative.setWfdEnable(false);
            } else {
                boolean bl = success = this.mWifiNative.setWfdEnable(true) && this.mWifiNative.setWfdDeviceInfo(wfdInfo.getDeviceInfoHex());
            }
            if (!success) {
                this.loge("Failed to set wfd properties");
                return false;
            }
            ((WifiP2pService)WifiP2pService.this).mThisDevice.wfdInfo = wfdInfo;
            this.sendThisDeviceChangedBroadcast();
            return true;
        }

        private void initializeP2pSettings() {
            this.mWifiNative.setPersistentReconnect(true);
            ((WifiP2pService)WifiP2pService.this).mThisDevice.deviceName = this.getPersistedDeviceName();
            this.mWifiNative.setDeviceName(((WifiP2pService)WifiP2pService.this).mThisDevice.deviceName);
            this.mWifiNative.setP2pSsidPostfix("-" + ((WifiP2pService)WifiP2pService.this).mThisDevice.deviceName);
            this.mWifiNative.setDeviceType(((WifiP2pService)WifiP2pService.this).mThisDevice.primaryDeviceType);
            this.mWifiNative.setConfigMethods("virtual_push_button physical_display keypad");
            this.mWifiNative.setConcurrencyPriority("sta");
            ((WifiP2pService)WifiP2pService.this).mThisDevice.deviceAddress = this.mWifiNative.p2pGetDeviceAddress();
            this.updateThisDevice(3);
            WifiP2pService.this.mClientInfoList.clear();
            this.mWifiNative.p2pFlush();
            this.mWifiNative.p2pServiceFlush();
            WifiP2pService.this.mServiceTransactionId = (byte)0;
            WifiP2pService.this.mServiceDiscReqId = null;
            String countryCode = Settings.Global.getString(WifiP2pService.this.mContext.getContentResolver(), "wifi_country_code");
            if (countryCode != null && !countryCode.isEmpty()) {
                WifiP2pService.this.mP2pStateMachine.sendMessage(143376, countryCode);
            }
            this.updatePersistentNetworks(RELOAD);
        }

        private void updateThisDevice(int status) {
            ((WifiP2pService)WifiP2pService.this).mThisDevice.status = status;
            this.sendThisDeviceChangedBroadcast();
        }

        private void handleGroupCreationFailure() {
            this.resetWifiP2pInfo();
            WifiP2pService.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.FAILED, null, null);
            this.sendP2pConnectionChangedBroadcast();
            boolean peersChanged = this.mPeers.remove(this.mPeersLostDuringConnection);
            if (this.mPeers.remove(this.mSavedPeerConfig.deviceAddress) != null) {
                peersChanged = true;
            }
            if (peersChanged) {
                this.sendPeersChangedBroadcast();
            }
            this.mPeersLostDuringConnection.clear();
            WifiP2pService.this.mServiceDiscReqId = null;
            this.sendMessage(139265);
        }

        private void handleGroupRemoved() {
            if (this.mGroup.isGroupOwner()) {
                this.stopDhcpServer(this.mGroup.getInterface());
            } else {
                WifiP2pService.this.mDhcpStateMachine.sendMessage(196610);
                WifiP2pService.this.mDhcpStateMachine.doQuit();
                WifiP2pService.this.mDhcpStateMachine = null;
            }
            try {
                WifiP2pService.this.mNwService.clearInterfaceAddresses(this.mGroup.getInterface());
            }
            catch (Exception e) {
                this.loge("Failed to clear addresses " + e);
            }
            NetworkUtils.resetConnections(this.mGroup.getInterface(), 3);
            this.mWifiNative.setP2pGroupIdle(this.mGroup.getInterface(), 0);
            boolean peersChanged = false;
            for (WifiP2pDevice d : this.mGroup.getClientList()) {
                if (!this.mPeers.remove(d)) continue;
                peersChanged = true;
            }
            if (this.mPeers.remove(this.mGroup.getOwner())) {
                peersChanged = true;
            }
            if (this.mPeers.remove(this.mPeersLostDuringConnection)) {
                peersChanged = true;
            }
            if (peersChanged) {
                this.sendPeersChangedBroadcast();
            }
            this.mGroup = null;
            this.mPeersLostDuringConnection.clear();
            WifiP2pService.this.mServiceDiscReqId = null;
            if (WifiP2pService.this.mTempoarilyDisconnectedWifi) {
                WifiP2pService.this.mWifiChannel.sendMessage(143372, 0);
                WifiP2pService.this.mTempoarilyDisconnectedWifi = false;
            }
        }

        private void replyToMessage(Message msg, int what) {
            if (msg.replyTo == null) {
                return;
            }
            Message dstMsg = this.obtainMessage(msg);
            dstMsg.what = what;
            WifiP2pService.this.mReplyChannel.replyToMessage(msg, dstMsg);
        }

        private void replyToMessage(Message msg, int what, int arg1) {
            if (msg.replyTo == null) {
                return;
            }
            Message dstMsg = this.obtainMessage(msg);
            dstMsg.what = what;
            dstMsg.arg1 = arg1;
            WifiP2pService.this.mReplyChannel.replyToMessage(msg, dstMsg);
        }

        private void replyToMessage(Message msg, int what, Object obj) {
            if (msg.replyTo == null) {
                return;
            }
            Message dstMsg = this.obtainMessage(msg);
            dstMsg.what = what;
            dstMsg.obj = obj;
            WifiP2pService.this.mReplyChannel.replyToMessage(msg, dstMsg);
        }

        private Message obtainMessage(Message srcMsg) {
            Message msg = Message.obtain();
            msg.arg2 = srcMsg.arg2;
            return msg;
        }

        protected void logd(String s) {
            Slog.d(WifiP2pService.TAG, s);
        }

        protected void loge(String s) {
            Slog.e(WifiP2pService.TAG, s);
        }

        private boolean updateSupplicantServiceRequest() {
            this.clearSupplicantServiceRequest();
            StringBuffer sb = new StringBuffer();
            for (ClientInfo c : WifiP2pService.this.mClientInfoList.values()) {
                for (int i = 0; i < c.mReqList.size(); ++i) {
                    WifiP2pServiceRequest req = (WifiP2pServiceRequest)c.mReqList.valueAt(i);
                    if (req == null) continue;
                    sb.append(req.getSupplicantQuery());
                }
            }
            if (sb.length() == 0) {
                return false;
            }
            WifiP2pService.this.mServiceDiscReqId = this.mWifiNative.p2pServDiscReq("00:00:00:00:00:00", sb.toString());
            return WifiP2pService.this.mServiceDiscReqId != null;
        }

        private void clearSupplicantServiceRequest() {
            if (WifiP2pService.this.mServiceDiscReqId == null) {
                return;
            }
            this.mWifiNative.p2pServDiscCancelReq(WifiP2pService.this.mServiceDiscReqId);
            WifiP2pService.this.mServiceDiscReqId = null;
        }

        private boolean addServiceRequest(Messenger m, WifiP2pServiceRequest req) {
            this.clearClientDeadChannels();
            ClientInfo clientInfo = this.getClientInfo(m, true);
            if (clientInfo == null) {
                return false;
            }
            WifiP2pService.this.mServiceTransactionId = (byte)(WifiP2pService.this.mServiceTransactionId + 1);
            if (WifiP2pService.this.mServiceTransactionId == 0) {
                WifiP2pService.this.mServiceTransactionId = (byte)(WifiP2pService.this.mServiceTransactionId + 1);
            }
            req.setTransactionId(WifiP2pService.this.mServiceTransactionId);
            clientInfo.mReqList.put(WifiP2pService.this.mServiceTransactionId, req);
            if (WifiP2pService.this.mServiceDiscReqId == null) {
                return true;
            }
            return this.updateSupplicantServiceRequest();
        }

        private void removeServiceRequest(Messenger m, WifiP2pServiceRequest req) {
            ClientInfo clientInfo = this.getClientInfo(m, false);
            if (clientInfo == null) {
                return;
            }
            boolean removed = false;
            for (int i = 0; i < clientInfo.mReqList.size(); ++i) {
                if (!req.equals(clientInfo.mReqList.valueAt(i))) continue;
                removed = true;
                clientInfo.mReqList.removeAt(i);
                break;
            }
            if (!removed) {
                return;
            }
            if (clientInfo.mReqList.size() == 0 && clientInfo.mServList.size() == 0) {
                WifiP2pService.this.mClientInfoList.remove(clientInfo.mMessenger);
            }
            if (WifiP2pService.this.mServiceDiscReqId == null) {
                return;
            }
            this.updateSupplicantServiceRequest();
        }

        private void clearServiceRequests(Messenger m) {
            ClientInfo clientInfo = this.getClientInfo(m, false);
            if (clientInfo == null) {
                return;
            }
            if (clientInfo.mReqList.size() == 0) {
                return;
            }
            clientInfo.mReqList.clear();
            if (clientInfo.mServList.size() == 0) {
                WifiP2pService.this.mClientInfoList.remove(clientInfo.mMessenger);
            }
            if (WifiP2pService.this.mServiceDiscReqId == null) {
                return;
            }
            this.updateSupplicantServiceRequest();
        }

        private boolean addLocalService(Messenger m, WifiP2pServiceInfo servInfo) {
            this.clearClientDeadChannels();
            ClientInfo clientInfo = this.getClientInfo(m, true);
            if (clientInfo == null) {
                return false;
            }
            if (!clientInfo.mServList.add(servInfo)) {
                return false;
            }
            if (!this.mWifiNative.p2pServiceAdd(servInfo)) {
                clientInfo.mServList.remove(servInfo);
                return false;
            }
            return true;
        }

        private void removeLocalService(Messenger m, WifiP2pServiceInfo servInfo) {
            ClientInfo clientInfo = this.getClientInfo(m, false);
            if (clientInfo == null) {
                return;
            }
            this.mWifiNative.p2pServiceDel(servInfo);
            clientInfo.mServList.remove(servInfo);
            if (clientInfo.mReqList.size() == 0 && clientInfo.mServList.size() == 0) {
                WifiP2pService.this.mClientInfoList.remove(clientInfo.mMessenger);
            }
        }

        private void clearLocalServices(Messenger m) {
            ClientInfo clientInfo = this.getClientInfo(m, false);
            if (clientInfo == null) {
                return;
            }
            for (WifiP2pServiceInfo servInfo : clientInfo.mServList) {
                this.mWifiNative.p2pServiceDel(servInfo);
            }
            clientInfo.mServList.clear();
            if (clientInfo.mReqList.size() == 0) {
                WifiP2pService.this.mClientInfoList.remove(clientInfo.mMessenger);
            }
        }

        private void clearClientInfo(Messenger m) {
            this.clearLocalServices(m);
            this.clearServiceRequests(m);
        }

        private void sendServiceResponse(WifiP2pServiceResponse resp) {
            for (ClientInfo c : WifiP2pService.this.mClientInfoList.values()) {
                WifiP2pServiceRequest req = (WifiP2pServiceRequest)c.mReqList.get(resp.getTransactionId());
                if (req == null) continue;
                Message msg = Message.obtain();
                msg.what = 139314;
                msg.arg1 = 0;
                msg.arg2 = 0;
                msg.obj = resp;
                try {
                    c.mMessenger.send(msg);
                }
                catch (RemoteException e) {
                    this.clearClientInfo(c.mMessenger);
                    return;
                }
            }
        }

        private void clearClientDeadChannels() {
            ArrayList<Messenger> deadClients = new ArrayList<Messenger>();
            for (ClientInfo c : WifiP2pService.this.mClientInfoList.values()) {
                Message msg = Message.obtain();
                msg.what = 139313;
                msg.arg1 = 0;
                msg.arg2 = 0;
                msg.obj = null;
                try {
                    c.mMessenger.send(msg);
                }
                catch (RemoteException e) {
                    deadClients.add(c.mMessenger);
                }
            }
            for (Messenger m : deadClients) {
                this.clearClientInfo(m);
            }
        }

        private ClientInfo getClientInfo(Messenger m, boolean createIfNotExist) {
            ClientInfo clientInfo = (ClientInfo)WifiP2pService.this.mClientInfoList.get(m);
            if (clientInfo == null && createIfNotExist) {
                clientInfo = new ClientInfo(m);
                WifiP2pService.this.mClientInfoList.put(m, clientInfo);
            }
            return clientInfo;
        }

        class OngoingGroupRemovalState
        extends State {
            OngoingGroupRemovalState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 139280: {
                        P2pStateMachine.this.replyToMessage(message, 139282);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class UserAuthorizingJoinState
        extends State {
            UserAuthorizingJoinState() {
            }

            public void enter() {
                P2pStateMachine.this.notifyInvitationReceived();
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147489: 
                    case 147491: 
                    case 147492: {
                        break;
                    }
                    case 143362: {
                        P2pStateMachine.this.mWifiNative.p2pStopFind();
                        if (((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup == 0) {
                            P2pStateMachine.this.mWifiNative.startWpsPbc(P2pStateMachine.this.mGroup.getInterface(), null);
                        } else {
                            P2pStateMachine.this.mWifiNative.startWpsPinKeypad(P2pStateMachine.this.mGroup.getInterface(), ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.pin);
                        }
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupCreatedState);
                        break;
                    }
                    case 143363: {
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupCreatedState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }

            public void exit() {
            }
        }

        class GroupCreatedState
        extends State {
            GroupCreatedState() {
            }

            public void enter() {
                P2pStateMachine.this.mSavedPeerConfig.invalidate();
                WifiP2pService.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
                P2pStateMachine.this.updateThisDevice(0);
                if (P2pStateMachine.this.mGroup.isGroupOwner()) {
                    P2pStateMachine.this.setWifiP2pInfoOnGroupFormation(NetworkUtils.numericToInetAddress(WifiP2pService.SERVER_ADDRESS));
                }
                if (WifiP2pService.this.mAutonomousGroup) {
                    P2pStateMachine.this.sendP2pConnectionChangedBroadcast();
                }
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147498: {
                        WifiP2pDevice device = (WifiP2pDevice)message.obj;
                        String deviceAddress = device.deviceAddress;
                        P2pStateMachine.this.mWifiNative.setP2pGroupIdle(P2pStateMachine.this.mGroup.getInterface(), 0);
                        if (deviceAddress != null) {
                            if (P2pStateMachine.this.mPeers.get(deviceAddress) != null) {
                                P2pStateMachine.this.mGroup.addClient(P2pStateMachine.this.mPeers.get(deviceAddress));
                            } else {
                                P2pStateMachine.this.mGroup.addClient(deviceAddress);
                            }
                            P2pStateMachine.this.mPeers.updateStatus(deviceAddress, 0);
                            P2pStateMachine.this.sendPeersChangedBroadcast();
                        } else {
                            P2pStateMachine.this.loge("Connect on null device address, ignore");
                        }
                        P2pStateMachine.this.sendP2pConnectionChangedBroadcast();
                        break;
                    }
                    case 147497: {
                        WifiP2pDevice device = (WifiP2pDevice)message.obj;
                        String deviceAddress = device.deviceAddress;
                        if (deviceAddress != null) {
                            P2pStateMachine.this.mPeers.updateStatus(deviceAddress, 3);
                            if (P2pStateMachine.this.mGroup.removeClient(deviceAddress)) {
                                if (!WifiP2pService.this.mAutonomousGroup && P2pStateMachine.this.mGroup.isClientListEmpty()) {
                                    P2pStateMachine.this.logd("Client list empty, remove non-persistent p2p group");
                                    P2pStateMachine.this.mWifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface());
                                } else {
                                    P2pStateMachine.this.sendP2pConnectionChangedBroadcast();
                                }
                            } else {
                                for (WifiP2pDevice c : P2pStateMachine.this.mGroup.getClientList()) {
                                }
                            }
                            P2pStateMachine.this.sendPeersChangedBroadcast();
                            break;
                        }
                        P2pStateMachine.this.loge("Disconnect on unknown device: " + device);
                        break;
                    }
                    case 196613: {
                        DhcpResults dhcpResults = (DhcpResults)message.obj;
                        if (message.arg1 == 1 && dhcpResults != null) {
                            P2pStateMachine.this.setWifiP2pInfoOnGroupFormation(dhcpResults.serverAddress);
                            P2pStateMachine.this.sendP2pConnectionChangedBroadcast();
                            P2pStateMachine.this.mWifiNative.setP2pPowerSave(P2pStateMachine.this.mGroup.getInterface(), true);
                            break;
                        }
                        P2pStateMachine.this.loge("DHCP failed");
                        P2pStateMachine.this.mWifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface());
                        break;
                    }
                    case 139280: {
                        if (P2pStateMachine.this.mWifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface())) {
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mOngoingGroupRemovalState);
                            P2pStateMachine.this.replyToMessage(message, 139282);
                            break;
                        }
                        P2pStateMachine.this.handleGroupRemoved();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        P2pStateMachine.this.replyToMessage(message, 139281, 0);
                        break;
                    }
                    case 147486: {
                        P2pStateMachine.this.handleGroupRemoved();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    case 147478: {
                        WifiP2pDevice device = (WifiP2pDevice)message.obj;
                        if (P2pStateMachine.this.mGroup.contains(device)) {
                            P2pStateMachine.this.mPeersLostDuringConnection.updateSupplicantDetails(device);
                            return true;
                        }
                        return false;
                    }
                    case 131204: {
                        P2pStateMachine.this.sendMessage(139280);
                        P2pStateMachine.this.deferMessage(message);
                        break;
                    }
                    case 139326: {
                        WpsInfo wps = (WpsInfo)message.obj;
                        if (wps == null) {
                            P2pStateMachine.this.replyToMessage(message, 139327);
                            break;
                        }
                        boolean ret = true;
                        if (wps.setup == 0) {
                            ret = P2pStateMachine.this.mWifiNative.startWpsPbc(P2pStateMachine.this.mGroup.getInterface(), null);
                        } else if (wps.pin == null) {
                            String pin = P2pStateMachine.this.mWifiNative.startWpsPinDisplay(P2pStateMachine.this.mGroup.getInterface());
                            try {
                                Integer.parseInt(pin);
                                P2pStateMachine.this.notifyInvitationSent(pin, "any");
                            }
                            catch (NumberFormatException ignore) {
                                ret = false;
                            }
                        } else {
                            ret = P2pStateMachine.this.mWifiNative.startWpsPinKeypad(P2pStateMachine.this.mGroup.getInterface(), wps.pin);
                        }
                        P2pStateMachine.this.replyToMessage(message, ret ? 139328 : 139327);
                        break;
                    }
                    case 139271: {
                        WifiP2pConfig config = (WifiP2pConfig)message.obj;
                        if (P2pStateMachine.this.isConfigInvalid(config)) {
                            P2pStateMachine.this.loge("Dropping connect requeset " + config);
                            P2pStateMachine.this.replyToMessage(message, 139272);
                            break;
                        }
                        P2pStateMachine.this.logd("Inviting device : " + config.deviceAddress);
                        P2pStateMachine.this.mSavedPeerConfig = config;
                        if (P2pStateMachine.this.mWifiNative.p2pInvite(P2pStateMachine.this.mGroup, config.deviceAddress)) {
                            P2pStateMachine.this.mPeers.updateStatus(config.deviceAddress, 1);
                            P2pStateMachine.this.sendPeersChangedBroadcast();
                            P2pStateMachine.this.replyToMessage(message, 139273);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139272, 0);
                        break;
                    }
                    case 147488: {
                        int netId;
                        P2pStatus status = (P2pStatus)((Object)message.obj);
                        if (status == P2pStatus.SUCCESS) break;
                        P2pStateMachine.this.loge("Invitation result " + (Object)((Object)status));
                        if (status != P2pStatus.UNKNOWN_P2P_GROUP || (netId = P2pStateMachine.this.mGroup.getNetworkId()) < 0) break;
                        if (!P2pStateMachine.this.removeClientFromList(netId, ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress, false)) {
                            P2pStateMachine.this.loge("Already removed the client, ignore");
                            break;
                        }
                        P2pStateMachine.this.sendMessage(139271, P2pStateMachine.this.mSavedPeerConfig);
                        break;
                    }
                    case 147489: 
                    case 147491: 
                    case 147492: {
                        WifiP2pProvDiscEvent provDisc = (WifiP2pProvDiscEvent)message.obj;
                        P2pStateMachine.this.mSavedPeerConfig = new WifiP2pConfig();
                        ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress = provDisc.device.deviceAddress;
                        if (message.what == 147491) {
                            ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup = 2;
                        } else if (message.what == 147492) {
                            ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup = 1;
                            ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.pin = provDisc.pin;
                        } else {
                            ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup = 0;
                        }
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mUserAuthorizingJoinState);
                        break;
                    }
                    case 147485: {
                        P2pStateMachine.this.loge("Duplicate group creation event notice, ignore");
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }

            public void exit() {
                P2pStateMachine.this.updateThisDevice(3);
                P2pStateMachine.this.resetWifiP2pInfo();
                WifiP2pService.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                P2pStateMachine.this.sendP2pConnectionChangedBroadcast();
            }
        }

        class FrequencyConflictState
        extends State {
            private AlertDialog mFrequencyConflictDialog;

            FrequencyConflictState() {
            }

            public void enter() {
                this.notifyFrequencyConflict();
            }

            private void notifyFrequencyConflict() {
                P2pStateMachine.this.logd("Notify frequency conflict");
                Resources r = Resources.getSystem();
                AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setMessage(r.getString(17040451, P2pStateMachine.this.getDeviceName(((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress))).setPositiveButton(r.getString(17040496), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        P2pStateMachine.this.sendMessage(143364);
                    }
                }).setNegativeButton(r.getString(17040444), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        P2pStateMachine.this.sendMessage(143365);
                    }
                }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface arg0) {
                        P2pStateMachine.this.sendMessage(143365);
                    }
                }).create();
                dialog.getWindow().setType(2003);
                dialog.show();
                this.mFrequencyConflictDialog = dialog;
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147481: 
                    case 147483: {
                        P2pStateMachine.this.loge(this.getName() + "group sucess during freq conflict!");
                        break;
                    }
                    case 147485: {
                        P2pStateMachine.this.loge(this.getName() + "group started after freq conflict, handle anyway");
                        P2pStateMachine.this.deferMessage(message);
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                        break;
                    }
                    case 147482: 
                    case 147484: 
                    case 147486: {
                        break;
                    }
                    case 143365: {
                        P2pStateMachine.this.handleGroupCreationFailure();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    case 143364: {
                        WifiP2pService.this.mWifiChannel.sendMessage(143372, 1);
                        WifiP2pService.this.mTempoarilyDisconnectedWifi = true;
                        break;
                    }
                    case 143373: {
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        P2pStateMachine.this.sendMessage(139271, P2pStateMachine.this.mSavedPeerConfig);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }

            public void exit() {
                if (this.mFrequencyConflictDialog != null) {
                    this.mFrequencyConflictDialog.dismiss();
                }
            }
        }

        class GroupNegotiationState
        extends State {
            GroupNegotiationState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147481: 
                    case 147483: {
                        break;
                    }
                    case 147485: {
                        P2pStateMachine.this.mGroup = (WifiP2pGroup)message.obj;
                        if (P2pStateMachine.this.mGroup.getNetworkId() == -2) {
                            P2pStateMachine.this.updatePersistentNetworks(NO_RELOAD);
                            String devAddr = ((P2pStateMachine)P2pStateMachine.this).mGroup.getOwner().deviceAddress;
                            P2pStateMachine.this.mGroup.setNetworkId(P2pStateMachine.this.mGroups.getNetworkId(devAddr, P2pStateMachine.this.mGroup.getNetworkName()));
                        }
                        if (P2pStateMachine.this.mGroup.isGroupOwner()) {
                            if (!WifiP2pService.this.mAutonomousGroup) {
                                P2pStateMachine.this.mWifiNative.setP2pGroupIdle(P2pStateMachine.this.mGroup.getInterface(), 10);
                            }
                            P2pStateMachine.this.startDhcpServer(P2pStateMachine.this.mGroup.getInterface());
                        } else {
                            P2pStateMachine.this.mWifiNative.setP2pGroupIdle(P2pStateMachine.this.mGroup.getInterface(), 10);
                            WifiP2pService.this.mDhcpStateMachine = DhcpStateMachine.makeDhcpStateMachine(WifiP2pService.this.mContext, P2pStateMachine.this, P2pStateMachine.this.mGroup.getInterface());
                            P2pStateMachine.this.mWifiNative.setP2pPowerSave(P2pStateMachine.this.mGroup.getInterface(), false);
                            WifiP2pService.this.mDhcpStateMachine.sendMessage(196609);
                            WifiP2pDevice groupOwner = P2pStateMachine.this.mGroup.getOwner();
                            WifiP2pDevice peer = P2pStateMachine.this.mPeers.get(groupOwner.deviceAddress);
                            if (peer != null) {
                                groupOwner.updateSupplicantDetails(peer);
                                P2pStateMachine.this.mPeers.updateStatus(groupOwner.deviceAddress, 0);
                                P2pStateMachine.this.sendPeersChangedBroadcast();
                            } else {
                                P2pStateMachine.this.logw("Unknown group owner " + groupOwner);
                            }
                        }
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupCreatedState);
                        break;
                    }
                    case 147482: {
                        P2pStatus status = (P2pStatus)((Object)message.obj);
                        if (status == P2pStatus.NO_COMMON_CHANNEL) {
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mFrequencyConflictState);
                            break;
                        }
                    }
                    case 147486: {
                        P2pStateMachine.this.handleGroupCreationFailure();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    case 147484: {
                        P2pStatus status = (P2pStatus)((Object)message.obj);
                        if (status != P2pStatus.NO_COMMON_CHANNEL) break;
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mFrequencyConflictState);
                        break;
                    }
                    case 147488: {
                        P2pStatus status = (P2pStatus)((Object)message.obj);
                        if (status == P2pStatus.SUCCESS) break;
                        P2pStateMachine.this.loge("Invitation result " + (Object)((Object)status));
                        if (status == P2pStatus.UNKNOWN_P2P_GROUP) {
                            int netId = ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.netId;
                            if (netId >= 0) {
                                P2pStateMachine.this.removeClientFromList(netId, ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress, true);
                            }
                            ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.netId = -2;
                            P2pStateMachine.this.p2pConnectWithPinDisplay(P2pStateMachine.this.mSavedPeerConfig);
                            break;
                        }
                        if (status == P2pStatus.INFORMATION_IS_CURRENTLY_UNAVAILABLE) {
                            ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.netId = -2;
                            P2pStateMachine.this.p2pConnectWithPinDisplay(P2pStateMachine.this.mSavedPeerConfig);
                            break;
                        }
                        if (status == P2pStatus.NO_COMMON_CHANNEL) {
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mFrequencyConflictState);
                            break;
                        }
                        P2pStateMachine.this.handleGroupCreationFailure();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class ProvisionDiscoveryState
        extends State {
            ProvisionDiscoveryState() {
            }

            public void enter() {
                P2pStateMachine.this.mWifiNative.p2pProvisionDiscovery(P2pStateMachine.this.mSavedPeerConfig);
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147490: {
                        WifiP2pProvDiscEvent provDisc = (WifiP2pProvDiscEvent)message.obj;
                        WifiP2pDevice device = provDisc.device;
                        if (!device.deviceAddress.equals(((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress) || ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup != 0) break;
                        P2pStateMachine.this.p2pConnectWithPinDisplay(P2pStateMachine.this.mSavedPeerConfig);
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                        break;
                    }
                    case 147491: {
                        WifiP2pProvDiscEvent provDisc = (WifiP2pProvDiscEvent)message.obj;
                        WifiP2pDevice device = provDisc.device;
                        if (!device.deviceAddress.equals(((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress) || ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup != 2) break;
                        if (!TextUtils.isEmpty(((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.pin)) {
                            P2pStateMachine.this.p2pConnectWithPinDisplay(P2pStateMachine.this.mSavedPeerConfig);
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                            break;
                        }
                        WifiP2pService.this.mJoinExistingGroup = false;
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mUserAuthorizingNegotiationRequestState);
                        break;
                    }
                    case 147492: {
                        WifiP2pProvDiscEvent provDisc = (WifiP2pProvDiscEvent)message.obj;
                        WifiP2pDevice device = provDisc.device;
                        if (!device.deviceAddress.equals(((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress) || ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup != 1) break;
                        ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.pin = provDisc.pin;
                        P2pStateMachine.this.p2pConnectWithPinDisplay(P2pStateMachine.this.mSavedPeerConfig);
                        P2pStateMachine.this.notifyInvitationSent(provDisc.pin, device.deviceAddress);
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                        break;
                    }
                    case 147495: {
                        P2pStateMachine.this.loge("provision discovery failed");
                        P2pStateMachine.this.handleGroupCreationFailure();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class UserAuthorizingInviteRequestState
        extends State {
            UserAuthorizingInviteRequestState() {
            }

            public void enter() {
                P2pStateMachine.this.notifyInvitationReceived();
            }

            public boolean processMessage(Message message) {
                boolean ret = true;
                switch (message.what) {
                    case 143362: {
                        P2pStateMachine.this.mWifiNative.p2pStopFind();
                        if (!P2pStateMachine.this.reinvokePersistentGroup(P2pStateMachine.this.mSavedPeerConfig)) {
                            P2pStateMachine.this.p2pConnectWithPinDisplay(P2pStateMachine.this.mSavedPeerConfig);
                        }
                        P2pStateMachine.this.mPeers.updateStatus(((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress, 1);
                        P2pStateMachine.this.sendPeersChangedBroadcast();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                        break;
                    }
                    case 143363: {
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return ret;
            }

            public void exit() {
            }
        }

        class UserAuthorizingNegotiationRequestState
        extends State {
            UserAuthorizingNegotiationRequestState() {
            }

            public void enter() {
                P2pStateMachine.this.notifyInvitationReceived();
            }

            public boolean processMessage(Message message) {
                boolean ret = true;
                switch (message.what) {
                    case 143362: {
                        P2pStateMachine.this.mWifiNative.p2pStopFind();
                        P2pStateMachine.this.p2pConnectWithPinDisplay(P2pStateMachine.this.mSavedPeerConfig);
                        P2pStateMachine.this.mPeers.updateStatus(((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress, 1);
                        P2pStateMachine.this.sendPeersChangedBroadcast();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                        break;
                    }
                    case 143363: {
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return ret;
            }

            public void exit() {
            }
        }

        class GroupCreatingState
        extends State {
            GroupCreatingState() {
            }

            public void enter() {
                P2pStateMachine.this.sendMessageDelayed(P2pStateMachine.this.obtainMessage(143361, ++mGroupCreatingTimeoutIndex, 0), 120000L);
            }

            public boolean processMessage(Message message) {
                boolean ret = true;
                switch (message.what) {
                    case 143361: {
                        if (mGroupCreatingTimeoutIndex != message.arg1) break;
                        P2pStateMachine.this.handleGroupCreationFailure();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    case 147478: {
                        WifiP2pDevice device = (WifiP2pDevice)message.obj;
                        if (!((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress.equals(device.deviceAddress)) {
                            ret = false;
                            break;
                        }
                        P2pStateMachine.this.mPeersLostDuringConnection.updateSupplicantDetails(device);
                        break;
                    }
                    case 139265: {
                        P2pStateMachine.this.replyToMessage(message, 139266, 2);
                        break;
                    }
                    case 139274: {
                        P2pStateMachine.this.mWifiNative.p2pCancelConnect();
                        P2pStateMachine.this.handleGroupCreationFailure();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        P2pStateMachine.this.replyToMessage(message, 139276);
                        break;
                    }
                    default: {
                        ret = false;
                    }
                }
                return ret;
            }
        }

        class InactiveState
        extends State {
            InactiveState() {
            }

            public void enter() {
                P2pStateMachine.this.mSavedPeerConfig.invalidate();
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 139271: {
                        WifiP2pConfig config = (WifiP2pConfig)message.obj;
                        if (P2pStateMachine.this.isConfigInvalid(config)) {
                            P2pStateMachine.this.loge("Dropping connect requeset " + config);
                            P2pStateMachine.this.replyToMessage(message, 139272);
                            break;
                        }
                        WifiP2pService.this.mAutonomousGroup = false;
                        P2pStateMachine.this.mWifiNative.p2pStopFind();
                        if (P2pStateMachine.this.reinvokePersistentGroup(config)) {
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                        } else {
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mProvisionDiscoveryState);
                        }
                        P2pStateMachine.this.mSavedPeerConfig = config;
                        P2pStateMachine.this.mPeers.updateStatus(((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.deviceAddress, 1);
                        P2pStateMachine.this.sendPeersChangedBroadcast();
                        P2pStateMachine.this.replyToMessage(message, 139273);
                        break;
                    }
                    case 139268: {
                        if (P2pStateMachine.this.mWifiNative.p2pStopFind()) {
                            P2pStateMachine.this.mWifiNative.p2pFlush();
                            WifiP2pService.this.mServiceDiscReqId = null;
                            P2pStateMachine.this.replyToMessage(message, 139270);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139269, 0);
                        break;
                    }
                    case 147479: {
                        WifiP2pConfig config = (WifiP2pConfig)message.obj;
                        if (P2pStateMachine.this.isConfigInvalid(config)) {
                            P2pStateMachine.this.loge("Dropping GO neg request " + config);
                            break;
                        }
                        P2pStateMachine.this.mSavedPeerConfig = config;
                        WifiP2pService.this.mAutonomousGroup = false;
                        WifiP2pService.this.mJoinExistingGroup = false;
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mUserAuthorizingNegotiationRequestState);
                        break;
                    }
                    case 147487: {
                        WifiP2pGroup group = (WifiP2pGroup)message.obj;
                        WifiP2pDevice owner = group.getOwner();
                        if (owner == null) {
                            P2pStateMachine.this.loge("Ignored invitation from null owner");
                            break;
                        }
                        WifiP2pConfig config = new WifiP2pConfig();
                        config.deviceAddress = group.getOwner().deviceAddress;
                        if (P2pStateMachine.this.isConfigInvalid(config)) {
                            P2pStateMachine.this.loge("Dropping invitation request " + config);
                            break;
                        }
                        P2pStateMachine.this.mSavedPeerConfig = config;
                        owner = P2pStateMachine.this.mPeers.get(owner.deviceAddress);
                        if (owner != null) {
                            if (owner.wpsPbcSupported()) {
                                ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup = 0;
                            } else if (owner.wpsKeypadSupported()) {
                                ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup = 2;
                            } else if (owner.wpsDisplaySupported()) {
                                ((P2pStateMachine)P2pStateMachine.this).mSavedPeerConfig.wps.setup = 1;
                            }
                        }
                        WifiP2pService.this.mAutonomousGroup = false;
                        WifiP2pService.this.mJoinExistingGroup = true;
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mUserAuthorizingInviteRequestState);
                        break;
                    }
                    case 147489: 
                    case 147491: 
                    case 147492: {
                        break;
                    }
                    case 139277: {
                        WifiP2pService.this.mAutonomousGroup = true;
                        int netId = message.arg1;
                        boolean ret = false;
                        ret = netId == -2 ? ((netId = P2pStateMachine.this.mGroups.getNetworkId(((WifiP2pService)WifiP2pService.this).mThisDevice.deviceAddress)) != -1 ? P2pStateMachine.this.mWifiNative.p2pGroupAdd(netId) : P2pStateMachine.this.mWifiNative.p2pGroupAdd(true)) : P2pStateMachine.this.mWifiNative.p2pGroupAdd(false);
                        if (ret) {
                            P2pStateMachine.this.replyToMessage(message, 139279);
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139278, 0);
                        break;
                    }
                    case 147485: {
                        P2pStateMachine.this.mGroup = (WifiP2pGroup)message.obj;
                        if (P2pStateMachine.this.mGroup.getNetworkId() == -2) {
                            WifiP2pService.this.mAutonomousGroup = false;
                            P2pStateMachine.this.deferMessage(message);
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                            break;
                        }
                        P2pStateMachine.this.loge("Unexpected group creation, remove " + P2pStateMachine.this.mGroup);
                        P2pStateMachine.this.mWifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface());
                        break;
                    }
                    case 139329: {
                        P2pStateMachine.this.mWifiNative.p2pFlush();
                        if (P2pStateMachine.this.mWifiNative.p2pExtListen(true, 500, 500)) {
                            P2pStateMachine.this.replyToMessage(message, 139331);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139330);
                        break;
                    }
                    case 139332: {
                        if (P2pStateMachine.this.mWifiNative.p2pExtListen(false, 0, 0)) {
                            P2pStateMachine.this.replyToMessage(message, 139334);
                        } else {
                            P2pStateMachine.this.replyToMessage(message, 139333);
                        }
                        P2pStateMachine.this.mWifiNative.p2pFlush();
                        break;
                    }
                    case 139335: {
                        Bundle p2pChannels = (Bundle)message.obj;
                        int lc = p2pChannels.getInt("lc", 0);
                        int oc = p2pChannels.getInt("oc", 0);
                        if (P2pStateMachine.this.mWifiNative.p2pSetChannel(lc, oc)) {
                            P2pStateMachine.this.replyToMessage(message, 139337);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139336);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class P2pEnabledState
        extends State {
            P2pEnabledState() {
            }

            public void enter() {
                P2pStateMachine.this.sendP2pStateChangedBroadcast(true);
                WifiP2pService.this.mNetworkInfo.setIsAvailable(true);
                P2pStateMachine.this.sendP2pConnectionChangedBroadcast();
                P2pStateMachine.this.initializeP2pSettings();
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147458: {
                        P2pStateMachine.this.loge("Unexpected loss of p2p socket connection");
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisabledState);
                        break;
                    }
                    case 131203: {
                        break;
                    }
                    case 131204: {
                        if (P2pStateMachine.this.mPeers.clear()) {
                            P2pStateMachine.this.sendPeersChangedBroadcast();
                        }
                        if (P2pStateMachine.this.mGroups.clear()) {
                            P2pStateMachine.this.sendP2pPersistentGroupsChangedBroadcast();
                        }
                        P2pStateMachine.this.mWifiMonitor.stopMonitoring();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisablingState);
                        break;
                    }
                    case 139315: {
                        WifiP2pDevice d = (WifiP2pDevice)message.obj;
                        if (d != null && P2pStateMachine.this.setAndPersistDeviceName(d.deviceName)) {
                            P2pStateMachine.this.replyToMessage(message, 139317);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139316, 0);
                        break;
                    }
                    case 139323: {
                        WifiP2pWfdInfo d = (WifiP2pWfdInfo)message.obj;
                        if (d != null && P2pStateMachine.this.setWfdInfo(d)) {
                            P2pStateMachine.this.replyToMessage(message, 139325);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139324, 0);
                        break;
                    }
                    case 143375: {
                        boolean blocked;
                        boolean bl = blocked = message.arg1 == 1;
                        if (WifiP2pService.this.mDiscoveryBlocked == blocked) break;
                        WifiP2pService.this.mDiscoveryBlocked = blocked;
                        if (blocked && WifiP2pService.this.mDiscoveryStarted) {
                            P2pStateMachine.this.mWifiNative.p2pStopFind();
                            WifiP2pService.this.mDiscoveryPostponed = true;
                        }
                        if (!blocked && WifiP2pService.this.mDiscoveryPostponed) {
                            WifiP2pService.this.mDiscoveryPostponed = false;
                            P2pStateMachine.this.mWifiNative.p2pFind(120);
                        }
                        if (!blocked) break;
                        try {
                            StateMachine m = (StateMachine)message.obj;
                            m.sendMessage(message.arg2);
                        }
                        catch (Exception e) {
                            P2pStateMachine.this.loge("unable to send BLOCK_DISCOVERY response: " + e);
                        }
                        break;
                    }
                    case 139265: {
                        if (WifiP2pService.this.mDiscoveryBlocked) {
                            P2pStateMachine.this.replyToMessage(message, 139266, 2);
                            break;
                        }
                        P2pStateMachine.this.clearSupplicantServiceRequest();
                        if (P2pStateMachine.this.mWifiNative.p2pFind(120)) {
                            P2pStateMachine.this.replyToMessage(message, 139267);
                            P2pStateMachine.this.sendP2pDiscoveryChangedBroadcast(true);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139266, 0);
                        break;
                    }
                    case 147493: {
                        P2pStateMachine.this.sendP2pDiscoveryChangedBroadcast(false);
                        break;
                    }
                    case 139268: {
                        if (P2pStateMachine.this.mWifiNative.p2pStopFind()) {
                            P2pStateMachine.this.replyToMessage(message, 139270);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139269, 0);
                        break;
                    }
                    case 139310: {
                        if (WifiP2pService.this.mDiscoveryBlocked) {
                            P2pStateMachine.this.replyToMessage(message, 139311, 2);
                            break;
                        }
                        if (!P2pStateMachine.this.updateSupplicantServiceRequest()) {
                            P2pStateMachine.this.replyToMessage(message, 139311, 3);
                            break;
                        }
                        if (P2pStateMachine.this.mWifiNative.p2pFind(120)) {
                            P2pStateMachine.this.replyToMessage(message, 139312);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139311, 0);
                        break;
                    }
                    case 147477: {
                        WifiP2pDevice device = (WifiP2pDevice)message.obj;
                        if (((WifiP2pService)WifiP2pService.this).mThisDevice.deviceAddress.equals(device.deviceAddress)) break;
                        P2pStateMachine.this.mPeers.updateSupplicantDetails(device);
                        P2pStateMachine.this.sendPeersChangedBroadcast();
                        break;
                    }
                    case 147478: {
                        WifiP2pDevice device = (WifiP2pDevice)message.obj;
                        device = P2pStateMachine.this.mPeers.remove(device.deviceAddress);
                        if (device == null) break;
                        P2pStateMachine.this.sendPeersChangedBroadcast();
                        break;
                    }
                    case 139292: {
                        WifiP2pServiceInfo servInfo = (WifiP2pServiceInfo)message.obj;
                        if (P2pStateMachine.this.addLocalService(message.replyTo, servInfo)) {
                            P2pStateMachine.this.replyToMessage(message, 139294);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139293);
                        break;
                    }
                    case 139295: {
                        WifiP2pServiceInfo servInfo = (WifiP2pServiceInfo)message.obj;
                        P2pStateMachine.this.removeLocalService(message.replyTo, servInfo);
                        P2pStateMachine.this.replyToMessage(message, 139297);
                        break;
                    }
                    case 139298: {
                        P2pStateMachine.this.clearLocalServices(message.replyTo);
                        P2pStateMachine.this.replyToMessage(message, 139300);
                        break;
                    }
                    case 139301: {
                        if (!P2pStateMachine.this.addServiceRequest(message.replyTo, (WifiP2pServiceRequest)message.obj)) {
                            P2pStateMachine.this.replyToMessage(message, 139302);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139303);
                        break;
                    }
                    case 139304: {
                        P2pStateMachine.this.removeServiceRequest(message.replyTo, (WifiP2pServiceRequest)message.obj);
                        P2pStateMachine.this.replyToMessage(message, 139306);
                        break;
                    }
                    case 139307: {
                        P2pStateMachine.this.clearServiceRequests(message.replyTo);
                        P2pStateMachine.this.replyToMessage(message, 139309);
                        break;
                    }
                    case 147494: {
                        List sdRespList = (List)message.obj;
                        for (WifiP2pServiceResponse resp : sdRespList) {
                            WifiP2pDevice dev = P2pStateMachine.this.mPeers.get(resp.getSrcDevice().deviceAddress);
                            resp.setSrcDevice(dev);
                            P2pStateMachine.this.sendServiceResponse(resp);
                        }
                        break;
                    }
                    case 139318: {
                        P2pStateMachine.this.mGroups.remove(message.arg1);
                        P2pStateMachine.this.replyToMessage(message, 139320);
                        break;
                    }
                    case 143374: {
                        P2pStateMachine.this.mWifiNative.setMiracastMode(message.arg1);
                        break;
                    }
                    case 139329: {
                        P2pStateMachine.this.mWifiNative.p2pFlush();
                        if (P2pStateMachine.this.mWifiNative.p2pExtListen(true, 500, 500)) {
                            P2pStateMachine.this.replyToMessage(message, 139331);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139330);
                        break;
                    }
                    case 139332: {
                        if (P2pStateMachine.this.mWifiNative.p2pExtListen(false, 0, 0)) {
                            P2pStateMachine.this.replyToMessage(message, 139334);
                        } else {
                            P2pStateMachine.this.replyToMessage(message, 139333);
                        }
                        P2pStateMachine.this.mWifiNative.p2pFlush();
                        break;
                    }
                    case 139335: {
                        Bundle p2pChannels = (Bundle)message.obj;
                        int lc = p2pChannels.getInt("lc", 0);
                        int oc = p2pChannels.getInt("oc", 0);
                        if (P2pStateMachine.this.mWifiNative.p2pSetChannel(lc, oc)) {
                            P2pStateMachine.this.replyToMessage(message, 139337);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139336);
                        break;
                    }
                    case 143376: {
                        String countryCode = (String)message.obj;
                        countryCode = countryCode.toUpperCase(Locale.ROOT);
                        if (WifiP2pService.this.mLastSetCountryCode != null && countryCode.equals(WifiP2pService.this.mLastSetCountryCode) || !P2pStateMachine.this.mWifiNative.setCountryCode(countryCode)) break;
                        WifiP2pService.this.mLastSetCountryCode = countryCode;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }

            public void exit() {
                P2pStateMachine.this.sendP2pStateChangedBroadcast(false);
                WifiP2pService.this.mNetworkInfo.setIsAvailable(false);
                WifiP2pService.this.mLastSetCountryCode = null;
            }
        }

        class P2pEnablingState
        extends State {
            P2pEnablingState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147457: {
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    case 147458: {
                        P2pStateMachine.this.loge("P2p socket connection failed");
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisabledState);
                        break;
                    }
                    case 131203: 
                    case 131204: {
                        P2pStateMachine.this.deferMessage(message);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class P2pDisabledState
        extends State {
            P2pDisabledState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 131203: {
                        try {
                            WifiP2pService.this.mNwService.setInterfaceUp(WifiP2pService.this.mInterface);
                        }
                        catch (RemoteException re) {
                            P2pStateMachine.this.loge("Unable to change interface settings: " + re);
                        }
                        catch (IllegalStateException ie) {
                            P2pStateMachine.this.loge("Unable to change interface settings: " + ie);
                        }
                        P2pStateMachine.this.mWifiMonitor.startMonitoring();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pEnablingState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class P2pDisablingState
        extends State {
            P2pDisablingState() {
            }

            public void enter() {
                P2pStateMachine.this.sendMessageDelayed(P2pStateMachine.this.obtainMessage(143366, ++mDisableP2pTimeoutIndex, 0), 5000L);
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147458: {
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisabledState);
                        break;
                    }
                    case 131203: 
                    case 131204: {
                        P2pStateMachine.this.deferMessage(message);
                        break;
                    }
                    case 143366: {
                        if (mGroupCreatingTimeoutIndex != message.arg1) break;
                        P2pStateMachine.this.loge("P2p disable timed out");
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisabledState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }

            public void exit() {
                WifiP2pService.this.mWifiChannel.sendMessage(131205);
            }
        }

        class P2pNotSupportedState
        extends State {
            P2pNotSupportedState() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 139265: {
                        P2pStateMachine.this.replyToMessage(message, 139266, 1);
                        break;
                    }
                    case 139268: {
                        P2pStateMachine.this.replyToMessage(message, 139269, 1);
                        break;
                    }
                    case 139310: {
                        P2pStateMachine.this.replyToMessage(message, 139311, 1);
                        break;
                    }
                    case 139271: {
                        P2pStateMachine.this.replyToMessage(message, 139272, 1);
                        break;
                    }
                    case 139274: {
                        P2pStateMachine.this.replyToMessage(message, 139275, 1);
                        break;
                    }
                    case 139277: {
                        P2pStateMachine.this.replyToMessage(message, 139278, 1);
                        break;
                    }
                    case 139280: {
                        P2pStateMachine.this.replyToMessage(message, 139281, 1);
                        break;
                    }
                    case 139292: {
                        P2pStateMachine.this.replyToMessage(message, 139293, 1);
                        break;
                    }
                    case 139295: {
                        P2pStateMachine.this.replyToMessage(message, 139296, 1);
                        break;
                    }
                    case 139298: {
                        P2pStateMachine.this.replyToMessage(message, 139299, 1);
                        break;
                    }
                    case 139301: {
                        P2pStateMachine.this.replyToMessage(message, 139302, 1);
                        break;
                    }
                    case 139304: {
                        P2pStateMachine.this.replyToMessage(message, 139305, 1);
                        break;
                    }
                    case 139307: {
                        P2pStateMachine.this.replyToMessage(message, 139308, 1);
                        break;
                    }
                    case 139315: {
                        P2pStateMachine.this.replyToMessage(message, 139316, 1);
                        break;
                    }
                    case 139318: {
                        P2pStateMachine.this.replyToMessage(message, 139318, 1);
                        break;
                    }
                    case 139323: {
                        P2pStateMachine.this.replyToMessage(message, 139324, 1);
                        break;
                    }
                    case 139326: {
                        P2pStateMachine.this.replyToMessage(message, 139327, 1);
                        break;
                    }
                    case 139329: {
                        P2pStateMachine.this.replyToMessage(message, 139330, 1);
                        break;
                    }
                    case 139332: {
                        P2pStateMachine.this.replyToMessage(message, 139333, 1);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class DefaultState
        extends State {
            DefaultState() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 69632: {
                        if (message.arg1 == 0) {
                            WifiP2pService.this.mWifiChannel = (AsyncChannel)message.obj;
                            break;
                        }
                        P2pStateMachine.this.loge("Full connection failure, error = " + message.arg1);
                        WifiP2pService.this.mWifiChannel = null;
                        break;
                    }
                    case 69636: {
                        if (message.arg1 == 2) {
                            P2pStateMachine.this.loge("Send failed, client connection lost");
                        } else {
                            P2pStateMachine.this.loge("Client connection lost with reason: " + message.arg1);
                        }
                        WifiP2pService.this.mWifiChannel = null;
                        break;
                    }
                    case 69633: {
                        AsyncChannel ac = new AsyncChannel();
                        ac.connect(WifiP2pService.this.mContext, P2pStateMachine.this.getHandler(), message.replyTo);
                        break;
                    }
                    case 143375: {
                        WifiP2pService.this.mDiscoveryBlocked = message.arg1 == 1;
                        WifiP2pService.this.mDiscoveryPostponed = false;
                        if (!WifiP2pService.this.mDiscoveryBlocked) break;
                        try {
                            StateMachine m = (StateMachine)message.obj;
                            m.sendMessage(message.arg2);
                        }
                        catch (Exception e) {
                            P2pStateMachine.this.loge("unable to send BLOCK_DISCOVERY response: " + e);
                        }
                        break;
                    }
                    case 139265: {
                        P2pStateMachine.this.replyToMessage(message, 139266, 2);
                        break;
                    }
                    case 139268: {
                        P2pStateMachine.this.replyToMessage(message, 139269, 2);
                        break;
                    }
                    case 139310: {
                        P2pStateMachine.this.replyToMessage(message, 139311, 2);
                        break;
                    }
                    case 139271: {
                        P2pStateMachine.this.replyToMessage(message, 139272, 2);
                        break;
                    }
                    case 139274: {
                        P2pStateMachine.this.replyToMessage(message, 139275, 2);
                        break;
                    }
                    case 139277: {
                        P2pStateMachine.this.replyToMessage(message, 139278, 2);
                        break;
                    }
                    case 139280: {
                        P2pStateMachine.this.replyToMessage(message, 139281, 2);
                        break;
                    }
                    case 139292: {
                        P2pStateMachine.this.replyToMessage(message, 139293, 2);
                        break;
                    }
                    case 139295: {
                        P2pStateMachine.this.replyToMessage(message, 139296, 2);
                        break;
                    }
                    case 139298: {
                        P2pStateMachine.this.replyToMessage(message, 139299, 2);
                        break;
                    }
                    case 139301: {
                        P2pStateMachine.this.replyToMessage(message, 139302, 2);
                        break;
                    }
                    case 139304: {
                        P2pStateMachine.this.replyToMessage(message, 139305, 2);
                        break;
                    }
                    case 139307: {
                        P2pStateMachine.this.replyToMessage(message, 139308, 2);
                        break;
                    }
                    case 139315: {
                        P2pStateMachine.this.replyToMessage(message, 139316, 2);
                        break;
                    }
                    case 139318: {
                        P2pStateMachine.this.replyToMessage(message, 139318, 2);
                        break;
                    }
                    case 139323: {
                        P2pStateMachine.this.replyToMessage(message, 139324, 2);
                        break;
                    }
                    case 139283: {
                        P2pStateMachine.this.replyToMessage(message, 139284, new WifiP2pDeviceList(P2pStateMachine.this.mPeers));
                        break;
                    }
                    case 139285: {
                        P2pStateMachine.this.replyToMessage(message, 139286, new WifiP2pInfo(P2pStateMachine.this.mWifiP2pInfo));
                        break;
                    }
                    case 139287: {
                        P2pStateMachine.this.replyToMessage(message, 139288, P2pStateMachine.this.mGroup != null ? new WifiP2pGroup(P2pStateMachine.this.mGroup) : null);
                        break;
                    }
                    case 139321: {
                        P2pStateMachine.this.replyToMessage(message, 139322, new WifiP2pGroupList(P2pStateMachine.this.mGroups, null));
                        break;
                    }
                    case 139326: {
                        P2pStateMachine.this.replyToMessage(message, 139327, 2);
                        break;
                    }
                    case 139329: 
                    case 139332: 
                    case 139335: 
                    case 143361: 
                    case 143362: 
                    case 143363: 
                    case 143364: 
                    case 143365: 
                    case 143366: 
                    case 143373: 
                    case 143374: 
                    case 143376: 
                    case 147457: 
                    case 147458: 
                    case 147459: 
                    case 147460: 
                    case 147461: 
                    case 147462: 
                    case 147463: 
                    case 147464: 
                    case 147465: 
                    case 147466: 
                    case 147467: 
                    case 147477: 
                    case 147478: 
                    case 147486: 
                    case 147488: 
                    case 147493: 
                    case 147494: 
                    case 147495: 
                    case 196612: 
                    case 196613: 
                    case 196614: {
                        break;
                    }
                    case 131203: {
                        break;
                    }
                    case 131204: {
                        WifiP2pService.this.mWifiChannel.sendMessage(131205);
                        break;
                    }
                    case 147485: {
                        P2pStateMachine.this.mGroup = (WifiP2pGroup)message.obj;
                        P2pStateMachine.this.loge("Unexpected group creation, remove " + P2pStateMachine.this.mGroup);
                        P2pStateMachine.this.mWifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface());
                        break;
                    }
                    case 147484: {
                        break;
                    }
                    default: {
                        P2pStateMachine.this.loge("Unhandled message " + message);
                        return false;
                    }
                }
                return true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum P2pStatus {
        SUCCESS,
        INFORMATION_IS_CURRENTLY_UNAVAILABLE,
        INCOMPATIBLE_PARAMETERS,
        LIMIT_REACHED,
        INVALID_PARAMETER,
        UNABLE_TO_ACCOMMODATE_REQUEST,
        PREVIOUS_PROTOCOL_ERROR,
        NO_COMMON_CHANNEL,
        UNKNOWN_P2P_GROUP,
        BOTH_GO_INTENT_15,
        INCOMPATIBLE_PROVISIONING_METHOD,
        REJECTED_BY_USER,
        UNKNOWN;


        public static P2pStatus valueOf(int error) {
            switch (error) {
                case 0: {
                    return SUCCESS;
                }
                case 1: {
                    return INFORMATION_IS_CURRENTLY_UNAVAILABLE;
                }
                case 2: {
                    return INCOMPATIBLE_PARAMETERS;
                }
                case 3: {
                    return LIMIT_REACHED;
                }
                case 4: {
                    return INVALID_PARAMETER;
                }
                case 5: {
                    return UNABLE_TO_ACCOMMODATE_REQUEST;
                }
                case 6: {
                    return PREVIOUS_PROTOCOL_ERROR;
                }
                case 7: {
                    return NO_COMMON_CHANNEL;
                }
                case 8: {
                    return UNKNOWN_P2P_GROUP;
                }
                case 9: {
                    return BOTH_GO_INTENT_15;
                }
                case 10: {
                    return INCOMPATIBLE_PROVISIONING_METHOD;
                }
                case 11: {
                    return REJECTED_BY_USER;
                }
            }
            return UNKNOWN;
        }
    }
}

