/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.PrintDocumentInfo;
import android.print.PrintJobId;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintService;
import android.util.Log;
import java.io.IOException;

public final class PrintDocument {
    private static final String LOG_TAG = "PrintDocument";
    private final PrintJobId mPrintJobId;
    private final IPrintServiceClient mPrintServiceClient;
    private final PrintDocumentInfo mInfo;

    PrintDocument(PrintJobId printJobId, IPrintServiceClient printServiceClient, PrintDocumentInfo info) {
        this.mPrintJobId = printJobId;
        this.mPrintServiceClient = printServiceClient;
        this.mInfo = info;
    }

    public PrintDocumentInfo getInfo() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor getData() {
        PrintService.throwIfNotCalledOnMainThread();
        ParcelFileDescriptor source = null;
        ParcelFileDescriptor sink = null;
        try {
            ParcelFileDescriptor[] fds = ParcelFileDescriptor.createPipe();
            source = fds[0];
            sink = fds[1];
            this.mPrintServiceClient.writePrintJobData(sink, this.mPrintJobId);
            ParcelFileDescriptor parcelFileDescriptor = source;
            return parcelFileDescriptor;
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Error calling getting print job data!", ioe);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error calling getting print job data!", re);
        }
        finally {
            if (sink != null) {
                try {
                    sink.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }
}

