/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.renderscript.Type;
import java.util.ArrayList;

public final class ScriptGroup
extends BaseObj {
    IO[] mOutputs;
    IO[] mInputs;

    ScriptGroup(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public void setInput(Script.KernelID s, Allocation a) {
        for (int ct = 0; ct < this.mInputs.length; ++ct) {
            if (this.mInputs[ct].mKID != s) continue;
            this.mInputs[ct].mAllocation = a;
            this.mRS.nScriptGroupSetInput(this.getID(this.mRS), s.getID(this.mRS), this.mRS.safeID(a));
            return;
        }
        throw new RSIllegalArgumentException("Script not found");
    }

    public void setOutput(Script.KernelID s, Allocation a) {
        for (int ct = 0; ct < this.mOutputs.length; ++ct) {
            if (this.mOutputs[ct].mKID != s) continue;
            this.mOutputs[ct].mAllocation = a;
            this.mRS.nScriptGroupSetOutput(this.getID(this.mRS), s.getID(this.mRS), this.mRS.safeID(a));
            return;
        }
        throw new RSIllegalArgumentException("Script not found");
    }

    public void execute() {
        this.mRS.nScriptGroupExecute(this.getID(this.mRS));
    }

    public static final class Builder {
        private RenderScript mRS;
        private ArrayList<Node> mNodes = new ArrayList();
        private ArrayList<ConnectLine> mLines = new ArrayList();
        private int mKernelCount;

        public Builder(RenderScript rs) {
            this.mRS = rs;
        }

        private void validateCycle(Node target, Node original) {
            for (int ct = 0; ct < target.mOutputs.size(); ++ct) {
                Node tn;
                ConnectLine cl = target.mOutputs.get(ct);
                if (cl.mToK != null) {
                    tn = this.findNode(cl.mToK.mScript);
                    if (tn.equals(original)) {
                        throw new RSInvalidStateException("Loops in group not allowed.");
                    }
                    this.validateCycle(tn, original);
                }
                if (cl.mToF == null) continue;
                tn = this.findNode(cl.mToF.mScript);
                if (tn.equals(original)) {
                    throw new RSInvalidStateException("Loops in group not allowed.");
                }
                this.validateCycle(tn, original);
            }
        }

        private void mergeDAGs(int valueUsed, int valueKilled) {
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                if (this.mNodes.get((int)ct).dagNumber != valueKilled) continue;
                this.mNodes.get((int)ct).dagNumber = valueUsed;
            }
        }

        private void validateDAGRecurse(Node n, int dagNumber) {
            if (n.dagNumber != 0 && n.dagNumber != dagNumber) {
                this.mergeDAGs(n.dagNumber, dagNumber);
                return;
            }
            n.dagNumber = dagNumber;
            for (int ct = 0; ct < n.mOutputs.size(); ++ct) {
                Node tn;
                ConnectLine cl = n.mOutputs.get(ct);
                if (cl.mToK != null) {
                    tn = this.findNode(cl.mToK.mScript);
                    this.validateDAGRecurse(tn, dagNumber);
                }
                if (cl.mToF == null) continue;
                tn = this.findNode(cl.mToF.mScript);
                this.validateDAGRecurse(tn, dagNumber);
            }
        }

        private void validateDAG() {
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                Node n = this.mNodes.get(ct);
                if (n.mInputs.size() != 0) continue;
                if (n.mOutputs.size() == 0 && this.mNodes.size() > 1) {
                    throw new RSInvalidStateException("Groups cannot contain unconnected scripts");
                }
                this.validateDAGRecurse(n, ct + 1);
            }
            int dagNumber = this.mNodes.get((int)0).dagNumber;
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                if (this.mNodes.get((int)ct).dagNumber == dagNumber) continue;
                throw new RSInvalidStateException("Multiple DAGs in group not allowed.");
            }
        }

        private Node findNode(Script s) {
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                if (s != this.mNodes.get((int)ct).mScript) continue;
                return this.mNodes.get(ct);
            }
            return null;
        }

        private Node findNode(Script.KernelID k) {
            for (int ct = 0; ct < this.mNodes.size(); ++ct) {
                Node n = this.mNodes.get(ct);
                for (int ct2 = 0; ct2 < n.mKernels.size(); ++ct2) {
                    if (k != n.mKernels.get(ct2)) continue;
                    return n;
                }
            }
            return null;
        }

        public Builder addKernel(Script.KernelID k) {
            if (this.mLines.size() != 0) {
                throw new RSInvalidStateException("Kernels may not be added once connections exist.");
            }
            if (this.findNode(k) != null) {
                return this;
            }
            ++this.mKernelCount;
            Node n = this.findNode(k.mScript);
            if (n == null) {
                n = new Node(k.mScript);
                this.mNodes.add(n);
            }
            n.mKernels.add(k);
            return this;
        }

        public Builder addConnection(Type t, Script.KernelID from, Script.FieldID to) {
            Node nf = this.findNode(from);
            if (nf == null) {
                throw new RSInvalidStateException("From script not found.");
            }
            Node nt = this.findNode(to.mScript);
            if (nt == null) {
                throw new RSInvalidStateException("To script not found.");
            }
            ConnectLine cl = new ConnectLine(t, from, to);
            this.mLines.add(new ConnectLine(t, from, to));
            nf.mOutputs.add(cl);
            nt.mInputs.add(cl);
            this.validateCycle(nf, nf);
            return this;
        }

        public Builder addConnection(Type t, Script.KernelID from, Script.KernelID to) {
            Node nf = this.findNode(from);
            if (nf == null) {
                throw new RSInvalidStateException("From script not found.");
            }
            Node nt = this.findNode(to);
            if (nt == null) {
                throw new RSInvalidStateException("To script not found.");
            }
            ConnectLine cl = new ConnectLine(t, from, to);
            this.mLines.add(new ConnectLine(t, from, to));
            nf.mOutputs.add(cl);
            nt.mInputs.add(cl);
            this.validateCycle(nf, nf);
            return this;
        }

        public ScriptGroup create() {
            int ct;
            if (this.mNodes.size() == 0) {
                throw new RSInvalidStateException("Empty script groups are not allowed");
            }
            for (int ct2 = 0; ct2 < this.mNodes.size(); ++ct2) {
                this.mNodes.get((int)ct2).dagNumber = 0;
            }
            this.validateDAG();
            ArrayList<IO> inputs = new ArrayList<IO>();
            ArrayList<IO> outputs = new ArrayList<IO>();
            int[] kernels = new int[this.mKernelCount];
            int idx = 0;
            for (int ct3 = 0; ct3 < this.mNodes.size(); ++ct3) {
                Node n = this.mNodes.get(ct3);
                for (int ct2 = 0; ct2 < n.mKernels.size(); ++ct2) {
                    int ct32;
                    Script.KernelID kid = n.mKernels.get(ct2);
                    kernels[idx++] = kid.getID(this.mRS);
                    boolean hasInput = false;
                    boolean hasOutput = false;
                    for (ct32 = 0; ct32 < n.mInputs.size(); ++ct32) {
                        if (n.mInputs.get((int)ct32).mToK != kid) continue;
                        hasInput = true;
                    }
                    for (ct32 = 0; ct32 < n.mOutputs.size(); ++ct32) {
                        if (n.mOutputs.get((int)ct32).mFrom != kid) continue;
                        hasOutput = true;
                    }
                    if (!hasInput) {
                        inputs.add(new IO(kid));
                    }
                    if (hasOutput) continue;
                    outputs.add(new IO(kid));
                }
            }
            if (idx != this.mKernelCount) {
                throw new RSRuntimeException("Count mismatch, should not happen.");
            }
            int[] src = new int[this.mLines.size()];
            int[] dstk = new int[this.mLines.size()];
            int[] dstf = new int[this.mLines.size()];
            int[] types = new int[this.mLines.size()];
            for (int ct4 = 0; ct4 < this.mLines.size(); ++ct4) {
                ConnectLine cl = this.mLines.get(ct4);
                src[ct4] = cl.mFrom.getID(this.mRS);
                if (cl.mToK != null) {
                    dstk[ct4] = cl.mToK.getID(this.mRS);
                }
                if (cl.mToF != null) {
                    dstf[ct4] = cl.mToF.getID(this.mRS);
                }
                types[ct4] = cl.mAllocationType.getID(this.mRS);
            }
            int id2 = this.mRS.nScriptGroupCreate(kernels, src, dstk, dstf, types);
            if (id2 == 0) {
                throw new RSRuntimeException("Object creation error, should not happen.");
            }
            ScriptGroup sg = new ScriptGroup(id2, this.mRS);
            sg.mOutputs = new IO[outputs.size()];
            for (ct = 0; ct < outputs.size(); ++ct) {
                sg.mOutputs[ct] = (IO)outputs.get(ct);
            }
            sg.mInputs = new IO[inputs.size()];
            for (ct = 0; ct < inputs.size(); ++ct) {
                sg.mInputs[ct] = (IO)inputs.get(ct);
            }
            return sg;
        }
    }

    static class Node {
        Script mScript;
        ArrayList<Script.KernelID> mKernels = new ArrayList();
        ArrayList<ConnectLine> mInputs = new ArrayList();
        ArrayList<ConnectLine> mOutputs = new ArrayList();
        int dagNumber;
        Node mNext;

        Node(Script s) {
            this.mScript = s;
        }
    }

    static class ConnectLine {
        Script.FieldID mToF;
        Script.KernelID mToK;
        Script.KernelID mFrom;
        Type mAllocationType;

        ConnectLine(Type t, Script.KernelID from, Script.KernelID to) {
            this.mFrom = from;
            this.mToK = to;
            this.mAllocationType = t;
        }

        ConnectLine(Type t, Script.KernelID from, Script.FieldID to) {
            this.mFrom = from;
            this.mToF = to;
            this.mAllocationType = t;
        }
    }

    static class IO {
        Script.KernelID mKID;
        Allocation mAllocation;

        IO(Script.KernelID s) {
            this.mKID = s;
        }
    }
}

