/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.IOException;
import java.io.InputStream;

public final class MicrophoneInputStream
extends InputStream {
    private static final String TAG = "MicrophoneInputStream";
    private long mAudioRecord = 0L;
    private byte[] mOneByte = new byte[1];

    public MicrophoneInputStream(int sampleRate, int fifoDepth) throws IOException {
        this.mAudioRecord = MicrophoneInputStream.AudioRecordNew(sampleRate, fifoDepth);
        if (this.mAudioRecord == 0L) {
            throw new IOException("AudioRecord constructor failed - busy?");
        }
        int status = MicrophoneInputStream.AudioRecordStart(this.mAudioRecord);
        if (status != 0) {
            this.close();
            throw new IOException("AudioRecord start failed: " + status);
        }
    }

    public int read() throws IOException {
        if (this.mAudioRecord == 0L) {
            throw new IllegalStateException("not open");
        }
        int rtn = MicrophoneInputStream.AudioRecordRead(this.mAudioRecord, this.mOneByte, 0, 1);
        return rtn == 1 ? this.mOneByte[0] & 0xFF : -1;
    }

    public int read(byte[] b) throws IOException {
        if (this.mAudioRecord == 0L) {
            throw new IllegalStateException("not open");
        }
        return MicrophoneInputStream.AudioRecordRead(this.mAudioRecord, b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.mAudioRecord == 0L) {
            throw new IllegalStateException("not open");
        }
        return MicrophoneInputStream.AudioRecordRead(this.mAudioRecord, b, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.mAudioRecord != 0L) {
            try {
                MicrophoneInputStream.AudioRecordStop(this.mAudioRecord);
            }
            finally {
                try {
                    MicrophoneInputStream.AudioRecordDelete(this.mAudioRecord);
                }
                finally {
                    this.mAudioRecord = 0L;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.mAudioRecord != 0L) {
            this.close();
            throw new IOException("someone forgot to close MicrophoneInputStream");
        }
    }

    private static native long AudioRecordNew(int var0, int var1);

    private static native int AudioRecordStart(long var0);

    private static native int AudioRecordRead(long var0, byte[] var2, int var3, int var4) throws IOException;

    private static native void AudioRecordStop(long var0) throws IOException;

    private static native void AudioRecordDelete(long var0) throws IOException;

    static {
        System.loadLibrary("srec_jni");
    }
}

