/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.test.ActivityInstrumentationTestCase;
import android.test.ActivityTestCase;
import android.test.mock.MockApplication;
import android.view.Window;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityUnitTestCase<T extends Activity>
extends ActivityTestCase {
    private Class<T> mActivityClass;
    private Context mActivityContext;
    private Application mApplication;
    private MockParent mMockParent;
    private boolean mAttached = false;
    private boolean mCreated = false;

    public ActivityUnitTestCase(Class<T> activityClass) {
        this.mActivityClass = activityClass;
    }

    public T getActivity() {
        return (T)super.getActivity();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mActivityContext = this.getInstrumentation().getTargetContext();
    }

    protected T startActivity(Intent intent, Bundle savedInstanceState, Object lastNonConfigurationInstance) {
        T result;
        ActivityUnitTestCase.assertFalse("Activity already created", this.mCreated);
        if (!this.mAttached) {
            ActivityUnitTestCase.assertNotNull(this.mActivityClass);
            this.setActivity(null);
            Activity newActivity = null;
            try {
                IBinder token = null;
                if (this.mApplication == null) {
                    this.setApplication(new MockApplication());
                }
                ComponentName cn = new ComponentName(this.mActivityClass.getPackage().getName(), this.mActivityClass.getName());
                intent.setComponent(cn);
                ActivityInfo info = new ActivityInfo();
                String title = this.mActivityClass.getName();
                this.mMockParent = new MockParent();
                String id2 = null;
                newActivity = this.getInstrumentation().newActivity(this.mActivityClass, this.mActivityContext, token, this.mApplication, intent, info, title, this.mMockParent, id2, lastNonConfigurationInstance);
            }
            catch (Exception e) {
                ActivityUnitTestCase.assertNotNull(newActivity);
            }
            ActivityUnitTestCase.assertNotNull(newActivity);
            this.setActivity(newActivity);
            this.mAttached = true;
        }
        if ((result = this.getActivity()) != null) {
            this.getInstrumentation().callActivityOnCreate((Activity)this.getActivity(), savedInstanceState);
            this.mCreated = true;
        }
        return result;
    }

    @Override
    protected void tearDown() throws Exception {
        this.setActivity(null);
        this.scrubClass(ActivityInstrumentationTestCase.class);
        super.tearDown();
    }

    public void setApplication(Application application) {
        this.mApplication = application;
    }

    public void setActivityContext(Context activityContext) {
        this.mActivityContext = activityContext;
    }

    public int getRequestedOrientation() {
        if (this.mMockParent != null) {
            return this.mMockParent.mRequestedOrientation;
        }
        return 0;
    }

    public Intent getStartedActivityIntent() {
        if (this.mMockParent != null) {
            return this.mMockParent.mStartedActivityIntent;
        }
        return null;
    }

    public int getStartedActivityRequest() {
        if (this.mMockParent != null) {
            return this.mMockParent.mStartedActivityRequest;
        }
        return 0;
    }

    public boolean isFinishCalled() {
        if (this.mMockParent != null) {
            return this.mMockParent.mFinished;
        }
        return false;
    }

    public int getFinishedActivityRequest() {
        if (this.mMockParent != null) {
            return this.mMockParent.mFinishedActivityRequest;
        }
        return 0;
    }

    private static class MockParent
    extends Activity {
        public int mRequestedOrientation = 0;
        public Intent mStartedActivityIntent = null;
        public int mStartedActivityRequest = -1;
        public boolean mFinished = false;
        public int mFinishedActivityRequest = -1;

        private MockParent() {
        }

        public void setRequestedOrientation(int requestedOrientation) {
            this.mRequestedOrientation = requestedOrientation;
        }

        public int getRequestedOrientation() {
            return this.mRequestedOrientation;
        }

        public Window getWindow() {
            return null;
        }

        public void startActivityFromChild(Activity child, Intent intent, int requestCode) {
            this.mStartedActivityIntent = intent;
            this.mStartedActivityRequest = requestCode;
        }

        public void finishFromChild(Activity child) {
            this.mFinished = true;
        }

        public void finishActivityFromChild(Activity child, int requestCode) {
            this.mFinished = true;
            this.mFinishedActivityRequest = requestCode;
        }
    }
}

