/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.app.Instrumentation;
import android.content.Context;
import android.os.PerformanceCollector;
import android.test.AndroidTestCase;
import android.test.InstrumentationTestCase;
import android.test.NoExecTestResult;
import android.test.PerformanceCollectorTestCase;
import android.test.TestCaseUtil;
import android.test.TestSuiteProvider;
import com.google.android.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidTestRunner
extends BaseTestRunner {
    private TestResult mTestResult;
    private String mTestClassName;
    private List<TestCase> mTestCases;
    private Context mContext;
    private boolean mSkipExecution = false;
    private List<TestListener> mTestListeners = Lists.newArrayList();
    private Instrumentation mInstrumentation;
    private PerformanceCollector.PerformanceResultsWriter mPerfWriter;

    public void setTestClassName(String testClassName, String testMethodName) {
        Class<? extends Test> testClass = this.loadTestClass(testClassName);
        if (this.shouldRunSingleTestMethod(testMethodName, testClass)) {
            TestCase testCase = this.buildSingleTestMethod(testClass, testMethodName);
            this.mTestCases = Lists.newArrayList(testCase);
            this.mTestClassName = testClass.getSimpleName();
        } else {
            this.setTest(this.getTest(testClass), testClass);
        }
    }

    public void setTest(Test test) {
        this.setTest(test, test.getClass());
    }

    private void setTest(Test test, Class<? extends Test> testClass) {
        this.mTestCases = TestCaseUtil.getTests(test, true);
        this.mTestClassName = TestSuite.class.isAssignableFrom(testClass) ? TestCaseUtil.getTestName(test) : testClass.getSimpleName();
    }

    public void clearTestListeners() {
        this.mTestListeners.clear();
    }

    public void addTestListener(TestListener testListener) {
        if (testListener != null) {
            this.mTestListeners.add(testListener);
        }
    }

    private Class<? extends Test> loadTestClass(String testClassName) {
        try {
            return this.mContext.getClassLoader().loadClass(testClassName);
        }
        catch (ClassNotFoundException e) {
            this.runFailed("Could not find test class. Class: " + testClassName);
            return null;
        }
    }

    private TestCase buildSingleTestMethod(Class testClass, String testMethodName) {
        try {
            Constructor c = testClass.getConstructor(new Class[0]);
            return this.newSingleTestMethod(testClass, testMethodName, c, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor c = testClass.getConstructor(String.class);
                return this.newSingleTestMethod(testClass, testMethodName, c, testMethodName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }

    private TestCase newSingleTestMethod(Class testClass, String testMethodName, Constructor constructor, Object ... args) {
        try {
            TestCase testCase = (TestCase)constructor.newInstance(args);
            testCase.setName(testMethodName);
            return testCase;
        }
        catch (IllegalAccessException e) {
            this.runFailed("Could not access test class. Class: " + testClass.getName());
        }
        catch (InstantiationException e) {
            this.runFailed("Could not instantiate test class. Class: " + testClass.getName());
        }
        catch (IllegalArgumentException e) {
            this.runFailed("Illegal argument passed to constructor. Class: " + testClass.getName());
        }
        catch (InvocationTargetException e) {
            this.runFailed("Constructor thew an exception. Class: " + testClass.getName());
        }
        return null;
    }

    private boolean shouldRunSingleTestMethod(String testMethodName, Class<? extends Test> testClass) {
        return testMethodName != null && TestCase.class.isAssignableFrom(testClass);
    }

    private Test getTest(Class clazz) {
        if (TestSuiteProvider.class.isAssignableFrom(clazz)) {
            try {
                TestSuiteProvider testSuiteProvider = (TestSuiteProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                return testSuiteProvider.getTestSuite();
            }
            catch (InstantiationException e) {
                this.runFailed("Could not instantiate test suite provider. Class: " + clazz.getName());
            }
            catch (IllegalAccessException e) {
                this.runFailed("Illegal access of test suite provider. Class: " + clazz.getName());
            }
            catch (InvocationTargetException e) {
                this.runFailed("Invocation exception test suite provider. Class: " + clazz.getName());
            }
            catch (NoSuchMethodException e) {
                this.runFailed("No such method on test suite provider. Class: " + clazz.getName());
            }
        }
        return this.getTest(clazz.getName());
    }

    protected TestResult createTestResult() {
        if (this.mSkipExecution) {
            return new NoExecTestResult();
        }
        return new TestResult();
    }

    void setSkipExecution(boolean skip) {
        this.mSkipExecution = skip;
    }

    public List<TestCase> getTestCases() {
        return this.mTestCases;
    }

    public String getTestClassName() {
        return this.mTestClassName;
    }

    public TestResult getTestResult() {
        return this.mTestResult;
    }

    public void runTest() {
        this.runTest(this.createTestResult());
    }

    public void runTest(TestResult testResult) {
        this.mTestResult = testResult;
        for (TestListener testListener : this.mTestListeners) {
            this.mTestResult.addListener(testListener);
        }
        Context testContext = this.mInstrumentation == null ? this.mContext : this.mInstrumentation.getContext();
        for (TestCase testCase : this.mTestCases) {
            this.setContextIfAndroidTestCase(testCase, this.mContext, testContext);
            this.setInstrumentationIfInstrumentationTestCase(testCase, this.mInstrumentation);
            this.setPerformanceWriterIfPerformanceCollectorTestCase(testCase, this.mPerfWriter);
            testCase.run(this.mTestResult);
        }
    }

    private void setContextIfAndroidTestCase(Test test, Context context, Context testContext) {
        if (AndroidTestCase.class.isAssignableFrom(test.getClass())) {
            ((AndroidTestCase)test).setContext(context);
            ((AndroidTestCase)test).setTestContext(testContext);
        }
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    private void setInstrumentationIfInstrumentationTestCase(Test test, Instrumentation instrumentation) {
        if (InstrumentationTestCase.class.isAssignableFrom(test.getClass())) {
            ((InstrumentationTestCase)test).injectInstrumentation(instrumentation);
        }
    }

    private void setPerformanceWriterIfPerformanceCollectorTestCase(Test test, PerformanceCollector.PerformanceResultsWriter writer) {
        if (PerformanceCollectorTestCase.class.isAssignableFrom(test.getClass())) {
            ((PerformanceCollectorTestCase)((Object)test)).setPerformanceResultsWriter(writer);
        }
    }

    public void setInstrumentation(Instrumentation instrumentation) {
        this.mInstrumentation = instrumentation;
    }

    @Deprecated
    public void setInstrumentaiton(Instrumentation instrumentation) {
        this.setInstrumentation(instrumentation);
    }

    public void setPerformanceResultsWriter(PerformanceCollector.PerformanceResultsWriter writer) {
        this.mPerfWriter = writer;
    }

    protected Class loadSuiteClass(String suiteClassName) throws ClassNotFoundException {
        return this.mContext.getClassLoader().loadClass(suiteClassName);
    }

    @Override
    public void testStarted(String testName) {
    }

    @Override
    public void testEnded(String testName) {
    }

    @Override
    public void testFailed(int status, Test test, Throwable t) {
    }

    @Override
    protected void runFailed(String message) {
        throw new RuntimeException(message);
    }
}

