/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.app.Application;
import android.app.Instrumentation;
import android.content.Context;
import android.test.AndroidTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationTestCase<T extends Application>
extends AndroidTestCase {
    Class<T> mApplicationClass;
    private Context mSystemContext;
    private T mApplication;
    private boolean mAttached = false;
    private boolean mCreated = false;

    public ApplicationTestCase(Class<T> applicationClass) {
        this.mApplicationClass = applicationClass;
    }

    public T getApplication() {
        return this.mApplication;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mSystemContext = this.getContext();
    }

    private void setupApplication() {
        this.mApplication = null;
        try {
            this.mApplication = Instrumentation.newApplication(this.mApplicationClass, this.getContext());
        }
        catch (Exception e) {
            ApplicationTestCase.assertNotNull(this.mApplication);
        }
        this.mAttached = true;
    }

    protected final void createApplication() {
        ApplicationTestCase.assertFalse(this.mCreated);
        if (!this.mAttached) {
            this.setupApplication();
        }
        ApplicationTestCase.assertNotNull(this.mApplication);
        ((Application)this.mApplication).onCreate();
        this.mCreated = true;
    }

    protected final void terminateApplication() {
        if (this.mCreated) {
            ((Application)this.mApplication).onTerminate();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.terminateApplication();
        this.mApplication = null;
        this.scrubClass(ApplicationTestCase.class);
        super.tearDown();
    }

    public Context getSystemContext() {
        return this.mSystemContext;
    }

    public final void testApplicationTestCaseSetUpProperly() throws Exception {
        this.setupApplication();
        ApplicationTestCase.assertNotNull("Application class could not be instantiated successfully", this.mApplication);
    }
}

