/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.os.Bundle;
import android.test.AndroidTestRunner;
import android.test.InstrumentationTestRunner;
import android.test.suitebuilder.TestMethod;
import android.test.suitebuilder.annotation.HasAnnotation;
import android.util.Log;
import com.android.internal.util.Predicate;
import com.android.internal.util.Predicates;
import dalvik.annotation.BrokenTest;
import dalvik.annotation.SideEffect;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationCoreTestRunner
extends InstrumentationTestRunner {
    private static final String TAG = "InstrumentationCoreTestRunner";
    private boolean singleTest = false;

    @Override
    public void onCreate(Bundle arguments) {
        File cacheDir = this.getTargetContext().getCacheDir();
        System.setProperty("user.language", "en");
        System.setProperty("user.region", "US");
        System.setProperty("java.home", cacheDir.getAbsolutePath());
        System.setProperty("user.home", cacheDir.getAbsolutePath());
        System.setProperty("java.io.tmpdir", cacheDir.getAbsolutePath());
        if (arguments != null) {
            String classArg = arguments.getString("class");
            this.singleTest = classArg != null && classArg.contains("#");
        }
        super.onCreate(arguments);
    }

    @Override
    protected AndroidTestRunner getAndroidTestRunner() {
        AndroidTestRunner runner = super.getAndroidTestRunner();
        runner.addTestListener(new TestListener(){
            private Class<?> lastClass;
            private static final int MINIMUM_TIME = 100;
            private long startTime;

            @Override
            public void startTest(Test test) {
                if (test.getClass() != this.lastClass) {
                    this.lastClass = test.getClass();
                    this.printMemory(test.getClass());
                }
                Thread.currentThread().setContextClassLoader(test.getClass().getClassLoader());
                this.startTime = System.currentTimeMillis();
            }

            @Override
            public void endTest(Test test) {
                if (test instanceof TestCase) {
                    this.cleanup((TestCase)test);
                    long timeTaken = System.currentTimeMillis() - this.startTime;
                    if (timeTaken < 100L) {
                        try {
                            Thread.sleep(100L - timeTaken);
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                }
            }

            @Override
            public void addError(Test test, Throwable t) {
            }

            @Override
            public void addFailure(Test test, AssertionFailedError t) {
            }

            private void printMemory(Class<? extends Test> testClass) {
                Runtime runtime = Runtime.getRuntime();
                long total = runtime.totalMemory();
                long free = runtime.freeMemory();
                long used = total - free;
                Log.d(InstrumentationCoreTestRunner.TAG, "Total memory  : " + total);
                Log.d(InstrumentationCoreTestRunner.TAG, "Used memory   : " + used);
                Log.d(InstrumentationCoreTestRunner.TAG, "Free memory   : " + free);
                Log.d(InstrumentationCoreTestRunner.TAG, "Now executing : " + testClass.getName());
            }

            private void cleanup(TestCase test) {
                for (Class<?> clazz = test.getClass(); clazz != TestCase.class; clazz = clazz.getSuperclass()) {
                    Field[] fields = clazz.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        Field f = fields[i];
                        if (f.getType().isPrimitive() || Modifier.isStatic(f.getModifiers())) continue;
                        try {
                            f.setAccessible(true);
                            f.set(test, null);
                            continue;
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        return runner;
    }

    @Override
    List<Predicate<TestMethod>> getBuilderRequirements() {
        List<Predicate<TestMethod>> builderRequirements = super.getBuilderRequirements();
        Predicate<TestMethod> brokenTestPredicate = Predicates.not(new HasAnnotation(BrokenTest.class));
        builderRequirements.add(brokenTestPredicate);
        if (!this.singleTest) {
            Predicate<TestMethod> sideEffectPredicate = Predicates.not(new HasAnnotation(SideEffect.class));
            builderRequirements.add(sideEffectPredicate);
        }
        return builderRequirements;
    }
}

