/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.app.Instrumentation;
import android.os.Bundle;
import android.os.Debug;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PerformanceCollector;
import android.test.AndroidTestRunner;
import android.test.ClassPathPackageInfoSource;
import android.test.InstrumentationTestCase;
import android.test.RepetitiveTest;
import android.test.TestPrinter;
import android.test.TestSuiteProvider;
import android.test.TimedTest;
import android.test.suitebuilder.TestMethod;
import android.test.suitebuilder.TestPredicates;
import android.test.suitebuilder.TestSuiteBuilder;
import android.test.suitebuilder.annotation.HasAnnotation;
import android.util.Log;
import com.android.internal.util.Predicate;
import com.android.internal.util.Predicates;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.textui.ResultPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationTestRunner
extends Instrumentation
implements TestSuiteProvider {
    public static final String ARGUMENT_TEST_CLASS = "class";
    public static final String ARGUMENT_TEST_PACKAGE = "package";
    public static final String ARGUMENT_TEST_SIZE_PREDICATE = "size";
    public static final String ARGUMENT_DELAY_MSEC = "delay_msec";
    private static final String SMALL_SUITE = "small";
    private static final String MEDIUM_SUITE = "medium";
    private static final String LARGE_SUITE = "large";
    private static final String ARGUMENT_LOG_ONLY = "log";
    static final String ARGUMENT_ANNOTATION = "annotation";
    static final String ARGUMENT_NOT_ANNOTATION = "notAnnotation";
    private static final float SMALL_SUITE_MAX_RUNTIME = 100.0f;
    private static final float MEDIUM_SUITE_MAX_RUNTIME = 1000.0f;
    public static final String REPORT_VALUE_ID = "InstrumentationTestRunner";
    public static final String REPORT_KEY_NUM_TOTAL = "numtests";
    public static final String REPORT_KEY_NUM_CURRENT = "current";
    public static final String REPORT_KEY_NAME_CLASS = "class";
    public static final String REPORT_KEY_NAME_TEST = "test";
    private static final String REPORT_KEY_RUN_TIME = "runtime";
    private static final String REPORT_KEY_NUM_ITERATIONS = "numiterations";
    private static final String REPORT_KEY_SUITE_ASSIGNMENT = "suiteassignment";
    private static final String REPORT_KEY_COVERAGE_PATH = "coverageFilePath";
    public static final int REPORT_VALUE_RESULT_START = 1;
    public static final int REPORT_VALUE_RESULT_OK = 0;
    public static final int REPORT_VALUE_RESULT_ERROR = -1;
    public static final int REPORT_VALUE_RESULT_FAILURE = -2;
    public static final String REPORT_KEY_STACK = "stack";
    private static final String DEFAULT_COVERAGE_FILE_NAME = "coverage.ec";
    private static final String LOG_TAG = "InstrumentationTestRunner";
    private final Bundle mResults = new Bundle();
    private Bundle mArguments;
    private AndroidTestRunner mTestRunner;
    private boolean mDebug;
    private boolean mJustCount;
    private boolean mSuiteAssignmentMode;
    private int mTestCount;
    private String mPackageOfTests;
    private boolean mCoverage;
    private String mCoverageFilePath;
    private int mDelayMsec;

    @Override
    public void onCreate(Bundle arguments) {
        super.onCreate(arguments);
        this.mArguments = arguments;
        String[] apkPaths = new String[]{this.getTargetContext().getPackageCodePath(), this.getContext().getPackageCodePath()};
        ClassPathPackageInfoSource.setApkPaths(apkPaths);
        Predicate<TestMethod> testSizePredicate = null;
        Predicate<TestMethod> testAnnotationPredicate = null;
        Predicate<TestMethod> testNotAnnotationPredicate = null;
        String testClassesArg = null;
        boolean logOnly = false;
        if (arguments != null) {
            testClassesArg = arguments.getString("class");
            this.mDebug = this.getBooleanArgument(arguments, "debug");
            this.mJustCount = this.getBooleanArgument(arguments, "count");
            this.mSuiteAssignmentMode = this.getBooleanArgument(arguments, "suiteAssignment");
            this.mPackageOfTests = arguments.getString(ARGUMENT_TEST_PACKAGE);
            testSizePredicate = this.getSizePredicateFromArg(arguments.getString(ARGUMENT_TEST_SIZE_PREDICATE));
            testAnnotationPredicate = this.getAnnotationPredicate(arguments.getString(ARGUMENT_ANNOTATION));
            testNotAnnotationPredicate = this.getNotAnnotationPredicate(arguments.getString(ARGUMENT_NOT_ANNOTATION));
            logOnly = this.getBooleanArgument(arguments, ARGUMENT_LOG_ONLY);
            this.mCoverage = this.getBooleanArgument(arguments, "coverage");
            this.mCoverageFilePath = arguments.getString("coverageFile");
            try {
                Object delay = arguments.get(ARGUMENT_DELAY_MSEC);
                if (delay != null) {
                    this.mDelayMsec = Integer.parseInt(delay.toString());
                }
            }
            catch (NumberFormatException e) {
                Log.e("InstrumentationTestRunner", "Invalid delay_msec parameter", e);
            }
        }
        TestSuiteBuilder testSuiteBuilder = new TestSuiteBuilder(this.getClass().getName(), this.getTargetContext().getClassLoader());
        if (testSizePredicate != null) {
            testSuiteBuilder.addRequirements(testSizePredicate);
        }
        if (testAnnotationPredicate != null) {
            testSuiteBuilder.addRequirements(testAnnotationPredicate);
        }
        if (testNotAnnotationPredicate != null) {
            testSuiteBuilder.addRequirements(testNotAnnotationPredicate);
        }
        if (testClassesArg == null) {
            if (this.mPackageOfTests != null) {
                testSuiteBuilder.includePackages(this.mPackageOfTests);
            } else {
                TestSuite testSuite = this.getTestSuite();
                if (testSuite != null) {
                    testSuiteBuilder.addTestSuite(testSuite);
                } else {
                    testSuiteBuilder.includePackages("");
                }
            }
        } else {
            this.parseTestClasses(testClassesArg, testSuiteBuilder);
        }
        testSuiteBuilder.addRequirements(this.getBuilderRequirements());
        this.mTestRunner = this.getAndroidTestRunner();
        this.mTestRunner.setContext(this.getTargetContext());
        this.mTestRunner.setInstrumentation(this);
        this.mTestRunner.setSkipExecution(logOnly);
        this.mTestRunner.setTest(testSuiteBuilder.build());
        this.mTestCount = this.mTestRunner.getTestCases().size();
        if (this.mSuiteAssignmentMode) {
            this.mTestRunner.addTestListener(new SuiteAssignmentPrinter());
        } else {
            WatcherResultPrinter resultPrinter = new WatcherResultPrinter(this.mTestCount);
            this.mTestRunner.addTestListener(new TestPrinter("TestRunner", false));
            this.mTestRunner.addTestListener(resultPrinter);
            this.mTestRunner.setPerformanceResultsWriter(resultPrinter);
        }
        this.start();
    }

    public Bundle getArguments() {
        return this.mArguments;
    }

    protected void addTestListener(TestListener listener) {
        if (this.mTestRunner != null && listener != null) {
            this.mTestRunner.addTestListener(listener);
        }
    }

    List<Predicate<TestMethod>> getBuilderRequirements() {
        return new ArrayList<Predicate<TestMethod>>();
    }

    private void parseTestClasses(String testClassArg, TestSuiteBuilder testSuiteBuilder) {
        String[] testClasses;
        for (String testClass : testClasses = testClassArg.split(",")) {
            this.parseTestClass(testClass, testSuiteBuilder);
        }
    }

    private void parseTestClass(String testClassName, TestSuiteBuilder testSuiteBuilder) {
        int methodSeparatorIndex = testClassName.indexOf(35);
        String testMethodName = null;
        if (methodSeparatorIndex > 0) {
            testMethodName = testClassName.substring(methodSeparatorIndex + 1);
            testClassName = testClassName.substring(0, methodSeparatorIndex);
        }
        testSuiteBuilder.addTestClassByName(testClassName, testMethodName, this.getTargetContext());
    }

    protected AndroidTestRunner getAndroidTestRunner() {
        return new AndroidTestRunner();
    }

    private boolean getBooleanArgument(Bundle arguments, String tag) {
        String tagString = arguments.getString(tag);
        return tagString != null && Boolean.parseBoolean(tagString);
    }

    private Predicate<TestMethod> getSizePredicateFromArg(String sizeArg) {
        if (SMALL_SUITE.equals(sizeArg)) {
            return TestPredicates.SELECT_SMALL;
        }
        if (MEDIUM_SUITE.equals(sizeArg)) {
            return TestPredicates.SELECT_MEDIUM;
        }
        if (LARGE_SUITE.equals(sizeArg)) {
            return TestPredicates.SELECT_LARGE;
        }
        return null;
    }

    private Predicate<TestMethod> getAnnotationPredicate(String annotationClassName) {
        Class<? extends Annotation> annotationClass = this.getAnnotationClass(annotationClassName);
        if (annotationClass != null) {
            return new HasAnnotation(annotationClass);
        }
        return null;
    }

    private Predicate<TestMethod> getNotAnnotationPredicate(String annotationClassName) {
        Class<? extends Annotation> annotationClass = this.getAnnotationClass(annotationClassName);
        if (annotationClass != null) {
            return Predicates.not(new HasAnnotation(annotationClass));
        }
        return null;
    }

    private Class<? extends Annotation> getAnnotationClass(String annotationClassName) {
        if (annotationClassName == null) {
            return null;
        }
        try {
            Class<?> annotationClass = Class.forName(annotationClassName);
            if (annotationClass.isAnnotation()) {
                return annotationClass;
            }
            Log.e("InstrumentationTestRunner", String.format("Provided annotation value %s is not an Annotation", annotationClassName));
        }
        catch (ClassNotFoundException e) {
            Log.e("InstrumentationTestRunner", String.format("Could not find class for specified annotation %s", annotationClassName));
        }
        return null;
    }

    void prepareLooper() {
        Looper.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onStart() {
        this.prepareLooper();
        if (this.mJustCount) {
            this.mResults.putString("id", "InstrumentationTestRunner");
            this.mResults.putInt(REPORT_KEY_NUM_TOTAL, this.mTestCount);
            this.finish(-1, this.mResults);
            return;
        }
        if (this.mDebug) {
            Debug.waitForDebugger();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(byteArrayOutputStream);
        try {
            StringResultPrinter resultPrinter = new StringResultPrinter(writer);
            this.mTestRunner.addTestListener(resultPrinter);
            long startTime = System.currentTimeMillis();
            this.mTestRunner.runTest();
            long runTime = System.currentTimeMillis() - startTime;
            resultPrinter.printResult(this.mTestRunner.getTestResult(), runTime);
        }
        catch (Throwable t) {
            try {
                writer.println(String.format("Test run aborted due to unexpected exception: %s", t.getMessage()));
                t.printStackTrace(writer);
            }
            catch (Throwable throwable) {
                this.mResults.putString("stream", String.format("\nTest results for %s=%s", this.mTestRunner.getTestClassName(), byteArrayOutputStream.toString()));
                if (this.mCoverage) {
                    this.generateCoverageReport();
                }
                writer.close();
                this.finish(-1, this.mResults);
                throw throwable;
            }
            this.mResults.putString("stream", String.format("\nTest results for %s=%s", this.mTestRunner.getTestClassName(), byteArrayOutputStream.toString()));
            if (this.mCoverage) {
                this.generateCoverageReport();
            }
            writer.close();
            this.finish(-1, this.mResults);
            return;
        }
        this.mResults.putString("stream", String.format("\nTest results for %s=%s", this.mTestRunner.getTestClassName(), byteArrayOutputStream.toString()));
        if (this.mCoverage) {
            this.generateCoverageReport();
        }
        writer.close();
        this.finish(-1, this.mResults);
        return;
    }

    @Override
    public TestSuite getTestSuite() {
        return this.getAllTests();
    }

    public TestSuite getAllTests() {
        return null;
    }

    public ClassLoader getLoader() {
        return null;
    }

    private void generateCoverageReport() {
        String coverageFilePath = this.getCoverageFilePath();
        File coverageFile = new File(coverageFilePath);
        try {
            Class<?> emmaRTClass = Class.forName("com.vladium.emma.rt.RT");
            Method dumpCoverageMethod = emmaRTClass.getMethod("dumpCoverageData", coverageFile.getClass(), Boolean.TYPE, Boolean.TYPE);
            dumpCoverageMethod.invoke(null, coverageFile, false, false);
            this.mResults.putString(REPORT_KEY_COVERAGE_PATH, coverageFilePath);
            String currentStream = this.mResults.getString("stream");
            this.mResults.putString("stream", String.format("%s\nGenerated code coverage data to %s", currentStream, coverageFilePath));
        }
        catch (ClassNotFoundException e) {
            this.reportEmmaError("Is emma jar on classpath?", e);
        }
        catch (SecurityException e) {
            this.reportEmmaError(e);
        }
        catch (NoSuchMethodException e) {
            this.reportEmmaError(e);
        }
        catch (IllegalArgumentException e) {
            this.reportEmmaError(e);
        }
        catch (IllegalAccessException e) {
            this.reportEmmaError(e);
        }
        catch (InvocationTargetException e) {
            this.reportEmmaError(e);
        }
    }

    private String getCoverageFilePath() {
        if (this.mCoverageFilePath == null) {
            return this.getTargetContext().getFilesDir().getAbsolutePath() + File.separator + DEFAULT_COVERAGE_FILE_NAME;
        }
        return this.mCoverageFilePath;
    }

    private void reportEmmaError(Exception e) {
        this.reportEmmaError("", e);
    }

    private void reportEmmaError(String hint, Exception e) {
        String msg = "Failed to generate emma coverage. " + hint;
        Log.e("InstrumentationTestRunner", msg, e);
        this.mResults.putString("stream", "\nError: " + msg);
    }

    private class WatcherResultPrinter
    implements TestListener,
    PerformanceCollector.PerformanceResultsWriter {
        private final Bundle mResultTemplate;
        Bundle mTestResult;
        int mTestNum = 0;
        int mTestResultCode = 0;
        String mTestClass = null;
        PerformanceCollector mPerfCollector = new PerformanceCollector();
        boolean mIsTimedTest = false;
        boolean mIncludeDetailedStats = false;

        public WatcherResultPrinter(int numTests) {
            this.mResultTemplate = new Bundle();
            this.mResultTemplate.putString("id", "InstrumentationTestRunner");
            this.mResultTemplate.putInt(InstrumentationTestRunner.REPORT_KEY_NUM_TOTAL, numTests);
        }

        public void startTest(Test test) {
            String testClass = test.getClass().getName();
            String testName = ((TestCase)test).getName();
            this.mTestResult = new Bundle(this.mResultTemplate);
            this.mTestResult.putString("class", testClass);
            this.mTestResult.putString(InstrumentationTestRunner.REPORT_KEY_NAME_TEST, testName);
            this.mTestResult.putInt(InstrumentationTestRunner.REPORT_KEY_NUM_CURRENT, ++this.mTestNum);
            if (testClass != null && !testClass.equals(this.mTestClass)) {
                this.mTestResult.putString("stream", String.format("\n%s:", testClass));
                this.mTestClass = testClass;
            } else {
                this.mTestResult.putString("stream", "");
            }
            Method testMethod = null;
            try {
                testMethod = test.getClass().getMethod(testName, new Class[0]);
                if (testMethod.isAnnotationPresent(RepetitiveTest.class)) {
                    int numIterations = testMethod.getAnnotation(RepetitiveTest.class).numIterations();
                    this.mTestResult.putInt(InstrumentationTestRunner.REPORT_KEY_NUM_ITERATIONS, numIterations);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                if (this.mTestNum == 1) {
                    Thread.sleep(InstrumentationTestRunner.this.mDelayMsec);
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            InstrumentationTestRunner.this.sendStatus(1, this.mTestResult);
            this.mTestResultCode = 0;
            this.mIsTimedTest = false;
            this.mIncludeDetailedStats = false;
            try {
                if (testMethod != null && testMethod.isAnnotationPresent(TimedTest.class)) {
                    this.mIsTimedTest = true;
                    this.mIncludeDetailedStats = testMethod.getAnnotation(TimedTest.class).includeDetailedStats();
                } else if (test.getClass().isAnnotationPresent(TimedTest.class)) {
                    this.mIsTimedTest = true;
                    this.mIncludeDetailedStats = test.getClass().getAnnotation(TimedTest.class).includeDetailedStats();
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (this.mIsTimedTest && this.mIncludeDetailedStats) {
                this.mPerfCollector.beginSnapshot("");
            } else if (this.mIsTimedTest) {
                this.mPerfCollector.startTiming("");
            }
        }

        public void addError(Test test, Throwable t) {
            this.mTestResult.putString(InstrumentationTestRunner.REPORT_KEY_STACK, BaseTestRunner.getFilteredTrace(t));
            this.mTestResultCode = -1;
            this.mTestResult.putString("stream", String.format("\nError in %s:\n%s", ((TestCase)test).getName(), BaseTestRunner.getFilteredTrace(t)));
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.mTestResult.putString(InstrumentationTestRunner.REPORT_KEY_STACK, BaseTestRunner.getFilteredTrace((Throwable)((Object)t)));
            this.mTestResultCode = -2;
            this.mTestResult.putString("stream", String.format("\nFailure in %s:\n%s", ((TestCase)test).getName(), BaseTestRunner.getFilteredTrace((Throwable)((Object)t))));
        }

        public void endTest(Test test) {
            if (this.mIsTimedTest && this.mIncludeDetailedStats) {
                this.mTestResult.putAll(this.mPerfCollector.endSnapshot());
            } else if (this.mIsTimedTest) {
                this.writeStopTiming(this.mPerfCollector.stopTiming(""));
            }
            if (this.mTestResultCode == 0) {
                this.mTestResult.putString("stream", ".");
            }
            InstrumentationTestRunner.this.sendStatus(this.mTestResultCode, this.mTestResult);
            try {
                Thread.sleep(InstrumentationTestRunner.this.mDelayMsec);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        public void writeBeginSnapshot(String label) {
        }

        public void writeEndSnapshot(Bundle results) {
            InstrumentationTestRunner.this.mResults.putAll(results);
        }

        public void writeStartTiming(String label) {
        }

        public void writeStopTiming(Bundle results) {
            int i = 0;
            for (Parcelable p : results.getParcelableArrayList("iterations")) {
                Bundle iteration = (Bundle)p;
                String index = "iteration" + i + ".";
                this.mTestResult.putString(index + "label", iteration.getString("label"));
                this.mTestResult.putLong(index + "cpu_time", iteration.getLong("cpu_time"));
                this.mTestResult.putLong(index + "execution_time", iteration.getLong("execution_time"));
                ++i;
            }
        }

        public void writeMeasurement(String label, long value) {
            this.mTestResult.putLong(label, value);
        }

        public void writeMeasurement(String label, float value) {
            this.mTestResult.putFloat(label, value);
        }

        public void writeMeasurement(String label, String value) {
            this.mTestResult.putString(label, value);
        }
    }

    private class SuiteAssignmentPrinter
    implements TestListener {
        private Bundle mTestResult;
        private long mStartTime;
        private long mEndTime;
        private boolean mTimingValid;

        public void startTest(Test test) {
            this.mTimingValid = true;
            this.mStartTime = System.currentTimeMillis();
        }

        public void addError(Test test, Throwable t) {
            this.mTimingValid = false;
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.mTimingValid = false;
        }

        public void endTest(Test test) {
            float runTime;
            String assignmentSuite;
            this.mEndTime = System.currentTimeMillis();
            this.mTestResult = new Bundle();
            if (!this.mTimingValid || this.mStartTime < 0L) {
                assignmentSuite = "NA";
                runTime = -1.0f;
            } else {
                runTime = this.mEndTime - this.mStartTime;
                assignmentSuite = runTime < 100.0f && !InstrumentationTestCase.class.isAssignableFrom(test.getClass()) ? InstrumentationTestRunner.SMALL_SUITE : (runTime < 1000.0f ? InstrumentationTestRunner.MEDIUM_SUITE : InstrumentationTestRunner.LARGE_SUITE);
            }
            this.mStartTime = -1L;
            this.mTestResult.putString("stream", test.getClass().getName() + "#" + ((TestCase)test).getName() + "\nin " + assignmentSuite + " suite\nrunTime: " + String.valueOf(runTime) + "\n");
            this.mTestResult.putFloat(InstrumentationTestRunner.REPORT_KEY_RUN_TIME, runTime);
            this.mTestResult.putString(InstrumentationTestRunner.REPORT_KEY_SUITE_ASSIGNMENT, assignmentSuite);
            InstrumentationTestRunner.this.sendStatus(0, this.mTestResult);
        }
    }

    private class StringResultPrinter
    extends ResultPrinter {
        public StringResultPrinter(PrintStream writer) {
            super(writer);
        }

        public synchronized void printResult(TestResult result, long runTime) {
            this.printHeader(runTime);
            this.printFooter(result);
        }
    }
}

