/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.content.Loader;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.test.AndroidTestCase;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoaderTestCase
extends AndroidTestCase {
    public <T> T getLoaderResultSynchronously(final Loader<T> loader) {
        Object result;
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        final Loader.OnLoadCompleteListener listener = new Loader.OnLoadCompleteListener<T>(){

            @Override
            public void onLoadComplete(Loader<T> completedLoader, T data) {
                completedLoader.unregisterListener(this);
                completedLoader.stopLoading();
                completedLoader.reset();
                queue.add(data);
            }
        };
        Handler mainThreadHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                loader.registerListener(0, listener);
                loader.startLoading();
            }
        };
        mainThreadHandler.sendEmptyMessage(0);
        try {
            result = queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("waiting thread interrupted", e);
        }
        return (T)result;
    }

    static {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... args) {
                return null;
            }

            @Override
            protected void onPostExecute(Void result) {
            }
        };
    }
}

