/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.database.DatabaseUtils;
import android.test.AndroidTestCase;
import android.test.IsolatedContext;
import android.test.RenamingDelegatingContext;
import android.test.mock.MockContentResolver;
import android.test.mock.MockContext;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProviderTestCase2<T extends ContentProvider>
extends AndroidTestCase {
    Class<T> mProviderClass;
    String mProviderAuthority;
    private IsolatedContext mProviderContext;
    private MockContentResolver mResolver;
    private T mProvider;

    public ProviderTestCase2(Class<T> providerClass, String providerAuthority) {
        this.mProviderClass = providerClass;
        this.mProviderAuthority = providerAuthority;
    }

    public T getProvider() {
        return this.mProvider;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mResolver = new MockContentResolver();
        String filenamePrefix = "test.";
        RenamingDelegatingContext targetContextWrapper = new RenamingDelegatingContext(new MockContext2(), this.getContext(), "test.");
        this.mProviderContext = new IsolatedContext(this.mResolver, targetContextWrapper);
        this.mProvider = (ContentProvider)this.mProviderClass.newInstance();
        ((ContentProvider)this.mProvider).attachInfoForTesting(this.mProviderContext, null);
        ProviderTestCase2.assertNotNull(this.mProvider);
        this.mResolver.addProvider(this.mProviderAuthority, (ContentProvider)this.getProvider());
    }

    @Override
    protected void tearDown() throws Exception {
        ((ContentProvider)this.mProvider).shutdown();
        super.tearDown();
    }

    public MockContentResolver getMockContentResolver() {
        return this.mResolver;
    }

    public IsolatedContext getMockContext() {
        return this.mProviderContext;
    }

    public static <T extends ContentProvider> ContentResolver newResolverWithContentProviderFromSql(Context targetContext, String filenamePrefix, Class<T> providerClass, String authority, String databaseName, int databaseVersion, String sql) throws IllegalAccessException, InstantiationException {
        MockContentResolver resolver = new MockContentResolver();
        RenamingDelegatingContext targetContextWrapper = new RenamingDelegatingContext(new MockContext(), targetContext, filenamePrefix);
        IsolatedContext context = new IsolatedContext(resolver, targetContextWrapper);
        DatabaseUtils.createDbFromSqlStatements(context, databaseName, databaseVersion, sql);
        ContentProvider provider = (ContentProvider)providerClass.newInstance();
        provider.attachInfoForTesting(context, null);
        resolver.addProvider(authority, provider);
        return resolver;
    }

    private class MockContext2
    extends MockContext {
        private MockContext2() {
        }

        public Resources getResources() {
            return ProviderTestCase2.this.getContext().getResources();
        }

        public File getDir(String name, int mode) {
            return ProviderTestCase2.this.getContext().getDir("mockcontext2_" + name, mode);
        }

        public Context getApplicationContext() {
            return this;
        }
    }
}

