/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.test.AndroidTestCase;
import android.test.mock.MockApplication;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceTestCase<T extends Service>
extends AndroidTestCase {
    Class<T> mServiceClass;
    private Context mSystemContext;
    private Application mApplication;
    private T mService;
    private boolean mServiceAttached = false;
    private boolean mServiceCreated = false;
    private boolean mServiceStarted = false;
    private boolean mServiceBound = false;
    private Intent mServiceIntent = null;
    private int mServiceId;

    public ServiceTestCase(Class<T> serviceClass) {
        this.mServiceClass = serviceClass;
    }

    public T getService() {
        return this.mService;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mSystemContext = this.getContext();
    }

    protected void setupService() {
        this.mService = null;
        try {
            this.mService = (Service)this.mServiceClass.newInstance();
        }
        catch (Exception e) {
            ServiceTestCase.assertNotNull(this.mService);
        }
        if (this.getApplication() == null) {
            this.setApplication(new MockApplication());
        }
        ((Service)this.mService).attach(this.getContext(), null, this.mServiceClass.getName(), null, this.getApplication(), null);
        ServiceTestCase.assertNotNull(this.mService);
        this.mServiceId = new Random().nextInt();
        this.mServiceAttached = true;
    }

    protected void startService(Intent intent) {
        if (!this.mServiceAttached) {
            this.setupService();
        }
        ServiceTestCase.assertNotNull(this.mService);
        if (!this.mServiceCreated) {
            ((Service)this.mService).onCreate();
            this.mServiceCreated = true;
        }
        ((Service)this.mService).onStartCommand(intent, 0, this.mServiceId);
        this.mServiceStarted = true;
    }

    protected IBinder bindService(Intent intent) {
        if (!this.mServiceAttached) {
            this.setupService();
        }
        ServiceTestCase.assertNotNull(this.mService);
        if (!this.mServiceCreated) {
            ((Service)this.mService).onCreate();
            this.mServiceCreated = true;
        }
        this.mServiceIntent = intent.cloneFilter();
        IBinder result = ((Service)this.mService).onBind(intent);
        this.mServiceBound = true;
        return result;
    }

    protected void shutdownService() {
        if (this.mServiceStarted) {
            ((Service)this.mService).stopSelf();
            this.mServiceStarted = false;
        } else if (this.mServiceBound) {
            ((Service)this.mService).onUnbind(this.mServiceIntent);
            this.mServiceBound = false;
        }
        if (this.mServiceCreated) {
            ((Service)this.mService).onDestroy();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.shutdownService();
        this.mService = null;
        this.scrubClass(ServiceTestCase.class);
        super.tearDown();
    }

    public void setApplication(Application application) {
        this.mApplication = application;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public Context getSystemContext() {
        return this.mSystemContext;
    }

    public void testServiceTestCaseSetUpProperly() throws Exception {
        this.setupService();
        ServiceTestCase.assertNotNull("service should be launched successfully", this.mService);
    }
}

