/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.test.InstrumentationTestCase;

public class SyncBaseInstrumentation
extends InstrumentationTestCase {
    private Context mTargetContext;
    ContentResolver mContentResolver;
    private static final int MAX_TIME_FOR_SYNC_IN_MINS = 20;

    protected void setUp() throws Exception {
        super.setUp();
        this.mTargetContext = this.getInstrumentation().getTargetContext();
        this.mContentResolver = this.mTargetContext.getContentResolver();
    }

    protected void syncProvider(Uri uri, String accountName, String authority) throws Exception {
        Bundle extras = new Bundle();
        extras.putBoolean("ignore_settings", true);
        Account account = new Account(accountName, "com.google");
        ContentResolver.requestSync(account, authority, extras);
        long startTimeInMillis = SystemClock.elapsedRealtime();
        long endTimeInMillis = startTimeInMillis + 1200000L;
        int counter = 0;
        while (counter < 2) {
            Thread.sleep(1000L);
            if (SystemClock.elapsedRealtime() > endTimeInMillis) break;
            if (ContentResolver.isSyncActive(account, authority)) {
                counter = 0;
                continue;
            }
            ++counter;
        }
    }

    protected void cancelSyncsandDisableAutoSync() {
        ContentResolver.setMasterSyncAutomatically(false);
        ContentResolver.cancelSync(null, null);
    }
}

