/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import com.google.android.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseUtil {
    private TestCaseUtil() {
    }

    public static List<String> getTestCaseNames(Test test, boolean flatten) {
        List<? extends Test> tests = TestCaseUtil.getTests(test, flatten);
        ArrayList<String> testCaseNames = Lists.newArrayList();
        for (Test test2 : tests) {
            testCaseNames.add(TestCaseUtil.getTestName(test2));
        }
        return testCaseNames;
    }

    public static List<? extends Test> getTests(Test test, boolean flatten) {
        return TestCaseUtil.getTests(test, flatten, new HashSet());
    }

    private static List<? extends Test> getTests(Test test, boolean flatten, Set<Class<?>> seen) {
        ArrayList<? extends Test> testCases = Lists.newArrayList();
        if (test != null) {
            Test workingTest = null;
            if (test instanceof TestCase && ((TestCase)test).getName() == null) {
                workingTest = TestCaseUtil.invokeSuiteMethodIfPossible(test.getClass(), seen);
            }
            if (workingTest == null) {
                workingTest = test;
            }
            if (workingTest instanceof TestSuite) {
                TestSuite testSuite = (TestSuite)workingTest;
                Enumeration<Test> enumeration = testSuite.tests();
                while (enumeration.hasMoreElements()) {
                    Test childTest = enumeration.nextElement();
                    if (flatten) {
                        testCases.addAll(TestCaseUtil.getTests(childTest, flatten, seen));
                        continue;
                    }
                    testCases.add(childTest);
                }
            } else {
                testCases.add(workingTest);
            }
        }
        return testCases;
    }

    private static Test invokeSuiteMethodIfPossible(Class testClass, Set<Class<?>> seen) {
        block5: {
            try {
                Method suiteMethod = testClass.getMethod("suite", new Class[0]);
                if (!Modifier.isStatic(suiteMethod.getModifiers()) || seen.contains(testClass)) break block5;
                seen.add(testClass);
                try {
                    return (Test)suiteMethod.invoke(null, null);
                }
                catch (InvocationTargetException e) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getTestName(Test test) {
        TestSuite testSuite;
        String name;
        if (test instanceof TestCase) {
            TestCase testCase = (TestCase)test;
            return testCase.getName();
        }
        if (test instanceof TestSuite && (name = (testSuite = (TestSuite)test).getName()) != null) {
            int index = name.lastIndexOf(".");
            if (index > -1) {
                return name.substring(index + 1);
            }
            return name;
        }
        return "";
    }

    public static Test getTestAtIndex(TestSuite testSuite, int position) {
        int index = 0;
        Enumeration<Test> enumeration = testSuite.tests();
        while (enumeration.hasMoreElements()) {
            Test test = enumeration.nextElement();
            if (index == position) {
                return test;
            }
            ++index;
        }
        return null;
    }

    public static TestSuite createTestSuite(Class<? extends Test> testClass) throws InstantiationException, IllegalAccessException {
        Test test = TestCaseUtil.invokeSuiteMethodIfPossible(testClass, new HashSet());
        if (test == null) {
            return new TestSuite((Class<?>)testClass);
        }
        if (TestCase.class.isAssignableFrom(test.getClass())) {
            TestSuite testSuite = new TestSuite(test.getClass().getName());
            testSuite.addTest(test);
            return testSuite;
        }
        return (TestSuite)test;
    }
}

