/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.test.TestRunner;
import android.util.Log;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPrinter
implements TestRunner.Listener,
TestListener {
    private String mTag;
    private boolean mOnlyFailures;
    private Set<String> mFailedTests = new HashSet<String>();

    public TestPrinter(String tag, boolean onlyFailures) {
        this.mTag = tag;
        this.mOnlyFailures = onlyFailures;
    }

    @Override
    public void started(String className) {
        if (!this.mOnlyFailures) {
            Log.i(this.mTag, "started: " + className);
        }
    }

    @Override
    public void finished(String className) {
        if (!this.mOnlyFailures) {
            Log.i(this.mTag, "finished: " + className);
        }
    }

    @Override
    public void performance(String className, long itemTimeNS, int iterations, List<TestRunner.IntermediateTime> intermediates) {
        Log.i(this.mTag, "perf: " + className + " = " + itemTimeNS + "ns/op (done " + iterations + " times)");
        if (intermediates != null && intermediates.size() > 0) {
            int N = intermediates.size();
            for (int i = 0; i < N; ++i) {
                TestRunner.IntermediateTime time = intermediates.get(i);
                Log.i(this.mTag, "  intermediate: " + time.name + " = " + time.timeInNS + "ns");
            }
        }
    }

    @Override
    public void passed(String className) {
        if (!this.mOnlyFailures) {
            Log.i(this.mTag, "passed: " + className);
        }
    }

    @Override
    public void failed(String className, Throwable exception) {
        Log.i(this.mTag, "failed: " + className);
        Log.i(this.mTag, "----- begin exception -----");
        Log.i(this.mTag, "", exception);
        Log.i(this.mTag, "----- end exception -----");
    }

    private void failed(Test test, Throwable t) {
        this.mFailedTests.add(test.toString());
        this.failed(test.toString(), t);
    }

    @Override
    public void addError(Test test, Throwable t) {
        this.failed(test, t);
    }

    @Override
    public void addFailure(Test test, AssertionFailedError t) {
        this.failed(test, (Throwable)((Object)t));
    }

    @Override
    public void endTest(Test test) {
        this.finished(test.toString());
        if (!this.mFailedTests.contains(test.toString())) {
            this.passed(test.toString());
        }
        this.mFailedTests.remove(test.toString());
    }

    @Override
    public void startTest(Test test) {
        this.started(test.toString());
    }
}

