/*
 * Decompiled with CFR 0.152.
 */
package android.test.mock;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.database.ContentObserver;
import android.net.Uri;
import com.google.android.collect.Maps;
import java.util.Map;

public class MockContentResolver
extends ContentResolver {
    Map<String, ContentProvider> mProviders = Maps.newHashMap();

    public MockContentResolver() {
        this(null);
    }

    public MockContentResolver(Context context) {
        super(context);
    }

    public void addProvider(String name, ContentProvider provider) {
        this.mProviders.put(name, provider);
    }

    protected IContentProvider acquireProvider(Context context, String name) {
        return this.acquireExistingProvider(context, name);
    }

    protected IContentProvider acquireExistingProvider(Context context, String name) {
        ContentProvider provider = this.mProviders.get(name);
        if (provider != null) {
            return provider.getIContentProvider();
        }
        return null;
    }

    public boolean releaseProvider(IContentProvider provider) {
        return true;
    }

    protected IContentProvider acquireUnstableProvider(Context c, String name) {
        return this.acquireProvider(c, name);
    }

    public boolean releaseUnstableProvider(IContentProvider icp) {
        return this.releaseProvider(icp);
    }

    public void unstableProviderDied(IContentProvider icp) {
    }

    public void notifyChange(Uri uri, ContentObserver observer, boolean syncToNetwork) {
    }
}

