/*
 * Decompiled with CFR 0.152.
 */
package android.test.suitebuilder;

import android.test.ClassPathPackageInfo;
import android.test.ClassPathPackageInfoSource;
import android.test.PackageInfoSources;
import android.test.suitebuilder.TestMethod;
import android.util.Log;
import com.android.internal.util.Predicate;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGrouping {
    private static final String LOG_TAG = "TestGrouping";
    SortedSet<Class<? extends TestCase>> testCaseClasses;
    public static final Comparator<Class<? extends TestCase>> SORT_BY_SIMPLE_NAME = new SortBySimpleName();
    public static final Comparator<Class<? extends TestCase>> SORT_BY_FULLY_QUALIFIED_NAME = new SortByFullyQualifiedName();
    protected String firstIncludedPackage = null;
    private ClassLoader classLoader;

    public TestGrouping(Comparator<Class<? extends TestCase>> comparator) {
        this.testCaseClasses = new TreeSet<Class<? extends TestCase>>(comparator);
    }

    public List<TestMethod> getTests() {
        ArrayList<TestMethod> testMethods = new ArrayList<TestMethod>();
        for (Class clazz : this.testCaseClasses) {
            for (Method testMethod : this.getTestMethods(clazz)) {
                testMethods.add(new TestMethod(testMethod, (Class<? extends TestCase>)clazz));
            }
        }
        return testMethods;
    }

    protected List<Method> getTestMethods(Class<? extends TestCase> testCaseClass) {
        List<Method> methods = Arrays.asList(testCaseClass.getMethods());
        return this.select(methods, new TestMethodPredicate());
    }

    SortedSet<Class<? extends TestCase>> getTestCaseClasses() {
        return this.testCaseClasses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestGrouping other = (TestGrouping)o;
        if (!this.testCaseClasses.equals(other.testCaseClasses)) {
            return false;
        }
        return ((Object)this.testCaseClasses.comparator()).equals(other.testCaseClasses.comparator());
    }

    public int hashCode() {
        return this.testCaseClasses.hashCode();
    }

    public TestGrouping addPackagesRecursive(String ... packageNames) {
        for (String packageName : packageNames) {
            List<Class<? extends TestCase>> addedClasses = this.testCaseClassesInPackage(packageName);
            if (addedClasses.isEmpty()) {
                Log.w(LOG_TAG, "Invalid Package: '" + packageName + "' could not be found or has no tests");
            }
            this.testCaseClasses.addAll(addedClasses);
            if (this.firstIncludedPackage != null) continue;
            this.firstIncludedPackage = packageName;
        }
        return this;
    }

    public TestGrouping removePackagesRecursive(String ... packageNames) {
        for (String packageName : packageNames) {
            this.testCaseClasses.removeAll(this.testCaseClassesInPackage(packageName));
        }
        return this;
    }

    public String getFirstIncludedPackage() {
        return this.firstIncludedPackage;
    }

    private List<Class<? extends TestCase>> testCaseClassesInPackage(String packageName) {
        ClassPathPackageInfoSource source = PackageInfoSources.forClassPath(this.classLoader);
        ClassPathPackageInfo packageInfo = source.getPackageInfo(packageName);
        return this.selectTestClasses(packageInfo.getTopLevelClassesRecursive());
    }

    private List<Class<? extends TestCase>> selectTestClasses(Set<Class<?>> allClasses) {
        ArrayList<Class<? extends TestCase>> testClasses = new ArrayList<Class<? extends TestCase>>();
        for (Class<?> testClass : this.select(allClasses, new TestCasePredicate())) {
            testClasses.add(testClass);
        }
        return testClasses;
    }

    private <T> List<T> select(Collection<T> items, Predicate<T> predicate) {
        ArrayList<T> selectedItems = new ArrayList<T>();
        for (T item : items) {
            if (!predicate.apply(item)) continue;
            selectedItems.add(item);
        }
        return selectedItems;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestMethodPredicate
    implements Predicate<Method> {
        private TestMethodPredicate() {
        }

        @Override
        public boolean apply(Method method) {
            return method.getParameterTypes().length == 0 && method.getName().startsWith("test") && method.getReturnType().getSimpleName().equals("void");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestCasePredicate
    implements Predicate<Class<?>> {
        private TestCasePredicate() {
        }

        @Override
        public boolean apply(Class aClass) {
            int modifiers = aClass.getModifiers();
            return TestCase.class.isAssignableFrom(aClass) && Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && this.hasValidConstructor(aClass);
        }

        private boolean hasValidConstructor(Class<?> aClass) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = aClass.getConstructors()) {
                Class<?>[] parameterTypes;
                if (!Modifier.isPublic(constructor.getModifiers()) || (parameterTypes = constructor.getParameterTypes()).length != 0 && (parameterTypes.length != 1 || parameterTypes[0] != String.class)) continue;
                return true;
            }
            Log.i(TestGrouping.LOG_TAG, String.format("TestCase class %s is missing a public constructor with no parameters or a single String parameter - skipping", aClass.getName()));
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortByFullyQualifiedName
    implements Comparator<Class<? extends TestCase>>,
    Serializable {
        private SortByFullyQualifiedName() {
        }

        @Override
        public int compare(Class<? extends TestCase> class1, Class<? extends TestCase> class2) {
            return class1.getName().compareTo(class2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortBySimpleName
    implements Comparator<Class<? extends TestCase>>,
    Serializable {
        private SortBySimpleName() {
        }

        @Override
        public int compare(Class<? extends TestCase> class1, Class<? extends TestCase> class2) {
            int result = class1.getSimpleName().compareTo(class2.getSimpleName());
            if (result != 0) {
                return result;
            }
            return class1.getName().compareTo(class2.getName());
        }
    }
}

