/*
 * Decompiled with CFR 0.152.
 */
package android.test.suitebuilder;

import android.content.Context;
import android.test.AndroidTestRunner;
import android.test.TestCaseUtil;
import android.test.suitebuilder.TestGrouping;
import android.test.suitebuilder.TestMethod;
import android.test.suitebuilder.TestPredicates;
import android.util.Log;
import com.android.internal.util.Predicate;
import com.google.android.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteBuilder {
    private Context context;
    private final TestGrouping testGrouping = new TestGrouping(TestGrouping.SORT_BY_FULLY_QUALIFIED_NAME);
    private final Set<Predicate<TestMethod>> predicates = new HashSet<Predicate<TestMethod>>();
    private List<TestCase> testCases;
    private TestSuite rootSuite;
    private TestSuite suiteForCurrentClass;
    private String currentClassname;
    private String suiteName;

    public TestSuiteBuilder(Class clazz) {
        this(clazz.getName(), clazz.getClassLoader());
    }

    public TestSuiteBuilder(String name, ClassLoader classLoader) {
        this.suiteName = name;
        this.testGrouping.setClassLoader(classLoader);
        this.testCases = Lists.newArrayList();
        this.addRequirements(TestPredicates.REJECT_SUPPRESSED);
    }

    public TestSuiteBuilder addTestClassByName(String testClassName, String testMethodName, Context context) {
        AndroidTestRunner atr = new AndroidTestRunner();
        atr.setContext(context);
        atr.setTestClassName(testClassName, testMethodName);
        this.testCases.addAll(atr.getTestCases());
        return this;
    }

    public TestSuiteBuilder addTestSuite(TestSuite testSuite) {
        for (TestCase testCase : TestCaseUtil.getTests(testSuite, true)) {
            this.testCases.add(testCase);
        }
        return this;
    }

    public TestSuiteBuilder includePackages(String ... packageNames) {
        this.testGrouping.addPackagesRecursive(packageNames);
        return this;
    }

    public TestSuiteBuilder excludePackages(String ... packageNames) {
        this.testGrouping.removePackagesRecursive(packageNames);
        return this;
    }

    public TestSuiteBuilder addRequirements(List<Predicate<TestMethod>> predicates) {
        this.predicates.addAll(predicates);
        return this;
    }

    public final TestSuiteBuilder includeAllPackagesUnderHere() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String callingClassName = null;
        String thisClassName = TestSuiteBuilder.class.getName();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement element = stackTraceElements[i];
            if (!thisClassName.equals(element.getClassName()) || !"includeAllPackagesUnderHere".equals(element.getMethodName())) continue;
            callingClassName = stackTraceElements[i + 1].getClassName();
            break;
        }
        String packageName = TestSuiteBuilder.parsePackageNameFromClassName(callingClassName);
        return this.includePackages(packageName);
    }

    public TestSuiteBuilder named(String newSuiteName) {
        this.suiteName = newSuiteName;
        return this;
    }

    public final TestSuite build() {
        this.rootSuite = new TestSuite(this.getSuiteName());
        this.currentClassname = null;
        try {
            for (TestMethod test : this.testGrouping.getTests()) {
                if (!this.satisfiesAllPredicates(test)) continue;
                this.addTest(test);
            }
            if (this.testCases.size() > 0) {
                for (TestCase testCase : this.testCases) {
                    if (!this.satisfiesAllPredicates(new TestMethod(testCase))) continue;
                    this.addTest(testCase);
                }
            }
        }
        catch (Exception exception) {
            Log.i("TestSuiteBuilder", "Failed to create test.", exception);
            TestSuite suite = new TestSuite(this.getSuiteName());
            suite.addTest(new FailedToCreateTests(exception));
            return suite;
        }
        return this.rootSuite;
    }

    protected String getSuiteName() {
        return this.suiteName;
    }

    public final TestSuiteBuilder addRequirements(Predicate<TestMethod> ... predicates) {
        ArrayList<Predicate<TestMethod>> list = new ArrayList<Predicate<TestMethod>>();
        Collections.addAll(list, predicates);
        return this.addRequirements(list);
    }

    protected TestGrouping getTestGrouping() {
        return this.testGrouping;
    }

    private boolean satisfiesAllPredicates(TestMethod test) {
        for (Predicate<TestMethod> predicate : this.predicates) {
            if (predicate.apply(test)) continue;
            return false;
        }
        return true;
    }

    private void addTest(TestMethod testMethod) throws Exception {
        this.addSuiteIfNecessary(testMethod.getEnclosingClassname());
        this.suiteForCurrentClass.addTest(testMethod.createTest());
    }

    private void addTest(Test test) {
        this.addSuiteIfNecessary(test.getClass().getName());
        this.suiteForCurrentClass.addTest(test);
    }

    private void addSuiteIfNecessary(String parentClassname) {
        if (!parentClassname.equals(this.currentClassname)) {
            this.currentClassname = parentClassname;
            this.suiteForCurrentClass = new TestSuite(parentClassname);
            this.rootSuite.addTest(this.suiteForCurrentClass);
        }
    }

    private static String parsePackageNameFromClassName(String className) {
        return className.substring(0, className.lastIndexOf(46));
    }

    public static class FailedToCreateTests
    extends TestCase {
        private final Exception exception;

        public FailedToCreateTests(Exception exception) {
            super("testSuiteConstructionFailed");
            this.exception = exception;
        }

        public void testSuiteConstructionFailed() {
            throw new RuntimeException("Exception during suite construction", this.exception);
        }
    }
}

