/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.transition.AutoTransition;
import android.transition.ChangeBounds;
import android.transition.Fade;
import android.transition.Recolor;
import android.transition.Scene;
import android.transition.Slide;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TransitionInflater {
    private Context mContext;

    private TransitionInflater(Context context) {
        this.mContext = context;
    }

    public static TransitionInflater from(Context context) {
        return new TransitionInflater(context);
    }

    public Transition inflateTransition(int resource) {
        XmlResourceParser parser = this.mContext.getResources().getXml(resource);
        try {
            Transition transition = this.createTransitionFromXml(parser, Xml.asAttributeSet(parser), null);
            return transition;
        }
        catch (XmlPullParserException e) {
            InflateException ex = new InflateException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        finally {
            parser.close();
        }
    }

    public TransitionManager inflateTransitionManager(int resource, ViewGroup sceneRoot) {
        XmlResourceParser parser = this.mContext.getResources().getXml(resource);
        try {
            TransitionManager transitionManager = this.createTransitionManagerFromXml(parser, Xml.asAttributeSet(parser), sceneRoot);
            return transitionManager;
        }
        catch (XmlPullParserException e) {
            InflateException ex = new InflateException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        finally {
            parser.close();
        }
    }

    private Transition createTransitionFromXml(XmlPullParser parser, AttributeSet attrs, TransitionSet transitionSet) throws XmlPullParserException, IOException {
        int type;
        Transition transition = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            TypedArray a;
            boolean newTransition = false;
            if (type != 2) continue;
            String name = parser.getName();
            if ("fade".equals(name)) {
                a = this.mContext.obtainStyledAttributes(attrs, R.styleable.Fade);
                int fadingMode = a.getInt(0, 3);
                transition = new Fade(fadingMode);
                newTransition = true;
            } else if ("changeBounds".equals(name)) {
                transition = new ChangeBounds();
                newTransition = true;
            } else if ("slide".equals(name)) {
                transition = new Slide();
                newTransition = true;
            } else if ("autoTransition".equals(name)) {
                transition = new AutoTransition();
                newTransition = true;
            } else if ("recolor".equals(name)) {
                transition = new Recolor();
                newTransition = true;
            } else if ("transitionSet".equals(name)) {
                transition = new TransitionSet();
                a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TransitionSet);
                int ordering = a.getInt(0, 0);
                ((TransitionSet)transition).setOrdering(ordering);
                this.createTransitionFromXml(parser, attrs, (TransitionSet)transition);
                a.recycle();
                newTransition = true;
            } else if ("targets".equals(name)) {
                if (parser.getDepth() - 1 > depth && transition != null) {
                    this.getTargetIds(parser, attrs, transition);
                } else if (parser.getDepth() - 1 == depth && transitionSet != null) {
                    this.getTargetIds(parser, attrs, transitionSet);
                }
            }
            if (transition != null || "targets".equals(name)) {
                if (!newTransition) continue;
                this.loadTransition(transition, attrs);
                if (transitionSet == null) continue;
                transitionSet.addTransition(transition);
                continue;
            }
            throw new RuntimeException("Unknown scene name: " + parser.getName());
        }
        return transition;
    }

    private void getTargetIds(XmlPullParser parser, AttributeSet attrs, Transition transition) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        ArrayList<Integer> targetIds = new ArrayList<Integer>();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("target")) {
                TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TransitionTarget);
                int id2 = a.getResourceId(0, -1);
                if (id2 < 0) continue;
                targetIds.add(id2);
                continue;
            }
            throw new RuntimeException("Unknown scene name: " + parser.getName());
        }
        int numTargets = targetIds.size();
        if (numTargets > 0) {
            for (int i = 0; i < numTargets; ++i) {
                transition.addTarget((Integer)targetIds.get(i));
            }
        }
    }

    private Transition loadTransition(Transition transition, AttributeSet attrs) throws Resources.NotFoundException {
        int resID;
        long startDelay;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.Transition);
        long duration = a.getInt(1, -1);
        if (duration >= 0L) {
            transition.setDuration(duration);
        }
        if ((startDelay = (long)a.getInt(2, -1)) > 0L) {
            transition.setStartDelay(startDelay);
        }
        if ((resID = a.getResourceId(0, 0)) > 0) {
            transition.setInterpolator(AnimationUtils.loadInterpolator(this.mContext, resID));
        }
        a.recycle();
        return transition;
    }

    private TransitionManager createTransitionManagerFromXml(XmlPullParser parser, AttributeSet attrs, ViewGroup sceneRoot) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        TransitionManager transitionManager = null;
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("transitionManager")) {
                transitionManager = new TransitionManager();
                continue;
            }
            if (name.equals("transition") && transitionManager != null) {
                this.loadTransition(attrs, sceneRoot, transitionManager);
                continue;
            }
            throw new RuntimeException("Unknown scene name: " + parser.getName());
        }
        return transitionManager;
    }

    private void loadTransition(AttributeSet attrs, ViewGroup sceneRoot, TransitionManager transitionManager) throws Resources.NotFoundException {
        Transition transition;
        int toId;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TransitionManager);
        int transitionId = a.getResourceId(2, -1);
        Scene fromScene = null;
        Scene toScene = null;
        int fromId = a.getResourceId(0, -1);
        if (fromId >= 0) {
            fromScene = Scene.getSceneForLayout(sceneRoot, fromId, this.mContext);
        }
        if ((toId = a.getResourceId(1, -1)) >= 0) {
            toScene = Scene.getSceneForLayout(sceneRoot, toId, this.mContext);
        }
        if (transitionId >= 0 && (transition = this.inflateTransition(transitionId)) != null) {
            if (fromScene != null) {
                if (toScene == null) {
                    throw new RuntimeException("No matching toScene for given fromScene for transition ID " + transitionId);
                }
                transitionManager.setTransition(fromScene, toScene, transition);
            } else if (toId >= 0) {
                transitionManager.setTransition(toScene, transition);
            }
        }
        a.recycle();
    }
}

