/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.SurfaceControl;
import dalvik.system.CloseGuard;

public class Surface
implements Parcelable {
    private static final String TAG = "Surface";
    public static final Parcelable.Creator<Surface> CREATOR = new Parcelable.Creator<Surface>(){

        @Override
        public Surface createFromParcel(Parcel source) {
            try {
                Surface s = new Surface();
                s.readFromParcel(source);
                return s;
            }
            catch (Exception e) {
                Log.e(Surface.TAG, "Exception creating surface from parcel", e);
                return null;
            }
        }

        public Surface[] newArray(int size) {
            return new Surface[size];
        }
    };
    private final CloseGuard mCloseGuard = CloseGuard.get();
    final Object mLock = new Object();
    private String mName;
    int mNativeObject;
    private int mLockedObject;
    private int mGenerationId;
    private final Canvas mCanvas = new CompatibleCanvas();
    private Matrix mCompatibleMatrix;
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;

    private static native int nativeCreateFromSurfaceTexture(SurfaceTexture var0) throws OutOfResourcesException;

    private static native int nativeCreateFromSurfaceControl(int var0);

    private static native int nativeLockCanvas(int var0, Canvas var1, Rect var2) throws OutOfResourcesException;

    private static native void nativeUnlockCanvasAndPost(int var0, Canvas var1);

    private static native void nativeRelease(int var0);

    private static native boolean nativeIsValid(int var0);

    private static native boolean nativeIsConsumerRunningBehind(int var0);

    private static native int nativeReadFromParcel(int var0, Parcel var1);

    private static native void nativeWriteToParcel(int var0, Parcel var1);

    public Surface() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface(SurfaceTexture surfaceTexture) {
        if (surfaceTexture == null) {
            throw new IllegalArgumentException("surfaceTexture must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mName = surfaceTexture.toString();
            this.setNativeObjectLocked(Surface.nativeCreateFromSurfaceTexture(surfaceTexture));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface(int nativeObject) {
        Object object = this.mLock;
        synchronized (object) {
            this.setNativeObjectLocked(nativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0) {
                Surface.nativeRelease(this.mNativeObject);
                this.setNativeObjectLocked(0);
            }
        }
    }

    public void destroy() {
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject == 0) {
                return false;
            }
            return Surface.nativeIsValid(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGenerationId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mGenerationId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumerRunningBehind() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            return Surface.nativeIsConsumerRunningBehind(this.mNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canvas lockCanvas(Rect inOutDirty) throws OutOfResourcesException, IllegalArgumentException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mLockedObject != 0) {
                throw new IllegalStateException("Surface was already locked");
            }
            this.mLockedObject = Surface.nativeLockCanvas(this.mNativeObject, this.mCanvas, inOutDirty);
            return this.mCanvas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockCanvasAndPost(Canvas canvas) {
        if (canvas != this.mCanvas) {
            throw new IllegalArgumentException("canvas object must be the same instance that was previously returned by lockCanvas");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotReleasedLocked();
            if (this.mNativeObject != this.mLockedObject) {
                Log.w(TAG, "WARNING: Surface's mNativeObject (0x" + Integer.toHexString(this.mNativeObject) + ") != mLockedObject (0x" + Integer.toHexString(this.mLockedObject) + ")");
            }
            if (this.mLockedObject == 0) {
                throw new IllegalStateException("Surface was not locked");
            }
            Surface.nativeUnlockCanvasAndPost(this.mLockedObject, canvas);
            Surface.nativeRelease(this.mLockedObject);
            this.mLockedObject = 0;
        }
    }

    @Deprecated
    public void unlockCanvas(Canvas canvas) {
        throw new UnsupportedOperationException();
    }

    void setCompatibilityTranslator(CompatibilityInfo.Translator translator) {
        if (translator != null) {
            float appScale = translator.applicationScale;
            this.mCompatibleMatrix = new Matrix();
            this.mCompatibleMatrix.setScale(appScale, appScale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(SurfaceControl other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        int surfaceControlPtr = other.mNativeObject;
        if (surfaceControlPtr == 0) {
            throw new NullPointerException("SurfaceControl native object is null. Are you using a released SurfaceControl?");
        }
        int newNativeObject = Surface.nativeCreateFromSurfaceControl(surfaceControlPtr);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeObject != 0) {
                Surface.nativeRelease(this.mNativeObject);
            }
            this.setNativeObjectLocked(newNativeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void transferFrom(Surface other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null");
        }
        if (other != this) {
            int newPtr;
            Object object = other.mLock;
            synchronized (object) {
                newPtr = other.mNativeObject;
                other.setNativeObjectLocked(0);
            }
            object = this.mLock;
            synchronized (object) {
                if (this.mNativeObject != 0) {
                    Surface.nativeRelease(this.mNativeObject);
                }
                this.setNativeObjectLocked(newPtr);
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromParcel(Parcel source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mName = source.readString();
            this.setNativeObjectLocked(Surface.nativeReadFromParcel(this.mNativeObject, source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            dest.writeString(this.mName);
            Surface.nativeWriteToParcel(this.mNativeObject, dest);
        }
        if ((flags & 1) != 0) {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mLock;
        synchronized (object) {
            return "Surface(name=" + this.mName + ")/@0x" + Integer.toHexString(System.identityHashCode(this));
        }
    }

    private void setNativeObjectLocked(int ptr) {
        if (this.mNativeObject != ptr) {
            if (this.mNativeObject == 0 && ptr != 0) {
                this.mCloseGuard.open("release");
            } else if (this.mNativeObject != 0 && ptr == 0) {
                this.mCloseGuard.close();
            }
            this.mNativeObject = ptr;
            ++this.mGenerationId;
        }
    }

    private void checkNotReleasedLocked() {
        if (this.mNativeObject == 0) {
            throw new IllegalStateException("Surface has already been released.");
        }
    }

    public static String rotationToString(int rotation) {
        switch (rotation) {
            case 0: {
                return "ROTATION_0";
            }
            case 1: {
                return "ROATATION_90";
            }
            case 2: {
                return "ROATATION_180";
            }
            case 3: {
                return "ROATATION_270";
            }
        }
        throw new IllegalArgumentException("Invalid rotation: " + rotation);
    }

    private final class CompatibleCanvas
    extends Canvas {
        private Matrix mOrigMatrix = null;

        private CompatibleCanvas() {
        }

        public void setMatrix(Matrix matrix) {
            if (Surface.this.mCompatibleMatrix == null || this.mOrigMatrix == null || this.mOrigMatrix.equals(matrix)) {
                super.setMatrix(matrix);
            } else {
                Matrix m = new Matrix(Surface.this.mCompatibleMatrix);
                m.preConcat(matrix);
                super.setMatrix(m);
            }
        }

        public void getMatrix(Matrix m) {
            super.getMatrix(m);
            if (this.mOrigMatrix == null) {
                this.mOrigMatrix = new Matrix();
            }
            this.mOrigMatrix.set(m);
        }
    }

    public static class OutOfResourcesException
    extends RuntimeException {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String name) {
            super(name);
        }
    }
}

