/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.AudioService;
import android.media.AudioSystem;
import android.media.RingtoneManager;
import android.media.ToneGenerator;
import android.media.VolumeController;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.SeekBar;
import java.util.HashMap;

public class VolumePanel
extends Handler
implements SeekBar.OnSeekBarChangeListener,
View.OnClickListener,
VolumeController {
    private static final String TAG = "VolumePanel";
    private static boolean LOGD = false;
    public static final int PLAY_SOUND_DELAY = 300;
    public static final int VIBRATE_DELAY = 300;
    private static final int VIBRATE_DURATION = 300;
    private static final int BEEP_DURATION = 150;
    private static final int MAX_VOLUME = 100;
    private static final int FREE_DELAY = 10000;
    private static final int TIMEOUT_DELAY = 3000;
    private static final int MSG_VOLUME_CHANGED = 0;
    private static final int MSG_FREE_RESOURCES = 1;
    private static final int MSG_PLAY_SOUND = 2;
    private static final int MSG_STOP_SOUNDS = 3;
    private static final int MSG_VIBRATE = 4;
    private static final int MSG_TIMEOUT = 5;
    private static final int MSG_RINGER_MODE_CHANGED = 6;
    private static final int MSG_MUTE_CHANGED = 7;
    private static final int MSG_REMOTE_VOLUME_CHANGED = 8;
    private static final int MSG_REMOTE_VOLUME_UPDATE_IF_SHOWN = 9;
    private static final int MSG_SLIDER_VISIBILITY_CHANGED = 10;
    private static final int MSG_DISPLAY_SAFE_VOLUME_WARNING = 11;
    private static final int STREAM_MASTER = -100;
    protected Context mContext;
    private AudioManager mAudioManager;
    protected AudioService mAudioService;
    private boolean mRingIsSilent;
    private boolean mShowCombinedVolumes;
    private boolean mVoiceCapable;
    private final boolean mPlayMasterStreamTones;
    private final Dialog mDialog;
    private final View mView;
    private final ViewGroup mPanel;
    private final ViewGroup mSliderGroup;
    private final View mMoreButton;
    private final View mDivider;
    private int mActiveStreamType = -1;
    private HashMap<Integer, StreamControl> mStreamControls;
    private static final StreamResources[] STREAMS = new StreamResources[]{StreamResources.BluetoothSCOStream, StreamResources.RingerStream, StreamResources.VoiceStream, StreamResources.MediaStream, StreamResources.NotificationStream, StreamResources.AlarmStream, StreamResources.MasterStream, StreamResources.RemoteStream};
    private ToneGenerator[] mToneGenerators;
    private Vibrator mVibrator;
    private static AlertDialog sConfirmSafeVolumeDialog;
    private static Object sConfirmSafeVolumeLock;

    public VolumePanel(Context context, AudioService volumeService) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioService = volumeService;
        boolean useMasterVolume = context.getResources().getBoolean(0x1110011);
        if (useMasterVolume) {
            for (int i = 0; i < STREAMS.length; ++i) {
                StreamResources streamRes = STREAMS[i];
                streamRes.show = streamRes.streamType == -100;
            }
        }
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = this.mView = inflater.inflate(17367225, null);
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                VolumePanel.this.resetTimeout();
                return false;
            }
        });
        this.mPanel = (ViewGroup)this.mView.findViewById(16909149);
        this.mSliderGroup = (ViewGroup)this.mView.findViewById(16909150);
        this.mMoreButton = (ImageView)this.mView.findViewById(16909152);
        this.mDivider = (ImageView)this.mView.findViewById(16909151);
        this.mDialog = new Dialog(context, 16974602){

            public boolean onTouchEvent(MotionEvent event) {
                if (this.isShowing() && event.getAction() == 4 && sConfirmSafeVolumeDialog == null) {
                    VolumePanel.this.forceTimeout();
                    return true;
                }
                return false;
            }
        };
        this.mDialog.setTitle("Volume control");
        this.mDialog.setContentView(this.mView);
        this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                VolumePanel.this.mActiveStreamType = -1;
                VolumePanel.this.mAudioManager.forceVolumeControlStream(VolumePanel.this.mActiveStreamType);
            }
        });
        Window window = this.mDialog.getWindow();
        window.setGravity(48);
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.token = null;
        lp.y = this.mContext.getResources().getDimensionPixelOffset(17104975);
        lp.type = 2020;
        lp.width = -2;
        lp.height = -2;
        lp.privateFlags |= 0x20;
        window.setAttributes(lp);
        window.addFlags(262184);
        this.mToneGenerators = new ToneGenerator[AudioSystem.getNumStreamTypes()];
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        this.mVoiceCapable = context.getResources().getBoolean(17891385);
        boolean bl = this.mShowCombinedVolumes = !this.mVoiceCapable && !useMasterVolume;
        if (!this.mShowCombinedVolumes) {
            this.mMoreButton.setVisibility(8);
            this.mDivider.setVisibility(8);
        } else {
            this.mMoreButton.setOnClickListener(this);
        }
        boolean masterVolumeOnly = context.getResources().getBoolean(0x1110011);
        boolean masterVolumeKeySounds = this.mContext.getResources().getBoolean(0x1110012);
        this.mPlayMasterStreamTones = masterVolumeOnly && masterVolumeKeySounds;
        this.listenToRingerMode();
    }

    public void setLayoutDirection(int layoutDirection) {
        this.mPanel.setLayoutDirection(layoutDirection);
        this.updateStates();
    }

    private void listenToRingerMode() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.media.RINGER_MODE_CHANGED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.media.RINGER_MODE_CHANGED".equals(action)) {
                    VolumePanel.this.removeMessages(6);
                    VolumePanel.this.sendMessage(VolumePanel.this.obtainMessage(6));
                }
            }
        }, filter);
    }

    private boolean isMuted(int streamType) {
        if (streamType == -100) {
            return this.mAudioManager.isMasterMute();
        }
        if (streamType == -200) {
            return this.mAudioService.getRemoteStreamVolume() <= 0;
        }
        return this.mAudioManager.isStreamMute(streamType);
    }

    private int getStreamMaxVolume(int streamType) {
        if (streamType == -100) {
            return this.mAudioManager.getMasterMaxVolume();
        }
        if (streamType == -200) {
            return this.mAudioService.getRemoteStreamMaxVolume();
        }
        return this.mAudioManager.getStreamMaxVolume(streamType);
    }

    private int getStreamVolume(int streamType) {
        if (streamType == -100) {
            return this.mAudioManager.getMasterVolume();
        }
        if (streamType == -200) {
            return this.mAudioService.getRemoteStreamVolume();
        }
        return this.mAudioManager.getStreamVolume(streamType);
    }

    private void setStreamVolume(int streamType, int index, int flags) {
        if (streamType == -100) {
            this.mAudioManager.setMasterVolume(index, flags);
        } else if (streamType == -200) {
            this.mAudioService.setRemoteStreamVolume(index);
        } else {
            this.mAudioManager.setStreamVolume(streamType, index, flags);
        }
    }

    private void createSliders() {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mStreamControls = new HashMap(STREAMS.length);
        Resources res = this.mContext.getResources();
        for (int i = 0; i < STREAMS.length; ++i) {
            StreamResources streamRes = STREAMS[i];
            int streamType = streamRes.streamType;
            if (this.mVoiceCapable && streamRes == StreamResources.NotificationStream) {
                streamRes = StreamResources.RingerStream;
            }
            StreamControl sc = new StreamControl();
            sc.streamType = streamType;
            sc.group = (ViewGroup)inflater.inflate(17367226, null);
            sc.group.setTag(sc);
            sc.icon = (ImageView)sc.group.findViewById(16909153);
            sc.icon.setTag(sc);
            sc.icon.setContentDescription(res.getString(streamRes.descRes));
            sc.iconRes = streamRes.iconRes;
            sc.iconMuteRes = streamRes.iconMuteRes;
            sc.icon.setImageResource(sc.iconRes);
            sc.seekbarView = (SeekBar)sc.group.findViewById(16909050);
            int plusOne = streamType == 6 || streamType == 0 ? 1 : 0;
            sc.seekbarView.setMax(this.getStreamMaxVolume(streamType) + plusOne);
            sc.seekbarView.setOnSeekBarChangeListener(this);
            sc.seekbarView.setTag(sc);
            this.mStreamControls.put(streamType, sc);
        }
    }

    private void reorderSliders(int activeStreamType) {
        this.mSliderGroup.removeAllViews();
        StreamControl active = this.mStreamControls.get(activeStreamType);
        if (active == null) {
            Log.e(TAG, "Missing stream type! - " + activeStreamType);
            this.mActiveStreamType = -1;
        } else {
            this.mSliderGroup.addView(active.group);
            this.mActiveStreamType = activeStreamType;
            active.group.setVisibility(0);
            this.updateSlider(active);
        }
        this.addOtherVolumes();
    }

    private void addOtherVolumes() {
        if (!this.mShowCombinedVolumes) {
            return;
        }
        for (int i = 0; i < STREAMS.length; ++i) {
            int streamType = VolumePanel.STREAMS[i].streamType;
            if (!VolumePanel.STREAMS[i].show || streamType == this.mActiveStreamType) continue;
            StreamControl sc = this.mStreamControls.get(streamType);
            this.mSliderGroup.addView(sc.group);
            this.updateSlider(sc);
        }
    }

    private void updateSlider(StreamControl sc) {
        sc.seekbarView.setProgress(this.getStreamVolume(sc.streamType));
        boolean muted = this.isMuted(sc.streamType);
        sc.icon.setImageDrawable(null);
        sc.icon.setImageResource(muted ? sc.iconMuteRes : sc.iconRes);
        if ((sc.streamType == 2 || sc.streamType == 5) && this.mAudioManager.getRingerMode() == 1) {
            sc.icon.setImageResource(17302186);
        }
        if (sc.streamType == -200) {
            sc.seekbarView.setEnabled(true);
        } else if (sc.streamType != this.mAudioManager.getMasterStreamType() && muted || sConfirmSafeVolumeDialog != null) {
            sc.seekbarView.setEnabled(false);
        } else {
            sc.seekbarView.setEnabled(true);
        }
    }

    private boolean isExpanded() {
        return this.mMoreButton.getVisibility() != 0;
    }

    private void expand() {
        int count = this.mSliderGroup.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.mSliderGroup.getChildAt(i).setVisibility(0);
        }
        this.mMoreButton.setVisibility(4);
        this.mDivider.setVisibility(4);
    }

    private void collapse() {
        this.mMoreButton.setVisibility(0);
        this.mDivider.setVisibility(0);
        int count = this.mSliderGroup.getChildCount();
        for (int i = 1; i < count; ++i) {
            this.mSliderGroup.getChildAt(i).setVisibility(8);
        }
    }

    public void updateStates() {
        int count = this.mSliderGroup.getChildCount();
        for (int i = 0; i < count; ++i) {
            StreamControl sc = (StreamControl)this.mSliderGroup.getChildAt(i).getTag();
            this.updateSlider(sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postVolumeChanged(int streamType, int flags) {
        if (this.hasMessages(0)) {
            return;
        }
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            if (this.mStreamControls == null) {
                this.createSliders();
            }
        }
        this.removeMessages(1);
        this.obtainMessage(0, streamType, flags).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRemoteVolumeChanged(int streamType, int flags) {
        if (this.hasMessages(8)) {
            return;
        }
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            if (this.mStreamControls == null) {
                this.createSliders();
            }
        }
        this.removeMessages(1);
        this.obtainMessage(8, streamType, flags).sendToTarget();
    }

    public void postRemoteSliderVisibility(boolean visible) {
        this.obtainMessage(10, -200, visible ? 1 : 0).sendToTarget();
    }

    public void postHasNewRemotePlaybackInfo() {
        if (this.hasMessages(9)) {
            return;
        }
        this.obtainMessage(9).sendToTarget();
    }

    public void postMasterVolumeChanged(int flags) {
        this.postVolumeChanged(-100, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMuteChanged(int streamType, int flags) {
        if (this.hasMessages(0)) {
            return;
        }
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            if (this.mStreamControls == null) {
                this.createSliders();
            }
        }
        this.removeMessages(1);
        this.obtainMessage(7, streamType, flags).sendToTarget();
    }

    public void postMasterMuteChanged(int flags) {
        this.postMuteChanged(-100, flags);
    }

    public void postDisplaySafeVolumeWarning(int flags) {
        if (this.hasMessages(11)) {
            return;
        }
        this.obtainMessage(11, flags, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onVolumeChanged(int streamType, int flags) {
        if (LOGD) {
            Log.d(TAG, "onVolumeChanged(streamType: " + streamType + ", flags: " + flags + ")");
        }
        if ((flags & 1) != 0) {
            VolumePanel volumePanel = this;
            synchronized (volumePanel) {
                if (this.mActiveStreamType != streamType) {
                    this.reorderSliders(streamType);
                }
                this.onShowVolumeChanged(streamType, flags);
            }
        }
        if ((flags & 4) != 0 && !this.mRingIsSilent) {
            this.removeMessages(2);
            this.sendMessageDelayed(this.obtainMessage(2, streamType, flags), 300L);
        }
        if ((flags & 8) != 0) {
            this.removeMessages(2);
            this.removeMessages(4);
            this.onStopSounds();
        }
        this.removeMessages(1);
        this.sendMessageDelayed(this.obtainMessage(1), 10000L);
        this.resetTimeout();
    }

    protected void onMuteChanged(int streamType, int flags) {
        StreamControl sc;
        if (LOGD) {
            Log.d(TAG, "onMuteChanged(streamType: " + streamType + ", flags: " + flags + ")");
        }
        if ((sc = this.mStreamControls.get(streamType)) != null) {
            sc.icon.setImageResource(this.isMuted(sc.streamType) ? sc.iconMuteRes : sc.iconRes);
        }
        this.onVolumeChanged(streamType, flags);
    }

    protected void onShowVolumeChanged(int streamType, int flags) {
        int index = this.getStreamVolume(streamType);
        this.mRingIsSilent = false;
        if (LOGD) {
            Log.d(TAG, "onShowVolumeChanged(streamType: " + streamType + ", flags: " + flags + "), index: " + index);
        }
        int max = this.getStreamMaxVolume(streamType);
        switch (streamType) {
            case 2: {
                Uri ringuri = RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 1);
                if (ringuri != null) break;
                this.mRingIsSilent = true;
                break;
            }
            case 3: {
                if ((this.mAudioManager.getDevicesForStream(3) & 0x380) != 0) {
                    this.setMusicIcon(17302174, 17302175);
                    break;
                }
                this.setMusicIcon(17302188, 17302190);
                break;
            }
            case 0: {
                ++index;
                ++max;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                Uri ringuri = RingtoneManager.getActualDefaultRingtoneUri(this.mContext, 2);
                if (ringuri != null) break;
                this.mRingIsSilent = true;
                break;
            }
            case 6: {
                ++index;
                ++max;
                break;
            }
            case -200: {
                if (!LOGD) break;
                Log.d(TAG, "showing remote volume " + index + " over " + max);
            }
        }
        StreamControl sc = this.mStreamControls.get(streamType);
        if (sc != null) {
            if (sc.seekbarView.getMax() != max) {
                sc.seekbarView.setMax(max);
            }
            sc.seekbarView.setProgress(index);
            if ((flags & 0x20) != 0 || streamType != this.mAudioManager.getMasterStreamType() && streamType != -200 && this.isMuted(streamType) || sConfirmSafeVolumeDialog != null) {
                sc.seekbarView.setEnabled(false);
            } else {
                sc.seekbarView.setEnabled(true);
            }
        }
        if (!this.mDialog.isShowing()) {
            int stream = streamType == -200 ? -1 : streamType;
            this.mAudioManager.forceVolumeControlStream(stream);
            this.mDialog.setContentView(this.mView);
            if (this.mShowCombinedVolumes) {
                this.collapse();
            }
            this.mDialog.show();
        }
        if (streamType != -200 && (flags & 0x10) != 0 && this.mAudioService.isStreamAffectedByRingerMode(streamType) && this.mAudioManager.getRingerMode() == 1) {
            this.sendMessageDelayed(this.obtainMessage(4), 300L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPlaySound(int streamType, int flags) {
        if (this.hasMessages(3)) {
            this.removeMessages(3);
            this.onStopSounds();
        }
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            ToneGenerator toneGen = this.getOrCreateToneGenerator(streamType);
            if (toneGen != null) {
                toneGen.startTone(24);
                this.sendMessageDelayed(this.obtainMessage(3), 150L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStopSounds() {
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int i = numStreamTypes - 1; i >= 0; --i) {
                ToneGenerator toneGen = this.mToneGenerators[i];
                if (toneGen == null) continue;
                toneGen.stopTone();
            }
        }
    }

    protected void onVibrate() {
        if (this.mAudioManager.getRingerMode() != 1) {
            return;
        }
        this.mVibrator.vibrate(300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRemoteVolumeChanged(int streamType, int flags) {
        if (LOGD) {
            Log.d(TAG, "onRemoteVolumeChanged(stream:" + streamType + ", flags: " + flags + ")");
        }
        if ((flags & 1) != 0 || this.mDialog.isShowing()) {
            VolumePanel volumePanel = this;
            synchronized (volumePanel) {
                if (this.mActiveStreamType != -200) {
                    this.reorderSliders(-200);
                }
                this.onShowVolumeChanged(-200, flags);
            }
        } else if (LOGD) {
            Log.d(TAG, "not calling onShowVolumeChanged(), no FLAG_SHOW_UI or no UI");
        }
        if ((flags & 4) != 0 && !this.mRingIsSilent) {
            this.removeMessages(2);
            this.sendMessageDelayed(this.obtainMessage(2, streamType, flags), 300L);
        }
        if ((flags & 8) != 0) {
            this.removeMessages(2);
            this.removeMessages(4);
            this.onStopSounds();
        }
        this.removeMessages(1);
        this.sendMessageDelayed(this.obtainMessage(1), 10000L);
        this.resetTimeout();
    }

    protected void onRemoteVolumeUpdateIfShown() {
        if (LOGD) {
            Log.d(TAG, "onRemoteVolumeUpdateIfShown()");
        }
        if (this.mDialog.isShowing() && this.mActiveStreamType == -200 && this.mStreamControls != null) {
            this.onShowVolumeChanged(-200, 0);
        }
    }

    protected synchronized void onSliderVisibilityChanged(int streamType, int visible) {
        if (LOGD) {
            Log.d(TAG, "onSliderVisibilityChanged(stream=" + streamType + ", visi=" + visible + ")");
        }
        boolean isVisible = visible == 1;
        for (int i = STREAMS.length - 1; i >= 0; --i) {
            StreamResources streamRes = STREAMS[i];
            if (streamRes.streamType != streamType) continue;
            streamRes.show = isVisible;
            if (isVisible || this.mActiveStreamType != streamType) break;
            this.mActiveStreamType = -1;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDisplaySafeVolumeWarning(int flags) {
        if ((flags & 1) != 0 || this.mDialog.isShowing()) {
            Object object = sConfirmSafeVolumeLock;
            synchronized (object) {
                if (sConfirmSafeVolumeDialog != null) {
                    return;
                }
                sConfirmSafeVolumeDialog = new AlertDialog.Builder(this.mContext).setMessage(17040766).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        VolumePanel.this.mAudioService.disableSafeMediaVolume();
                    }
                }).setNegativeButton(17039369, null).setIconAttribute(16843605).create();
                WarningDialogReceiver warning = new WarningDialogReceiver(this.mContext, sConfirmSafeVolumeDialog, this);
                sConfirmSafeVolumeDialog.setOnDismissListener(warning);
                sConfirmSafeVolumeDialog.getWindow().setType(2009);
                sConfirmSafeVolumeDialog.show();
            }
            this.updateStates();
        }
        this.resetTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ToneGenerator getOrCreateToneGenerator(int streamType) {
        if (streamType == -100) {
            if (this.mPlayMasterStreamTones) {
                streamType = 1;
            } else {
                return null;
            }
        }
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            block9: {
                if (this.mToneGenerators[streamType] == null) {
                    try {
                        this.mToneGenerators[streamType] = new ToneGenerator(streamType, 100);
                    }
                    catch (RuntimeException e) {
                        if (!LOGD) break block9;
                        Log.d(TAG, "ToneGenerator constructor failed with RuntimeException: " + e);
                    }
                }
            }
            return this.mToneGenerators[streamType];
        }
    }

    private void setMusicIcon(int resId, int resMuteId) {
        StreamControl sc = this.mStreamControls.get(3);
        if (sc != null) {
            sc.iconRes = resId;
            sc.iconMuteRes = resMuteId;
            sc.icon.setImageResource(this.isMuted(sc.streamType) ? sc.iconMuteRes : sc.iconRes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFreeResources() {
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            for (int i = this.mToneGenerators.length - 1; i >= 0; --i) {
                if (this.mToneGenerators[i] != null) {
                    this.mToneGenerators[i].release();
                }
                this.mToneGenerators[i] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.onVolumeChanged(msg.arg1, msg.arg2);
                break;
            }
            case 7: {
                this.onMuteChanged(msg.arg1, msg.arg2);
                break;
            }
            case 1: {
                this.onFreeResources();
                break;
            }
            case 3: {
                this.onStopSounds();
                break;
            }
            case 2: {
                this.onPlaySound(msg.arg1, msg.arg2);
                break;
            }
            case 4: {
                this.onVibrate();
                break;
            }
            case 5: {
                if (this.mDialog.isShowing()) {
                    this.mDialog.dismiss();
                    this.mActiveStreamType = -1;
                }
                Object object = sConfirmSafeVolumeLock;
                synchronized (object) {
                    if (sConfirmSafeVolumeDialog != null) {
                        sConfirmSafeVolumeDialog.dismiss();
                    }
                    break;
                }
            }
            case 6: {
                if (!this.mDialog.isShowing()) break;
                this.updateStates();
                break;
            }
            case 8: {
                this.onRemoteVolumeChanged(msg.arg1, msg.arg2);
                break;
            }
            case 9: {
                this.onRemoteVolumeUpdateIfShown();
                break;
            }
            case 10: {
                this.onSliderVisibilityChanged(msg.arg1, msg.arg2);
                break;
            }
            case 11: {
                this.onDisplaySafeVolumeWarning(msg.arg1);
            }
        }
    }

    private void resetTimeout() {
        this.removeMessages(5);
        this.sendMessageDelayed(this.obtainMessage(5), 3000L);
    }

    private void forceTimeout() {
        this.removeMessages(5);
        this.sendMessage(this.obtainMessage(5));
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        Object tag = seekBar.getTag();
        if (fromUser && tag instanceof StreamControl) {
            StreamControl sc = (StreamControl)tag;
            if (this.getStreamVolume(sc.streamType) != progress) {
                this.setStreamVolume(sc.streamType, progress, 0);
            }
        }
        this.resetTimeout();
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        Object tag = seekBar.getTag();
        if (tag instanceof StreamControl) {
            StreamControl sc = (StreamControl)tag;
            if (sc.streamType == -200) {
                seekBar.setProgress(this.getStreamVolume(-200));
            }
        }
    }

    public void onClick(View v) {
        if (v == this.mMoreButton) {
            this.expand();
        }
        this.resetTimeout();
    }

    static {
        sConfirmSafeVolumeLock = new Object();
    }

    private static class WarningDialogReceiver
    extends BroadcastReceiver
    implements DialogInterface.OnDismissListener {
        private final Context mContext;
        private final Dialog mDialog;
        private final VolumePanel mVolumePanel;

        WarningDialogReceiver(Context context, Dialog dialog, VolumePanel volumePanel) {
            this.mContext = context;
            this.mDialog = dialog;
            this.mVolumePanel = volumePanel;
            IntentFilter filter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
            context.registerReceiver(this, filter);
        }

        public void onReceive(Context context, Intent intent) {
            this.mDialog.cancel();
            this.cleanUp();
        }

        public void onDismiss(DialogInterface unused) {
            this.mContext.unregisterReceiver(this);
            this.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUp() {
            Object object = sConfirmSafeVolumeLock;
            synchronized (object) {
                sConfirmSafeVolumeDialog = null;
            }
            this.mVolumePanel.forceTimeout();
            this.mVolumePanel.updateStates();
        }
    }

    private class StreamControl {
        int streamType;
        ViewGroup group;
        ImageView icon;
        SeekBar seekbarView;
        int iconRes;
        int iconMuteRes;

        private StreamControl() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StreamResources {
        BluetoothSCOStream(6, 17040422, 17302174, 17302174, false),
        RingerStream(2, 17040423, 17302182, 17302184, false),
        VoiceStream(0, 17040424, 17302180, 17302180, false),
        AlarmStream(4, 17040419, 17302172, 17302173, false),
        MediaStream(3, 17040425, 17302188, 17302190, true),
        NotificationStream(5, 17040426, 17302176, 17302178, true),
        MasterStream(-100, 17040425, 17302188, 17302190, false),
        RemoteStream(-200, 17040425, 17302316, 17302304, false);

        int streamType;
        int descRes;
        int iconRes;
        int iconMuteRes;
        boolean show;

        private StreamResources(int streamType, int descRes, int iconRes, int iconMuteRes, boolean show) {
            this.streamType = streamType;
            this.descRes = descRes;
            this.iconRes = iconRes;
            this.iconMuteRes = iconMuteRes;
            this.show = show;
        }
    }
}

