/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Build;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseLongArray;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.HashSet;
import java.util.LinkedList;

public class AccessibilityNodeInfoCache {
    private static final String LOG_TAG = AccessibilityNodeInfoCache.class.getSimpleName();
    private static final boolean ENABLED = true;
    private static final boolean DEBUG = false;
    private static final boolean CHECK_INTEGRITY_IF_DEBUGGABLE_BUILD = true;
    private final Object mLock = new Object();
    private final LongSparseArray<AccessibilityNodeInfo> mCacheImpl = new LongSparseArray();
    private int mWindowId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAccessibilityEvent(AccessibilityEvent event) {
        int eventType = event.getEventType();
        switch (eventType) {
            case 32: 
            case 128: 
            case 256: 
            case 1024: {
                int windowId = event.getWindowId();
                if (this.mWindowId == windowId) break;
                this.mWindowId = windowId;
                this.clear();
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 8192: 
            case 32768: 
            case 65536: {
                this.refreshCachedNode(event.getSourceNodeId());
                break;
            }
            case 4096: {
                Object object = this.mLock;
                synchronized (object) {
                    this.clearSubTreeLocked(event.getSourceNodeId());
                    break;
                }
            }
            case 2048: {
                Object object = this.mLock;
                synchronized (object) {
                    long sourceId = event.getSourceNodeId();
                    if ((event.getContentChangeTypes() & 1) != 0) {
                        this.clearSubTreeLocked(sourceId);
                    } else {
                        this.refreshCachedNode(sourceId);
                    }
                    break;
                }
            }
        }
        if (Build.IS_DEBUGGABLE) {
            this.checkIntegrity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCachedNode(long sourceId) {
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityNodeInfo cachedInfo = this.mCacheImpl.get(sourceId);
            if (cachedInfo == null) {
                return;
            }
            if (cachedInfo.refresh(true)) {
                return;
            }
            this.clearSubTreeLocked(sourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo get(long accessibilityNodeId) {
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityNodeInfo info = this.mCacheImpl.get(accessibilityNodeId);
            if (info != null) {
                info = AccessibilityNodeInfo.obtain(info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AccessibilityNodeInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            long sourceId = info.getSourceNodeId();
            AccessibilityNodeInfo oldInfo = this.mCacheImpl.get(sourceId);
            if (oldInfo != null) {
                SparseLongArray oldChildrenIds = oldInfo.getChildNodeIds();
                SparseLongArray newChildrenIds = info.getChildNodeIds();
                int oldChildCount = oldChildrenIds.size();
                for (int i = 0; i < oldChildCount; ++i) {
                    long oldChildId = oldChildrenIds.valueAt(i);
                    if (newChildrenIds.indexOfValue(oldChildId) >= 0) continue;
                    this.clearSubTreeLocked(oldChildId);
                }
                long oldParentId = oldInfo.getParentNodeId();
                if (info.getParentNodeId() != oldParentId) {
                    this.clearSubTreeLocked(oldParentId);
                }
            }
            AccessibilityNodeInfo clone = AccessibilityNodeInfo.obtain(info);
            this.mCacheImpl.put(sourceId, clone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            int nodeCount = this.mCacheImpl.size();
            for (int i = 0; i < nodeCount; ++i) {
                AccessibilityNodeInfo info = this.mCacheImpl.valueAt(i);
                info.recycle();
            }
            this.mCacheImpl.clear();
        }
    }

    private void clearSubTreeLocked(long rootNodeId) {
        this.clearSubTreeRecursiveLocked(rootNodeId);
    }

    private void clearSubTreeRecursiveLocked(long rootNodeId) {
        AccessibilityNodeInfo current = this.mCacheImpl.get(rootNodeId);
        if (current == null) {
            return;
        }
        this.mCacheImpl.remove(rootNodeId);
        SparseLongArray childNodeIds = current.getChildNodeIds();
        int childCount = childNodeIds.size();
        for (int i = 0; i < childCount; ++i) {
            long childNodeId = childNodeIds.valueAt(i);
            this.clearSubTreeRecursiveLocked(childNodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIntegrity() {
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityNodeInfo root;
            if (this.mCacheImpl.size() <= 0) {
                return;
            }
            AccessibilityNodeInfo parent = root = this.mCacheImpl.valueAt(0);
            while (parent != null) {
                root = parent;
                parent = this.mCacheImpl.get(parent.getParentNodeId());
            }
            int windowId = root.getWindowId();
            AccessibilityNodeInfo accessFocus = null;
            AccessibilityNodeInfo inputFocus = null;
            HashSet<AccessibilityNodeInfo> seen = new HashSet<AccessibilityNodeInfo>();
            LinkedList<AccessibilityNodeInfo> fringe = new LinkedList<AccessibilityNodeInfo>();
            fringe.add(root);
            while (!fringe.isEmpty()) {
                AccessibilityNodeInfo current = (AccessibilityNodeInfo)fringe.poll();
                if (!seen.add(current)) {
                    Log.e(LOG_TAG, "Duplicate node: " + current);
                    return;
                }
                if (current.isAccessibilityFocused()) {
                    if (accessFocus != null) {
                        Log.e(LOG_TAG, "Duplicate accessibility focus:" + current);
                    } else {
                        accessFocus = current;
                    }
                }
                if (current.isFocused()) {
                    if (inputFocus != null) {
                        Log.e(LOG_TAG, "Duplicate input focus: " + current);
                    } else {
                        inputFocus = current;
                    }
                }
                SparseLongArray childIds = current.getChildNodeIds();
                int childCount = childIds.size();
                for (int i = 0; i < childCount; ++i) {
                    long childId = childIds.valueAt(i);
                    AccessibilityNodeInfo child = this.mCacheImpl.get(childId);
                    if (child == null) continue;
                    fringe.add(child);
                }
            }
            for (int i = 0; i < this.mCacheImpl.size(); ++i) {
                AccessibilityNodeInfo info = this.mCacheImpl.valueAt(i);
                if (seen.contains(info)) continue;
                if (info.getWindowId() == windowId) {
                    Log.e(LOG_TAG, "Disconneced node: " + info);
                    continue;
                }
                Log.e(LOG_TAG, "Node from: " + info.getWindowId() + " not from:" + windowId + " " + info);
            }
        }
    }
}

