/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.app.PendingIntent;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.UndoManager;
import android.content.UndoOperation;
import android.content.UndoOwner;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.ExtractEditText;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.text.method.KeyListener;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.WordIterator;
import android.text.style.EasyEditSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.URLSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ActionMode;
import android.view.DisplayList;
import android.view.DragEvent;
import android.view.HardwareCanvas;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.SpellChecker;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.ArrayUtils;
import com.android.internal.widget.EditableInputConnection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class Editor {
    private static final String TAG = "Editor";
    static final boolean DEBUG_UNDO = false;
    static final int BLINK = 500;
    private static final float[] TEMP_POSITION = new float[2];
    private static int DRAG_SHADOW_MAX_TEXT_LENGTH = 20;
    UndoManager mUndoManager;
    UndoOwner mUndoOwner;
    InputFilter mUndoInputFilter;
    InsertionPointCursorController mInsertionPointCursorController;
    SelectionModifierCursorController mSelectionModifierCursorController;
    ActionMode mSelectionActionMode;
    boolean mInsertionControllerEnabled;
    boolean mSelectionControllerEnabled;
    CorrectionHighlighter mCorrectionHighlighter;
    InputContentType mInputContentType;
    InputMethodState mInputMethodState;
    DisplayList[] mTextDisplayLists;
    boolean mFrozenWithFocus;
    boolean mSelectionMoved;
    boolean mTouchFocusSelected;
    KeyListener mKeyListener;
    int mInputType = 0;
    boolean mDiscardNextActionUp;
    boolean mIgnoreActionUpEvent;
    long mShowCursor;
    Blink mBlink;
    boolean mCursorVisible = true;
    boolean mSelectAllOnFocus;
    boolean mTextIsSelectable;
    CharSequence mError;
    boolean mErrorWasChanged;
    ErrorPopup mErrorPopup;
    boolean mShowErrorAfterAttach;
    boolean mInBatchEditControllers;
    boolean mShowSoftInputOnFocus = true;
    boolean mPreserveDetachedSelection;
    boolean mTemporaryDetach;
    SuggestionsPopupWindow mSuggestionsPopupWindow;
    SuggestionRangeSpan mSuggestionRangeSpan;
    Runnable mShowSuggestionRunnable;
    final Drawable[] mCursorDrawable = new Drawable[2];
    int mCursorCount;
    private Drawable mSelectHandleLeft;
    private Drawable mSelectHandleRight;
    private Drawable mSelectHandleCenter;
    private PositionListener mPositionListener;
    float mLastDownPositionX;
    float mLastDownPositionY;
    ActionMode.Callback mCustomSelectionActionModeCallback;
    boolean mCreatedWithASelection;
    private SpanController mSpanController;
    WordIterator mWordIterator;
    SpellChecker mSpellChecker;
    private Rect mTempRect;
    private TextView mTextView;
    static final int EXTRACT_NOTHING = -2;
    static final int EXTRACT_UNKNOWN = -1;

    Editor(TextView textView) {
        this.mTextView = textView;
    }

    void onAttachedToWindow() {
        if (this.mShowErrorAfterAttach) {
            this.showError();
            this.mShowErrorAfterAttach = false;
        }
        this.mTemporaryDetach = false;
        ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
        if (this.mInsertionPointCursorController != null) {
            observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.resetTouchOffsets();
            observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        this.updateSpellCheckSpans(0, this.mTextView.getText().length(), true);
        if (this.mTextView.hasTransientState() && this.mTextView.getSelectionStart() != this.mTextView.getSelectionEnd()) {
            this.mTextView.setHasTransientState(false);
            this.startSelectionActionMode();
        }
    }

    void onDetachedFromWindow() {
        if (this.mError != null) {
            this.hideError();
        }
        if (this.mBlink != null) {
            this.mBlink.removeCallbacks(this.mBlink);
        }
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.onDetached();
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.onDetached();
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
        }
        this.invalidateTextDisplayList();
        if (this.mSpellChecker != null) {
            this.mSpellChecker.closeSession();
            this.mSpellChecker = null;
        }
        this.mPreserveDetachedSelection = true;
        this.hideControllers();
        this.mPreserveDetachedSelection = false;
        this.mTemporaryDetach = false;
    }

    private void showError() {
        if (this.mTextView.getWindowToken() == null) {
            this.mShowErrorAfterAttach = true;
            return;
        }
        if (this.mErrorPopup == null) {
            LayoutInflater inflater = LayoutInflater.from(this.mTextView.getContext());
            TextView err = (TextView)inflater.inflate(17367217, null);
            float scale = this.mTextView.getResources().getDisplayMetrics().density;
            this.mErrorPopup = new ErrorPopup(err, (int)(200.0f * scale + 0.5f), (int)(50.0f * scale + 0.5f));
            this.mErrorPopup.setFocusable(false);
            this.mErrorPopup.setInputMethodMode(1);
        }
        TextView tv = (TextView)this.mErrorPopup.getContentView();
        this.chooseSize(this.mErrorPopup, this.mError, tv);
        tv.setText(this.mError);
        this.mErrorPopup.showAsDropDown(this.mTextView, this.getErrorX(), this.getErrorY());
        this.mErrorPopup.fixDirection(this.mErrorPopup.isAboveAnchor());
    }

    public void setError(CharSequence error, Drawable icon) {
        this.mError = TextUtils.stringOrSpannedString(error);
        this.mErrorWasChanged = true;
        if (this.mError == null) {
            this.setErrorIcon(null);
            if (this.mErrorPopup != null) {
                if (this.mErrorPopup.isShowing()) {
                    this.mErrorPopup.dismiss();
                }
                this.mErrorPopup = null;
            }
            this.mShowErrorAfterAttach = false;
        } else {
            this.setErrorIcon(icon);
            if (this.mTextView.isFocused()) {
                this.showError();
            }
        }
    }

    private void setErrorIcon(Drawable icon) {
        TextView.Drawables dr = this.mTextView.mDrawables;
        if (dr == null) {
            this.mTextView.mDrawables = dr = new TextView.Drawables(this.mTextView.getContext());
        }
        dr.setErrorDrawable(icon, this.mTextView);
        this.mTextView.resetResolvedDrawables();
        this.mTextView.invalidate();
        this.mTextView.requestLayout();
    }

    private void hideError() {
        if (this.mErrorPopup != null && this.mErrorPopup.isShowing()) {
            this.mErrorPopup.dismiss();
        }
        this.mShowErrorAfterAttach = false;
    }

    private int getErrorX() {
        int errorX;
        float scale = this.mTextView.getResources().getDisplayMetrics().density;
        TextView.Drawables dr = this.mTextView.mDrawables;
        int layoutDirection = this.mTextView.getLayoutDirection();
        switch (layoutDirection) {
            default: {
                int offset = -(dr != null ? dr.mDrawableSizeRight : 0) / 2 + (int)(25.0f * scale + 0.5f);
                errorX = this.mTextView.getWidth() - this.mErrorPopup.getWidth() - this.mTextView.getPaddingRight() + offset;
                break;
            }
            case 1: {
                int offset = (dr != null ? dr.mDrawableSizeLeft : 0) / 2 - (int)(25.0f * scale + 0.5f);
                errorX = this.mTextView.getPaddingLeft() + offset;
            }
        }
        return errorX;
    }

    private int getErrorY() {
        int height;
        int compoundPaddingTop = this.mTextView.getCompoundPaddingTop();
        int vspace = this.mTextView.getBottom() - this.mTextView.getTop() - this.mTextView.getCompoundPaddingBottom() - compoundPaddingTop;
        TextView.Drawables dr = this.mTextView.mDrawables;
        int layoutDirection = this.mTextView.getLayoutDirection();
        switch (layoutDirection) {
            default: {
                height = dr != null ? dr.mDrawableHeightRight : 0;
                break;
            }
            case 1: {
                height = dr != null ? dr.mDrawableHeightLeft : 0;
            }
        }
        int icontop = compoundPaddingTop + (vspace - height) / 2;
        float scale = this.mTextView.getResources().getDisplayMetrics().density;
        return icontop + height - this.mTextView.getHeight() - (int)(2.0f * scale + 0.5f);
    }

    void createInputContentTypeIfNeeded() {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
    }

    void createInputMethodStateIfNeeded() {
        if (this.mInputMethodState == null) {
            this.mInputMethodState = new InputMethodState();
        }
    }

    boolean isCursorVisible() {
        return this.mCursorVisible && this.mTextView.isTextEditable();
    }

    void prepareCursorControllers() {
        boolean windowSupportsHandles = false;
        ViewGroup.LayoutParams params = this.mTextView.getRootView().getLayoutParams();
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams windowParams = (WindowManager.LayoutParams)params;
            windowSupportsHandles = windowParams.type < 1000 || windowParams.type > 1999;
        }
        boolean enabled = windowSupportsHandles && this.mTextView.getLayout() != null;
        this.mInsertionControllerEnabled = enabled && this.isCursorVisible();
        boolean bl = this.mSelectionControllerEnabled = enabled && this.mTextView.textCanBeSelected();
        if (!this.mInsertionControllerEnabled) {
            this.hideInsertionPointCursorController();
            if (this.mInsertionPointCursorController != null) {
                this.mInsertionPointCursorController.onDetached();
                this.mInsertionPointCursorController = null;
            }
        }
        if (!this.mSelectionControllerEnabled) {
            this.stopSelectionActionMode();
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.onDetached();
                this.mSelectionModifierCursorController = null;
            }
        }
    }

    private void hideInsertionPointCursorController() {
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.hide();
        }
    }

    void hideControllers() {
        this.hideCursorControllers();
        this.hideSpanControllers();
    }

    private void hideSpanControllers() {
        if (this.mSpanController != null) {
            this.mSpanController.hide();
        }
    }

    private void hideCursorControllers() {
        if (this.mSuggestionsPopupWindow != null && !this.mSuggestionsPopupWindow.isShowingUp()) {
            this.mSuggestionsPopupWindow.hide();
        }
        this.hideInsertionPointCursorController();
        this.stopSelectionActionMode();
    }

    private void updateSpellCheckSpans(int start, int end, boolean createSpellChecker) {
        this.mTextView.removeAdjacentSuggestionSpans(start);
        this.mTextView.removeAdjacentSuggestionSpans(end);
        if (this.mTextView.isTextEditable() && this.mTextView.isSuggestionsEnabled() && !(this.mTextView instanceof ExtractEditText)) {
            if (this.mSpellChecker == null && createSpellChecker) {
                this.mSpellChecker = new SpellChecker(this.mTextView);
            }
            if (this.mSpellChecker != null) {
                this.mSpellChecker.spellCheck(start, end);
            }
        }
    }

    void onScreenStateChanged(int screenState) {
        switch (screenState) {
            case 1: {
                this.resumeBlink();
                break;
            }
            case 0: {
                this.suspendBlink();
            }
        }
    }

    private void suspendBlink() {
        if (this.mBlink != null) {
            this.mBlink.cancel();
        }
    }

    private void resumeBlink() {
        if (this.mBlink != null) {
            this.mBlink.uncancel();
            this.makeBlink();
        }
    }

    void adjustInputType(boolean password, boolean passwordInputType, boolean webPasswordInputType, boolean numberPasswordInputType) {
        if ((this.mInputType & 0xF) == 1) {
            if (password || passwordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0x80;
            }
            if (webPasswordInputType) {
                this.mInputType = this.mInputType & 0xFFFFF00F | 0xE0;
            }
        } else if ((this.mInputType & 0xF) == 2 && numberPasswordInputType) {
            this.mInputType = this.mInputType & 0xFFFFF00F | 0x10;
        }
    }

    private void chooseSize(PopupWindow pop, CharSequence text, TextView tv) {
        int wid = tv.getPaddingLeft() + tv.getPaddingRight();
        int ht = tv.getPaddingTop() + tv.getPaddingBottom();
        int defaultWidthInPixels = this.mTextView.getResources().getDimensionPixelSize(17104974);
        StaticLayout l = new StaticLayout(text, tv.getPaint(), defaultWidthInPixels, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        float max = 0.0f;
        for (int i = 0; i < ((Layout)l).getLineCount(); ++i) {
            max = Math.max(max, l.getLineWidth(i));
        }
        pop.setWidth(wid + (int)Math.ceil(max));
        pop.setHeight(ht + l.getHeight());
    }

    void setFrame() {
        if (this.mErrorPopup != null) {
            TextView tv = (TextView)this.mErrorPopup.getContentView();
            this.chooseSize(this.mErrorPopup, this.mError, tv);
            this.mErrorPopup.update(this.mTextView, this.getErrorX(), this.getErrorY(), this.mErrorPopup.getWidth(), this.mErrorPopup.getHeight());
        }
    }

    private boolean canSelectText() {
        return this.hasSelectionController() && this.mTextView.getText().length() != 0;
    }

    private boolean hasPasswordTransformationMethod() {
        return this.mTextView.getTransformationMethod() instanceof PasswordTransformationMethod;
    }

    private boolean selectCurrentWord() {
        int selectionEnd;
        int selectionStart;
        if (!this.canSelectText()) {
            return false;
        }
        if (this.hasPasswordTransformationMethod()) {
            return this.mTextView.selectAllText();
        }
        int inputType = this.mTextView.getInputType();
        int klass = inputType & 0xF;
        int variation = inputType & 0xFF0;
        if (klass == 2 || klass == 3 || klass == 4 || variation == 16 || variation == 32 || variation == 208 || variation == 176) {
            return this.mTextView.selectAllText();
        }
        long lastTouchOffsets = this.getLastTouchOffsets();
        int minOffset = TextUtils.unpackRangeStartFromLong(lastTouchOffsets);
        int maxOffset = TextUtils.unpackRangeEndFromLong(lastTouchOffsets);
        if (minOffset < 0 || minOffset >= this.mTextView.getText().length()) {
            return false;
        }
        if (maxOffset < 0 || maxOffset >= this.mTextView.getText().length()) {
            return false;
        }
        URLSpan[] urlSpans = ((Spanned)this.mTextView.getText()).getSpans(minOffset, maxOffset, URLSpan.class);
        if (urlSpans.length >= 1) {
            URLSpan urlSpan = urlSpans[0];
            selectionStart = ((Spanned)this.mTextView.getText()).getSpanStart(urlSpan);
            selectionEnd = ((Spanned)this.mTextView.getText()).getSpanEnd(urlSpan);
        } else {
            WordIterator wordIterator = this.getWordIterator();
            wordIterator.setCharSequence(this.mTextView.getText(), minOffset, maxOffset);
            selectionStart = wordIterator.getBeginning(minOffset);
            selectionEnd = wordIterator.getEnd(maxOffset);
            if (selectionStart == -1 || selectionEnd == -1 || selectionStart == selectionEnd) {
                long range = this.getCharRange(minOffset);
                selectionStart = TextUtils.unpackRangeStartFromLong(range);
                selectionEnd = TextUtils.unpackRangeEndFromLong(range);
            }
        }
        Selection.setSelection((Spannable)this.mTextView.getText(), selectionStart, selectionEnd);
        return selectionEnd > selectionStart;
    }

    void onLocaleChanged() {
        this.mWordIterator = null;
    }

    public WordIterator getWordIterator() {
        if (this.mWordIterator == null) {
            this.mWordIterator = new WordIterator(this.mTextView.getTextServicesLocale());
        }
        return this.mWordIterator;
    }

    private long getCharRange(int offset) {
        char nextChar;
        char currentChar;
        int textLength = this.mTextView.getText().length();
        if (offset + 1 < textLength && Character.isSurrogatePair(currentChar = this.mTextView.getText().charAt(offset), nextChar = this.mTextView.getText().charAt(offset + 1))) {
            return TextUtils.packRangeInLong(offset, offset + 2);
        }
        if (offset < textLength) {
            return TextUtils.packRangeInLong(offset, offset + 1);
        }
        if (offset - 2 >= 0) {
            char previousChar = this.mTextView.getText().charAt(offset - 1);
            char previousPreviousChar = this.mTextView.getText().charAt(offset - 2);
            if (Character.isSurrogatePair(previousPreviousChar, previousChar)) {
                return TextUtils.packRangeInLong(offset - 2, offset);
            }
        }
        if (offset - 1 >= 0) {
            return TextUtils.packRangeInLong(offset - 1, offset);
        }
        return TextUtils.packRangeInLong(offset, offset);
    }

    private boolean touchPositionIsInSelection() {
        int selectionEnd;
        int selectionStart = this.mTextView.getSelectionStart();
        if (selectionStart == (selectionEnd = this.mTextView.getSelectionEnd())) {
            return false;
        }
        if (selectionStart > selectionEnd) {
            int tmp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = tmp;
            Selection.setSelection((Spannable)this.mTextView.getText(), selectionStart, selectionEnd);
        }
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return minOffset >= selectionStart && maxOffset < selectionEnd;
    }

    private PositionListener getPositionListener() {
        if (this.mPositionListener == null) {
            this.mPositionListener = new PositionListener();
        }
        return this.mPositionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPositionVisible(int positionX, int positionY) {
        float[] fArray = TEMP_POSITION;
        synchronized (TEMP_POSITION) {
            float[] position = TEMP_POSITION;
            position[0] = positionX;
            position[1] = positionY;
            View view = this.mTextView;
            while (view != null) {
                if (view != this.mTextView) {
                    position[0] = position[0] - (float)view.getScrollX();
                    position[1] = position[1] - (float)view.getScrollY();
                }
                if (position[0] < 0.0f || position[1] < 0.0f || position[0] > (float)view.getWidth() || position[1] > (float)view.getHeight()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                if (!view.getMatrix().isIdentity()) {
                    view.getMatrix().mapPoints(position);
                }
                position[0] = position[0] + (float)view.getLeft();
                position[1] = position[1] + (float)view.getTop();
                ViewParent parent = view.getParent();
                if (parent instanceof View) {
                    view = (View)((Object)parent);
                    continue;
                }
                view = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    private boolean isOffsetVisible(int offset) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return false;
        }
        int line = layout2.getLineForOffset(offset);
        int lineBottom = layout2.getLineBottom(line);
        int primaryHorizontal = (int)layout2.getPrimaryHorizontal(offset);
        return this.isPositionVisible(primaryHorizontal + this.mTextView.viewportToContentHorizontalOffset(), lineBottom + this.mTextView.viewportToContentVerticalOffset());
    }

    private boolean isPositionOnText(float x, float y) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return false;
        }
        int line = this.mTextView.getLineAtCoordinate(y);
        if ((x = this.mTextView.convertToLocalHorizontalCoordinate(x)) < layout2.getLineLeft(line)) {
            return false;
        }
        return !(x > layout2.getLineRight(line));
    }

    public boolean performLongClick(boolean handled) {
        if (!handled && !this.isPositionOnText(this.mLastDownPositionX, this.mLastDownPositionY) && this.mInsertionControllerEnabled) {
            int offset = this.mTextView.getOffsetForPosition(this.mLastDownPositionX, this.mLastDownPositionY);
            this.stopSelectionActionMode();
            Selection.setSelection((Spannable)this.mTextView.getText(), offset);
            this.getInsertionController().showWithActionPopup();
            handled = true;
        }
        if (!handled && this.mSelectionActionMode != null) {
            if (this.touchPositionIsInSelection()) {
                int start = this.mTextView.getSelectionStart();
                int end = this.mTextView.getSelectionEnd();
                CharSequence selectedText = this.mTextView.getTransformedText(start, end);
                ClipData data = ClipData.newPlainText(null, selectedText);
                DragLocalState localState = new DragLocalState(this.mTextView, start, end);
                this.mTextView.startDrag(data, this.getTextThumbnailBuilder(selectedText), localState, 0);
                this.stopSelectionActionMode();
            } else {
                this.getSelectionController().hide();
                this.selectCurrentWord();
                this.getSelectionController().show();
            }
            handled = true;
        }
        if (!handled) {
            handled = this.startSelectionActionMode();
        }
        return handled;
    }

    private long getLastTouchOffsets() {
        SelectionModifierCursorController selectionController = this.getSelectionController();
        int minOffset = selectionController.getMinTouchOffset();
        int maxOffset = selectionController.getMaxTouchOffset();
        return TextUtils.packRangeInLong(minOffset, maxOffset);
    }

    void onFocusChanged(boolean focused, int direction) {
        this.mShowCursor = SystemClock.uptimeMillis();
        this.ensureEndedBatchEdit();
        if (focused) {
            int selStart = this.mTextView.getSelectionStart();
            int selEnd = this.mTextView.getSelectionEnd();
            boolean isFocusHighlighted = this.mSelectAllOnFocus && selStart == 0 && selEnd == this.mTextView.getText().length();
            boolean bl = this.mCreatedWithASelection = this.mFrozenWithFocus && this.mTextView.hasSelection() && !isFocusHighlighted;
            if (!this.mFrozenWithFocus || selStart < 0 || selEnd < 0) {
                MovementMethod mMovement;
                int lastTapPosition = this.getLastTapPosition();
                if (lastTapPosition >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), lastTapPosition);
                }
                if ((mMovement = this.mTextView.getMovementMethod()) != null) {
                    mMovement.onTakeFocus(this.mTextView, (Spannable)this.mTextView.getText(), direction);
                }
                if ((this.mTextView instanceof ExtractEditText || this.mSelectionMoved) && selStart >= 0 && selEnd >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), selStart, selEnd);
                }
                if (this.mSelectAllOnFocus) {
                    this.mTextView.selectAllText();
                }
                this.mTouchFocusSelected = true;
            }
            this.mFrozenWithFocus = false;
            this.mSelectionMoved = false;
            if (this.mError != null) {
                this.showError();
            }
            this.makeBlink();
        } else {
            if (this.mError != null) {
                this.hideError();
            }
            this.mTextView.onEndBatchEdit();
            if (this.mTextView instanceof ExtractEditText) {
                int selStart = this.mTextView.getSelectionStart();
                int selEnd = this.mTextView.getSelectionEnd();
                this.hideControllers();
                Selection.setSelection((Spannable)this.mTextView.getText(), selStart, selEnd);
            } else {
                if (this.mTemporaryDetach) {
                    this.mPreserveDetachedSelection = true;
                }
                this.hideControllers();
                if (this.mTemporaryDetach) {
                    this.mPreserveDetachedSelection = false;
                }
                this.downgradeEasyCorrectionSpans();
            }
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.resetTouchOffsets();
            }
        }
    }

    private void downgradeEasyCorrectionSpans() {
        CharSequence text = this.mTextView.getText();
        if (text instanceof Spannable) {
            Spannable spannable = (Spannable)text;
            SuggestionSpan[] suggestionSpans = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
            for (int i = 0; i < suggestionSpans.length; ++i) {
                int flags = suggestionSpans[i].getFlags();
                if ((flags & 1) == 0 || (flags & 2) != 0) continue;
                suggestionSpans[i].setFlags(flags &= 0xFFFFFFFE);
            }
        }
    }

    void sendOnTextChanged(int start, int after) {
        this.updateSpellCheckSpans(start, start + after, false);
        this.hideCursorControllers();
    }

    private int getLastTapPosition() {
        int lastTapPosition;
        if (this.mSelectionModifierCursorController != null && (lastTapPosition = this.mSelectionModifierCursorController.getMinTouchOffset()) >= 0) {
            if (lastTapPosition > this.mTextView.getText().length()) {
                lastTapPosition = this.mTextView.getText().length();
            }
            return lastTapPosition;
        }
        return -1;
    }

    void onWindowFocusChanged(boolean hasWindowFocus) {
        if (hasWindowFocus) {
            if (this.mBlink != null) {
                this.mBlink.uncancel();
                this.makeBlink();
            }
        } else {
            if (this.mBlink != null) {
                this.mBlink.cancel();
            }
            if (this.mInputContentType != null) {
                this.mInputContentType.enterDown = false;
            }
            this.hideControllers();
            if (this.mSuggestionsPopupWindow != null) {
                this.mSuggestionsPopupWindow.onParentLostFocus();
            }
            this.ensureEndedBatchEdit();
        }
    }

    void onTouchEvent(MotionEvent event) {
        if (this.hasSelectionController()) {
            this.getSelectionController().onTouchEvent(event);
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
            this.mShowSuggestionRunnable = null;
        }
        if (event.getActionMasked() == 0) {
            this.mLastDownPositionX = event.getX();
            this.mLastDownPositionY = event.getY();
            this.mTouchFocusSelected = false;
            this.mIgnoreActionUpEvent = false;
        }
    }

    public void beginBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = true;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = ++ims.mBatchEditNesting) == 1) {
            ims.mCursorChanged = false;
            ims.mChangedDelta = 0;
            if (ims.mContentChanged) {
                ims.mChangedStart = 0;
                ims.mChangedEnd = this.mTextView.getText().length();
            } else {
                ims.mChangedStart = -1;
                ims.mChangedEnd = -1;
                ims.mContentChanged = false;
            }
            this.mTextView.onBeginBatchEdit();
        }
    }

    public void endBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = false;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = --ims.mBatchEditNesting) == 0) {
            this.finishBatchEdit(ims);
        }
    }

    void ensureEndedBatchEdit() {
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting != 0) {
            ims.mBatchEditNesting = 0;
            this.finishBatchEdit(ims);
        }
    }

    void finishBatchEdit(InputMethodState ims) {
        this.mTextView.onEndBatchEdit();
        if (ims.mContentChanged || ims.mSelectionModeChanged) {
            this.mTextView.updateAfterEdit();
            this.reportExtractedText();
        } else if (ims.mCursorChanged) {
            this.mTextView.invalidateCursor();
        }
        this.sendUpdateSelection();
    }

    boolean extractText(ExtractedTextRequest request, ExtractedText outText) {
        return this.extractTextInternal(request, -1, -1, -1, outText);
    }

    private boolean extractTextInternal(ExtractedTextRequest request, int partialStartOffset, int partialEndOffset, int delta, ExtractedText outText) {
        CharSequence content = this.mTextView.getText();
        if (content != null) {
            if (partialStartOffset != -2) {
                int N = content.length();
                if (partialStartOffset < 0) {
                    outText.partialEndOffset = -1;
                    outText.partialStartOffset = -1;
                    partialStartOffset = 0;
                    partialEndOffset = N;
                } else {
                    partialEndOffset += delta;
                    if (content instanceof Spanned) {
                        Spanned spanned = (Spanned)content;
                        ParcelableSpan[] spans = spanned.getSpans(partialStartOffset, partialEndOffset, ParcelableSpan.class);
                        int i = spans.length;
                        while (i > 0) {
                            int j;
                            if ((j = spanned.getSpanStart(spans[--i])) < partialStartOffset) {
                                partialStartOffset = j;
                            }
                            if ((j = spanned.getSpanEnd(spans[i])) <= partialEndOffset) continue;
                            partialEndOffset = j;
                        }
                    }
                    outText.partialStartOffset = partialStartOffset;
                    outText.partialEndOffset = partialEndOffset - delta;
                    if (partialStartOffset > N) {
                        partialStartOffset = N;
                    } else if (partialStartOffset < 0) {
                        partialStartOffset = 0;
                    }
                    if (partialEndOffset > N) {
                        partialEndOffset = N;
                    } else if (partialEndOffset < 0) {
                        partialEndOffset = 0;
                    }
                }
                outText.text = (request.flags & 1) != 0 ? content.subSequence(partialStartOffset, partialEndOffset) : TextUtils.substring(content, partialStartOffset, partialEndOffset);
            } else {
                outText.partialStartOffset = 0;
                outText.partialEndOffset = 0;
                outText.text = "";
            }
            outText.flags = 0;
            if (MetaKeyKeyListener.getMetaState(content, 2048) != 0) {
                outText.flags |= 2;
            }
            if (this.mTextView.isSingleLine()) {
                outText.flags |= 1;
            }
            outText.startOffset = 0;
            outText.selectionStart = this.mTextView.getSelectionStart();
            outText.selectionEnd = this.mTextView.getSelectionEnd();
            return true;
        }
        return false;
    }

    boolean reportExtractedText() {
        boolean contentChanged;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ((contentChanged = ims.mContentChanged) || ims.mSelectionModeChanged)) {
            InputMethodManager imm;
            ims.mContentChanged = false;
            ims.mSelectionModeChanged = false;
            ExtractedTextRequest req = ims.mExtractedTextRequest;
            if (req != null && (imm = InputMethodManager.peekInstance()) != null) {
                if (ims.mChangedStart < 0 && !contentChanged) {
                    ims.mChangedStart = -2;
                }
                if (this.extractTextInternal(req, ims.mChangedStart, ims.mChangedEnd, ims.mChangedDelta, ims.mExtractedText)) {
                    imm.updateExtractedText(this.mTextView, req.token, ims.mExtractedText);
                    ims.mChangedStart = -1;
                    ims.mChangedEnd = -1;
                    ims.mChangedDelta = 0;
                    ims.mContentChanged = false;
                    return true;
                }
            }
        }
        return false;
    }

    private void sendUpdateSelection() {
        InputMethodManager imm;
        if (null != this.mInputMethodState && this.mInputMethodState.mBatchEditNesting <= 0 && null != (imm = InputMethodManager.peekInstance())) {
            int selectionStart = this.mTextView.getSelectionStart();
            int selectionEnd = this.mTextView.getSelectionEnd();
            int candStart = -1;
            int candEnd = -1;
            if (this.mTextView.getText() instanceof Spannable) {
                Spannable sp = (Spannable)this.mTextView.getText();
                candStart = EditableInputConnection.getComposingSpanStart(sp);
                candEnd = EditableInputConnection.getComposingSpanEnd(sp);
            }
            imm.updateSelection(this.mTextView, selectionStart, selectionEnd, candStart, candEnd);
        }
    }

    void onDraw(Canvas canvas, Layout layout2, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        InputMethodManager imm;
        int selectionStart = this.mTextView.getSelectionStart();
        int selectionEnd = this.mTextView.getSelectionEnd();
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting == 0 && (imm = InputMethodManager.peekInstance()) != null) {
            if (imm.isActive(this.mTextView)) {
                boolean reported = false;
                if (ims.mContentChanged || ims.mSelectionModeChanged) {
                    reported = this.reportExtractedText();
                }
            }
            if (imm.isWatchingCursor(this.mTextView) && highlight != null) {
                highlight.computeBounds(ims.mTmpRectF, true);
                ims.mTmpOffset[1] = 0.0f;
                ims.mTmpOffset[0] = 0.0f;
                canvas.getMatrix().mapPoints(ims.mTmpOffset);
                ims.mTmpRectF.offset(ims.mTmpOffset[0], ims.mTmpOffset[1]);
                ims.mTmpRectF.offset(0.0f, cursorOffsetVertical);
                ims.mCursorRectInWindow.set((int)((double)ims.mTmpRectF.left + 0.5), (int)((double)ims.mTmpRectF.top + 0.5), (int)((double)ims.mTmpRectF.right + 0.5), (int)((double)ims.mTmpRectF.bottom + 0.5));
                imm.updateCursor(this.mTextView, ims.mCursorRectInWindow.left, ims.mCursorRectInWindow.top, ims.mCursorRectInWindow.right, ims.mCursorRectInWindow.bottom);
            }
        }
        if (this.mCorrectionHighlighter != null) {
            this.mCorrectionHighlighter.draw(canvas, cursorOffsetVertical);
        }
        if (highlight != null && selectionStart == selectionEnd && this.mCursorCount > 0) {
            this.drawCursor(canvas, cursorOffsetVertical);
            highlight = null;
        }
        if (this.mTextView.canHaveDisplayList() && canvas.isHardwareAccelerated()) {
            this.drawHardwareAccelerated(canvas, layout2, highlight, highlightPaint, cursorOffsetVertical);
        } else {
            layout2.draw(canvas, highlight, highlightPaint, cursorOffsetVertical);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawHardwareAccelerated(Canvas canvas, Layout layout2, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        long lineRange = layout2.getLineRangeForDraw(canvas);
        int firstLine = TextUtils.unpackRangeStartFromLong(lineRange);
        int lastLine = TextUtils.unpackRangeEndFromLong(lineRange);
        if (lastLine < 0) {
            return;
        }
        layout2.drawBackground(canvas, highlight, highlightPaint, cursorOffsetVertical, firstLine, lastLine);
        if (layout2 instanceof DynamicLayout) {
            if (this.mTextDisplayLists == null) {
                this.mTextDisplayLists = new DisplayList[ArrayUtils.idealObjectArraySize(0)];
            }
            DynamicLayout dynamicLayout = (DynamicLayout)layout2;
            int[] blockEndLines = dynamicLayout.getBlockEndLines();
            int[] blockIndices = dynamicLayout.getBlockIndices();
            int numberOfBlocks = dynamicLayout.getNumberOfBlocks();
            int indexFirstChangedBlock = dynamicLayout.getIndexFirstChangedBlock();
            int endOfPreviousBlock = -1;
            int searchStartIndex = 0;
            for (int i = 0; i < numberOfBlocks; ++i) {
                boolean blockDisplayListIsInvalid;
                DisplayList blockDisplayList;
                boolean blockIsInvalid;
                int blockEndLine = blockEndLines[i];
                int blockIndex = blockIndices[i];
                boolean bl = blockIsInvalid = blockIndex == -1;
                if (blockIsInvalid) {
                    blockIndices[i] = blockIndex = this.getAvailableDisplayListIndex(blockIndices, numberOfBlocks, searchStartIndex);
                    searchStartIndex = blockIndex + 1;
                }
                if ((blockDisplayList = this.mTextDisplayLists[blockIndex]) == null) {
                    blockDisplayList = this.mTextDisplayLists[blockIndex] = this.mTextView.getHardwareRenderer().createDisplayList("Text " + blockIndex);
                } else if (blockIsInvalid) {
                    blockDisplayList.clear();
                }
                boolean bl2 = blockDisplayListIsInvalid = !blockDisplayList.isValid();
                if (i >= indexFirstChangedBlock || blockDisplayListIsInvalid) {
                    int blockBeginLine = endOfPreviousBlock + 1;
                    int top = layout2.getLineTop(blockBeginLine);
                    int bottom = layout2.getLineBottom(blockEndLine);
                    int left = 0;
                    int right = this.mTextView.getWidth();
                    if (this.mTextView.getHorizontallyScrolling()) {
                        float min = Float.MAX_VALUE;
                        float max = Float.MIN_VALUE;
                        for (int line = blockBeginLine; line <= blockEndLine; ++line) {
                            min = Math.min(min, layout2.getLineLeft(line));
                            max = Math.max(max, layout2.getLineRight(line));
                        }
                        left = (int)min;
                        right = (int)(max + 0.5f);
                    }
                    if (blockDisplayListIsInvalid) {
                        HardwareCanvas hardwareCanvas = blockDisplayList.start(right - left, bottom - top);
                        try {
                            hardwareCanvas.translate(-left, -top);
                            layout2.drawText(hardwareCanvas, blockBeginLine, blockEndLine);
                        }
                        finally {
                            blockDisplayList.end();
                            blockDisplayList.setClipToBounds(false);
                        }
                    }
                    blockDisplayList.setLeftTopRightBottom(left, top, right, bottom);
                }
                ((HardwareCanvas)canvas).drawDisplayList(blockDisplayList, null, 0);
                endOfPreviousBlock = blockEndLine;
            }
            dynamicLayout.setIndexFirstChangedBlock(numberOfBlocks);
        } else {
            layout2.drawText(canvas, firstLine, lastLine);
        }
    }

    private int getAvailableDisplayListIndex(int[] blockIndices, int numberOfBlocks, int searchStartIndex) {
        int length = this.mTextDisplayLists.length;
        for (int i = searchStartIndex; i < length; ++i) {
            boolean blockIndexFound = false;
            for (int j = 0; j < numberOfBlocks; ++j) {
                if (blockIndices[j] != i) continue;
                blockIndexFound = true;
                break;
            }
            if (blockIndexFound) continue;
            return i;
        }
        int newSize = ArrayUtils.idealIntArraySize(length + 1);
        DisplayList[] displayLists = new DisplayList[newSize];
        System.arraycopy(this.mTextDisplayLists, 0, displayLists, 0, length);
        this.mTextDisplayLists = displayLists;
        return length;
    }

    private void drawCursor(Canvas canvas, int cursorOffsetVertical) {
        boolean translate;
        boolean bl = translate = cursorOffsetVertical != 0;
        if (translate) {
            canvas.translate(0.0f, cursorOffsetVertical);
        }
        for (int i = 0; i < this.mCursorCount; ++i) {
            this.mCursorDrawable[i].draw(canvas);
        }
        if (translate) {
            canvas.translate(0.0f, -cursorOffsetVertical);
        }
    }

    void invalidateTextDisplayList(Layout layout2, int start, int end) {
        if (this.mTextDisplayLists != null && layout2 instanceof DynamicLayout) {
            int i;
            int firstLine = layout2.getLineForOffset(start);
            int lastLine = layout2.getLineForOffset(end);
            DynamicLayout dynamicLayout = (DynamicLayout)layout2;
            int[] blockEndLines = dynamicLayout.getBlockEndLines();
            int[] blockIndices = dynamicLayout.getBlockIndices();
            int numberOfBlocks = dynamicLayout.getNumberOfBlocks();
            for (i = 0; i < numberOfBlocks && blockEndLines[i] < firstLine; ++i) {
            }
            while (i < numberOfBlocks) {
                int blockIndex = blockIndices[i];
                if (blockIndex != -1) {
                    this.mTextDisplayLists[blockIndex].clear();
                }
                if (blockEndLines[i] >= lastLine) break;
                ++i;
            }
        }
    }

    void invalidateTextDisplayList() {
        if (this.mTextDisplayLists != null) {
            for (int i = 0; i < this.mTextDisplayLists.length; ++i) {
                if (this.mTextDisplayLists[i] == null) continue;
                this.mTextDisplayLists[i].clear();
            }
        }
    }

    void updateCursorsPositions() {
        if (this.mTextView.mCursorDrawableRes == 0) {
            this.mCursorCount = 0;
            return;
        }
        Layout layout2 = this.mTextView.getLayout();
        Layout hintLayout = this.mTextView.getHintLayout();
        int offset = this.mTextView.getSelectionStart();
        int line = layout2.getLineForOffset(offset);
        int top = layout2.getLineTop(line);
        int bottom = layout2.getLineTop(line + 1);
        this.mCursorCount = layout2.isLevelBoundary(offset) ? 2 : 1;
        int middle = bottom;
        if (this.mCursorCount == 2) {
            middle = top + bottom >> 1;
        }
        boolean clamped = layout2.shouldClampCursor(line);
        this.updateCursorPosition(0, top, middle, this.getPrimaryHorizontal(layout2, hintLayout, offset, clamped));
        if (this.mCursorCount == 2) {
            this.updateCursorPosition(1, middle, bottom, layout2.getSecondaryHorizontal(offset, clamped));
        }
    }

    private float getPrimaryHorizontal(Layout layout2, Layout hintLayout, int offset, boolean clamped) {
        if (TextUtils.isEmpty(layout2.getText()) && hintLayout != null && !TextUtils.isEmpty(hintLayout.getText())) {
            return hintLayout.getPrimaryHorizontal(offset, clamped);
        }
        return layout2.getPrimaryHorizontal(offset, clamped);
    }

    boolean startSelectionActionMode() {
        InputMethodManager imm;
        boolean selectionStarted;
        if (this.mSelectionActionMode != null) {
            return false;
        }
        if (!this.canSelectText() || !this.mTextView.requestFocus()) {
            Log.w("TextView", "TextView does not support text selection. Action mode cancelled.");
            return false;
        }
        if (!this.mTextView.hasSelection() && !this.selectCurrentWord()) {
            return false;
        }
        boolean willExtract = this.extractedTextModeWillBeStarted();
        if (!willExtract) {
            SelectionActionModeCallback actionModeCallback = new SelectionActionModeCallback();
            this.mSelectionActionMode = this.mTextView.startActionMode(actionModeCallback);
        }
        boolean bl = selectionStarted = this.mSelectionActionMode != null || willExtract;
        if (selectionStarted && !this.mTextView.isTextSelectable() && this.mShowSoftInputOnFocus && (imm = InputMethodManager.peekInstance()) != null) {
            imm.showSoftInput(this.mTextView, 0, null);
        }
        return selectionStarted;
    }

    private boolean extractedTextModeWillBeStarted() {
        if (!(this.mTextView instanceof ExtractEditText)) {
            InputMethodManager imm = InputMethodManager.peekInstance();
            return imm != null && imm.isFullscreenMode();
        }
        return false;
    }

    private boolean isCursorInsideSuggestionSpan() {
        CharSequence text = this.mTextView.getText();
        if (!(text instanceof Spannable)) {
            return false;
        }
        SuggestionSpan[] suggestionSpans = ((Spannable)text).getSpans(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SuggestionSpan.class);
        return suggestionSpans.length > 0;
    }

    private boolean isCursorInsideEasyCorrectionSpan() {
        Spannable spannable = (Spannable)this.mTextView.getText();
        SuggestionSpan[] suggestionSpans = spannable.getSpans(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpans.length; ++i) {
            if ((suggestionSpans[i].getFlags() & 1) == 0) continue;
            return true;
        }
        return false;
    }

    void onTouchUpEvent(MotionEvent event) {
        boolean selectAllGotFocus = this.mSelectAllOnFocus && this.mTextView.didTouchFocusSelect();
        this.hideControllers();
        CharSequence text = this.mTextView.getText();
        if (!selectAllGotFocus && text.length() > 0) {
            int offset = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
            Selection.setSelection((Spannable)text, offset);
            if (this.mSpellChecker != null) {
                this.mSpellChecker.onSelectionChanged();
            }
            if (!this.extractedTextModeWillBeStarted()) {
                if (this.isCursorInsideEasyCorrectionSpan()) {
                    this.mShowSuggestionRunnable = new Runnable(){

                        public void run() {
                            Editor.this.showSuggestions();
                        }
                    };
                    this.mTextView.postDelayed(this.mShowSuggestionRunnable, ViewConfiguration.getDoubleTapTimeout());
                } else if (this.hasInsertionController()) {
                    this.getInsertionController().show();
                }
            }
        }
    }

    protected void stopSelectionActionMode() {
        if (this.mSelectionActionMode != null) {
            this.mSelectionActionMode.finish();
        }
    }

    boolean hasInsertionController() {
        return this.mInsertionControllerEnabled;
    }

    boolean hasSelectionController() {
        return this.mSelectionControllerEnabled;
    }

    InsertionPointCursorController getInsertionController() {
        if (!this.mInsertionControllerEnabled) {
            return null;
        }
        if (this.mInsertionPointCursorController == null) {
            this.mInsertionPointCursorController = new InsertionPointCursorController();
            ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        return this.mInsertionPointCursorController;
    }

    SelectionModifierCursorController getSelectionController() {
        if (!this.mSelectionControllerEnabled) {
            return null;
        }
        if (this.mSelectionModifierCursorController == null) {
            this.mSelectionModifierCursorController = new SelectionModifierCursorController();
            ViewTreeObserver observer = this.mTextView.getViewTreeObserver();
            observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        return this.mSelectionModifierCursorController;
    }

    private void updateCursorPosition(int cursorIndex, int top, int bottom, float horizontal) {
        if (this.mCursorDrawable[cursorIndex] == null) {
            this.mCursorDrawable[cursorIndex] = this.mTextView.getResources().getDrawable(this.mTextView.mCursorDrawableRes);
        }
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        this.mCursorDrawable[cursorIndex].getPadding(this.mTempRect);
        int width = this.mCursorDrawable[cursorIndex].getIntrinsicWidth();
        horizontal = Math.max(0.5f, horizontal - 0.5f);
        int left = (int)horizontal - this.mTempRect.left;
        this.mCursorDrawable[cursorIndex].setBounds(left, top - this.mTempRect.top, left + width, bottom + this.mTempRect.bottom);
    }

    public void onCommitCorrection(CorrectionInfo info) {
        if (this.mCorrectionHighlighter == null) {
            this.mCorrectionHighlighter = new CorrectionHighlighter();
        } else {
            this.mCorrectionHighlighter.invalidate(false);
        }
        this.mCorrectionHighlighter.highlight(info);
    }

    void showSuggestions() {
        if (this.mSuggestionsPopupWindow == null) {
            this.mSuggestionsPopupWindow = new SuggestionsPopupWindow();
        }
        this.hideControllers();
        this.mSuggestionsPopupWindow.show();
    }

    boolean areSuggestionsShown() {
        return this.mSuggestionsPopupWindow != null && this.mSuggestionsPopupWindow.isShowing();
    }

    void onScrollChanged() {
        if (this.mPositionListener != null) {
            this.mPositionListener.onScrollChanged();
        }
    }

    private boolean shouldBlink() {
        if (!this.isCursorVisible() || !this.mTextView.isFocused()) {
            return false;
        }
        int start = this.mTextView.getSelectionStart();
        if (start < 0) {
            return false;
        }
        int end = this.mTextView.getSelectionEnd();
        if (end < 0) {
            return false;
        }
        return start == end;
    }

    void makeBlink() {
        if (this.shouldBlink()) {
            this.mShowCursor = SystemClock.uptimeMillis();
            if (this.mBlink == null) {
                this.mBlink = new Blink();
            }
            this.mBlink.removeCallbacks(this.mBlink);
            this.mBlink.postAtTime(this.mBlink, this.mShowCursor + 500L);
        } else if (this.mBlink != null) {
            this.mBlink.removeCallbacks(this.mBlink);
        }
    }

    private View.DragShadowBuilder getTextThumbnailBuilder(CharSequence text) {
        TextView shadowView = (TextView)View.inflate(this.mTextView.getContext(), 17367209, null);
        if (shadowView == null) {
            throw new IllegalArgumentException("Unable to inflate text drag thumbnail");
        }
        if (text.length() > DRAG_SHADOW_MAX_TEXT_LENGTH) {
            text = text.subSequence(0, DRAG_SHADOW_MAX_TEXT_LENGTH);
        }
        shadowView.setText(text);
        shadowView.setTextColor(this.mTextView.getTextColors());
        shadowView.setTextAppearance(this.mTextView.getContext(), 16);
        shadowView.setGravity(17);
        shadowView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        int size = View.MeasureSpec.makeMeasureSpec(0, 0);
        shadowView.measure(size, size);
        shadowView.layout(0, 0, shadowView.getMeasuredWidth(), shadowView.getMeasuredHeight());
        shadowView.invalidate();
        return new View.DragShadowBuilder(shadowView);
    }

    void onDrop(DragEvent event) {
        boolean dragDropIntoItself;
        StringBuilder content = new StringBuilder("");
        ClipData clipData = event.getClipData();
        int itemCount = clipData.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            ClipData.Item item = clipData.getItemAt(i);
            content.append(item.coerceToStyledText(this.mTextView.getContext()));
        }
        int offset = this.mTextView.getOffsetForPosition(event.getX(), event.getY());
        Object localState = event.getLocalState();
        DragLocalState dragLocalState = null;
        if (localState instanceof DragLocalState) {
            dragLocalState = (DragLocalState)localState;
        }
        boolean bl = dragDropIntoItself = dragLocalState != null && dragLocalState.sourceTextView == this.mTextView;
        if (dragDropIntoItself && offset >= dragLocalState.start && offset < dragLocalState.end) {
            return;
        }
        int originalLength = this.mTextView.getText().length();
        long minMax = this.mTextView.prepareSpacesAroundPaste(offset, offset, content);
        int min = TextUtils.unpackRangeStartFromLong(minMax);
        int max = TextUtils.unpackRangeEndFromLong(minMax);
        Selection.setSelection((Spannable)this.mTextView.getText(), max);
        this.mTextView.replaceText_internal(min, max, content);
        if (dragDropIntoItself) {
            CharSequence t;
            int dragSourceStart = dragLocalState.start;
            int dragSourceEnd = dragLocalState.end;
            if (max <= dragSourceStart) {
                int shift = this.mTextView.getText().length() - originalLength;
                dragSourceStart += shift;
                dragSourceEnd += shift;
            }
            this.mTextView.deleteText_internal(dragSourceStart, dragSourceEnd);
            int prevCharIdx = Math.max(0, dragSourceStart - 1);
            int nextCharIdx = Math.min(this.mTextView.getText().length(), dragSourceStart + 1);
            if (nextCharIdx > prevCharIdx + 1 && Character.isSpaceChar((t = this.mTextView.getTransformedText(prevCharIdx, nextCharIdx)).charAt(0)) && Character.isSpaceChar(t.charAt(1))) {
                this.mTextView.deleteText_internal(prevCharIdx, prevCharIdx + 1);
            }
        }
    }

    public void addSpanWatchers(Spannable text) {
        int textLength = text.length();
        if (this.mKeyListener != null) {
            text.setSpan(this.mKeyListener, 0, textLength, 18);
        }
        if (this.mSpanController == null) {
            this.mSpanController = new SpanController();
        }
        text.setSpan(this.mSpanController, 0, textLength, 18);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextModifyOperation
    extends UndoOperation<TextView> {
        int mRangeStart;
        int mRangeEnd;
        CharSequence mOldText;
        public static final Parcelable.ClassLoaderCreator<TextModifyOperation> CREATOR = new Parcelable.ClassLoaderCreator<TextModifyOperation>(){

            @Override
            public TextModifyOperation createFromParcel(Parcel in) {
                return new TextModifyOperation(in, null);
            }

            @Override
            public TextModifyOperation createFromParcel(Parcel in, ClassLoader loader) {
                return new TextModifyOperation(in, loader);
            }

            public TextModifyOperation[] newArray(int size) {
                return new TextModifyOperation[size];
            }
        };

        public TextModifyOperation(UndoOwner owner) {
            super(owner);
        }

        public TextModifyOperation(Parcel src, ClassLoader loader) {
            super(src, loader);
            this.mRangeStart = src.readInt();
            this.mRangeEnd = src.readInt();
            this.mOldText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(src);
        }

        @Override
        public void commit() {
        }

        @Override
        public void undo() {
            this.swapText();
        }

        @Override
        public void redo() {
            this.swapText();
        }

        private void swapText() {
            TextView tv = (TextView)this.getOwnerData();
            Editable editable = (Editable)tv.getText();
            CharSequence curText = this.mRangeStart >= this.mRangeEnd ? null : editable.subSequence(this.mRangeStart, this.mRangeEnd);
            if (this.mOldText == null) {
                editable.delete(this.mRangeStart, this.mRangeEnd);
                this.mRangeEnd = this.mRangeStart;
            } else {
                editable.replace(this.mRangeStart, this.mRangeEnd, this.mOldText);
                this.mRangeEnd = this.mRangeStart + this.mOldText.length();
            }
            this.mOldText = curText;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRangeStart);
            dest.writeInt(this.mRangeEnd);
            TextUtils.writeToParcel(this.mOldText, dest, flags);
        }
    }

    public static class UndoInputFilter
    implements InputFilter {
        final Editor mEditor;

        public UndoInputFilter(Editor editor) {
            this.mEditor = editor;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            UndoManager um = this.mEditor.mUndoManager;
            if (um.isInUndo()) {
                return null;
            }
            um.beginUpdate("Edit text");
            TextModifyOperation op = um.getLastOperation(TextModifyOperation.class, this.mEditor.mUndoOwner, 1);
            if (op != null) {
                if (op.mOldText == null) {
                    if (start < end && (dstart >= op.mRangeStart && dend <= op.mRangeEnd || dstart == op.mRangeEnd && dend == op.mRangeEnd)) {
                        op.mRangeEnd = dstart + (end - start);
                        um.endUpdate();
                        return null;
                    }
                } else if (start == end && dend == op.mRangeStart - 1) {
                    SpannableStringBuilder str = op.mOldText instanceof SpannableString ? (SpannableStringBuilder)op.mOldText : new SpannableStringBuilder(op.mOldText);
                    str.insert(0, dest, dstart, dend);
                    op.mRangeStart = dstart;
                    op.mOldText = str;
                    um.endUpdate();
                    return null;
                }
                um.commitState(null);
                um.setUndoLabel("Edit text");
            }
            op = new TextModifyOperation(this.mEditor.mUndoOwner);
            op.mRangeStart = dstart;
            op.mRangeEnd = start < end ? dstart + (end - start) : dstart;
            if (dstart < dend) {
                op.mOldText = dest.subSequence(dstart, dend);
            }
            um.addOperation(op, 0);
            um.endUpdate();
            return null;
        }
    }

    static class InputMethodState {
        Rect mCursorRectInWindow = new Rect();
        RectF mTmpRectF = new RectF();
        float[] mTmpOffset = new float[2];
        ExtractedTextRequest mExtractedTextRequest;
        final ExtractedText mExtractedText = new ExtractedText();
        int mBatchEditNesting;
        boolean mCursorChanged;
        boolean mSelectionModeChanged;
        boolean mContentChanged;
        int mChangedStart;
        int mChangedEnd;
        int mChangedDelta;

        InputMethodState() {
        }
    }

    static class InputContentType {
        int imeOptions = 0;
        String privateImeOptions;
        CharSequence imeActionLabel;
        int imeActionId;
        Bundle extras;
        TextView.OnEditorActionListener onEditorActionListener;
        boolean enterDown;

        InputContentType() {
        }
    }

    private static class ErrorPopup
    extends PopupWindow {
        private boolean mAbove = false;
        private final TextView mView;
        private int mPopupInlineErrorBackgroundId = 0;
        private int mPopupInlineErrorAboveBackgroundId = 0;

        ErrorPopup(TextView v, int width, int height) {
            super(v, width, height);
            this.mView = v;
            this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 225);
            this.mView.setBackgroundResource(this.mPopupInlineErrorBackgroundId);
        }

        void fixDirection(boolean above) {
            this.mAbove = above;
            if (above) {
                this.mPopupInlineErrorAboveBackgroundId = this.getResourceId(this.mPopupInlineErrorAboveBackgroundId, 226);
            } else {
                this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 225);
            }
            this.mView.setBackgroundResource(above ? this.mPopupInlineErrorAboveBackgroundId : this.mPopupInlineErrorBackgroundId);
        }

        private int getResourceId(int currentId, int index) {
            if (currentId == 0) {
                TypedArray styledAttributes = this.mView.getContext().obtainStyledAttributes(R.styleable.Theme);
                currentId = styledAttributes.getResourceId(index, 0);
                styledAttributes.recycle();
            }
            return currentId;
        }

        public void update(int x, int y, int w, int h, boolean force) {
            super.update(x, y, w, h, force);
            boolean above = this.isAboveAnchor();
            if (above != this.mAbove) {
                this.fixDirection(above);
            }
        }
    }

    private class CorrectionHighlighter {
        private final Path mPath = new Path();
        private final Paint mPaint = new Paint(1);
        private int mStart;
        private int mEnd;
        private long mFadingStartTime;
        private RectF mTempRectF;
        private static final int FADE_OUT_DURATION = 400;

        public CorrectionHighlighter() {
            this.mPaint.setCompatibilityScaling(((Editor)Editor.this).mTextView.getResources().getCompatibilityInfo().applicationScale);
            this.mPaint.setStyle(Paint.Style.FILL);
        }

        public void highlight(CorrectionInfo info) {
            this.mStart = info.getOffset();
            this.mEnd = this.mStart + info.getNewText().length();
            this.mFadingStartTime = SystemClock.uptimeMillis();
            if (this.mStart < 0 || this.mEnd < 0) {
                this.stopAnimation();
            }
        }

        public void draw(Canvas canvas, int cursorOffsetVertical) {
            if (this.updatePath() && this.updatePaint()) {
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, cursorOffsetVertical);
                }
                canvas.drawPath(this.mPath, this.mPaint);
                if (cursorOffsetVertical != 0) {
                    canvas.translate(0.0f, -cursorOffsetVertical);
                }
                this.invalidate(true);
            } else {
                this.stopAnimation();
                this.invalidate(false);
            }
        }

        private boolean updatePaint() {
            long duration = SystemClock.uptimeMillis() - this.mFadingStartTime;
            if (duration > 400L) {
                return false;
            }
            float coef = 1.0f - (float)duration / 400.0f;
            int highlightColorAlpha = Color.alpha(((Editor)Editor.this).mTextView.mHighlightColor);
            int color2 = (((Editor)Editor.this).mTextView.mHighlightColor & 0xFFFFFF) + ((int)((float)highlightColorAlpha * coef) << 24);
            this.mPaint.setColor(color2);
            return true;
        }

        private boolean updatePath() {
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                return false;
            }
            int length = Editor.this.mTextView.getText().length();
            int start = Math.min(length, this.mStart);
            int end = Math.min(length, this.mEnd);
            this.mPath.reset();
            layout2.getSelectionPath(start, end, this.mPath);
            return true;
        }

        private void invalidate(boolean delayed) {
            if (Editor.this.mTextView.getLayout() == null) {
                return;
            }
            if (this.mTempRectF == null) {
                this.mTempRectF = new RectF();
            }
            this.mPath.computeBounds(this.mTempRectF, false);
            int left = Editor.this.mTextView.getCompoundPaddingLeft();
            int top = Editor.this.mTextView.getExtendedPaddingTop() + Editor.this.mTextView.getVerticalOffset(true);
            if (delayed) {
                Editor.this.mTextView.postInvalidateOnAnimation(left + (int)this.mTempRectF.left, top + (int)this.mTempRectF.top, left + (int)this.mTempRectF.right, top + (int)this.mTempRectF.bottom);
            } else {
                Editor.this.mTextView.postInvalidate((int)this.mTempRectF.left, (int)this.mTempRectF.top, (int)this.mTempRectF.right, (int)this.mTempRectF.bottom);
            }
        }

        private void stopAnimation() {
            Editor.this.mCorrectionHighlighter = null;
        }
    }

    class SelectionModifierCursorController
    implements CursorController {
        private static final int DELAY_BEFORE_REPLACE_ACTION = 200;
        private SelectionStartHandleView mStartHandle;
        private SelectionEndHandleView mEndHandle;
        private int mMinTouchOffset;
        private int mMaxTouchOffset;
        private long mPreviousTapUpTime = 0L;
        private float mDownPositionX;
        private float mDownPositionY;
        private boolean mGestureStayedInTapRegion;

        SelectionModifierCursorController() {
            this.resetTouchOffsets();
        }

        public void show() {
            if (Editor.this.mTextView.isInBatchEditMode()) {
                return;
            }
            this.initDrawables();
            this.initHandles();
            Editor.this.hideInsertionPointCursorController();
        }

        private void initDrawables() {
            if (Editor.this.mSelectHandleLeft == null) {
                Editor.this.mSelectHandleLeft = Editor.this.mTextView.getContext().getResources().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleLeftRes);
            }
            if (Editor.this.mSelectHandleRight == null) {
                Editor.this.mSelectHandleRight = Editor.this.mTextView.getContext().getResources().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleRightRes);
            }
        }

        private void initHandles() {
            if (this.mStartHandle == null) {
                this.mStartHandle = new SelectionStartHandleView(Editor.this.mSelectHandleLeft, Editor.this.mSelectHandleRight);
            }
            if (this.mEndHandle == null) {
                this.mEndHandle = new SelectionEndHandleView(Editor.this.mSelectHandleRight, Editor.this.mSelectHandleLeft);
            }
            this.mStartHandle.show();
            this.mEndHandle.show();
            this.mStartHandle.showActionPopupWindow(200);
            this.mEndHandle.setActionPopupWindow(this.mStartHandle.getActionPopupWindow());
            Editor.this.hideInsertionPointCursorController();
        }

        public void hide() {
            if (this.mStartHandle != null) {
                this.mStartHandle.hide();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.hide();
            }
        }

        public void onTouchEvent(MotionEvent event) {
            switch (event.getActionMasked()) {
                case 0: {
                    long duration;
                    float x = event.getX();
                    float y = event.getY();
                    this.mMinTouchOffset = this.mMaxTouchOffset = Editor.this.mTextView.getOffsetForPosition(x, y);
                    if (this.mGestureStayedInTapRegion && (duration = SystemClock.uptimeMillis() - this.mPreviousTapUpTime) <= (long)ViewConfiguration.getDoubleTapTimeout()) {
                        boolean stayedInArea;
                        float deltaX = x - this.mDownPositionX;
                        float deltaY = y - this.mDownPositionY;
                        float distanceSquared = deltaX * deltaX + deltaY * deltaY;
                        ViewConfiguration viewConfiguration = ViewConfiguration.get(Editor.this.mTextView.getContext());
                        int doubleTapSlop = viewConfiguration.getScaledDoubleTapSlop();
                        boolean bl = stayedInArea = distanceSquared < (float)(doubleTapSlop * doubleTapSlop);
                        if (stayedInArea && Editor.this.isPositionOnText(x, y)) {
                            Editor.this.startSelectionActionMode();
                            Editor.this.mDiscardNextActionUp = true;
                        }
                    }
                    this.mDownPositionX = x;
                    this.mDownPositionY = y;
                    this.mGestureStayedInTapRegion = true;
                    break;
                }
                case 5: 
                case 6: {
                    if (!Editor.this.mTextView.getContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) break;
                    this.updateMinAndMaxOffsets(event);
                    break;
                }
                case 2: {
                    ViewConfiguration viewConfiguration;
                    int doubleTapTouchSlop;
                    float deltaY;
                    float deltaX;
                    float distanceSquared;
                    if (!this.mGestureStayedInTapRegion || !((distanceSquared = (deltaX = event.getX() - this.mDownPositionX) * deltaX + (deltaY = event.getY() - this.mDownPositionY) * deltaY) > (float)((doubleTapTouchSlop = (viewConfiguration = ViewConfiguration.get(Editor.this.mTextView.getContext())).getScaledDoubleTapTouchSlop()) * doubleTapTouchSlop))) break;
                    this.mGestureStayedInTapRegion = false;
                    break;
                }
                case 1: {
                    this.mPreviousTapUpTime = SystemClock.uptimeMillis();
                }
            }
        }

        private void updateMinAndMaxOffsets(MotionEvent event) {
            int pointerCount = event.getPointerCount();
            for (int index = 0; index < pointerCount; ++index) {
                int offset = Editor.this.mTextView.getOffsetForPosition(event.getX(index), event.getY(index));
                if (offset < this.mMinTouchOffset) {
                    this.mMinTouchOffset = offset;
                }
                if (offset <= this.mMaxTouchOffset) continue;
                this.mMaxTouchOffset = offset;
            }
        }

        public int getMinTouchOffset() {
            return this.mMinTouchOffset;
        }

        public int getMaxTouchOffset() {
            return this.mMaxTouchOffset;
        }

        public void resetTouchOffsets() {
            this.mMaxTouchOffset = -1;
            this.mMinTouchOffset = -1;
        }

        public boolean isSelectionStartDragged() {
            return this.mStartHandle != null && this.mStartHandle.isDragging();
        }

        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        public void onDetached() {
            ViewTreeObserver observer = Editor.this.mTextView.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mStartHandle != null) {
                this.mStartHandle.onDetached();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.onDetached();
            }
        }
    }

    private class InsertionPointCursorController
    implements CursorController {
        private InsertionHandleView mHandle;

        private InsertionPointCursorController() {
        }

        public void show() {
            this.getHandle().show();
        }

        public void showWithActionPopup() {
            this.getHandle().showWithActionPopup();
        }

        public void hide() {
            if (this.mHandle != null) {
                this.mHandle.hide();
            }
        }

        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        private InsertionHandleView getHandle() {
            if (Editor.this.mSelectHandleCenter == null) {
                Editor.this.mSelectHandleCenter = Editor.this.mTextView.getResources().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleRes);
            }
            if (this.mHandle == null) {
                this.mHandle = new InsertionHandleView(Editor.this.mSelectHandleCenter);
            }
            return this.mHandle;
        }

        public void onDetached() {
            ViewTreeObserver observer = Editor.this.mTextView.getViewTreeObserver();
            observer.removeOnTouchModeChangeListener(this);
            if (this.mHandle != null) {
                this.mHandle.onDetached();
            }
        }
    }

    private static interface CursorController
    extends ViewTreeObserver.OnTouchModeChangeListener {
        public void show();

        public void hide();

        public void onDetached();
    }

    private class SelectionEndHandleView
    extends HandleView {
        public SelectionEndHandleView(Drawable drawableLtr, Drawable drawableRtl) {
            super(drawableLtr, drawableRtl);
        }

        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            if (isRtlRun) {
                return drawable2.getIntrinsicWidth() * 3 / 4;
            }
            return drawable2.getIntrinsicWidth() / 4;
        }

        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionEnd();
        }

        public void updateSelection(int offset) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionStart(), offset);
            this.updateDrawable();
        }

        public void updatePosition(float x, float y) {
            int selectionStart;
            int offset = Editor.this.mTextView.getOffsetForPosition(x, y);
            if (offset <= (selectionStart = Editor.this.mTextView.getSelectionStart())) {
                offset = Math.min(selectionStart + 1, Editor.this.mTextView.getText().length());
            }
            this.positionAtCursorOffset(offset, false);
        }

        public void setActionPopupWindow(ActionPopupWindow actionPopupWindow) {
            this.mActionPopupWindow = actionPopupWindow;
        }
    }

    private class SelectionStartHandleView
    extends HandleView {
        public SelectionStartHandleView(Drawable drawableLtr, Drawable drawableRtl) {
            super(drawableLtr, drawableRtl);
        }

        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            if (isRtlRun) {
                return drawable2.getIntrinsicWidth() / 4;
            }
            return drawable2.getIntrinsicWidth() * 3 / 4;
        }

        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        public void updateSelection(int offset) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), offset, Editor.this.mTextView.getSelectionEnd());
            this.updateDrawable();
        }

        public void updatePosition(float x, float y) {
            int selectionEnd;
            int offset = Editor.this.mTextView.getOffsetForPosition(x, y);
            if (offset >= (selectionEnd = Editor.this.mTextView.getSelectionEnd())) {
                offset = Math.max(0, selectionEnd - 1);
            }
            this.positionAtCursorOffset(offset, false);
        }

        public ActionPopupWindow getActionPopupWindow() {
            return this.mActionPopupWindow;
        }
    }

    private class InsertionHandleView
    extends HandleView {
        private static final int DELAY_BEFORE_HANDLE_FADES_OUT = 4000;
        private static final int RECENT_CUT_COPY_DURATION = 15000;
        private float mDownPositionX;
        private float mDownPositionY;
        private Runnable mHider;

        public InsertionHandleView(Drawable drawable2) {
            super(drawable2, drawable2);
        }

        public void show() {
            super.show();
            long durationSinceCutOrCopy = SystemClock.uptimeMillis() - TextView.LAST_CUT_OR_COPY_TIME;
            if (durationSinceCutOrCopy < 15000L) {
                this.showActionPopupWindow(0);
            }
            this.hideAfterDelay();
        }

        public void showWithActionPopup() {
            this.show();
            this.showActionPopupWindow(0);
        }

        private void hideAfterDelay() {
            if (this.mHider == null) {
                this.mHider = new Runnable(){

                    public void run() {
                        InsertionHandleView.this.hide();
                    }
                };
            } else {
                this.removeHiderCallback();
            }
            Editor.this.mTextView.postDelayed(this.mHider, 4000L);
        }

        private void removeHiderCallback() {
            if (this.mHider != null) {
                Editor.this.mTextView.removeCallbacks(this.mHider);
            }
        }

        protected int getHotspotX(Drawable drawable2, boolean isRtlRun) {
            return drawable2.getIntrinsicWidth() / 2;
        }

        public boolean onTouchEvent(MotionEvent ev) {
            boolean result = super.onTouchEvent(ev);
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDownPositionX = ev.getRawX();
                    this.mDownPositionY = ev.getRawY();
                    break;
                }
                case 1: {
                    ViewConfiguration viewConfiguration;
                    int touchSlop;
                    float deltaY;
                    float deltaX;
                    float distanceSquared;
                    if (!this.offsetHasBeenChanged() && (distanceSquared = (deltaX = this.mDownPositionX - ev.getRawX()) * deltaX + (deltaY = this.mDownPositionY - ev.getRawY()) * deltaY) < (float)((touchSlop = (viewConfiguration = ViewConfiguration.get(Editor.this.mTextView.getContext())).getScaledTouchSlop()) * touchSlop)) {
                        if (this.mActionPopupWindow != null && this.mActionPopupWindow.isShowing()) {
                            this.mActionPopupWindow.hide();
                        } else {
                            this.showWithActionPopup();
                        }
                    }
                    this.hideAfterDelay();
                    break;
                }
                case 3: {
                    this.hideAfterDelay();
                    break;
                }
            }
            return result;
        }

        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        public void updateSelection(int offset) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), offset);
        }

        public void updatePosition(float x, float y) {
            this.positionAtCursorOffset(Editor.this.mTextView.getOffsetForPosition(x, y), false);
        }

        void onHandleMoved() {
            super.onHandleMoved();
            this.removeHiderCallback();
        }

        public void onDetached() {
            super.onDetached();
            this.removeHiderCallback();
        }
    }

    private abstract class HandleView
    extends View
    implements TextViewPositionListener {
        protected Drawable mDrawable;
        protected Drawable mDrawableLtr;
        protected Drawable mDrawableRtl;
        private final PopupWindow mContainer;
        private int mPositionX;
        private int mPositionY;
        private boolean mIsDragging;
        private float mTouchToWindowOffsetX;
        private float mTouchToWindowOffsetY;
        protected int mHotspotX;
        private float mTouchOffsetY;
        private float mIdealVerticalOffset;
        private int mLastParentX;
        private int mLastParentY;
        protected ActionPopupWindow mActionPopupWindow;
        private int mPreviousOffset;
        private boolean mPositionHasChanged;
        private Runnable mActionPopupShower;
        private static final int HISTORY_SIZE = 5;
        private static final int TOUCH_UP_FILTER_DELAY_AFTER = 150;
        private static final int TOUCH_UP_FILTER_DELAY_BEFORE = 350;
        private final long[] mPreviousOffsetsTimes;
        private final int[] mPreviousOffsets;
        private int mPreviousOffsetIndex;
        private int mNumberPreviousOffsets;

        public HandleView(Drawable drawableLtr, Drawable drawableRtl) {
            super(Editor.this.mTextView.getContext());
            this.mPreviousOffset = -1;
            this.mPositionHasChanged = true;
            this.mPreviousOffsetsTimes = new long[5];
            this.mPreviousOffsets = new int[5];
            this.mPreviousOffsetIndex = 0;
            this.mNumberPreviousOffsets = 0;
            this.mContainer = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mContainer.setSplitTouchEnabled(true);
            this.mContainer.setClippingEnabled(false);
            this.mContainer.setWindowLayoutType(1002);
            this.mContainer.setContentView(this);
            this.mDrawableLtr = drawableLtr;
            this.mDrawableRtl = drawableRtl;
            this.updateDrawable();
            int handleHeight = this.mDrawable.getIntrinsicHeight();
            this.mTouchOffsetY = -0.3f * (float)handleHeight;
            this.mIdealVerticalOffset = 0.7f * (float)handleHeight;
        }

        protected void updateDrawable() {
            int offset = this.getCurrentCursorOffset();
            boolean isRtlCharAtOffset = Editor.this.mTextView.getLayout().isRtlCharAt(offset);
            this.mDrawable = isRtlCharAtOffset ? this.mDrawableRtl : this.mDrawableLtr;
            this.mHotspotX = this.getHotspotX(this.mDrawable, isRtlCharAtOffset);
        }

        protected abstract int getHotspotX(Drawable var1, boolean var2);

        private void startTouchUpFilter(int offset) {
            this.mNumberPreviousOffsets = 0;
            this.addPositionToTouchUpFilter(offset);
        }

        private void addPositionToTouchUpFilter(int offset) {
            this.mPreviousOffsetIndex = (this.mPreviousOffsetIndex + 1) % 5;
            this.mPreviousOffsets[this.mPreviousOffsetIndex] = offset;
            this.mPreviousOffsetsTimes[this.mPreviousOffsetIndex] = SystemClock.uptimeMillis();
            ++this.mNumberPreviousOffsets;
        }

        private void filterOnTouchUp() {
            long now = SystemClock.uptimeMillis();
            int i = 0;
            int index = this.mPreviousOffsetIndex;
            int iMax = Math.min(this.mNumberPreviousOffsets, 5);
            while (i < iMax && now - this.mPreviousOffsetsTimes[index] < 150L) {
                index = (this.mPreviousOffsetIndex - ++i + 5) % 5;
            }
            if (i > 0 && i < iMax && now - this.mPreviousOffsetsTimes[index] > 350L) {
                this.positionAtCursorOffset(this.mPreviousOffsets[index], false);
            }
        }

        public boolean offsetHasBeenChanged() {
            return this.mNumberPreviousOffsets > 1;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        public void show() {
            if (this.isShowing()) {
                return;
            }
            Editor.this.getPositionListener().addSubscriber(this, true);
            this.mPreviousOffset = -1;
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), false);
            this.hideActionPopupWindow();
        }

        protected void dismiss() {
            this.mIsDragging = false;
            this.mContainer.dismiss();
            this.onDetached();
        }

        public void hide() {
            this.dismiss();
            Editor.this.getPositionListener().removeSubscriber(this);
        }

        void showActionPopupWindow(int delay) {
            if (this.mActionPopupWindow == null) {
                this.mActionPopupWindow = new ActionPopupWindow();
            }
            if (this.mActionPopupShower == null) {
                this.mActionPopupShower = new Runnable(){

                    public void run() {
                        HandleView.this.mActionPopupWindow.show();
                    }
                };
            } else {
                Editor.this.mTextView.removeCallbacks(this.mActionPopupShower);
            }
            Editor.this.mTextView.postDelayed(this.mActionPopupShower, delay);
        }

        protected void hideActionPopupWindow() {
            if (this.mActionPopupShower != null) {
                Editor.this.mTextView.removeCallbacks(this.mActionPopupShower);
            }
            if (this.mActionPopupWindow != null) {
                this.mActionPopupWindow.hide();
            }
        }

        public boolean isShowing() {
            return this.mContainer.isShowing();
        }

        private boolean isVisible() {
            if (this.mIsDragging) {
                return true;
            }
            if (Editor.this.mTextView.isInBatchEditMode()) {
                return false;
            }
            return Editor.this.isPositionVisible(this.mPositionX + this.mHotspotX, this.mPositionY);
        }

        public abstract int getCurrentCursorOffset();

        protected abstract void updateSelection(int var1);

        public abstract void updatePosition(float var1, float var2);

        protected void positionAtCursorOffset(int offset, boolean parentScrolled) {
            boolean offsetChanged;
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                Editor.this.prepareCursorControllers();
                return;
            }
            boolean bl = offsetChanged = offset != this.mPreviousOffset;
            if (offsetChanged || parentScrolled) {
                if (offsetChanged) {
                    this.updateSelection(offset);
                    this.addPositionToTouchUpFilter(offset);
                }
                int line = layout2.getLineForOffset(offset);
                this.mPositionX = (int)(layout2.getPrimaryHorizontal(offset) - 0.5f - (float)this.mHotspotX);
                this.mPositionY = layout2.getLineBottom(line);
                this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
                this.mPositionY += Editor.this.mTextView.viewportToContentVerticalOffset();
                this.mPreviousOffset = offset;
                this.mPositionHasChanged = true;
            }
        }

        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), parentScrolled);
            if (parentPositionChanged || this.mPositionHasChanged) {
                if (this.mIsDragging) {
                    if (parentPositionX != this.mLastParentX || parentPositionY != this.mLastParentY) {
                        this.mTouchToWindowOffsetX += (float)(parentPositionX - this.mLastParentX);
                        this.mTouchToWindowOffsetY += (float)(parentPositionY - this.mLastParentY);
                        this.mLastParentX = parentPositionX;
                        this.mLastParentY = parentPositionY;
                    }
                    this.onHandleMoved();
                }
                if (this.isVisible()) {
                    int positionX = parentPositionX + this.mPositionX;
                    int positionY = parentPositionY + this.mPositionY;
                    if (this.isShowing()) {
                        this.mContainer.update(positionX, positionY, -1, -1);
                    } else {
                        this.mContainer.showAtLocation(Editor.this.mTextView, 0, positionX, positionY);
                    }
                } else if (this.isShowing()) {
                    this.dismiss();
                }
                this.mPositionHasChanged = false;
            }
        }

        protected void onDraw(Canvas c) {
            this.mDrawable.setBounds(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
            this.mDrawable.draw(c);
        }

        public boolean onTouchEvent(MotionEvent ev) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.startTouchUpFilter(this.getCurrentCursorOffset());
                    this.mTouchToWindowOffsetX = ev.getRawX() - (float)this.mPositionX;
                    this.mTouchToWindowOffsetY = ev.getRawY() - (float)this.mPositionY;
                    PositionListener positionListener = Editor.this.getPositionListener();
                    this.mLastParentX = positionListener.getPositionX();
                    this.mLastParentY = positionListener.getPositionY();
                    this.mIsDragging = true;
                    break;
                }
                case 2: {
                    float newVerticalOffset;
                    float rawX = ev.getRawX();
                    float rawY = ev.getRawY();
                    float previousVerticalOffset = this.mTouchToWindowOffsetY - (float)this.mLastParentY;
                    float currentVerticalOffset = rawY - (float)this.mPositionY - (float)this.mLastParentY;
                    if (previousVerticalOffset < this.mIdealVerticalOffset) {
                        newVerticalOffset = Math.min(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.max(newVerticalOffset, previousVerticalOffset);
                    } else {
                        newVerticalOffset = Math.max(currentVerticalOffset, this.mIdealVerticalOffset);
                        newVerticalOffset = Math.min(newVerticalOffset, previousVerticalOffset);
                    }
                    this.mTouchToWindowOffsetY = newVerticalOffset + (float)this.mLastParentY;
                    float newPosX = rawX - this.mTouchToWindowOffsetX + (float)this.mHotspotX;
                    float newPosY = rawY - this.mTouchToWindowOffsetY + this.mTouchOffsetY;
                    this.updatePosition(newPosX, newPosY);
                    break;
                }
                case 1: {
                    this.filterOnTouchUp();
                    this.mIsDragging = false;
                    break;
                }
                case 3: {
                    this.mIsDragging = false;
                }
            }
            return true;
        }

        public boolean isDragging() {
            return this.mIsDragging;
        }

        void onHandleMoved() {
            this.hideActionPopupWindow();
        }

        public void onDetached() {
            this.hideActionPopupWindow();
        }
    }

    private class ActionPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener {
        private static final int POPUP_TEXT_LAYOUT = 17367210;
        private TextView mPasteTextView;
        private TextView mReplaceTextView;

        private ActionPopupWindow() {
        }

        protected void createPopupWindow() {
            this.mPopupWindow = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mPopupWindow.setClippingEnabled(true);
        }

        protected void initContentView() {
            LinearLayout linearLayout = new LinearLayout(Editor.this.mTextView.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17303088);
            LayoutInflater inflater = (LayoutInflater)Editor.this.mTextView.getContext().getSystemService("layout_inflater");
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mPasteTextView = (TextView)inflater.inflate(17367210, null);
            this.mPasteTextView.setLayoutParams(wrapContent);
            this.mContentView.addView(this.mPasteTextView);
            this.mPasteTextView.setText(17039371);
            this.mPasteTextView.setOnClickListener(this);
            this.mReplaceTextView = (TextView)inflater.inflate(17367210, null);
            this.mReplaceTextView.setLayoutParams(wrapContent);
            this.mContentView.addView(this.mReplaceTextView);
            this.mReplaceTextView.setText(17040359);
            this.mReplaceTextView.setOnClickListener(this);
        }

        public void show() {
            boolean canPaste = Editor.this.mTextView.canPaste();
            boolean canSuggest = Editor.this.mTextView.isSuggestionsEnabled() && Editor.this.isCursorInsideSuggestionSpan();
            this.mPasteTextView.setVisibility(canPaste ? 0 : 8);
            this.mReplaceTextView.setVisibility(canSuggest ? 0 : 8);
            if (!canPaste && !canSuggest) {
                return;
            }
            super.show();
        }

        public void onClick(View view) {
            if (view == this.mPasteTextView && Editor.this.mTextView.canPaste()) {
                Editor.this.mTextView.onTextContextMenuItem(0x1020022);
                this.hide();
            } else if (view == this.mReplaceTextView) {
                int middle = (Editor.this.mTextView.getSelectionStart() + Editor.this.mTextView.getSelectionEnd()) / 2;
                Editor.this.stopSelectionActionMode();
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), middle);
                Editor.this.showSuggestions();
            }
        }

        protected int getTextOffset() {
            return (Editor.this.mTextView.getSelectionStart() + Editor.this.mTextView.getSelectionEnd()) / 2;
        }

        protected int getVerticalLocalPosition(int line) {
            return Editor.this.mTextView.getLayout().getLineTop(line) - this.mContentView.getMeasuredHeight();
        }

        protected int clipVertically(int positionY) {
            if (positionY < 0) {
                int offset = this.getTextOffset();
                Layout layout2 = Editor.this.mTextView.getLayout();
                int line = layout2.getLineForOffset(offset);
                positionY += layout2.getLineBottom(line) - layout2.getLineTop(line);
                positionY += this.mContentView.getMeasuredHeight();
                Drawable handle = Editor.this.mTextView.getResources().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleRes);
                positionY += handle.getIntrinsicHeight();
            }
            return positionY;
        }
    }

    private class SelectionActionModeCallback
    implements ActionMode.Callback {
        private SelectionActionModeCallback() {
        }

        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            TypedArray styledAttributes = Editor.this.mTextView.getContext().obtainStyledAttributes(R.styleable.SelectionModeDrawables);
            mode.setTitle(Editor.this.mTextView.getContext().getString(17040361));
            mode.setSubtitle(null);
            mode.setTitleOptionalHint(true);
            menu2.add(0, 16908319, 0, 17039373).setIcon(styledAttributes.getResourceId(3, 0)).setAlphabeticShortcut('a').setShowAsAction(6);
            if (Editor.this.mTextView.canCut()) {
                menu2.add(0, 0x1020020, 0, 17039363).setIcon(styledAttributes.getResourceId(0, 0)).setAlphabeticShortcut('x').setShowAsAction(6);
            }
            if (Editor.this.mTextView.canCopy()) {
                menu2.add(0, 0x1020021, 0, 0x1040001).setIcon(styledAttributes.getResourceId(1, 0)).setAlphabeticShortcut('c').setShowAsAction(6);
            }
            if (Editor.this.mTextView.canPaste()) {
                menu2.add(0, 0x1020022, 0, 17039371).setIcon(styledAttributes.getResourceId(2, 0)).setAlphabeticShortcut('v').setShowAsAction(6);
            }
            styledAttributes.recycle();
            if (Editor.this.mCustomSelectionActionModeCallback != null && !Editor.this.mCustomSelectionActionModeCallback.onCreateActionMode(mode, menu2)) {
                return false;
            }
            if (menu2.hasVisibleItems() || mode.getCustomView() != null) {
                Editor.this.getSelectionController().show();
                Editor.this.mTextView.setHasTransientState(true);
                return true;
            }
            return false;
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            if (Editor.this.mCustomSelectionActionModeCallback != null) {
                return Editor.this.mCustomSelectionActionModeCallback.onPrepareActionMode(mode, menu2);
            }
            return true;
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            if (Editor.this.mCustomSelectionActionModeCallback != null && Editor.this.mCustomSelectionActionModeCallback.onActionItemClicked(mode, item)) {
                return true;
            }
            return Editor.this.mTextView.onTextContextMenuItem(item.getItemId());
        }

        public void onDestroyActionMode(ActionMode mode) {
            if (Editor.this.mCustomSelectionActionModeCallback != null) {
                Editor.this.mCustomSelectionActionModeCallback.onDestroyActionMode(mode);
            }
            if (!Editor.this.mPreserveDetachedSelection) {
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionEnd());
                Editor.this.mTextView.setHasTransientState(false);
            }
            if (Editor.this.mSelectionModifierCursorController != null) {
                Editor.this.mSelectionModifierCursorController.hide();
            }
            Editor.this.mSelectionActionMode = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuggestionsPopupWindow
    extends PinnedPopupWindow
    implements AdapterView.OnItemClickListener {
        private static final int MAX_NUMBER_SUGGESTIONS = 5;
        private static final int ADD_TO_DICTIONARY = -1;
        private static final int DELETE_TEXT = -2;
        private SuggestionInfo[] mSuggestionInfos;
        private int mNumberOfSuggestions;
        private boolean mCursorWasVisibleBeforeSuggestions;
        private boolean mIsShowingUp;
        private SuggestionAdapter mSuggestionsAdapter;
        private final Comparator<SuggestionSpan> mSuggestionSpanComparator;
        private final HashMap<SuggestionSpan, Integer> mSpansLengths;

        public SuggestionsPopupWindow() {
            this.mIsShowingUp = false;
            this.mCursorWasVisibleBeforeSuggestions = Editor.this.mCursorVisible;
            this.mSuggestionSpanComparator = new SuggestionSpanComparator();
            this.mSpansLengths = new HashMap();
        }

        @Override
        protected void createPopupWindow() {
            this.mPopupWindow = new CustomPopupWindow(Editor.this.mTextView.getContext(), 16843635);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setClippingEnabled(false);
        }

        @Override
        protected void initContentView() {
            ListView listView = new ListView(Editor.this.mTextView.getContext());
            this.mSuggestionsAdapter = new SuggestionAdapter();
            listView.setAdapter(this.mSuggestionsAdapter);
            listView.setOnItemClickListener(this);
            this.mContentView = listView;
            this.mSuggestionInfos = new SuggestionInfo[7];
            for (int i = 0; i < this.mSuggestionInfos.length; ++i) {
                this.mSuggestionInfos[i] = new SuggestionInfo();
            }
        }

        public boolean isShowingUp() {
            return this.mIsShowingUp;
        }

        public void onParentLostFocus() {
            this.mIsShowingUp = false;
        }

        private SuggestionSpan[] getSuggestionSpans() {
            int pos = Editor.this.mTextView.getSelectionStart();
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            SuggestionSpan[] suggestionSpans = spannable.getSpans(pos, pos, SuggestionSpan.class);
            this.mSpansLengths.clear();
            for (SuggestionSpan suggestionSpan : suggestionSpans) {
                int start = spannable.getSpanStart(suggestionSpan);
                int end = spannable.getSpanEnd(suggestionSpan);
                this.mSpansLengths.put(suggestionSpan, end - start);
            }
            Arrays.sort(suggestionSpans, this.mSuggestionSpanComparator);
            return suggestionSpans;
        }

        @Override
        public void show() {
            if (!(Editor.this.mTextView.getText() instanceof Editable)) {
                return;
            }
            if (this.updateSuggestions()) {
                this.mCursorWasVisibleBeforeSuggestions = Editor.this.mCursorVisible;
                Editor.this.mTextView.setCursorVisible(false);
                this.mIsShowingUp = true;
                super.show();
            }
        }

        @Override
        protected void measureContent() {
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            int horizontalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE);
            int verticalMeasure = View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE);
            int width = 0;
            View view = null;
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                view = this.mSuggestionsAdapter.getView(i, view, this.mContentView);
                view.getLayoutParams().width = -2;
                view.measure(horizontalMeasure, verticalMeasure);
                width = Math.max(width, view.getMeasuredWidth());
            }
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), verticalMeasure);
            Drawable popupBackground = this.mPopupWindow.getBackground();
            if (popupBackground != null) {
                if (Editor.this.mTempRect == null) {
                    Editor.this.mTempRect = new Rect();
                }
                popupBackground.getPadding(Editor.this.mTempRect);
                width += ((Editor)Editor.this).mTempRect.left + ((Editor)Editor.this).mTempRect.right;
            }
            this.mPopupWindow.setWidth(width);
        }

        @Override
        protected int getTextOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        @Override
        protected int getVerticalLocalPosition(int line) {
            return Editor.this.mTextView.getLayout().getLineBottom(line);
        }

        @Override
        protected int clipVertically(int positionY) {
            int height = this.mContentView.getMeasuredHeight();
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            return Math.min(positionY, displayMetrics.heightPixels - height);
        }

        @Override
        public void hide() {
            super.hide();
        }

        private boolean updateSuggestions() {
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            SuggestionSpan[] suggestionSpans = this.getSuggestionSpans();
            int nbSpans = suggestionSpans.length;
            if (nbSpans == 0) {
                return false;
            }
            this.mNumberOfSuggestions = 0;
            int spanUnionStart = Editor.this.mTextView.getText().length();
            int spanUnionEnd = 0;
            SuggestionSpan misspelledSpan = null;
            int underlineColor = 0;
            block0: for (int spanIndex = 0; spanIndex < nbSpans; ++spanIndex) {
                SuggestionSpan suggestionSpan = suggestionSpans[spanIndex];
                int spanStart = spannable.getSpanStart(suggestionSpan);
                int spanEnd = spannable.getSpanEnd(suggestionSpan);
                spanUnionStart = Math.min(spanStart, spanUnionStart);
                spanUnionEnd = Math.max(spanEnd, spanUnionEnd);
                if ((suggestionSpan.getFlags() & 2) != 0) {
                    misspelledSpan = suggestionSpan;
                }
                if (spanIndex == 0) {
                    underlineColor = suggestionSpan.getUnderlineColor();
                }
                String[] suggestions = suggestionSpan.getSuggestions();
                int nbSuggestions = suggestions.length;
                for (int suggestionIndex = 0; suggestionIndex < nbSuggestions; ++suggestionIndex) {
                    String suggestion = suggestions[suggestionIndex];
                    boolean suggestionIsDuplicate = false;
                    for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                        if (!this.mSuggestionInfos[i].text.toString().equals(suggestion)) continue;
                        SuggestionSpan otherSuggestionSpan = this.mSuggestionInfos[i].suggestionSpan;
                        int otherSpanStart = spannable.getSpanStart(otherSuggestionSpan);
                        int otherSpanEnd = spannable.getSpanEnd(otherSuggestionSpan);
                        if (spanStart != otherSpanStart || spanEnd != otherSpanEnd) continue;
                        suggestionIsDuplicate = true;
                        break;
                    }
                    if (suggestionIsDuplicate) continue;
                    SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                    suggestionInfo.suggestionSpan = suggestionSpan;
                    suggestionInfo.suggestionIndex = suggestionIndex;
                    suggestionInfo.text.replace(0, suggestionInfo.text.length(), suggestion);
                    ++this.mNumberOfSuggestions;
                    if (this.mNumberOfSuggestions != 5) continue;
                    spanIndex = nbSpans;
                    continue block0;
                }
            }
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                this.highlightTextDifferences(this.mSuggestionInfos[i], spanUnionStart, spanUnionEnd);
            }
            if (misspelledSpan != null) {
                int misspelledStart = spannable.getSpanStart(misspelledSpan);
                int misspelledEnd = spannable.getSpanEnd(misspelledSpan);
                if (misspelledStart >= 0 && misspelledEnd > misspelledStart) {
                    SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                    suggestionInfo.suggestionSpan = misspelledSpan;
                    suggestionInfo.suggestionIndex = -1;
                    suggestionInfo.text.replace(0, suggestionInfo.text.length(), Editor.this.mTextView.getContext().getString(17040362));
                    suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
                    ++this.mNumberOfSuggestions;
                }
            }
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
            suggestionInfo.suggestionSpan = null;
            suggestionInfo.suggestionIndex = -2;
            suggestionInfo.text.replace(0, suggestionInfo.text.length(), Editor.this.mTextView.getContext().getString(17040363));
            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
            ++this.mNumberOfSuggestions;
            if (Editor.this.mSuggestionRangeSpan == null) {
                Editor.this.mSuggestionRangeSpan = new SuggestionRangeSpan();
            }
            if (underlineColor == 0) {
                Editor.this.mSuggestionRangeSpan.setBackgroundColor(((Editor)Editor.this).mTextView.mHighlightColor);
            } else {
                float BACKGROUND_TRANSPARENCY = 0.4f;
                int newAlpha = (int)((float)Color.alpha(underlineColor) * 0.4f);
                Editor.this.mSuggestionRangeSpan.setBackgroundColor((underlineColor & 0xFFFFFF) + (newAlpha << 24));
            }
            spannable.setSpan(Editor.this.mSuggestionRangeSpan, spanUnionStart, spanUnionEnd, 33);
            this.mSuggestionsAdapter.notifyDataSetChanged();
            return true;
        }

        private void highlightTextDifferences(SuggestionInfo suggestionInfo, int unionStart, int unionEnd) {
            Spannable text = (Spannable)Editor.this.mTextView.getText();
            int spanStart = text.getSpanStart(suggestionInfo.suggestionSpan);
            int spanEnd = text.getSpanEnd(suggestionInfo.suggestionSpan);
            suggestionInfo.suggestionStart = spanStart - unionStart;
            suggestionInfo.suggestionEnd = suggestionInfo.suggestionStart + suggestionInfo.text.length();
            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, suggestionInfo.text.length(), 33);
            String textAsString = text.toString();
            suggestionInfo.text.insert(0, textAsString.substring(unionStart, spanStart));
            suggestionInfo.text.append(textAsString.substring(spanEnd, unionEnd));
        }

        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            Editable editable = (Editable)Editor.this.mTextView.getText();
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[position];
            if (suggestionInfo.suggestionIndex == -2) {
                int spanUnionStart = editable.getSpanStart(Editor.this.mSuggestionRangeSpan);
                int spanUnionEnd = editable.getSpanEnd(Editor.this.mSuggestionRangeSpan);
                if (spanUnionStart >= 0 && spanUnionEnd > spanUnionStart) {
                    if (spanUnionEnd < editable.length() && Character.isSpaceChar(editable.charAt(spanUnionEnd)) && (spanUnionStart == 0 || Character.isSpaceChar(editable.charAt(spanUnionStart - 1)))) {
                        ++spanUnionEnd;
                    }
                    Editor.this.mTextView.deleteText_internal(spanUnionStart, spanUnionEnd);
                }
                this.hide();
                return;
            }
            int spanStart = editable.getSpanStart(suggestionInfo.suggestionSpan);
            int spanEnd = editable.getSpanEnd(suggestionInfo.suggestionSpan);
            if (spanStart < 0 || spanEnd <= spanStart) {
                this.hide();
                return;
            }
            String originalText = editable.toString().substring(spanStart, spanEnd);
            if (suggestionInfo.suggestionIndex == -1) {
                Intent intent = new Intent("com.android.settings.USER_DICTIONARY_INSERT");
                intent.putExtra("word", originalText);
                intent.putExtra("locale", Editor.this.mTextView.getTextServicesLocale().toString());
                intent.setFlags(intent.getFlags() | 0x10000000);
                Editor.this.mTextView.getContext().startActivity(intent);
                editable.removeSpan(suggestionInfo.suggestionSpan);
                Selection.setSelection(editable, spanEnd);
                Editor.this.updateSpellCheckSpans(spanStart, spanEnd, false);
            } else {
                SuggestionSpan[] suggestionSpans = editable.getSpans(spanStart, spanEnd, SuggestionSpan.class);
                int length = suggestionSpans.length;
                int[] suggestionSpansStarts = new int[length];
                int[] suggestionSpansEnds = new int[length];
                int[] suggestionSpansFlags = new int[length];
                for (int i = 0; i < length; ++i) {
                    SuggestionSpan suggestionSpan = suggestionSpans[i];
                    suggestionSpansStarts[i] = editable.getSpanStart(suggestionSpan);
                    suggestionSpansEnds[i] = editable.getSpanEnd(suggestionSpan);
                    suggestionSpansFlags[i] = editable.getSpanFlags(suggestionSpan);
                    int suggestionSpanFlags = suggestionSpan.getFlags();
                    if ((suggestionSpanFlags & 2) <= 0) continue;
                    suggestionSpanFlags &= 0xFFFFFFFD;
                    suggestionSpan.setFlags(suggestionSpanFlags &= 0xFFFFFFFE);
                }
                int suggestionStart = suggestionInfo.suggestionStart;
                int suggestionEnd = suggestionInfo.suggestionEnd;
                String suggestion = ((Object)suggestionInfo.text.subSequence(suggestionStart, suggestionEnd)).toString();
                Editor.this.mTextView.replaceText_internal(spanStart, spanEnd, suggestion);
                suggestionInfo.suggestionSpan.notifySelection(Editor.this.mTextView.getContext(), originalText, suggestionInfo.suggestionIndex);
                String[] suggestions = suggestionInfo.suggestionSpan.getSuggestions();
                suggestions[suggestionInfo.suggestionIndex] = originalText;
                int lengthDifference = suggestion.length() - (spanEnd - spanStart);
                for (int i = 0; i < length; ++i) {
                    if (suggestionSpansStarts[i] > spanStart || suggestionSpansEnds[i] < spanEnd) continue;
                    Editor.this.mTextView.setSpan_internal(suggestionSpans[i], suggestionSpansStarts[i], suggestionSpansEnds[i] + lengthDifference, suggestionSpansFlags[i]);
                }
                int newCursorPosition = spanEnd + lengthDifference;
                Editor.this.mTextView.setCursorPosition_internal(newCursorPosition, newCursorPosition);
            }
            this.hide();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SuggestionSpanComparator
        implements Comparator<SuggestionSpan> {
            private SuggestionSpanComparator() {
            }

            @Override
            public int compare(SuggestionSpan span1, SuggestionSpan span2) {
                int flag2;
                int flag1 = span1.getFlags();
                if (flag1 != (flag2 = span2.getFlags())) {
                    boolean misspelled2;
                    boolean easy1 = (flag1 & 1) != 0;
                    boolean easy2 = (flag2 & 1) != 0;
                    boolean misspelled1 = (flag1 & 2) != 0;
                    boolean bl = misspelled2 = (flag2 & 2) != 0;
                    if (easy1 && !misspelled1) {
                        return -1;
                    }
                    if (easy2 && !misspelled2) {
                        return 1;
                    }
                    if (misspelled1) {
                        return -1;
                    }
                    if (misspelled2) {
                        return 1;
                    }
                }
                return (Integer)SuggestionsPopupWindow.this.mSpansLengths.get(span1) - (Integer)SuggestionsPopupWindow.this.mSpansLengths.get(span2);
            }
        }

        private class SuggestionAdapter
        extends BaseAdapter {
            private LayoutInflater mInflater;

            private SuggestionAdapter() {
                this.mInflater = (LayoutInflater)Editor.this.mTextView.getContext().getSystemService("layout_inflater");
            }

            public int getCount() {
                return SuggestionsPopupWindow.this.mNumberOfSuggestions;
            }

            public Object getItem(int position) {
                return SuggestionsPopupWindow.this.mSuggestionInfos[position];
            }

            public long getItemId(int position) {
                return position;
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                TextView textView = (TextView)convertView;
                if (textView == null) {
                    textView = (TextView)this.mInflater.inflate(((Editor)Editor.this).mTextView.mTextEditSuggestionItemLayout, parent, false);
                }
                SuggestionInfo suggestionInfo = SuggestionsPopupWindow.this.mSuggestionInfos[position];
                textView.setText(suggestionInfo.text);
                if (suggestionInfo.suggestionIndex == -1 || suggestionInfo.suggestionIndex == -2) {
                    textView.setBackgroundColor(0);
                } else {
                    textView.setBackgroundColor(-1);
                }
                return textView;
            }
        }

        private class SuggestionInfo {
            int suggestionStart;
            int suggestionEnd;
            SuggestionSpan suggestionSpan;
            int suggestionIndex;
            SpannableStringBuilder text = new SpannableStringBuilder();
            TextAppearanceSpan highlightSpan;

            private SuggestionInfo() {
                this.highlightSpan = new TextAppearanceSpan(Editor.this.mTextView.getContext(), 16974104);
            }
        }

        private class CustomPopupWindow
        extends PopupWindow {
            public CustomPopupWindow(Context context, int defStyle) {
                super(context, null, defStyle);
            }

            public void dismiss() {
                super.dismiss();
                Editor.this.getPositionListener().removeSubscriber(SuggestionsPopupWindow.this);
                ((Spannable)Editor.this.mTextView.getText()).removeSpan(Editor.this.mSuggestionRangeSpan);
                Editor.this.mTextView.setCursorVisible(SuggestionsPopupWindow.this.mCursorWasVisibleBeforeSuggestions);
                if (Editor.this.hasInsertionController()) {
                    Editor.this.getInsertionController().show();
                }
            }
        }
    }

    private abstract class PinnedPopupWindow
    implements TextViewPositionListener {
        protected PopupWindow mPopupWindow;
        protected ViewGroup mContentView;
        int mPositionX;
        int mPositionY;

        protected abstract void createPopupWindow();

        protected abstract void initContentView();

        protected abstract int getTextOffset();

        protected abstract int getVerticalLocalPosition(int var1);

        protected abstract int clipVertically(int var1);

        public PinnedPopupWindow() {
            this.createPopupWindow();
            this.mPopupWindow.setWindowLayoutType(1002);
            this.mPopupWindow.setWidth(-2);
            this.mPopupWindow.setHeight(-2);
            this.initContentView();
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mContentView.setLayoutParams(wrapContent);
            this.mPopupWindow.setContentView(this.mContentView);
        }

        public void show() {
            Editor.this.getPositionListener().addSubscriber(this, false);
            this.computeLocalPosition();
            PositionListener positionListener = Editor.this.getPositionListener();
            this.updatePosition(positionListener.getPositionX(), positionListener.getPositionY());
        }

        protected void measureContent() {
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE));
        }

        private void computeLocalPosition() {
            this.measureContent();
            int width = this.mContentView.getMeasuredWidth();
            int offset = this.getTextOffset();
            this.mPositionX = (int)(Editor.this.mTextView.getLayout().getPrimaryHorizontal(offset) - (float)width / 2.0f);
            this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
            int line = Editor.this.mTextView.getLayout().getLineForOffset(offset);
            this.mPositionY = this.getVerticalLocalPosition(line);
            this.mPositionY += Editor.this.mTextView.viewportToContentVerticalOffset();
        }

        private void updatePosition(int parentPositionX, int parentPositionY) {
            int positionX = parentPositionX + this.mPositionX;
            int positionY = parentPositionY + this.mPositionY;
            positionY = this.clipVertically(positionY);
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            int width = this.mContentView.getMeasuredWidth();
            positionX = Math.min(displayMetrics.widthPixels - width, positionX);
            positionX = Math.max(0, positionX);
            if (this.isShowing()) {
                this.mPopupWindow.update(positionX, positionY, -1, -1);
            } else {
                this.mPopupWindow.showAtLocation(Editor.this.mTextView, 0, positionX, positionY);
            }
        }

        public void hide() {
            this.mPopupWindow.dismiss();
            Editor.this.getPositionListener().removeSubscriber(this);
        }

        public void updatePosition(int parentPositionX, int parentPositionY, boolean parentPositionChanged, boolean parentScrolled) {
            if (this.isShowing() && Editor.this.isOffsetVisible(this.getTextOffset())) {
                if (parentScrolled) {
                    this.computeLocalPosition();
                }
                this.updatePosition(parentPositionX, parentPositionY);
            } else {
                this.hide();
            }
        }

        public boolean isShowing() {
            return this.mPopupWindow.isShowing();
        }
    }

    private class PositionListener
    implements ViewTreeObserver.OnPreDrawListener {
        private final int MAXIMUM_NUMBER_OF_LISTENERS = 6;
        private TextViewPositionListener[] mPositionListeners = new TextViewPositionListener[6];
        private boolean[] mCanMove = new boolean[6];
        private boolean mPositionHasChanged = true;
        private int mPositionX;
        private int mPositionY;
        private int mNumberOfListeners;
        private boolean mScrollHasChanged;
        final int[] mTempCoords = new int[2];

        private PositionListener() {
        }

        public void addSubscriber(TextViewPositionListener positionListener, boolean canMove) {
            if (this.mNumberOfListeners == 0) {
                this.updatePosition();
                ViewTreeObserver vto = Editor.this.mTextView.getViewTreeObserver();
                vto.addOnPreDrawListener(this);
            }
            int emptySlotIndex = -1;
            for (int i = 0; i < 6; ++i) {
                TextViewPositionListener listener = this.mPositionListeners[i];
                if (listener == positionListener) {
                    return;
                }
                if (emptySlotIndex >= 0 || listener != null) continue;
                emptySlotIndex = i;
            }
            this.mPositionListeners[emptySlotIndex] = positionListener;
            this.mCanMove[emptySlotIndex] = canMove;
            ++this.mNumberOfListeners;
        }

        public void removeSubscriber(TextViewPositionListener positionListener) {
            for (int i = 0; i < 6; ++i) {
                if (this.mPositionListeners[i] != positionListener) continue;
                this.mPositionListeners[i] = null;
                --this.mNumberOfListeners;
                break;
            }
            if (this.mNumberOfListeners == 0) {
                ViewTreeObserver vto = Editor.this.mTextView.getViewTreeObserver();
                vto.removeOnPreDrawListener(this);
            }
        }

        public int getPositionX() {
            return this.mPositionX;
        }

        public int getPositionY() {
            return this.mPositionY;
        }

        public boolean onPreDraw() {
            this.updatePosition();
            for (int i = 0; i < 6; ++i) {
                TextViewPositionListener positionListener;
                if (!this.mPositionHasChanged && !this.mScrollHasChanged && !this.mCanMove[i] || (positionListener = this.mPositionListeners[i]) == null) continue;
                positionListener.updatePosition(this.mPositionX, this.mPositionY, this.mPositionHasChanged, this.mScrollHasChanged);
            }
            this.mScrollHasChanged = false;
            return true;
        }

        private void updatePosition() {
            Editor.this.mTextView.getLocationInWindow(this.mTempCoords);
            this.mPositionHasChanged = this.mTempCoords[0] != this.mPositionX || this.mTempCoords[1] != this.mPositionY;
            this.mPositionX = this.mTempCoords[0];
            this.mPositionY = this.mTempCoords[1];
        }

        public void onScrollChanged() {
            this.mScrollHasChanged = true;
        }
    }

    private class EasyEditPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener {
        private static final int POPUP_TEXT_LAYOUT = 17367210;
        private TextView mDeleteTextView;
        private EasyEditSpan mEasyEditSpan;
        private EasyEditDeleteListener mOnDeleteListener;

        private EasyEditPopupWindow() {
        }

        protected void createPopupWindow() {
            this.mPopupWindow = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setClippingEnabled(true);
        }

        protected void initContentView() {
            LinearLayout linearLayout = new LinearLayout(Editor.this.mTextView.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17303089);
            LayoutInflater inflater = (LayoutInflater)Editor.this.mTextView.getContext().getSystemService("layout_inflater");
            ViewGroup.LayoutParams wrapContent = new ViewGroup.LayoutParams(-2, -2);
            this.mDeleteTextView = (TextView)inflater.inflate(17367210, null);
            this.mDeleteTextView.setLayoutParams(wrapContent);
            this.mDeleteTextView.setText(17040360);
            this.mDeleteTextView.setOnClickListener(this);
            this.mContentView.addView(this.mDeleteTextView);
        }

        public void setEasyEditSpan(EasyEditSpan easyEditSpan) {
            this.mEasyEditSpan = easyEditSpan;
        }

        private void setOnDeleteListener(EasyEditDeleteListener listener) {
            this.mOnDeleteListener = listener;
        }

        public void onClick(View view) {
            if (view == this.mDeleteTextView && this.mEasyEditSpan != null && this.mEasyEditSpan.isDeleteEnabled() && this.mOnDeleteListener != null) {
                this.mOnDeleteListener.onDeleteClick(this.mEasyEditSpan);
            }
        }

        public void hide() {
            if (this.mEasyEditSpan != null) {
                this.mEasyEditSpan.setDeleteEnabled(false);
            }
            this.mOnDeleteListener = null;
            super.hide();
        }

        protected int getTextOffset() {
            Editable editable = (Editable)Editor.this.mTextView.getText();
            return editable.getSpanEnd(this.mEasyEditSpan);
        }

        protected int getVerticalLocalPosition(int line) {
            return Editor.this.mTextView.getLayout().getLineBottom(line);
        }

        protected int clipVertically(int positionY) {
            return positionY;
        }
    }

    private static interface EasyEditDeleteListener {
        public void onDeleteClick(EasyEditSpan var1);
    }

    class SpanController
    implements SpanWatcher {
        private static final int DISPLAY_TIMEOUT_MS = 3000;
        private EasyEditPopupWindow mPopupWindow;
        private Runnable mHidePopup;

        SpanController() {
        }

        private boolean isNonIntermediateSelectionSpan(Spannable text, Object span) {
            return (Selection.SELECTION_START == span || Selection.SELECTION_END == span) && (text.getSpanFlags(span) & 0x200) == 0;
        }

        public void onSpanAdded(Spannable text, Object span, int start, int end) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                Editor.this.sendUpdateSelection();
            } else if (span instanceof EasyEditSpan) {
                if (this.mPopupWindow == null) {
                    this.mPopupWindow = new EasyEditPopupWindow();
                    this.mHidePopup = new Runnable(){

                        public void run() {
                            SpanController.this.hide();
                        }
                    };
                }
                if (this.mPopupWindow.mEasyEditSpan != null) {
                    this.mPopupWindow.mEasyEditSpan.setDeleteEnabled(false);
                }
                this.mPopupWindow.setEasyEditSpan((EasyEditSpan)span);
                this.mPopupWindow.setOnDeleteListener(new EasyEditDeleteListener(){

                    public void onDeleteClick(EasyEditSpan span) {
                        Editable editable = (Editable)Editor.this.mTextView.getText();
                        int start = editable.getSpanStart(span);
                        int end = editable.getSpanEnd(span);
                        if (start >= 0 && end >= 0) {
                            SpanController.this.sendEasySpanNotification(1, span);
                            Editor.this.mTextView.deleteText_internal(start, end);
                        }
                        editable.removeSpan(span);
                    }
                });
                if (Editor.this.mTextView.getWindowVisibility() != 0) {
                    return;
                }
                if (Editor.this.mTextView.getLayout() == null) {
                    return;
                }
                if (Editor.this.extractedTextModeWillBeStarted()) {
                    return;
                }
                this.mPopupWindow.show();
                Editor.this.mTextView.removeCallbacks(this.mHidePopup);
                Editor.this.mTextView.postDelayed(this.mHidePopup, 3000L);
            }
        }

        public void onSpanRemoved(Spannable text, Object span, int start, int end) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                Editor.this.sendUpdateSelection();
            } else if (this.mPopupWindow != null && span == this.mPopupWindow.mEasyEditSpan) {
                this.hide();
            }
        }

        public void onSpanChanged(Spannable text, Object span, int previousStart, int previousEnd, int newStart, int newEnd) {
            if (this.isNonIntermediateSelectionSpan(text, span)) {
                Editor.this.sendUpdateSelection();
            } else if (this.mPopupWindow != null && span instanceof EasyEditSpan) {
                EasyEditSpan easyEditSpan = (EasyEditSpan)span;
                this.sendEasySpanNotification(2, easyEditSpan);
                text.removeSpan(easyEditSpan);
            }
        }

        public void hide() {
            if (this.mPopupWindow != null) {
                this.mPopupWindow.hide();
                Editor.this.mTextView.removeCallbacks(this.mHidePopup);
            }
        }

        private void sendEasySpanNotification(int textChangedType, EasyEditSpan span) {
            try {
                PendingIntent pendingIntent = span.getPendingIntent();
                if (pendingIntent != null) {
                    Intent intent = new Intent();
                    intent.putExtra("android.text.style.EXTRA_TEXT_CHANGED_TYPE", textChangedType);
                    pendingIntent.send(Editor.this.mTextView.getContext(), 0, intent);
                }
            }
            catch (PendingIntent.CanceledException e) {
                Log.w(Editor.TAG, "PendingIntent for notification cannot be sent", e);
            }
        }
    }

    private static class DragLocalState {
        public TextView sourceTextView;
        public int start;
        public int end;

        public DragLocalState(TextView sourceTextView, int start, int end) {
            this.sourceTextView = sourceTextView;
            this.start = start;
            this.end = end;
        }
    }

    private class Blink
    extends Handler
    implements Runnable {
        private boolean mCancelled;

        private Blink() {
        }

        public void run() {
            if (this.mCancelled) {
                return;
            }
            this.removeCallbacks(this);
            if (Editor.this.shouldBlink()) {
                if (Editor.this.mTextView.getLayout() != null) {
                    Editor.this.mTextView.invalidateCursorPath();
                }
                this.postAtTime(this, SystemClock.uptimeMillis() + 500L);
            }
        }

        void cancel() {
            if (!this.mCancelled) {
                this.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        void uncancel() {
            this.mCancelled = false;
        }
    }

    private static interface TextViewPositionListener {
        public void updatePosition(int var1, int var2, boolean var3, boolean var4);
    }
}

