/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.appwidget.AppWidgetManager;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.IRemoteViewsAdapterConnection;
import com.android.internal.widget.IRemoteViewsFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteViewsAdapter
extends BaseAdapter
implements Handler.Callback {
    private static final String MULTI_USER_PERM = "android.permission.INTERACT_ACROSS_USERS_FULL";
    private static final String TAG = "RemoteViewsAdapter";
    private static final int sDefaultCacheSize = 40;
    private static final int sUnbindServiceDelay = 5000;
    private static final int sDefaultLoadingViewHeight = 50;
    private static final int sDefaultMessageType = 0;
    private static final int sUnbindServiceMessageType = 1;
    private final Context mContext;
    private final Intent mIntent;
    private final int mAppWidgetId;
    private LayoutInflater mLayoutInflater;
    private RemoteViewsAdapterServiceConnection mServiceConnection;
    private WeakReference<RemoteAdapterConnectionCallback> mCallback;
    private RemoteViews.OnClickHandler mRemoteViewsOnClickHandler;
    private FixedSizeRemoteViewsCache mCache;
    private int mVisibleWindowLowerBound;
    private int mVisibleWindowUpperBound;
    private boolean mNotifyDataSetChangedAfterOnServiceConnected = false;
    private RemoteViewsFrameLayoutRefSet mRequestedViews;
    private HandlerThread mWorkerThread;
    private Handler mWorkerQueue;
    private Handler mMainQueue;
    private static final HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> sCachedRemoteViewsCaches = new HashMap();
    private static final HashMap<RemoteViewsCacheKey, Runnable> sRemoteViewsCacheRemoveRunnables = new HashMap();
    private static HandlerThread sCacheRemovalThread;
    private static Handler sCacheRemovalQueue;
    private static final int REMOTE_VIEWS_CACHE_DURATION = 5000;
    private boolean mDataReady = false;
    int mUserId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteViewsAdapter(Context context, Intent intent, RemoteAdapterConnectionCallback callback) {
        this.mContext = context;
        this.mIntent = intent;
        this.mAppWidgetId = intent.getIntExtra("remoteAdapterAppWidgetId", -1);
        this.mLayoutInflater = LayoutInflater.from(context);
        if (this.mIntent == null) {
            throw new IllegalArgumentException("Non-null Intent must be specified.");
        }
        this.mRequestedViews = new RemoteViewsFrameLayoutRefSet();
        RemoteViewsAdapter.checkInteractAcrossUsersPermission(context, UserHandle.myUserId());
        this.mUserId = context.getUserId();
        if (intent.hasExtra("remoteAdapterAppWidgetId")) {
            intent.removeExtra("remoteAdapterAppWidgetId");
        }
        this.mWorkerThread = new HandlerThread("RemoteViewsCache-loader");
        this.mWorkerThread.start();
        this.mWorkerQueue = new Handler(this.mWorkerThread.getLooper());
        this.mMainQueue = new Handler(Looper.myLooper(), this);
        if (sCacheRemovalThread == null) {
            sCacheRemovalThread = new HandlerThread("RemoteViewsAdapter-cachePruner");
            sCacheRemovalThread.start();
            sCacheRemovalQueue = new Handler(sCacheRemovalThread.getLooper());
        }
        this.mCallback = new WeakReference<RemoteAdapterConnectionCallback>(callback);
        this.mServiceConnection = new RemoteViewsAdapterServiceConnection(this);
        RemoteViewsCacheKey key = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId, this.mUserId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        synchronized (hashMap) {
            if (sCachedRemoteViewsCaches.containsKey(key)) {
                this.mCache = sCachedRemoteViewsCaches.get(key);
                RemoteViewsMetaData remoteViewsMetaData = this.mCache.mMetaData;
                synchronized (remoteViewsMetaData) {
                    if (((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count > 0) {
                        this.mDataReady = true;
                    }
                }
            } else {
                this.mCache = new FixedSizeRemoteViewsCache(40);
            }
            if (!this.mDataReady) {
                this.requestBindService();
            }
        }
    }

    private static void checkInteractAcrossUsersPermission(Context context, int userId) {
        if (context.getUserId() != userId && context.checkCallingOrSelfPermission(MULTI_USER_PERM) != 0) {
            throw new SecurityException("Must have permission android.permission.INTERACT_ACROSS_USERS_FULL to inflate another user's widget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mWorkerThread != null) {
                this.mWorkerThread.quit();
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean isDataReady() {
        return this.mDataReady;
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler handler) {
        this.mRemoteViewsOnClickHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRemoteViewsCache() {
        final RemoteViewsCacheKey key = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId, this.mUserId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        synchronized (hashMap) {
            if (sRemoteViewsCacheRemoveRunnables.containsKey(key)) {
                sCacheRemovalQueue.removeCallbacks(sRemoteViewsCacheRemoveRunnables.get(key));
                sRemoteViewsCacheRemoveRunnables.remove(key);
            }
            int metaDataCount = 0;
            int numRemoteViewsCached = 0;
            Object object = this.mCache.mMetaData;
            synchronized (object) {
                metaDataCount = ((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count;
            }
            object = this.mCache;
            synchronized (object) {
                numRemoteViewsCached = this.mCache.mIndexRemoteViews.size();
            }
            if (metaDataCount > 0 && numRemoteViewsCached > 0) {
                sCachedRemoteViewsCaches.put(key, this.mCache);
            }
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    HashMap hashMap = sCachedRemoteViewsCaches;
                    synchronized (hashMap) {
                        if (sCachedRemoteViewsCaches.containsKey(key)) {
                            sCachedRemoteViewsCaches.remove(key);
                        }
                        if (sRemoteViewsCacheRemoveRunnables.containsKey(key)) {
                            sRemoteViewsCacheRemoveRunnables.remove(key);
                        }
                    }
                }
            };
            sRemoteViewsCacheRemoveRunnables.put(key, r);
            sCacheRemovalQueue.postDelayed(r, 5000L);
        }
    }

    private void loadNextIndexInBackground() {
        this.mWorkerQueue.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (RemoteViewsAdapter.this.mServiceConnection.isConnected()) {
                    int position = -1;
                    FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = RemoteViewsAdapter.this.mCache;
                    synchronized (fixedSizeRemoteViewsCache) {
                        int[] res = RemoteViewsAdapter.this.mCache.getNextIndexToLoad();
                        position = res[0];
                    }
                    if (position > -1) {
                        RemoteViewsAdapter.this.updateRemoteViews(position, true);
                        RemoteViewsAdapter.this.loadNextIndexInBackground();
                    } else {
                        RemoteViewsAdapter.this.enqueueDeferredUnbindServiceMessage();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processException(String method, Exception e) {
        Log.e(TAG, "Error in " + method + ": " + e.getMessage());
        RemoteViewsMetaData metaData = this.mCache.getMetaData();
        Object object = metaData;
        synchronized (object) {
            metaData.reset();
        }
        object = this.mCache;
        synchronized (object) {
            this.mCache.reset();
        }
        this.mMainQueue.post(new Runnable(){

            public void run() {
                RemoteViewsAdapter.this.superNotifyDataSetChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTemporaryMetaData() {
        IRemoteViewsFactory factory = this.mServiceConnection.getRemoteViewsFactory();
        try {
            RemoteViewsMetaData tmpMetaData;
            boolean hasStableIds = factory.hasStableIds();
            int viewTypeCount = factory.getViewTypeCount();
            int count = factory.getCount();
            RemoteViews loadingView = factory.getLoadingView();
            RemoteViews firstView = null;
            if (count > 0 && loadingView == null) {
                firstView = factory.getViewAt(0);
            }
            RemoteViewsMetaData remoteViewsMetaData = tmpMetaData = this.mCache.getTemporaryMetaData();
            synchronized (remoteViewsMetaData) {
                tmpMetaData.hasStableIds = hasStableIds;
                tmpMetaData.viewTypeCount = viewTypeCount + 1;
                tmpMetaData.count = count;
                tmpMetaData.setLoadingViewTemplates(loadingView, firstView);
            }
        }
        catch (RemoteException e) {
            this.processException("updateMetaData", e);
        }
        catch (RuntimeException e) {
            this.processException("updateMetaData", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemoteViews(final int position, boolean notifyWhenLoaded) {
        int cacheCount;
        boolean viewTypeInRange;
        IRemoteViewsFactory factory = this.mServiceConnection.getRemoteViewsFactory();
        RemoteViews remoteViews = null;
        long itemId = 0L;
        try {
            remoteViews = factory.getViewAt(position);
            remoteViews.setUser(new UserHandle(this.mUserId));
            itemId = factory.getItemId(position);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in updateRemoteViews(" + position + "): " + e.getMessage());
            return;
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error in updateRemoteViews(" + position + "): " + e.getMessage());
            return;
        }
        if (remoteViews == null) {
            Log.e(TAG, "Error in updateRemoteViews(" + position + "): " + " null RemoteViews " + "returned from RemoteViewsFactory.");
            return;
        }
        int layoutId = remoteViews.getLayoutId();
        RemoteViewsMetaData metaData = this.mCache.getMetaData();
        Object object = metaData;
        synchronized (object) {
            viewTypeInRange = metaData.isViewTypeInRange(layoutId);
            cacheCount = ((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count;
        }
        object = this.mCache;
        synchronized (object) {
            if (viewTypeInRange) {
                ArrayList<Integer> visibleWindow = this.getVisibleWindow(this.mVisibleWindowLowerBound, this.mVisibleWindowUpperBound, cacheCount);
                this.mCache.insert(position, remoteViews, itemId, visibleWindow);
                final RemoteViews rv = remoteViews;
                if (notifyWhenLoaded) {
                    this.mMainQueue.post(new Runnable(){

                        public void run() {
                            RemoteViewsAdapter.this.mRequestedViews.notifyOnRemoteViewsLoaded(position, rv);
                        }
                    });
                }
            } else {
                Log.e(TAG, "Error: widget's RemoteViewsFactory returns more view types than  indicated by getViewTypeCount() ");
            }
        }
    }

    public Intent getRemoteViewsServiceIntent() {
        return this.mIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.count;
        }
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getItemId(int position) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (this.mCache.containsMetaDataAt(position)) {
                return this.mCache.getMetaDataAt((int)position).itemId;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItemViewType(int position) {
        RemoteViewsMetaData metaData;
        int typeId = 0;
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (!this.mCache.containsMetaDataAt(position)) {
                return 0;
            }
            typeId = this.mCache.getMetaDataAt((int)position).typeId;
        }
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.getMappedViewType(typeId);
        }
    }

    private int getConvertViewTypeId(View convertView) {
        Object tag;
        int typeId = -1;
        if (convertView != null && (tag = convertView.getTag(16908889)) != null) {
            typeId = (Integer)tag;
        }
        return typeId;
    }

    public void setVisibleRangeHint(int lowerBound, int upperBound) {
        this.mVisibleWindowLowerBound = lowerBound;
        this.mVisibleWindowUpperBound = upperBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            boolean isInCache = this.mCache.containsRemoteViewAt(position);
            boolean isConnected = this.mServiceConnection.isConnected();
            boolean hasNewItems = false;
            if (convertView != null && convertView instanceof RemoteViewsFrameLayout) {
                this.mRequestedViews.removeView((RemoteViewsFrameLayout)convertView);
            }
            if (!isInCache && !isConnected) {
                this.requestBindService();
            } else {
                hasNewItems = this.mCache.queuePositionsToBePreloadedFromRequestedPosition(position);
            }
            if (!isInCache) {
                RemoteViewsMetaData metaData;
                RemoteViewsFrameLayout loadingView = null;
                RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
                synchronized (remoteViewsMetaData) {
                    loadingView = metaData.createLoadingView(position, convertView, parent, this.mCache, this.mLayoutInflater, this.mRemoteViewsOnClickHandler);
                }
                this.mRequestedViews.add(position, loadingView);
                this.mCache.queueRequestedPositionToLoad(position);
                this.loadNextIndexInBackground();
                return loadingView;
            }
            View convertViewChild = null;
            int convertViewTypeId = 0;
            RemoteViewsFrameLayout layout2 = null;
            if (convertView instanceof RemoteViewsFrameLayout) {
                layout2 = (RemoteViewsFrameLayout)convertView;
                convertViewChild = layout2.getChildAt(0);
                convertViewTypeId = this.getConvertViewTypeId(convertViewChild);
            }
            Context context = parent.getContext();
            RemoteViews rv = this.mCache.getRemoteViewsAt(position);
            RemoteViewsIndexMetaData indexMetaData = this.mCache.getMetaDataAt(position);
            int typeId = indexMetaData.typeId;
            try {
                if (layout2 != null) {
                    if (convertViewTypeId == typeId) {
                        rv.reapply(context, convertViewChild, this.mRemoteViewsOnClickHandler);
                        RemoteViewsFrameLayout remoteViewsFrameLayout = layout2;
                        return remoteViewsFrameLayout;
                    }
                    layout2.removeAllViews();
                } else {
                    layout2 = new RemoteViewsFrameLayout(context);
                }
                View newView = rv.apply(context, parent, this.mRemoteViewsOnClickHandler);
                newView.setTagInternal(16908889, new Integer(typeId));
                layout2.addView(newView);
                RemoteViewsFrameLayout remoteViewsFrameLayout = layout2;
                return remoteViewsFrameLayout;
            }
            catch (Exception e) {
                Log.w(TAG, "Error inflating RemoteViews at position: " + position + ", using" + "loading view instead" + e);
                RemoteViewsFrameLayout loadingView = null;
                RemoteViewsMetaData metaData = this.mCache.getMetaData();
                Object object = metaData;
                synchronized (object) {
                    loadingView = metaData.createLoadingView(position, convertView, parent, this.mCache, this.mLayoutInflater, this.mRemoteViewsOnClickHandler);
                }
                object = loadingView;
                return object;
            }
            finally {
                if (hasNewItems) {
                    this.loadNextIndexInBackground();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getViewTypeCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.viewTypeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStableIds() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.hasStableIds;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNotifyDataSetChanged() {
        ArrayList<Integer> visibleWindow;
        int newCount;
        IRemoteViewsFactory factory = this.mServiceConnection.getRemoteViewsFactory();
        try {
            factory.onDataSetChanged();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in updateNotifyDataSetChanged(): " + e.getMessage());
            return;
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error in updateNotifyDataSetChanged(): " + e.getMessage());
            return;
        }
        FixedSizeRemoteViewsCache e = this.mCache;
        synchronized (e) {
            this.mCache.reset();
        }
        this.updateTemporaryMetaData();
        RemoteViewsMetaData remoteViewsMetaData = this.mCache.getTemporaryMetaData();
        synchronized (remoteViewsMetaData) {
            newCount = this.mCache.getTemporaryMetaData().count;
            visibleWindow = this.getVisibleWindow(this.mVisibleWindowLowerBound, this.mVisibleWindowUpperBound, newCount);
        }
        for (int i : visibleWindow) {
            if (i >= newCount) continue;
            this.updateRemoteViews(i, false);
        }
        this.mMainQueue.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = RemoteViewsAdapter.this.mCache;
                synchronized (fixedSizeRemoteViewsCache) {
                    RemoteViewsAdapter.this.mCache.commitTemporaryMetaData();
                }
                RemoteViewsAdapter.this.superNotifyDataSetChanged();
                RemoteViewsAdapter.this.enqueueDeferredUnbindServiceMessage();
            }
        });
        this.mNotifyDataSetChangedAfterOnServiceConnected = false;
    }

    private ArrayList<Integer> getVisibleWindow(int lower, int upper, int count) {
        ArrayList<Integer> window = new ArrayList<Integer>();
        if (lower == 0 && upper == 0 || lower < 0 || upper < 0) {
            return window;
        }
        if (lower <= upper) {
            for (int i = lower; i <= upper; ++i) {
                window.add(i);
            }
        } else {
            int i;
            for (i = lower; i < count; ++i) {
                window.add(i);
            }
            for (i = 0; i <= upper; ++i) {
                window.add(i);
            }
        }
        return window;
    }

    @Override
    public void notifyDataSetChanged() {
        this.mMainQueue.removeMessages(1);
        if (!this.mServiceConnection.isConnected()) {
            if (this.mNotifyDataSetChangedAfterOnServiceConnected) {
                return;
            }
            this.mNotifyDataSetChangedAfterOnServiceConnected = true;
            this.requestBindService();
            return;
        }
        this.mWorkerQueue.post(new Runnable(){

            public void run() {
                RemoteViewsAdapter.this.onNotifyDataSetChanged();
            }
        });
    }

    void superNotifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    @Override
    public boolean handleMessage(Message msg) {
        boolean result = false;
        switch (msg.what) {
            case 1: {
                if (this.mServiceConnection.isConnected()) {
                    this.mServiceConnection.unbind(this.mContext, this.mAppWidgetId, this.mIntent);
                }
                result = true;
                break;
            }
        }
        return result;
    }

    private void enqueueDeferredUnbindServiceMessage() {
        this.mMainQueue.removeMessages(1);
        this.mMainQueue.sendEmptyMessageDelayed(1, 5000L);
    }

    private boolean requestBindService() {
        if (!this.mServiceConnection.isConnected()) {
            this.mServiceConnection.bind(this.mContext, this.mAppWidgetId, this.mIntent);
        }
        this.mMainQueue.removeMessages(1);
        return this.mServiceConnection.isConnected();
    }

    static class RemoteViewsCacheKey {
        final Intent.FilterComparison filter;
        final int widgetId;
        final int userId;

        RemoteViewsCacheKey(Intent.FilterComparison filter, int widgetId, int userId) {
            this.filter = filter;
            this.widgetId = widgetId;
            this.userId = userId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RemoteViewsCacheKey)) {
                return false;
            }
            RemoteViewsCacheKey other = (RemoteViewsCacheKey)o;
            return other.filter.equals(this.filter) && other.widgetId == this.widgetId && other.userId == this.userId;
        }

        public int hashCode() {
            return (this.filter == null ? 0 : this.filter.hashCode()) ^ this.widgetId << 2 ^ this.userId << 10;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedSizeRemoteViewsCache {
        private static final String TAG = "FixedSizeRemoteViewsCache";
        private final RemoteViewsMetaData mMetaData;
        private final RemoteViewsMetaData mTemporaryMetaData;
        private HashMap<Integer, RemoteViewsIndexMetaData> mIndexMetaData;
        private HashMap<Integer, RemoteViews> mIndexRemoteViews;
        private HashSet<Integer> mRequestedIndices;
        private int mLastRequestedIndex;
        private HashSet<Integer> mLoadIndices;
        private int mPreloadLowerBound;
        private int mPreloadUpperBound;
        private int mMaxCount;
        private int mMaxCountSlack;
        private static final float sMaxCountSlackPercent = 0.75f;
        private static final int sMaxMemoryLimitInBytes = 0x200000;

        public FixedSizeRemoteViewsCache(int maxCacheSize) {
            this.mMaxCount = maxCacheSize;
            this.mMaxCountSlack = Math.round(0.75f * (float)(this.mMaxCount / 2));
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mMetaData = new RemoteViewsMetaData();
            this.mTemporaryMetaData = new RemoteViewsMetaData();
            this.mIndexMetaData = new HashMap();
            this.mIndexRemoteViews = new HashMap();
            this.mRequestedIndices = new HashSet();
            this.mLastRequestedIndex = -1;
            this.mLoadIndices = new HashSet();
        }

        public void insert(int position, RemoteViews v, long itemId, ArrayList<Integer> visibleWindow) {
            int pruneFromPosition;
            if (this.mIndexRemoteViews.size() >= this.mMaxCount) {
                this.mIndexRemoteViews.remove(this.getFarthestPositionFrom(position, visibleWindow));
            }
            int n = pruneFromPosition = this.mLastRequestedIndex > -1 ? this.mLastRequestedIndex : position;
            while (this.getRemoteViewsBitmapMemoryUsage() >= 0x200000) {
                this.mIndexRemoteViews.remove(this.getFarthestPositionFrom(pruneFromPosition, visibleWindow));
            }
            if (this.mIndexMetaData.containsKey(position)) {
                RemoteViewsIndexMetaData metaData = this.mIndexMetaData.get(position);
                metaData.set(v, itemId);
            } else {
                this.mIndexMetaData.put(position, new RemoteViewsIndexMetaData(v, itemId));
            }
            this.mIndexRemoteViews.put(position, v);
        }

        public RemoteViewsMetaData getMetaData() {
            return this.mMetaData;
        }

        public RemoteViewsMetaData getTemporaryMetaData() {
            return this.mTemporaryMetaData;
        }

        public RemoteViews getRemoteViewsAt(int position) {
            if (this.mIndexRemoteViews.containsKey(position)) {
                return this.mIndexRemoteViews.get(position);
            }
            return null;
        }

        public RemoteViewsIndexMetaData getMetaDataAt(int position) {
            if (this.mIndexMetaData.containsKey(position)) {
                return this.mIndexMetaData.get(position);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitTemporaryMetaData() {
            RemoteViewsMetaData remoteViewsMetaData = this.mTemporaryMetaData;
            synchronized (remoteViewsMetaData) {
                RemoteViewsMetaData remoteViewsMetaData2 = this.mMetaData;
                synchronized (remoteViewsMetaData2) {
                    this.mMetaData.set(this.mTemporaryMetaData);
                }
            }
        }

        private int getRemoteViewsBitmapMemoryUsage() {
            int mem = 0;
            for (Integer i : this.mIndexRemoteViews.keySet()) {
                RemoteViews v = this.mIndexRemoteViews.get(i);
                if (v == null) continue;
                mem += v.estimateMemoryUsage();
            }
            return mem;
        }

        private int getFarthestPositionFrom(int pos, ArrayList<Integer> visibleWindow) {
            int maxDist = 0;
            int maxDistIndex = -1;
            int maxDistNotVisible = 0;
            int maxDistIndexNotVisible = -1;
            for (int i : this.mIndexRemoteViews.keySet()) {
                int dist = Math.abs(i - pos);
                if (dist > maxDistNotVisible && !visibleWindow.contains(i)) {
                    maxDistIndexNotVisible = i;
                    maxDistNotVisible = dist;
                }
                if (dist < maxDist) continue;
                maxDistIndex = i;
                maxDist = dist;
            }
            if (maxDistIndexNotVisible > -1) {
                return maxDistIndexNotVisible;
            }
            return maxDistIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueRequestedPositionToLoad(int position) {
            this.mLastRequestedIndex = position;
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                this.mRequestedIndices.add(position);
                this.mLoadIndices.add(position);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queuePositionsToBePreloadedFromRequestedPosition(int position) {
            int center;
            if (this.mPreloadLowerBound <= position && position <= this.mPreloadUpperBound && Math.abs(position - (center = (this.mPreloadUpperBound + this.mPreloadLowerBound) / 2)) < this.mMaxCountSlack) {
                return false;
            }
            int count = 0;
            Object object = this.mMetaData;
            synchronized (object) {
                count = this.mMetaData.count;
            }
            object = this.mLoadIndices;
            synchronized (object) {
                this.mLoadIndices.clear();
                this.mLoadIndices.addAll(this.mRequestedIndices);
                int halfMaxCount = this.mMaxCount / 2;
                this.mPreloadLowerBound = position - halfMaxCount;
                this.mPreloadUpperBound = position + halfMaxCount;
                int effectiveLowerBound = Math.max(0, this.mPreloadLowerBound);
                int effectiveUpperBound = Math.min(this.mPreloadUpperBound, count - 1);
                for (int i = effectiveLowerBound; i <= effectiveUpperBound; ++i) {
                    this.mLoadIndices.add(i);
                }
                this.mLoadIndices.removeAll(this.mIndexRemoteViews.keySet());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getNextIndexToLoad() {
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                if (!this.mRequestedIndices.isEmpty()) {
                    Integer i = this.mRequestedIndices.iterator().next();
                    this.mRequestedIndices.remove(i);
                    this.mLoadIndices.remove(i);
                    return new int[]{i, 1};
                }
                if (!this.mLoadIndices.isEmpty()) {
                    Integer i = this.mLoadIndices.iterator().next();
                    this.mLoadIndices.remove(i);
                    return new int[]{i, 0};
                }
                return new int[]{-1, 0};
            }
        }

        public boolean containsRemoteViewAt(int position) {
            return this.mIndexRemoteViews.containsKey(position);
        }

        public boolean containsMetaDataAt(int position) {
            return this.mIndexMetaData.containsKey(position);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mLastRequestedIndex = -1;
            this.mIndexRemoteViews.clear();
            this.mIndexMetaData.clear();
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                this.mRequestedIndices.clear();
                this.mLoadIndices.clear();
            }
        }
    }

    private static class RemoteViewsIndexMetaData {
        int typeId;
        long itemId;

        public RemoteViewsIndexMetaData(RemoteViews v, long itemId) {
            this.set(v, itemId);
        }

        public void set(RemoteViews v, long id2) {
            this.itemId = id2;
            this.typeId = v != null ? v.getLayoutId() : 0;
        }
    }

    private static class RemoteViewsMetaData {
        int count;
        int viewTypeCount;
        boolean hasStableIds;
        RemoteViews mUserLoadingView;
        RemoteViews mFirstView;
        int mFirstViewHeight;
        private final HashMap<Integer, Integer> mTypeIdIndexMap = new HashMap();

        public RemoteViewsMetaData() {
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(RemoteViewsMetaData d) {
            RemoteViewsMetaData remoteViewsMetaData = d;
            synchronized (remoteViewsMetaData) {
                this.count = d.count;
                this.viewTypeCount = d.viewTypeCount;
                this.hasStableIds = d.hasStableIds;
                this.setLoadingViewTemplates(d.mUserLoadingView, d.mFirstView);
            }
        }

        public void reset() {
            this.count = 0;
            this.viewTypeCount = 1;
            this.hasStableIds = true;
            this.mUserLoadingView = null;
            this.mFirstView = null;
            this.mFirstViewHeight = 0;
            this.mTypeIdIndexMap.clear();
        }

        public void setLoadingViewTemplates(RemoteViews loadingView, RemoteViews firstView) {
            this.mUserLoadingView = loadingView;
            if (firstView != null) {
                this.mFirstView = firstView;
                this.mFirstViewHeight = -1;
            }
        }

        public int getMappedViewType(int typeId) {
            if (this.mTypeIdIndexMap.containsKey(typeId)) {
                return this.mTypeIdIndexMap.get(typeId);
            }
            int incrementalTypeId = this.mTypeIdIndexMap.size() + 1;
            this.mTypeIdIndexMap.put(typeId, incrementalTypeId);
            return incrementalTypeId;
        }

        public boolean isViewTypeInRange(int typeId) {
            int mappedType = this.getMappedViewType(typeId);
            return mappedType < this.viewTypeCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RemoteViewsFrameLayout createLoadingView(int position, View convertView, ViewGroup parent, Object lock, LayoutInflater layoutInflater, RemoteViews.OnClickHandler handler) {
            Context context = parent.getContext();
            RemoteViewsFrameLayout layout2 = new RemoteViewsFrameLayout(context);
            Object object = lock;
            synchronized (object) {
                boolean customLoadingViewAvailable = false;
                if (this.mUserLoadingView != null) {
                    try {
                        View loadingView = this.mUserLoadingView.apply(parent.getContext(), parent, handler);
                        loadingView.setTagInternal(16908889, new Integer(0));
                        layout2.addView(loadingView);
                        customLoadingViewAvailable = true;
                    }
                    catch (Exception e) {
                        Log.w(RemoteViewsAdapter.TAG, "Error inflating custom loading view, using default loadingview instead", e);
                    }
                }
                if (!customLoadingViewAvailable) {
                    if (this.mFirstViewHeight < 0) {
                        try {
                            View firstView = this.mFirstView.apply(parent.getContext(), parent, handler);
                            firstView.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
                            this.mFirstViewHeight = firstView.getMeasuredHeight();
                            this.mFirstView = null;
                        }
                        catch (Exception e) {
                            float density = context.getResources().getDisplayMetrics().density;
                            this.mFirstViewHeight = Math.round(50.0f * density);
                            this.mFirstView = null;
                            Log.w(RemoteViewsAdapter.TAG, "Error inflating first RemoteViews" + e);
                        }
                    }
                    TextView loadingTextView = (TextView)layoutInflater.inflate(17367174, (ViewGroup)layout2, false);
                    loadingTextView.setHeight(this.mFirstViewHeight);
                    loadingTextView.setTag(new Integer(0));
                    layout2.addView(loadingTextView);
                }
            }
            return layout2;
        }
    }

    private class RemoteViewsFrameLayoutRefSet {
        private HashMap<Integer, LinkedList<RemoteViewsFrameLayout>> mReferences = new HashMap();
        private HashMap<RemoteViewsFrameLayout, LinkedList<RemoteViewsFrameLayout>> mViewToLinkedList = new HashMap();

        public void add(int position, RemoteViewsFrameLayout layout2) {
            LinkedList<Object> refs;
            Integer pos = position;
            if (this.mReferences.containsKey(pos)) {
                refs = this.mReferences.get(pos);
            } else {
                refs = new LinkedList();
                this.mReferences.put(pos, refs);
            }
            this.mViewToLinkedList.put(layout2, refs);
            refs.add(layout2);
        }

        public void notifyOnRemoteViewsLoaded(int position, RemoteViews view) {
            if (view == null) {
                return;
            }
            Integer pos = position;
            if (this.mReferences.containsKey(pos)) {
                LinkedList<RemoteViewsFrameLayout> refs = this.mReferences.get(pos);
                for (RemoteViewsFrameLayout ref : refs) {
                    ref.onRemoteViewsLoaded(view, RemoteViewsAdapter.this.mRemoteViewsOnClickHandler);
                    if (!this.mViewToLinkedList.containsKey(ref)) continue;
                    this.mViewToLinkedList.remove(ref);
                }
                refs.clear();
                this.mReferences.remove(pos);
            }
        }

        public void removeView(RemoteViewsFrameLayout rvfl) {
            if (this.mViewToLinkedList.containsKey(rvfl)) {
                this.mViewToLinkedList.get(rvfl).remove(rvfl);
                this.mViewToLinkedList.remove(rvfl);
            }
        }

        public void clear() {
            this.mReferences.clear();
            this.mViewToLinkedList.clear();
        }
    }

    private static class RemoteViewsFrameLayout
    extends FrameLayout {
        public RemoteViewsFrameLayout(Context context) {
            super(context);
        }

        public void onRemoteViewsLoaded(RemoteViews view, RemoteViews.OnClickHandler handler) {
            try {
                this.removeAllViews();
                this.addView(view.apply(this.getContext(), this, handler));
            }
            catch (Exception e) {
                Log.e(RemoteViewsAdapter.TAG, "Failed to apply RemoteViews.");
            }
        }
    }

    private static class RemoteViewsAdapterServiceConnection
    extends IRemoteViewsAdapterConnection.Stub {
        private boolean mIsConnected;
        private boolean mIsConnecting;
        private WeakReference<RemoteViewsAdapter> mAdapter;
        private IRemoteViewsFactory mRemoteViewsFactory;

        public RemoteViewsAdapterServiceConnection(RemoteViewsAdapter adapter) {
            this.mAdapter = new WeakReference<RemoteViewsAdapter>(adapter);
        }

        public synchronized void bind(Context context, int appWidgetId, Intent intent) {
            if (!this.mIsConnecting) {
                try {
                    AppWidgetManager mgr = AppWidgetManager.getInstance(context);
                    RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
                    if (adapter != null) {
                        RemoteViewsAdapter.checkInteractAcrossUsersPermission(context, adapter.mUserId);
                        mgr.bindRemoteViewsService(appWidgetId, intent, this.asBinder(), new UserHandle(adapter.mUserId));
                    } else {
                        Slog.w(RemoteViewsAdapter.TAG, "bind: adapter was null");
                    }
                    this.mIsConnecting = true;
                }
                catch (Exception e) {
                    Log.e("RemoteViewsAdapterServiceConnection", "bind(): " + e.getMessage());
                    this.mIsConnecting = false;
                    this.mIsConnected = false;
                }
            }
        }

        public synchronized void unbind(Context context, int appWidgetId, Intent intent) {
            try {
                AppWidgetManager mgr = AppWidgetManager.getInstance(context);
                RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
                if (adapter != null) {
                    RemoteViewsAdapter.checkInteractAcrossUsersPermission(context, adapter.mUserId);
                    mgr.unbindRemoteViewsService(appWidgetId, intent, new UserHandle(adapter.mUserId));
                } else {
                    Slog.w(RemoteViewsAdapter.TAG, "unbind: adapter was null");
                }
                this.mIsConnecting = false;
            }
            catch (Exception e) {
                Log.e("RemoteViewsAdapterServiceConnection", "unbind(): " + e.getMessage());
                this.mIsConnecting = false;
                this.mIsConnected = false;
            }
        }

        public synchronized void onServiceConnected(IBinder service) {
            this.mRemoteViewsFactory = IRemoteViewsFactory.Stub.asInterface(service);
            final RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter == null) {
                return;
            }
            adapter.mWorkerQueue.post(new Runnable(){

                public void run() {
                    if (adapter.mNotifyDataSetChangedAfterOnServiceConnected) {
                        adapter.onNotifyDataSetChanged();
                    } else {
                        IRemoteViewsFactory factory = adapter.mServiceConnection.getRemoteViewsFactory();
                        try {
                            if (!factory.isCreated()) {
                                factory.onDataSetChanged();
                            }
                        }
                        catch (RemoteException e) {
                            Log.e(RemoteViewsAdapter.TAG, "Error notifying factory of data set changed in onServiceConnected(): " + e.getMessage());
                            return;
                        }
                        catch (RuntimeException e) {
                            Log.e(RemoteViewsAdapter.TAG, "Error notifying factory of data set changed in onServiceConnected(): " + e.getMessage());
                        }
                        adapter.updateTemporaryMetaData();
                        adapter.mMainQueue.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = adapter.mCache;
                                synchronized (fixedSizeRemoteViewsCache) {
                                    adapter.mCache.commitTemporaryMetaData();
                                }
                                RemoteAdapterConnectionCallback callback = (RemoteAdapterConnectionCallback)adapter.mCallback.get();
                                if (callback != null) {
                                    callback.onRemoteAdapterConnected();
                                }
                            }
                        });
                    }
                    adapter.enqueueDeferredUnbindServiceMessage();
                    RemoteViewsAdapterServiceConnection.this.mIsConnected = true;
                    RemoteViewsAdapterServiceConnection.this.mIsConnecting = false;
                }
            });
        }

        public synchronized void onServiceDisconnected() {
            this.mIsConnected = false;
            this.mIsConnecting = false;
            this.mRemoteViewsFactory = null;
            final RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter == null) {
                return;
            }
            adapter.mMainQueue.post(new Runnable(){

                public void run() {
                    adapter.mMainQueue.removeMessages(1);
                    RemoteAdapterConnectionCallback callback = (RemoteAdapterConnectionCallback)adapter.mCallback.get();
                    if (callback != null) {
                        callback.onRemoteAdapterDisconnected();
                    }
                }
            });
        }

        public synchronized IRemoteViewsFactory getRemoteViewsFactory() {
            return this.mRemoteViewsFactory;
        }

        public synchronized boolean isConnected() {
            return this.mIsConnected;
        }
    }

    public static interface RemoteAdapterConnectionCallback {
        public boolean onRemoteAdapterConnected();

        public void onRemoteAdapterDisconnected();

        public void deferNotifyDataSetChanged();
    }
}

