/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.am;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IInstrumentationWatcher;
import android.app.UiAutomationConnection;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.AndroidException;
import android.view.IWindowManager;
import com.android.internal.os.BaseCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;

public class Am
extends BaseCommand {
    private IActivityManager mAm;
    private int mStartFlags = 0;
    private boolean mWaitOption = false;
    private boolean mStopOption = false;
    private int mRepeat = 0;
    private int mUserId;
    private String mReceiverPermission;
    private String mProfileFile;

    public static void main(String[] args) {
        new Am().run(args);
    }

    public void onShowUsage(PrintStream out) {
        out.println("usage: am [subcommand] [options]\nusage: am start [-D] [-W] [-P <FILE>] [--start-profiler <FILE>]\n               [--R COUNT] [-S] [--opengl-trace]\n               [--user <USER_ID> | current] <INTENT>\n       am startservice [--user <USER_ID> | current] <INTENT>\n       am stopservice [--user <USER_ID> | current] <INTENT>\n       am force-stop [--user <USER_ID> | all | current] <PACKAGE>\n       am kill [--user <USER_ID> | all | current] <PACKAGE>\n       am kill-all\n       am broadcast [--user <USER_ID> | all | current] <INTENT>\n       am instrument [-r] [-e <NAME> <VALUE>] [-p <FILE>] [-w]\n               [--user <USER_ID> | current]\n               [--no-window-animation] <COMPONENT>\n       am profile start [--user <USER_ID> current] <PROCESS> <FILE>\n       am profile stop [--user <USER_ID> current] [<PROCESS>]\n       am dumpheap [--user <USER_ID> current] [-n] <PROCESS> <FILE>\n       am set-debug-app [-w] [--persistent] <PACKAGE>\n       am clear-debug-app\n       am monitor [--gdb <port>]\n       am hang [--allow-restart]\n       am restart\n       am idle-maintenance\n       am screen-compat [on|off] <PACKAGE>\n       am to-uri [INTENT]\n       am to-intent-uri [INTENT]\n       am switch-user <USER_ID>\n       am stop-user <USER_ID>\n       am stack create <TASK_ID> <RELATIVE_STACK_BOX_ID> <POSITION> <WEIGHT>\n       am stack movetask <TASK_ID> <STACK_ID> [true|false]\n       am stack resize <STACK_ID> <WEIGHT>\n       am stack boxes\n       am stack box <STACK_BOX_ID>\n\nam start: start an Activity.  Options are:\n    -D: enable debugging\n    -W: wait for launch to complete\n    --start-profiler <FILE>: start profiler and send results to <FILE>\n    -P <FILE>: like above, but profiling stops when app goes idle\n    -R: repeat the activity launch <COUNT> times.  Prior to each repeat,\n        the top activity will be finished.\n    -S: force stop the target app before starting the activity\n    --opengl-trace: enable tracing of OpenGL functions\n    --user <USER_ID> | current: Specify which user to run as; if not\n        specified then run as the current user.\n\nam startservice: start a Service.  Options are:\n    --user <USER_ID> | current: Specify which user to run as; if not\n        specified then run as the current user.\n\nam stopservice: stop a Service.  Options are:\n    --user <USER_ID> | current: Specify which user to run as; if not\n        specified then run as the current user.\n\nam force-stop: force stop everything associated with <PACKAGE>.\n    --user <USER_ID> | all | current: Specify user to force stop;\n        all users if not specified.\n\nam kill: Kill all processes associated with <PACKAGE>.  Only kills.\n  processes that are safe to kill -- that is, will not impact the user\n  experience.\n    --user <USER_ID> | all | current: Specify user whose processes to kill;\n        all users if not specified.\n\nam kill-all: Kill all background processes.\n\nam broadcast: send a broadcast Intent.  Options are:\n    --user <USER_ID> | all | current: Specify which user to send to; if not\n        specified then send to all users.\n    --receiver-permission <PERMISSION>: Require receiver to hold permission.\n\nam instrument: start an Instrumentation.  Typically this target <COMPONENT>\n  is the form <TEST_PACKAGE>/<RUNNER_CLASS>.  Options are:\n    -r: print raw results (otherwise decode REPORT_KEY_STREAMRESULT).  Use with\n        [-e perf true] to generate raw output for performance measurements.\n    -e <NAME> <VALUE>: set argument <NAME> to <VALUE>.  For test runners a\n        common form is [-e <testrunner_flag> <value>[,<value>...]].\n    -p <FILE>: write profiling data to <FILE>\n    -w: wait for instrumentation to finish before returning.  Required for\n        test runners.\n    --user <USER_ID> | current: Specify user instrumentation runs in;\n        current user if not specified.\n    --no-window-animation: turn off window animations while running.\n\nam profile: start and stop profiler on a process.  The given <PROCESS> argument\n  may be either a process name or pid.  Options are:\n    --user <USER_ID> | current: When supplying a process name,\n        specify user of process to profile; uses current user if not specified.\n\nam dumpheap: dump the heap of a process.  The given <PROCESS> argument may\n  be either a process name or pid.  Options are:\n    -n: dump native heap instead of managed heap\n    --user <USER_ID> | current: When supplying a process name,\n        specify user of process to dump; uses current user if not specified.\n\nam set-debug-app: set application <PACKAGE> to debug.  Options are:\n    -w: wait for debugger when application starts\n    --persistent: retain this value\n\nam clear-debug-app: clear the previously set-debug-app.\n\nam bug-report: request bug report generation; will launch UI\n    when done to select where it should be delivered.\n\nam monitor: start monitoring for crashes or ANRs.\n    --gdb: start gdbserv on the given port at crash/ANR\n\nam hang: hang the system.\n    --allow-restart: allow watchdog to perform normal system restart\n\nam restart: restart the user-space system.\n\nam idle-maintenance: perform idle maintenance now.\n\nam screen-compat: control screen compatibility mode of <PACKAGE>.\n\nam to-uri: print the given Intent specification as a URI.\n\nam to-intent-uri: print the given Intent specification as an intent: URI.\n\nam switch-user: switch to put USER_ID in the foreground, starting\n  execution of that user if it is currently stopped.\n\nam stop-user: stop execution of USER_ID, not allowing it to run any\n  code until a later explicit switch to it.\n\nam stack create: create a new stack relative to an existing one.\n   <TASK_ID>: the task to populate the new stack with. Must exist.\n   <RELATIVE_STACK_BOX_ID>: existing stack box's id.\n   <POSITION>: 0: before <RELATIVE_STACK_BOX_ID>, per RTL/LTR configuration,\n               1: after <RELATIVE_STACK_BOX_ID>, per RTL/LTR configuration,\n               2: to left of <RELATIVE_STACK_BOX_ID>,\n               3: to right of <RELATIVE_STACK_BOX_ID>,               4: above <RELATIVE_STACK_BOX_ID>, 5: below <RELATIVE_STACK_BOX_ID>\n   <WEIGHT>: float between 0.2 and 0.8 inclusive.\n\nam stack movetask: move <TASK_ID> from its current stack to the top (true) or   bottom (false) of <STACK_ID>.\n\nam stack resize: change <STACK_ID> relative size to new <WEIGHT>.\n\nam stack boxes: list the hierarchy of stack boxes and their contents.\n\nam stack box: list the hierarchy of stack boxes rooted at <STACK_BOX_ID>.\n\n<INTENT> specifications include these flags and arguments:\n    [-a <ACTION>] [-d <DATA_URI>] [-t <MIME_TYPE>]\n    [-c <CATEGORY> [-c <CATEGORY>] ...]\n    [-e|--es <EXTRA_KEY> <EXTRA_STRING_VALUE> ...]\n    [--esn <EXTRA_KEY> ...]\n    [--ez <EXTRA_KEY> <EXTRA_BOOLEAN_VALUE> ...]\n    [--ei <EXTRA_KEY> <EXTRA_INT_VALUE> ...]\n    [--el <EXTRA_KEY> <EXTRA_LONG_VALUE> ...]\n    [--ef <EXTRA_KEY> <EXTRA_FLOAT_VALUE> ...]\n    [--eu <EXTRA_KEY> <EXTRA_URI_VALUE> ...]\n    [--ecn <EXTRA_KEY> <EXTRA_COMPONENT_NAME_VALUE>]\n    [--eia <EXTRA_KEY> <EXTRA_INT_VALUE>[,<EXTRA_INT_VALUE...]]\n    [--ela <EXTRA_KEY> <EXTRA_LONG_VALUE>[,<EXTRA_LONG_VALUE...]]\n    [--efa <EXTRA_KEY> <EXTRA_FLOAT_VALUE>[,<EXTRA_FLOAT_VALUE...]]\n    [-n <COMPONENT>] [-f <FLAGS>]\n    [--grant-read-uri-permission] [--grant-write-uri-permission]\n    [--debug-log-resolution] [--exclude-stopped-packages]\n    [--include-stopped-packages]\n    [--activity-brought-to-front] [--activity-clear-top]\n    [--activity-clear-when-task-reset] [--activity-exclude-from-recents]\n    [--activity-launched-from-history] [--activity-multiple-task]\n    [--activity-no-animation] [--activity-no-history]\n    [--activity-no-user-action] [--activity-previous-is-top]\n    [--activity-reorder-to-front] [--activity-reset-task-if-needed]\n    [--activity-single-top] [--activity-clear-task]\n    [--activity-task-on-home]\n    [--receiver-registered-only] [--receiver-replace-pending]\n    [--selector]\n    [<URI> | <PACKAGE> | <COMPONENT>]\n");
    }

    public void onRun() throws Exception {
        this.mAm = ActivityManagerNative.getDefault();
        if (this.mAm == null) {
            System.err.println("Error type 2");
            throw new AndroidException("Can't connect to activity manager; is the system running?");
        }
        String op = this.nextArgRequired();
        if (op.equals("start")) {
            this.runStart();
        } else if (op.equals("startservice")) {
            this.runStartService();
        } else if (op.equals("stopservice")) {
            this.runStopService();
        } else if (op.equals("force-stop")) {
            this.runForceStop();
        } else if (op.equals("kill")) {
            this.runKill();
        } else if (op.equals("kill-all")) {
            this.runKillAll();
        } else if (op.equals("instrument")) {
            this.runInstrument();
        } else if (op.equals("broadcast")) {
            this.sendBroadcast();
        } else if (op.equals("profile")) {
            this.runProfile();
        } else if (op.equals("dumpheap")) {
            this.runDumpHeap();
        } else if (op.equals("set-debug-app")) {
            this.runSetDebugApp();
        } else if (op.equals("clear-debug-app")) {
            this.runClearDebugApp();
        } else if (op.equals("bug-report")) {
            this.runBugReport();
        } else if (op.equals("monitor")) {
            this.runMonitor();
        } else if (op.equals("hang")) {
            this.runHang();
        } else if (op.equals("restart")) {
            this.runRestart();
        } else if (op.equals("idle-maintenance")) {
            this.runIdleMaintenance();
        } else if (op.equals("screen-compat")) {
            this.runScreenCompat();
        } else if (op.equals("to-uri")) {
            this.runToUri(false);
        } else if (op.equals("to-intent-uri")) {
            this.runToUri(true);
        } else if (op.equals("switch-user")) {
            this.runSwitchUser();
        } else if (op.equals("stop-user")) {
            this.runStopUser();
        } else if (op.equals("stack")) {
            this.runStack();
        } else {
            this.showError("Error: unknown command '" + op + "'");
        }
    }

    int parseUserArg(String arg) {
        int userId = "all".equals(arg) ? -1 : ("current".equals(arg) || "cur".equals(arg) ? -2 : Integer.parseInt(arg));
        return userId;
    }

    private Intent makeIntent(int defUser) throws URISyntaxException {
        boolean hasSelector;
        String opt;
        Intent intent;
        Intent baseIntent = intent = new Intent();
        boolean hasIntentInfo = false;
        this.mStartFlags = 0;
        this.mWaitOption = false;
        this.mStopOption = false;
        this.mRepeat = 0;
        this.mProfileFile = null;
        this.mUserId = defUser;
        Uri data = null;
        String type = null;
        while ((opt = this.nextOption()) != null) {
            String str;
            int i;
            Object[] list;
            String[] strings;
            String value;
            String key;
            if (opt.equals("-a")) {
                intent.setAction(this.nextArgRequired());
                if (intent != baseIntent) continue;
                hasIntentInfo = true;
                continue;
            }
            if (opt.equals("-d")) {
                data = Uri.parse(this.nextArgRequired());
                if (intent != baseIntent) continue;
                hasIntentInfo = true;
                continue;
            }
            if (opt.equals("-t")) {
                type = this.nextArgRequired();
                if (intent != baseIntent) continue;
                hasIntentInfo = true;
                continue;
            }
            if (opt.equals("-c")) {
                intent.addCategory(this.nextArgRequired());
                if (intent != baseIntent) continue;
                hasIntentInfo = true;
                continue;
            }
            if (opt.equals("-e") || opt.equals("--es")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                intent.putExtra(key, value);
                continue;
            }
            if (opt.equals("--esn")) {
                key = this.nextArgRequired();
                intent.putExtra(key, (String)null);
                continue;
            }
            if (opt.equals("--ei")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                intent.putExtra(key, Integer.valueOf(value));
                continue;
            }
            if (opt.equals("--eu")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                intent.putExtra(key, Uri.parse(value));
                continue;
            }
            if (opt.equals("--ecn")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                ComponentName cn = ComponentName.unflattenFromString(value);
                if (cn == null) {
                    throw new IllegalArgumentException("Bad component name: " + value);
                }
                intent.putExtra(key, cn);
                continue;
            }
            if (opt.equals("--eia")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                strings = value.split(",");
                list = new int[strings.length];
                for (i = 0; i < strings.length; ++i) {
                    list[i] = Integer.valueOf(strings[i]);
                }
                intent.putExtra(key, (int[])list);
                continue;
            }
            if (opt.equals("--el")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                intent.putExtra(key, Long.valueOf(value));
                continue;
            }
            if (opt.equals("--ela")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                strings = value.split(",");
                list = new long[strings.length];
                for (i = 0; i < strings.length; ++i) {
                    list[i] = (int)Long.valueOf(strings[i]).longValue();
                }
                intent.putExtra(key, (long[])list);
                hasIntentInfo = true;
                continue;
            }
            if (opt.equals("--ef")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                intent.putExtra(key, Float.valueOf(value));
                hasIntentInfo = true;
                continue;
            }
            if (opt.equals("--efa")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                strings = value.split(",");
                list = new float[strings.length];
                for (i = 0; i < strings.length; ++i) {
                    list[i] = (int)Float.valueOf(strings[i]).floatValue();
                }
                intent.putExtra(key, (float[])list);
                hasIntentInfo = true;
                continue;
            }
            if (opt.equals("--ez")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                intent.putExtra(key, Boolean.valueOf(value));
                continue;
            }
            if (opt.equals("-n")) {
                str = this.nextArgRequired();
                ComponentName cn = ComponentName.unflattenFromString(str);
                if (cn == null) {
                    throw new IllegalArgumentException("Bad component name: " + str);
                }
                intent.setComponent(cn);
                if (intent != baseIntent) continue;
                hasIntentInfo = true;
                continue;
            }
            if (opt.equals("-f")) {
                str = this.nextArgRequired();
                intent.setFlags(Integer.decode(str));
                continue;
            }
            if (opt.equals("--grant-read-uri-permission")) {
                intent.addFlags(1);
                continue;
            }
            if (opt.equals("--grant-write-uri-permission")) {
                intent.addFlags(2);
                continue;
            }
            if (opt.equals("--exclude-stopped-packages")) {
                intent.addFlags(16);
                continue;
            }
            if (opt.equals("--include-stopped-packages")) {
                intent.addFlags(32);
                continue;
            }
            if (opt.equals("--debug-log-resolution")) {
                intent.addFlags(8);
                continue;
            }
            if (opt.equals("--activity-brought-to-front")) {
                intent.addFlags(0x400000);
                continue;
            }
            if (opt.equals("--activity-clear-top")) {
                intent.addFlags(0x4000000);
                continue;
            }
            if (opt.equals("--activity-clear-when-task-reset")) {
                intent.addFlags(524288);
                continue;
            }
            if (opt.equals("--activity-exclude-from-recents")) {
                intent.addFlags(0x800000);
                continue;
            }
            if (opt.equals("--activity-launched-from-history")) {
                intent.addFlags(0x100000);
                continue;
            }
            if (opt.equals("--activity-multiple-task")) {
                intent.addFlags(0x8000000);
                continue;
            }
            if (opt.equals("--activity-no-animation")) {
                intent.addFlags(65536);
                continue;
            }
            if (opt.equals("--activity-no-history")) {
                intent.addFlags(0x40000000);
                continue;
            }
            if (opt.equals("--activity-no-user-action")) {
                intent.addFlags(262144);
                continue;
            }
            if (opt.equals("--activity-previous-is-top")) {
                intent.addFlags(0x1000000);
                continue;
            }
            if (opt.equals("--activity-reorder-to-front")) {
                intent.addFlags(131072);
                continue;
            }
            if (opt.equals("--activity-reset-task-if-needed")) {
                intent.addFlags(0x200000);
                continue;
            }
            if (opt.equals("--activity-single-top")) {
                intent.addFlags(0x20000000);
                continue;
            }
            if (opt.equals("--activity-clear-task")) {
                intent.addFlags(32768);
                continue;
            }
            if (opt.equals("--activity-task-on-home")) {
                intent.addFlags(16384);
                continue;
            }
            if (opt.equals("--receiver-registered-only")) {
                intent.addFlags(0x40000000);
                continue;
            }
            if (opt.equals("--receiver-replace-pending")) {
                intent.addFlags(0x20000000);
                continue;
            }
            if (opt.equals("--selector")) {
                intent.setDataAndType(data, type);
                intent = new Intent();
                continue;
            }
            if (opt.equals("-D")) {
                this.mStartFlags |= 2;
                continue;
            }
            if (opt.equals("-W")) {
                this.mWaitOption = true;
                continue;
            }
            if (opt.equals("-P")) {
                this.mProfileFile = this.nextArgRequired();
                this.mStartFlags |= 8;
                continue;
            }
            if (opt.equals("--start-profiler")) {
                this.mProfileFile = this.nextArgRequired();
                this.mStartFlags &= 0xFFFFFFF7;
                continue;
            }
            if (opt.equals("-R")) {
                this.mRepeat = Integer.parseInt(this.nextArgRequired());
                continue;
            }
            if (opt.equals("-S")) {
                this.mStopOption = true;
                continue;
            }
            if (opt.equals("--opengl-trace")) {
                this.mStartFlags |= 4;
                continue;
            }
            if (opt.equals("--user")) {
                this.mUserId = this.parseUserArg(this.nextArgRequired());
                continue;
            }
            if (opt.equals("--receiver-permission")) {
                this.mReceiverPermission = this.nextArgRequired();
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            return null;
        }
        intent.setDataAndType(data, type);
        boolean bl = hasSelector = intent != baseIntent;
        if (hasSelector) {
            baseIntent.setSelector(intent);
            intent = baseIntent;
        }
        String arg = this.nextArg();
        baseIntent = null;
        if (arg == null) {
            if (hasSelector) {
                baseIntent = new Intent("android.intent.action.MAIN");
                baseIntent.addCategory("android.intent.category.LAUNCHER");
            }
        } else if (arg.indexOf(58) >= 0) {
            baseIntent = Intent.parseUri(arg, 1);
        } else if (arg.indexOf(47) >= 0) {
            baseIntent = new Intent("android.intent.action.MAIN");
            baseIntent.addCategory("android.intent.category.LAUNCHER");
            baseIntent.setComponent(ComponentName.unflattenFromString(arg));
        } else {
            baseIntent = new Intent("android.intent.action.MAIN");
            baseIntent.addCategory("android.intent.category.LAUNCHER");
            baseIntent.setPackage(arg);
        }
        if (baseIntent != null) {
            Bundle extras = intent.getExtras();
            intent.replaceExtras((Bundle)null);
            Bundle uriExtras = baseIntent.getExtras();
            baseIntent.replaceExtras((Bundle)null);
            if (intent.getAction() != null && baseIntent.getCategories() != null) {
                HashSet<String> cats = new HashSet<String>(baseIntent.getCategories());
                for (String c : cats) {
                    baseIntent.removeCategory(c);
                }
            }
            intent.fillIn(baseIntent, 72);
            if (extras == null) {
                extras = uriExtras;
            } else if (uriExtras != null) {
                uriExtras.putAll(extras);
                extras = uriExtras;
            }
            intent.replaceExtras(extras);
            hasIntentInfo = true;
        }
        if (!hasIntentInfo) {
            throw new IllegalArgumentException("No intent supplied");
        }
        return intent;
    }

    private void runStartService() throws Exception {
        Intent intent = this.makeIntent(-2);
        if (this.mUserId == -1) {
            System.err.println("Error: Can't start activity with user 'all'");
            return;
        }
        System.out.println("Starting service: " + intent);
        ComponentName cn = this.mAm.startService(null, intent, intent.getType(), this.mUserId);
        if (cn == null) {
            System.err.println("Error: Not found; no service started.");
        } else if (cn.getPackageName().equals("!")) {
            System.err.println("Error: Requires permission " + cn.getClassName());
        } else if (cn.getPackageName().equals("!!")) {
            System.err.println("Error: " + cn.getClassName());
        }
    }

    private void runStopService() throws Exception {
        Intent intent = this.makeIntent(-2);
        if (this.mUserId == -1) {
            System.err.println("Error: Can't stop activity with user 'all'");
            return;
        }
        System.out.println("Stopping service: " + intent);
        int result = this.mAm.stopService(null, intent, intent.getType(), this.mUserId);
        if (result == 0) {
            System.err.println("Service not stopped: was not running.");
        } else if (result == 1) {
            System.err.println("Service stopped");
        } else if (result == -1) {
            System.err.println("Error stopping service");
        }
    }

    private void runStart() throws Exception {
        Intent intent = this.makeIntent(-2);
        if (this.mUserId == -1) {
            System.err.println("Error: Can't start service with user 'all'");
            return;
        }
        String mimeType = intent.getType();
        if (mimeType == null && intent.getData() != null && "content".equals(intent.getData().getScheme())) {
            mimeType = this.mAm.getProviderMimeType(intent.getData(), this.mUserId);
        }
        do {
            int res;
            if (this.mStopOption) {
                String packageName;
                if (intent.getComponent() != null) {
                    packageName = intent.getComponent().getPackageName();
                } else {
                    IPackageManager pm = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
                    if (pm == null) {
                        System.err.println("Error: Package manager not running; aborting");
                        return;
                    }
                    List<ResolveInfo> activities = pm.queryIntentActivities(intent, mimeType, 0, this.mUserId);
                    if (activities == null || activities.size() <= 0) {
                        System.err.println("Error: Intent does not match any activities: " + intent);
                        return;
                    }
                    if (activities.size() > 1) {
                        System.err.println("Error: Intent matches multiple activities; can't stop: " + intent);
                        return;
                    }
                    packageName = activities.get((int)0).activityInfo.packageName;
                }
                System.out.println("Stopping: " + packageName);
                this.mAm.forceStopPackage(packageName, this.mUserId);
                Thread.sleep(250L);
            }
            System.out.println("Starting: " + intent);
            intent.addFlags(0x10000000);
            ParcelFileDescriptor fd = null;
            if (this.mProfileFile != null) {
                try {
                    fd = ParcelFileDescriptor.open(new File(this.mProfileFile), 0x3C000000);
                }
                catch (FileNotFoundException e) {
                    System.err.println("Error: Unable to open file: " + this.mProfileFile);
                    return;
                }
            }
            IActivityManager.WaitResult result = null;
            if (this.mWaitOption) {
                result = this.mAm.startActivityAndWait(null, null, intent, mimeType, null, null, 0, this.mStartFlags, this.mProfileFile, fd, null, this.mUserId);
                res = result.result;
            } else {
                res = this.mAm.startActivityAsUser(null, null, intent, mimeType, null, null, 0, this.mStartFlags, this.mProfileFile, fd, null, this.mUserId);
            }
            PrintStream out = this.mWaitOption ? System.out : System.err;
            boolean launched = false;
            switch (res) {
                case 0: {
                    launched = true;
                    break;
                }
                case 4: {
                    launched = true;
                    out.println("Warning: Activity not started because the  current activity is being kept for the user.");
                    break;
                }
                case 3: {
                    launched = true;
                    out.println("Warning: Activity not started, intent has been delivered to currently running top-most instance.");
                    break;
                }
                case 1: {
                    launched = true;
                    out.println("Warning: Activity not started because intent should be handled by the caller");
                    break;
                }
                case 2: {
                    launched = true;
                    out.println("Warning: Activity not started, its current task has been brought to the front");
                    break;
                }
                case -1: {
                    out.println("Error: Activity not started, unable to resolve " + intent.toString());
                    break;
                }
                case -2: {
                    out.println("Error type 3");
                    out.println("Error: Activity class " + intent.getComponent().toShortString() + " does not exist.");
                    break;
                }
                case -3: {
                    out.println("Error: Activity not started, you requested to both forward and receive its result");
                    break;
                }
                case -4: {
                    out.println("Error: Activity not started, you do not have permission to access it.");
                    break;
                }
                default: {
                    out.println("Error: Activity not started, unknown error code " + res);
                }
            }
            if (this.mWaitOption && launched) {
                if (result == null) {
                    result = new IActivityManager.WaitResult();
                    result.who = intent.getComponent();
                }
                System.out.println("Status: " + (result.timeout ? "timeout" : "ok"));
                if (result.who != null) {
                    System.out.println("Activity: " + result.who.flattenToShortString());
                }
                if (result.thisTime >= 0L) {
                    System.out.println("ThisTime: " + result.thisTime);
                }
                if (result.totalTime >= 0L) {
                    System.out.println("TotalTime: " + result.totalTime);
                }
                System.out.println("Complete");
            }
            --this.mRepeat;
            if (this.mRepeat <= 1) continue;
            this.mAm.unhandledBack();
        } while (this.mRepeat > 1);
    }

    private void runForceStop() throws Exception {
        String opt;
        int userId = -1;
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("--user")) {
                userId = this.parseUserArg(this.nextArgRequired());
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        this.mAm.forceStopPackage(this.nextArgRequired(), userId);
    }

    private void runKill() throws Exception {
        String opt;
        int userId = -1;
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("--user")) {
                userId = this.parseUserArg(this.nextArgRequired());
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        this.mAm.killBackgroundProcesses(this.nextArgRequired(), userId);
    }

    private void runKillAll() throws Exception {
        this.mAm.killAllBackgroundProcesses();
    }

    private void sendBroadcast() throws Exception {
        Intent intent = this.makeIntent(-1);
        IntentReceiver receiver = new IntentReceiver();
        System.out.println("Broadcasting: " + intent);
        this.mAm.broadcastIntent(null, intent, null, receiver, 0, null, null, this.mReceiverPermission, -1, true, false, this.mUserId);
        receiver.waitForFinish();
    }

    private void runInstrument() throws Exception {
        String opt;
        String profileFile = null;
        boolean wait = false;
        boolean rawMode = false;
        boolean no_window_animation = false;
        int userId = -2;
        Bundle args = new Bundle();
        String argKey = null;
        String argValue = null;
        IWindowManager wm = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("-p")) {
                profileFile = this.nextArgRequired();
                continue;
            }
            if (opt.equals("-w")) {
                wait = true;
                continue;
            }
            if (opt.equals("-r")) {
                rawMode = true;
                continue;
            }
            if (opt.equals("-e")) {
                argKey = this.nextArgRequired();
                argValue = this.nextArgRequired();
                args.putString(argKey, argValue);
                continue;
            }
            if (opt.equals("--no_window_animation") || opt.equals("--no-window-animation")) {
                no_window_animation = true;
                continue;
            }
            if (opt.equals("--user")) {
                userId = this.parseUserArg(this.nextArgRequired());
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        if (userId == -1) {
            System.err.println("Error: Can't start instrumentation with user 'all'");
            return;
        }
        String cnArg = this.nextArgRequired();
        ComponentName cn = ComponentName.unflattenFromString(cnArg);
        if (cn == null) {
            throw new IllegalArgumentException("Bad component name: " + cnArg);
        }
        InstrumentationWatcher watcher = null;
        UiAutomationConnection connection = null;
        if (wait) {
            watcher = new InstrumentationWatcher();
            watcher.setRawOutput(rawMode);
            connection = new UiAutomationConnection();
        }
        float[] oldAnims = null;
        if (no_window_animation) {
            oldAnims = wm.getAnimationScales();
            wm.setAnimationScale(0, 0.0f);
            wm.setAnimationScale(1, 0.0f);
        }
        if (!this.mAm.startInstrumentation(cn, profileFile, 0, args, watcher, connection, userId)) {
            throw new AndroidException("INSTRUMENTATION_FAILED: " + cn.flattenToString());
        }
        if (watcher != null && !watcher.waitForFinish()) {
            System.out.println("INSTRUMENTATION_ABORTED: System has crashed.");
        }
        if (oldAnims != null) {
            wm.setAnimationScales(oldAnims);
        }
    }

    static void removeWallOption() {
        String props = SystemProperties.get("dalvik.vm.extra-opts");
        if (props != null && props.contains("-Xprofile:wallclock")) {
            props = props.replace("-Xprofile:wallclock", "");
            props = props.trim();
            SystemProperties.set("dalvik.vm.extra-opts", props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runProfile() throws Exception {
        String opt;
        String profileFile = null;
        boolean start = false;
        boolean wall = false;
        int userId = -2;
        int profileType = 0;
        String process = null;
        String cmd = this.nextArgRequired();
        if ("start".equals(cmd)) {
            start = true;
            while ((opt = this.nextOption()) != null) {
                if (opt.equals("--user")) {
                    userId = this.parseUserArg(this.nextArgRequired());
                    continue;
                }
                if (opt.equals("--wall")) {
                    wall = true;
                    continue;
                }
                System.err.println("Error: Unknown option: " + opt);
                return;
            }
            process = this.nextArgRequired();
        } else if ("stop".equals(cmd)) {
            while ((opt = this.nextOption()) != null) {
                if (opt.equals("--user")) {
                    userId = this.parseUserArg(this.nextArgRequired());
                    continue;
                }
                System.err.println("Error: Unknown option: " + opt);
                return;
            }
            process = this.nextArg();
        } else {
            process = cmd;
            cmd = this.nextArgRequired();
            if ("start".equals(cmd)) {
                start = true;
            } else if (!"stop".equals(cmd)) {
                throw new IllegalArgumentException("Profile command " + process + " not valid");
            }
        }
        if (userId == -1) {
            System.err.println("Error: Can't profile with user 'all'");
            return;
        }
        ParcelFileDescriptor fd = null;
        if (start) {
            profileFile = this.nextArgRequired();
            try {
                fd = ParcelFileDescriptor.open(new File(profileFile), 0x3C000000);
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: Unable to open file: " + profileFile);
                return;
            }
        }
        try {
            if (wall) {
                String props = SystemProperties.get("dalvik.vm.extra-opts");
                if (props == null || !props.contains("-Xprofile:wallclock")) {
                    props = props + " -Xprofile:wallclock";
                }
            } else if (start) {
                // empty if block
            }
            if (!this.mAm.profileControl(process, userId, start, profileFile, fd, profileType)) {
                wall = false;
                throw new AndroidException("PROFILE FAILED on process " + process);
            }
        }
        finally {
            if (!wall) {
                // empty if block
            }
        }
    }

    private void runDumpHeap() throws Exception {
        String opt;
        boolean managed = true;
        int userId = -2;
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("--user")) {
                userId = this.parseUserArg(this.nextArgRequired());
                if (userId != -1) continue;
                System.err.println("Error: Can't dump heap with user 'all'");
                return;
            }
            if (opt.equals("-n")) {
                managed = false;
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        String process = this.nextArgRequired();
        String heapFile = this.nextArgRequired();
        ParcelFileDescriptor fd = null;
        try {
            File file = new File(heapFile);
            file.delete();
            fd = ParcelFileDescriptor.open(file, 0x3C000000);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: Unable to open file: " + heapFile);
            return;
        }
        if (!this.mAm.dumpHeap(process, userId, managed, heapFile, fd)) {
            throw new AndroidException("HEAP DUMP FAILED on process " + process);
        }
    }

    private void runSetDebugApp() throws Exception {
        String opt;
        boolean wait = false;
        boolean persistent = false;
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("-w")) {
                wait = true;
                continue;
            }
            if (opt.equals("--persistent")) {
                persistent = true;
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        String pkg = this.nextArgRequired();
        this.mAm.setDebugApp(pkg, wait, persistent);
    }

    private void runClearDebugApp() throws Exception {
        this.mAm.setDebugApp(null, false, true);
    }

    private void runBugReport() throws Exception {
        this.mAm.requestBugReport();
        System.out.println("Your lovely bug report is being created; please be patient.");
    }

    private void runSwitchUser() throws Exception {
        String user = this.nextArgRequired();
        this.mAm.switchUser(Integer.parseInt(user));
    }

    private void runStopUser() throws Exception {
        String user = this.nextArgRequired();
        int res = this.mAm.stopUser(Integer.parseInt(user), null);
        if (res != 0) {
            String txt = "";
            switch (res) {
                case -2: {
                    txt = " (Can't stop current user)";
                    break;
                }
                case -1: {
                    txt = " (Unknown user " + user + ")";
                }
            }
            System.err.println("Switch failed: " + res + txt);
        }
    }

    private void runMonitor() throws Exception {
        String opt;
        String gdbPort = null;
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("--gdb")) {
                gdbPort = this.nextArgRequired();
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        MyActivityController controller = new MyActivityController(gdbPort);
        controller.run();
    }

    private void runHang() throws Exception {
        String opt;
        boolean allowRestart = false;
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("--allow-restart")) {
                allowRestart = true;
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        System.out.println("Hanging the system...");
        this.mAm.hang(new Binder(), allowRestart);
    }

    private void runRestart() throws Exception {
        String opt = this.nextOption();
        if (opt != null) {
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        System.out.println("Restart the system...");
        this.mAm.restart();
    }

    private void runIdleMaintenance() throws Exception {
        String opt = this.nextOption();
        if (opt != null) {
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        System.out.println("Performing idle maintenance...");
        Intent intent = new Intent("com.android.server.IdleMaintenanceService.action.FORCE_IDLE_MAINTENANCE");
        this.mAm.broadcastIntent(null, intent, null, null, 0, null, null, null, -1, true, false, -1);
    }

    private void runScreenCompat() throws Exception {
        boolean enabled;
        String mode = this.nextArgRequired();
        if ("on".equals(mode)) {
            enabled = true;
        } else if ("off".equals(mode)) {
            enabled = false;
        } else {
            System.err.println("Error: enabled mode must be 'on' or 'off' at " + mode);
            return;
        }
        String packageName = this.nextArgRequired();
        do {
            try {
                this.mAm.setPackageScreenCompatMode(packageName, enabled ? 1 : 0);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        } while ((packageName = this.nextArg()) != null);
    }

    private void runToUri(boolean intentScheme) throws Exception {
        Intent intent = this.makeIntent(-2);
        System.out.println(intent.toUri(intentScheme ? 1 : 0));
    }

    private void runStack() throws Exception {
        String op = this.nextArgRequired();
        if (op.equals("create")) {
            this.runStackCreate();
        } else if (op.equals("movetask")) {
            this.runStackMoveTask();
        } else if (op.equals("resize")) {
            this.runStackBoxResize();
        } else if (op.equals("boxes")) {
            this.runStackBoxes();
        } else if (op.equals("box")) {
            this.runStackBoxInfo();
        } else {
            this.showError("Error: unknown command '" + op + "'");
            return;
        }
    }

    private void runStackCreate() throws Exception {
        String taskIdStr = this.nextArgRequired();
        int taskId = Integer.valueOf(taskIdStr);
        String relativeToStr = this.nextArgRequired();
        int relativeTo = Integer.valueOf(relativeToStr);
        String positionStr = this.nextArgRequired();
        int position = Integer.valueOf(positionStr);
        String weightStr = this.nextArgRequired();
        float weight = Float.valueOf(weightStr).floatValue();
        try {
            int stackId = this.mAm.createStack(taskId, relativeTo, position, weight);
            System.out.println("createStack returned new stackId=" + stackId + "\n\n");
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void runStackMoveTask() throws Exception {
        boolean toTop;
        String taskIdStr = this.nextArgRequired();
        int taskId = Integer.valueOf(taskIdStr);
        String stackIdStr = this.nextArgRequired();
        int stackId = Integer.valueOf(stackIdStr);
        String toTopStr = this.nextArgRequired();
        if ("true".equals(toTopStr)) {
            toTop = true;
        } else if ("false".equals(toTopStr)) {
            toTop = false;
        } else {
            System.err.println("Error: bad toTop arg: " + toTopStr);
            return;
        }
        try {
            this.mAm.moveTaskToStack(taskId, stackId, toTop);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void runStackBoxResize() throws Exception {
        String stackBoxIdStr = this.nextArgRequired();
        int stackBoxId = Integer.valueOf(stackBoxIdStr);
        String weightStr = this.nextArgRequired();
        float weight = Float.valueOf(weightStr).floatValue();
        try {
            this.mAm.resizeStackBox(stackBoxId, weight);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void runStackBoxes() throws Exception {
        try {
            List<ActivityManager.StackBoxInfo> stackBoxes = this.mAm.getStackBoxes();
            for (ActivityManager.StackBoxInfo info : stackBoxes) {
                System.out.println(info);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void runStackBoxInfo() throws Exception {
        try {
            String stackBoxIdStr = this.nextArgRequired();
            int stackBoxId = Integer.valueOf(stackBoxIdStr);
            ActivityManager.StackBoxInfo stackBoxInfo = this.mAm.getStackBoxInfo(stackBoxId);
            System.out.println(stackBoxInfo);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private class InstrumentationWatcher
    extends IInstrumentationWatcher.Stub {
        private boolean mFinished = false;
        private boolean mRawMode = false;

        private InstrumentationWatcher() {
        }

        public void setRawOutput(boolean rawMode) {
            this.mRawMode = rawMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void instrumentationStatus(ComponentName name, int resultCode, Bundle results) {
            InstrumentationWatcher instrumentationWatcher = this;
            synchronized (instrumentationWatcher) {
                String pretty = null;
                if (!this.mRawMode && results != null) {
                    pretty = results.getString("stream");
                }
                if (pretty != null) {
                    System.out.print(pretty);
                } else {
                    if (results != null) {
                        for (String key : results.keySet()) {
                            System.out.println("INSTRUMENTATION_STATUS: " + key + "=" + results.get(key));
                        }
                    }
                    System.out.println("INSTRUMENTATION_STATUS_CODE: " + resultCode);
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void instrumentationFinished(ComponentName name, int resultCode, Bundle results) {
            InstrumentationWatcher instrumentationWatcher = this;
            synchronized (instrumentationWatcher) {
                String pretty = null;
                if (!this.mRawMode && results != null) {
                    pretty = results.getString("stream");
                }
                if (pretty != null) {
                    System.out.println(pretty);
                } else {
                    if (results != null) {
                        for (String key : results.keySet()) {
                            System.out.println("INSTRUMENTATION_RESULT: " + key + "=" + results.get(key));
                        }
                    }
                    System.out.println("INSTRUMENTATION_CODE: " + resultCode);
                }
                this.mFinished = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForFinish() {
            InstrumentationWatcher instrumentationWatcher = this;
            synchronized (instrumentationWatcher) {
                while (!this.mFinished) {
                    try {
                        if (!Am.this.mAm.asBinder().pingBinder()) {
                            return false;
                        }
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
            return true;
        }
    }

    private class IntentReceiver
    extends IIntentReceiver.Stub {
        private boolean mFinished = false;

        private IntentReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
            String line = "Broadcast completed: result=" + resultCode;
            if (data != null) {
                line = line + ", data=\"" + data + "\"";
            }
            if (extras != null) {
                line = line + ", extras: " + extras;
            }
            System.out.println(line);
            IntentReceiver intentReceiver = this;
            synchronized (intentReceiver) {
                this.mFinished = true;
                this.notifyAll();
            }
        }

        public synchronized void waitForFinish() {
            try {
                while (!this.mFinished) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    class MyActivityController
    extends IActivityController.Stub {
        final String mGdbPort;
        static final int STATE_NORMAL = 0;
        static final int STATE_CRASHED = 1;
        static final int STATE_EARLY_ANR = 2;
        static final int STATE_ANR = 3;
        int mState;
        static final int RESULT_DEFAULT = 0;
        static final int RESULT_CRASH_DIALOG = 0;
        static final int RESULT_CRASH_KILL = 1;
        static final int RESULT_EARLY_ANR_CONTINUE = 0;
        static final int RESULT_EARLY_ANR_KILL = 1;
        static final int RESULT_ANR_DIALOG = 0;
        static final int RESULT_ANR_KILL = 1;
        static final int RESULT_ANR_WAIT = 1;
        int mResult;
        Process mGdbProcess;
        Thread mGdbThread;
        boolean mGotGdbPrint;

        MyActivityController(String gdbPort) {
            this.mGdbPort = gdbPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean activityResuming(String pkg) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                System.out.println("** Activity resuming: " + pkg);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean activityStarting(Intent intent, String pkg) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                System.out.println("** Activity starting: " + pkg);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean appCrashed(String processName, int pid, String shortMsg, String longMsg, long timeMillis, String stackTrace) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                System.out.println("** ERROR: PROCESS CRASHED");
                System.out.println("processName: " + processName);
                System.out.println("processPid: " + pid);
                System.out.println("shortMsg: " + shortMsg);
                System.out.println("longMsg: " + longMsg);
                System.out.println("timeMillis: " + timeMillis);
                System.out.println("stack:");
                System.out.print(stackTrace);
                System.out.println("#");
                int result = this.waitControllerLocked(pid, 1);
                return result != 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int appEarlyNotResponding(String processName, int pid, String annotation) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                System.out.println("** ERROR: EARLY PROCESS NOT RESPONDING");
                System.out.println("processName: " + processName);
                System.out.println("processPid: " + pid);
                System.out.println("annotation: " + annotation);
                int result = this.waitControllerLocked(pid, 2);
                if (result == 1) {
                    return -1;
                }
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int appNotResponding(String processName, int pid, String processStats) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                System.out.println("** ERROR: PROCESS NOT RESPONDING");
                System.out.println("processName: " + processName);
                System.out.println("processPid: " + pid);
                System.out.println("processStats:");
                System.out.print(processStats);
                System.out.println("#");
                int result = this.waitControllerLocked(pid, 3);
                if (result == 1) {
                    return -1;
                }
                if (result == 1) {
                    return 1;
                }
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int systemNotResponding(String message) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                System.out.println("** ERROR: PROCESS NOT RESPONDING");
                System.out.println("message: " + message);
                System.out.println("#");
                System.out.println("Allowing system to die.");
                return -1;
            }
        }

        void killGdbLocked() {
            this.mGotGdbPrint = false;
            if (this.mGdbProcess != null) {
                System.out.println("Stopping gdbserver");
                this.mGdbProcess.destroy();
                this.mGdbProcess = null;
            }
            if (this.mGdbThread != null) {
                this.mGdbThread.interrupt();
                this.mGdbThread = null;
            }
        }

        int waitControllerLocked(int pid, int state) {
            if (this.mGdbPort != null) {
                this.killGdbLocked();
                try {
                    System.out.println("Starting gdbserver on port " + this.mGdbPort);
                    System.out.println("Do the following:");
                    System.out.println("  adb forward tcp:" + this.mGdbPort + " tcp:" + this.mGdbPort);
                    System.out.println("  gdbclient app_process :" + this.mGdbPort);
                    this.mGdbProcess = Runtime.getRuntime().exec(new String[]{"gdbserver", ":" + this.mGdbPort, "--attach", Integer.toString(pid)});
                    final InputStreamReader converter = new InputStreamReader(this.mGdbProcess.getInputStream());
                    this.mGdbThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            BufferedReader in = new BufferedReader(converter);
                            int count = 0;
                            while (true) {
                                MyActivityController myActivityController = MyActivityController.this;
                                synchronized (myActivityController) {
                                    if (MyActivityController.this.mGdbThread == null) {
                                        return;
                                    }
                                    if (count == 2) {
                                        MyActivityController.this.mGotGdbPrint = true;
                                        MyActivityController.this.notifyAll();
                                    }
                                }
                                try {
                                    String line = in.readLine();
                                    if (line == null) {
                                        return;
                                    }
                                    System.out.println("GDB: " + line);
                                    ++count;
                                }
                                catch (IOException e) {
                                    return;
                                }
                            }
                        }
                    };
                    this.mGdbThread.start();
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException e) {}
                }
                catch (IOException e) {
                    System.err.println("Failure starting gdbserver: " + e);
                    this.killGdbLocked();
                }
            }
            this.mState = state;
            System.out.println("");
            this.printMessageForState();
            while (this.mState != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.killGdbLocked();
            return this.mResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resumeController(int result) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                this.mState = 0;
                this.mResult = result;
                this.notifyAll();
            }
        }

        void printMessageForState() {
            switch (this.mState) {
                case 0: {
                    System.out.println("Monitoring activity manager...  available commands:");
                    break;
                }
                case 1: {
                    System.out.println("Waiting after crash...  available commands:");
                    System.out.println("(c)ontinue: show crash dialog");
                    System.out.println("(k)ill: immediately kill app");
                    break;
                }
                case 2: {
                    System.out.println("Waiting after early ANR...  available commands:");
                    System.out.println("(c)ontinue: standard ANR processing");
                    System.out.println("(k)ill: immediately kill app");
                    break;
                }
                case 3: {
                    System.out.println("Waiting after ANR...  available commands:");
                    System.out.println("(c)ontinue: show ANR dialog");
                    System.out.println("(k)ill: immediately kill app");
                    System.out.println("(w)ait: wait some more");
                }
            }
            System.out.println("(q)uit: finish monitoring");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void run() throws RemoteException {
            try {
                String line;
                this.printMessageForState();
                Am.this.mAm.setActivityController(this);
                this.mState = 0;
                InputStreamReader converter = new InputStreamReader(System.in);
                BufferedReader in = new BufferedReader(converter);
                while ((line = in.readLine()) != null) {
                    boolean addNewline;
                    block22: {
                        block27: {
                            block25: {
                                block26: {
                                    block24: {
                                        block23: {
                                            addNewline = true;
                                            if (line.length() > 0) break block23;
                                            addNewline = false;
                                            break block22;
                                        }
                                        if ("q".equals(line) || "quit".equals(line)) {
                                            this.resumeController(0);
                                            return;
                                        }
                                        if (this.mState != 1) break block24;
                                        if ("c".equals(line) || "continue".equals(line)) {
                                            this.resumeController(0);
                                            break block22;
                                        } else if ("k".equals(line) || "kill".equals(line)) {
                                            this.resumeController(1);
                                            break block22;
                                        } else {
                                            System.out.println("Invalid command: " + line);
                                        }
                                        break block22;
                                    }
                                    if (this.mState != 3) break block25;
                                    if (!"c".equals(line) && !"continue".equals(line)) break block26;
                                    this.resumeController(0);
                                    break block22;
                                }
                                if ("k".equals(line) || "kill".equals(line)) {
                                    this.resumeController(1);
                                    break block22;
                                } else if ("w".equals(line) || "wait".equals(line)) {
                                    this.resumeController(1);
                                    break block22;
                                } else {
                                    System.out.println("Invalid command: " + line);
                                }
                                break block22;
                            }
                            if (this.mState != 2) break block27;
                            if ("c".equals(line) || "continue".equals(line)) {
                                this.resumeController(0);
                                break block22;
                            } else if ("k".equals(line) || "kill".equals(line)) {
                                this.resumeController(1);
                                break block22;
                            } else {
                                System.out.println("Invalid command: " + line);
                            }
                            break block22;
                        }
                        System.out.println("Invalid command: " + line);
                    }
                    MyActivityController myActivityController = this;
                    synchronized (myActivityController) {
                        if (addNewline) {
                            System.out.println("");
                        }
                        this.printMessageForState();
                    }
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                Am.this.mAm.setActivityController(null);
            }
        }
    }
}

