/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.bmgr;

import android.app.backup.IBackupManager;
import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreSet;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bmgr {
    IBackupManager mBmgr;
    IRestoreSession mRestore;
    static final String BMGR_NOT_RUNNING_ERR = "Error: Could not access the Backup Manager.  Is the system running?";
    static final String TRANSPORT_NOT_RUNNING_ERR = "Error: Could not access the backup transport.  Is the system running?";
    private String[] mArgs;
    private int mNextArg;

    public static void main(String[] args) {
        try {
            new Bmgr().run(args);
        }
        catch (Exception e) {
            System.err.println("Exception caught:");
            e.printStackTrace();
        }
    }

    public void run(String[] args) {
        if (args.length < 1) {
            Bmgr.showUsage();
            return;
        }
        this.mBmgr = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        if (this.mBmgr == null) {
            System.err.println(BMGR_NOT_RUNNING_ERR);
            return;
        }
        this.mArgs = args;
        String op = args[0];
        this.mNextArg = 1;
        if ("enabled".equals(op)) {
            this.doEnabled();
            return;
        }
        if ("enable".equals(op)) {
            this.doEnable();
            return;
        }
        if ("run".equals(op)) {
            this.doRun();
            return;
        }
        if ("backup".equals(op)) {
            this.doBackup();
            return;
        }
        if ("list".equals(op)) {
            this.doList();
            return;
        }
        if ("restore".equals(op)) {
            this.doRestore();
            return;
        }
        if ("transport".equals(op)) {
            this.doTransport();
            return;
        }
        if ("wipe".equals(op)) {
            this.doWipe();
            return;
        }
        System.err.println("Unknown command");
        Bmgr.showUsage();
    }

    private String enableToString(boolean enabled) {
        return enabled ? "enabled" : "disabled";
    }

    private void doEnabled() {
        try {
            boolean isEnabled = this.mBmgr.isBackupEnabled();
            System.out.println("Backup Manager currently " + this.enableToString(isEnabled));
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private void doEnable() {
        String arg = this.nextArg();
        if (arg == null) {
            Bmgr.showUsage();
            return;
        }
        try {
            boolean enable = Boolean.parseBoolean(arg);
            this.mBmgr.setBackupEnabled(enable);
            System.out.println("Backup Manager now " + this.enableToString(enable));
        }
        catch (NumberFormatException e) {
            Bmgr.showUsage();
            return;
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private void doRun() {
        try {
            this.mBmgr.backupNow();
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private void doBackup() {
        String pkg = this.nextArg();
        if (pkg == null) {
            Bmgr.showUsage();
            return;
        }
        try {
            this.mBmgr.dataChanged(pkg);
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private void doTransport() {
        try {
            String which = this.nextArg();
            if (which == null) {
                Bmgr.showUsage();
                return;
            }
            String old = this.mBmgr.selectBackupTransport(which);
            if (old == null) {
                System.out.println("Unknown transport '" + which + "' specified; no changes made.");
            } else {
                System.out.println("Selected transport " + which + " (formerly " + old + ")");
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private void doWipe() {
        String pkg = this.nextArg();
        if (pkg == null) {
            Bmgr.showUsage();
            return;
        }
        try {
            this.mBmgr.clearBackupData(pkg);
            System.out.println("Wiped backup data for " + pkg);
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private void doList() {
        String arg = this.nextArg();
        if ("transports".equals(arg)) {
            this.doListTransports();
            return;
        }
        try {
            this.mRestore = this.mBmgr.beginRestoreSession(null, null);
            if (this.mRestore == null) {
                System.err.println(BMGR_NOT_RUNNING_ERR);
                return;
            }
            if ("sets".equals(arg)) {
                this.doListRestoreSets();
            } else if ("transports".equals(arg)) {
                this.doListTransports();
            }
            this.mRestore.endRestoreSession();
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private void doListTransports() {
        try {
            String current = this.mBmgr.getCurrentTransport();
            String[] transports = this.mBmgr.listAllTransports();
            if (transports == null || transports.length == 0) {
                System.out.println("No transports available.");
                return;
            }
            for (String t : transports) {
                String pad = t.equals(current) ? "  * " : "    ";
                System.out.println(pad + t);
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private void doListRestoreSets() {
        try {
            RestoreObserver observer = new RestoreObserver();
            int err = this.mRestore.getAvailableRestoreSets(observer);
            if (err != 0) {
                System.out.println("Unable to request restore sets");
            } else {
                observer.waitForCompletion();
                this.printRestoreSets(observer.sets);
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(TRANSPORT_NOT_RUNNING_ERR);
        }
    }

    private void printRestoreSets(RestoreSet[] sets) {
        if (sets == null || sets.length == 0) {
            System.out.println("No restore sets");
            return;
        }
        for (RestoreSet s : sets) {
            System.out.println("  " + Long.toHexString(s.token) + " : " + s.name);
        }
    }

    private void doRestore() {
        String arg = this.nextArg();
        if (arg == null) {
            Bmgr.showUsage();
            return;
        }
        if (arg.indexOf(46) >= 0) {
            this.doRestorePackage(arg);
        } else {
            try {
                long token = Long.parseLong(arg, 16);
                HashSet<String> filter = null;
                while ((arg = this.nextArg()) != null) {
                    if (filter == null) {
                        filter = new HashSet<String>();
                    }
                    filter.add(arg);
                }
                this.doRestoreAll(token, filter);
            }
            catch (NumberFormatException e) {
                Bmgr.showUsage();
                return;
            }
        }
        System.out.println("done");
    }

    private void doRestorePackage(String pkg) {
        try {
            this.mRestore = this.mBmgr.beginRestoreSession(pkg, null);
            if (this.mRestore == null) {
                System.err.println(BMGR_NOT_RUNNING_ERR);
                return;
            }
            RestoreObserver observer = new RestoreObserver();
            int err = this.mRestore.restorePackage(pkg, observer);
            if (err == 0) {
                observer.waitForCompletion();
            } else {
                System.err.println("Unable to restore package " + pkg);
            }
            this.mRestore.endRestoreSession();
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private void doRestoreAll(long token, HashSet<String> filter) {
        RestoreObserver observer = new RestoreObserver();
        try {
            boolean didRestore = false;
            this.mRestore = this.mBmgr.beginRestoreSession(null, null);
            if (this.mRestore == null) {
                System.err.println(BMGR_NOT_RUNNING_ERR);
                return;
            }
            RestoreSet[] sets = null;
            int err = this.mRestore.getAvailableRestoreSets(observer);
            if (err == 0) {
                observer.waitForCompletion();
                sets = observer.sets;
                if (sets != null) {
                    for (RestoreSet s : sets) {
                        if (s.token != token) continue;
                        System.out.println("Scheduling restore: " + s.name);
                        if (filter == null) {
                            didRestore = this.mRestore.restoreAll(token, observer) == 0;
                            break;
                        }
                        String[] names = new String[filter.size()];
                        filter.toArray(names);
                        didRestore = this.mRestore.restoreSome(token, observer, names) == 0;
                        break;
                    }
                }
            }
            if (!didRestore) {
                if (sets == null || sets.length == 0) {
                    System.out.println("No available restore sets; no restore performed");
                } else {
                    System.out.println("No matching restore set token.  Available sets:");
                    this.printRestoreSets(sets);
                }
            }
            if (didRestore) {
                observer.waitForCompletion();
            }
            this.mRestore.endRestoreSession();
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(BMGR_NOT_RUNNING_ERR);
        }
    }

    private String nextArg() {
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String arg = this.mArgs[this.mNextArg];
        ++this.mNextArg;
        return arg;
    }

    private static void showUsage() {
        System.err.println("usage: bmgr [backup|restore|list|transport|run]");
        System.err.println("       bmgr backup PACKAGE");
        System.err.println("       bmgr enable BOOL");
        System.err.println("       bmgr enabled");
        System.err.println("       bmgr list transports");
        System.err.println("       bmgr list sets");
        System.err.println("       bmgr transport WHICH");
        System.err.println("       bmgr restore TOKEN");
        System.err.println("       bmgr restore TOKEN PACKAGE...");
        System.err.println("       bmgr restore PACKAGE");
        System.err.println("       bmgr run");
        System.err.println("       bmgr wipe PACKAGE");
        System.err.println("");
        System.err.println("The 'backup' command schedules a backup pass for the named package.");
        System.err.println("Note that the backup pass will effectively be a no-op if the package");
        System.err.println("does not actually have changed data to store.");
        System.err.println("");
        System.err.println("The 'enable' command enables or disables the entire backup mechanism.");
        System.err.println("If the argument is 'true' it will be enabled, otherwise it will be");
        System.err.println("disabled.  When disabled, neither backup or restore operations will");
        System.err.println("be performed.");
        System.err.println("");
        System.err.println("The 'enabled' command reports the current enabled/disabled state of");
        System.err.println("the backup mechanism.");
        System.err.println("");
        System.err.println("The 'list transports' command reports the names of the backup transports");
        System.err.println("currently available on the device.  These names can be passed as arguments");
        System.err.println("to the 'transport' command.  The currently selected transport is indicated");
        System.err.println("with a '*' character.");
        System.err.println("");
        System.err.println("The 'list sets' command reports the token and name of each restore set");
        System.err.println("available to the device via the current transport.");
        System.err.println("");
        System.err.println("The 'transport' command designates the named transport as the currently");
        System.err.println("active one.  This setting is persistent across reboots.");
        System.err.println("");
        System.err.println("The 'restore' command when given just a restore token initiates a full-system");
        System.err.println("restore operation from the currently active transport.  It will deliver");
        System.err.println("the restore set designated by the TOKEN argument to each application");
        System.err.println("that had contributed data to that restore set.");
        System.err.println("");
        System.err.println("The 'restore' command when given a token and one or more package names");
        System.err.println("initiates a restore operation of just those given packages from the restore");
        System.err.println("set designated by the TOKEN argument.  It is effectively the same as the");
        System.err.println("'restore' operation supplying only a token, but applies a filter to the");
        System.err.println("set of applications to be restored.");
        System.err.println("");
        System.err.println("The 'restore' command when given just a package name intiates a restore of");
        System.err.println("just that one package according to the restore set selection algorithm");
        System.err.println("used by the RestoreSession.restorePackage() method.");
        System.err.println("");
        System.err.println("The 'run' command causes any scheduled backup operation to be initiated");
        System.err.println("immediately, without the usual waiting period for batching together");
        System.err.println("data changes.");
        System.err.println("");
        System.err.println("The 'wipe' command causes all backed-up data for the given package to be");
        System.err.println("erased from the current transport's storage.  The next backup operation");
        System.err.println("that the given application performs will rewrite its entire data set.");
    }

    class RestoreObserver
    extends IRestoreObserver.Stub {
        boolean done;
        RestoreSet[] sets = null;

        RestoreObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restoreSetsAvailable(RestoreSet[] result) {
            RestoreObserver restoreObserver = this;
            synchronized (restoreObserver) {
                this.sets = result;
                this.done = true;
                this.notify();
            }
        }

        public void restoreStarting(int numPackages) {
            System.out.println("restoreStarting: " + numPackages + " packages");
        }

        public void onUpdate(int nowBeingRestored, String currentPackage) {
            System.out.println("onUpdate: " + nowBeingRestored + " = " + currentPackage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restoreFinished(int error) {
            System.out.println("restoreFinished: " + error);
            RestoreObserver restoreObserver = this;
            synchronized (restoreObserver) {
                this.done = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            RestoreObserver restoreObserver = this;
            synchronized (restoreObserver) {
                while (!this.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

