/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import com.android.commands.monkey.MonkeyEvent;
import com.android.commands.monkey.MonkeyEventSource;
import com.android.commands.monkey.MonkeyFlipEvent;
import com.android.commands.monkey.MonkeyKeyEvent;
import com.android.commands.monkey.MonkeyNoopEvent;
import com.android.commands.monkey.MonkeySourceNetworkVars;
import com.android.commands.monkey.MonkeySourceNetworkViews;
import com.android.commands.monkey.MonkeySourceRandom;
import com.android.commands.monkey.MonkeyThrottleEvent;
import com.android.commands.monkey.MonkeyTouchEvent;
import com.android.commands.monkey.MonkeyTrackballEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonkeySourceNetwork
implements MonkeyEventSource {
    private static final String TAG = "MonkeyStub";
    public static final int MONKEY_NETWORK_VERSION = 2;
    private static DeferredReturn deferredReturn;
    public static final MonkeyCommandReturn OK;
    public static final MonkeyCommandReturn ERROR;
    public static final MonkeyCommandReturn EARG;
    private static final Map<String, MonkeyCommand> COMMAND_MAP;
    private static final String QUIT = "quit";
    private static final String DONE = "done";
    private static final String OK_STR = "OK";
    private static final String ERROR_STR = "ERROR";
    private final CommandQueueImpl commandQueue = new CommandQueueImpl();
    private BufferedReader input;
    private PrintWriter output;
    private boolean started = false;
    private ServerSocket serverSocket;
    private Socket clientSocket;

    private static int getKeyCode(String keyName) {
        int keyCode;
        block2: {
            keyCode = -1;
            try {
                keyCode = Integer.parseInt(keyName);
            }
            catch (NumberFormatException e) {
                keyCode = MonkeySourceRandom.getKeyCode(keyName);
                if (keyCode != 0 || (keyCode = MonkeySourceRandom.getKeyCode("KEYCODE_" + keyName.toUpperCase())) != 0) break block2;
                return -1;
            }
        }
        return keyCode;
    }

    private static final boolean wake() {
        IPowerManager pm = IPowerManager.Stub.asInterface(ServiceManager.getService("power"));
        try {
            pm.wakeUp(SystemClock.uptimeMillis());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Got remote exception", e);
            return false;
        }
        return true;
    }

    public MonkeySourceNetwork(int port) throws IOException {
        this.serverSocket = new ServerSocket(port, 0, InetAddress.getLocalHost());
    }

    private void startServer() throws IOException {
        this.clientSocket = this.serverSocket.accept();
        MonkeySourceNetworkViews.setup();
        MonkeySourceNetwork.wake();
        this.input = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        this.output = new PrintWriter(this.clientSocket.getOutputStream(), true);
    }

    private void stopServer() throws IOException {
        this.clientSocket.close();
        MonkeySourceNetworkViews.teardown();
        this.input.close();
        this.output.close();
        this.started = false;
    }

    private static String replaceQuotedChars(String input) {
        return input.replace("\\\"", "\"");
    }

    private static List<String> commandLineSplit(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(line);
        boolean insideQuote = false;
        StringBuffer quotedWord = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String cur = tok.nextToken();
            if (!insideQuote && cur.startsWith("\"")) {
                quotedWord.append(MonkeySourceNetwork.replaceQuotedChars(cur));
                insideQuote = true;
                continue;
            }
            if (insideQuote) {
                if (cur.endsWith("\"")) {
                    insideQuote = false;
                    quotedWord.append(" ").append(MonkeySourceNetwork.replaceQuotedChars(cur));
                    String word = quotedWord.toString();
                    result.add(word.substring(1, word.length() - 1));
                    continue;
                }
                quotedWord.append(" ").append(MonkeySourceNetwork.replaceQuotedChars(cur));
                continue;
            }
            result.add(MonkeySourceNetwork.replaceQuotedChars(cur));
        }
        return result;
    }

    private void translateCommand(String commandLine) {
        MonkeyCommand command;
        Log.d(TAG, "translateCommand: " + commandLine);
        List<String> parts = MonkeySourceNetwork.commandLineSplit(commandLine);
        if (parts.size() > 0 && (command = COMMAND_MAP.get(parts.get(0))) != null) {
            MonkeyCommandReturn ret = command.translateCommand(parts, this.commandQueue);
            this.handleReturn(ret);
        }
    }

    private void handleReturn(MonkeyCommandReturn ret) {
        if (ret.wasSuccessful()) {
            if (ret.hasMessage()) {
                this.returnOk(ret.getMessage());
            } else {
                this.returnOk();
            }
        } else if (ret.hasMessage()) {
            this.returnError(ret.getMessage());
        } else {
            this.returnError();
        }
    }

    @Override
    public MonkeyEvent getNextEvent() {
        if (!this.started) {
            try {
                this.startServer();
            }
            catch (IOException e) {
                Log.e(TAG, "Got IOException from server", e);
                return null;
            }
            this.started = true;
        }
        try {
            while (true) {
                String command;
                MonkeyEvent queuedEvent;
                if ((queuedEvent = this.commandQueue.getNextQueuedEvent()) != null) {
                    return queuedEvent;
                }
                if (deferredReturn != null) {
                    Log.d(TAG, "Waiting for event");
                    MonkeyCommandReturn ret = deferredReturn.waitForEvent();
                    deferredReturn = null;
                    this.handleReturn(ret);
                }
                if ((command = this.input.readLine()) == null) {
                    Log.d(TAG, "Connection dropped.");
                    command = DONE;
                }
                if (DONE.equals(command)) {
                    try {
                        this.stopServer();
                    }
                    catch (IOException e) {
                        Log.e(TAG, "Got IOException shutting down!", e);
                        return null;
                    }
                    return new MonkeyNoopEvent();
                }
                if (QUIT.equals(command)) {
                    Log.d(TAG, "Quit requested");
                    this.returnOk();
                    return null;
                }
                if (command.startsWith("#")) continue;
                this.translateCommand(command);
            }
        }
        catch (IOException e) {
            Log.e(TAG, "Exception: ", e);
            return null;
        }
    }

    private void returnError() {
        this.output.println(ERROR_STR);
    }

    private void returnError(String msg) {
        this.output.print(ERROR_STR);
        this.output.print(":");
        this.output.println(msg);
    }

    private void returnOk() {
        this.output.println(OK_STR);
    }

    private void returnOk(String returnValue) {
        this.output.print(OK_STR);
        this.output.print(":");
        this.output.println(returnValue);
    }

    @Override
    public void setVerbose(int verbose) {
    }

    @Override
    public boolean validate() {
        return true;
    }

    static {
        OK = new MonkeyCommandReturn(true);
        ERROR = new MonkeyCommandReturn(false);
        EARG = new MonkeyCommandReturn(false, "Invalid Argument");
        COMMAND_MAP = new HashMap<String, MonkeyCommand>();
        COMMAND_MAP.put("flip", new FlipCommand());
        COMMAND_MAP.put("touch", new TouchCommand());
        COMMAND_MAP.put("trackball", new TrackballCommand());
        COMMAND_MAP.put("key", new KeyCommand());
        COMMAND_MAP.put("sleep", new SleepCommand());
        COMMAND_MAP.put("wake", new WakeCommand());
        COMMAND_MAP.put("tap", new TapCommand());
        COMMAND_MAP.put("press", new PressCommand());
        COMMAND_MAP.put("type", new TypeCommand());
        COMMAND_MAP.put("listvar", new MonkeySourceNetworkVars.ListVarCommand());
        COMMAND_MAP.put("getvar", new MonkeySourceNetworkVars.GetVarCommand());
        COMMAND_MAP.put("listviews", new MonkeySourceNetworkViews.ListViewsCommand());
        COMMAND_MAP.put("queryview", new MonkeySourceNetworkViews.QueryViewCommand());
        COMMAND_MAP.put("getrootview", new MonkeySourceNetworkViews.GetRootViewCommand());
        COMMAND_MAP.put("getviewswithtext", new MonkeySourceNetworkViews.GetViewsWithTextCommand());
        COMMAND_MAP.put("deferreturn", new DeferReturnCommand());
    }

    private static class DeferredReturn {
        public static final int ON_WINDOW_STATE_CHANGE = 1;
        private int event;
        private MonkeyCommandReturn deferredReturn;
        private long timeout;

        public DeferredReturn(int event, MonkeyCommandReturn deferredReturn, long timeout) {
            this.event = event;
            this.deferredReturn = deferredReturn;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MonkeyCommandReturn waitForEvent() {
            switch (this.event) {
                case 1: {
                    try {
                        Class<MonkeySourceNetworkViews> clazz = MonkeySourceNetworkViews.class;
                        synchronized (MonkeySourceNetworkViews.class) {
                            MonkeySourceNetworkViews.class.wait(this.timeout);
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return this.deferredReturn;
                        }
                    }
                    catch (InterruptedException e) {
                        Log.d(MonkeySourceNetwork.TAG, "Deferral interrupted: " + e.getMessage());
                    }
                }
            }
            return this.deferredReturn;
        }
    }

    private static class CommandQueueImpl
    implements CommandQueue {
        private final Queue<MonkeyEvent> queuedEvents = new LinkedList<MonkeyEvent>();

        private CommandQueueImpl() {
        }

        public void enqueueEvent(MonkeyEvent e) {
            this.queuedEvents.offer(e);
        }

        public MonkeyEvent getNextQueuedEvent() {
            return this.queuedEvents.poll();
        }
    }

    public static interface CommandQueue {
        public void enqueueEvent(MonkeyEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeferReturnCommand
    implements MonkeyCommand {
        private DeferReturnCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (command.size() > 3) {
                String event = command.get(1);
                if (!event.equals("screenchange")) {
                    return EARG;
                }
                int eventId = 1;
                long timeout = Long.parseLong(command.get(2));
                MonkeyCommand deferredCommand = (MonkeyCommand)COMMAND_MAP.get(command.get(3));
                if (deferredCommand != null) {
                    List<String> parts = command.subList(3, command.size());
                    MonkeyCommandReturn ret = deferredCommand.translateCommand(parts, queue);
                    deferredReturn = new DeferredReturn(eventId, ret, timeout);
                    return OK;
                }
            }
            return EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PressCommand
    implements MonkeyCommand {
        private PressCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (command.size() == 2) {
                int keyCode = MonkeySourceNetwork.getKeyCode(command.get(1));
                if (keyCode < 0) {
                    Log.e(MonkeySourceNetwork.TAG, "Can't find keyname: " + command.get(1));
                    return EARG;
                }
                queue.enqueueEvent(new MonkeyKeyEvent(0, keyCode));
                queue.enqueueEvent(new MonkeyKeyEvent(1, keyCode));
                return OK;
            }
            return EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TapCommand
    implements MonkeyCommand {
        private TapCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (command.size() == 3) {
                int x = 0;
                int y = 0;
                try {
                    x = Integer.parseInt(command.get(1));
                    y = Integer.parseInt(command.get(2));
                }
                catch (NumberFormatException e) {
                    Log.e(MonkeySourceNetwork.TAG, "Got something that wasn't a number", e);
                    return EARG;
                }
                queue.enqueueEvent(new MonkeyTouchEvent(0).addPointer(0, x, y));
                queue.enqueueEvent(new MonkeyTouchEvent(1).addPointer(0, x, y));
                return OK;
            }
            return EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WakeCommand
    implements MonkeyCommand {
        private WakeCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (!MonkeySourceNetwork.wake()) {
                return ERROR;
            }
            return OK;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeCommand
    implements MonkeyCommand {
        private TypeCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (command.size() == 2) {
                KeyEvent[] events;
                String str = command.get(1);
                char[] chars = str.toString().toCharArray();
                KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(-1);
                for (KeyEvent event : events = keyCharacterMap.getEvents(chars)) {
                    queue.enqueueEvent(new MonkeyKeyEvent(event));
                }
                return OK;
            }
            return EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SleepCommand
    implements MonkeyCommand {
        private SleepCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (command.size() == 2) {
                int sleep = -1;
                String sleepStr = command.get(1);
                try {
                    sleep = Integer.parseInt(sleepStr);
                }
                catch (NumberFormatException e) {
                    Log.e(MonkeySourceNetwork.TAG, "Not a number: " + sleepStr, e);
                    return EARG;
                }
                queue.enqueueEvent(new MonkeyThrottleEvent((long)sleep));
                return OK;
            }
            return EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyCommand
    implements MonkeyCommand {
        private KeyCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (command.size() == 3) {
                int keyCode = MonkeySourceNetwork.getKeyCode(command.get(2));
                if (keyCode < 0) {
                    Log.e(MonkeySourceNetwork.TAG, "Can't find keyname: " + command.get(2));
                    return EARG;
                }
                Log.d(MonkeySourceNetwork.TAG, "keycode: " + keyCode);
                int action = -1;
                if ("down".equals(command.get(1))) {
                    action = 0;
                } else if ("up".equals(command.get(1))) {
                    action = 1;
                }
                if (action == -1) {
                    Log.e(MonkeySourceNetwork.TAG, "got unknown action.");
                    return EARG;
                }
                queue.enqueueEvent(new MonkeyKeyEvent(action, keyCode));
                return OK;
            }
            return EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrackballCommand
    implements MonkeyCommand {
        private TrackballCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (command.size() == 3) {
                int dx = 0;
                int dy = 0;
                try {
                    dx = Integer.parseInt(command.get(1));
                    dy = Integer.parseInt(command.get(2));
                }
                catch (NumberFormatException e) {
                    Log.e(MonkeySourceNetwork.TAG, "Got something that wasn't a number", e);
                    return EARG;
                }
                queue.enqueueEvent(new MonkeyTrackballEvent(2).addPointer(0, dx, dy));
                return OK;
            }
            return EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TouchCommand
    implements MonkeyCommand {
        private TouchCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (command.size() == 4) {
                String actionName = command.get(1);
                int x = 0;
                int y = 0;
                try {
                    x = Integer.parseInt(command.get(2));
                    y = Integer.parseInt(command.get(3));
                }
                catch (NumberFormatException e) {
                    Log.e(MonkeySourceNetwork.TAG, "Got something that wasn't a number", e);
                    return EARG;
                }
                int action = -1;
                if ("down".equals(actionName)) {
                    action = 0;
                } else if ("up".equals(actionName)) {
                    action = 1;
                } else if ("move".equals(actionName)) {
                    action = 2;
                }
                if (action == -1) {
                    Log.e(MonkeySourceNetwork.TAG, "Got a bad action: " + actionName);
                    return EARG;
                }
                queue.enqueueEvent(new MonkeyTouchEvent(action).addPointer(0, x, y));
                return OK;
            }
            return EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlipCommand
    implements MonkeyCommand {
        private FlipCommand() {
        }

        @Override
        public MonkeyCommandReturn translateCommand(List<String> command, CommandQueue queue) {
            if (command.size() > 1) {
                String direction = command.get(1);
                if ("open".equals(direction)) {
                    queue.enqueueEvent(new MonkeyFlipEvent(true));
                    return OK;
                }
                if ("close".equals(direction)) {
                    queue.enqueueEvent(new MonkeyFlipEvent(false));
                    return OK;
                }
            }
            return EARG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MonkeyCommand {
        public MonkeyCommandReturn translateCommand(List<String> var1, CommandQueue var2);
    }

    public static class MonkeyCommandReturn {
        private final boolean success;
        private final String message;

        public MonkeyCommandReturn(boolean success) {
            this.success = success;
            this.message = null;
        }

        public MonkeyCommandReturn(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        boolean hasMessage() {
            return this.message != null;
        }

        String getMessage() {
            return this.message;
        }

        boolean wasSuccessful() {
            return this.success;
        }
    }
}

