/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.content.ComponentName;
import android.graphics.PointF;
import android.hardware.display.DisplayManagerGlobal;
import android.os.SystemClock;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import com.android.commands.monkey.MonkeyActivityEvent;
import com.android.commands.monkey.MonkeyEvent;
import com.android.commands.monkey.MonkeyEventQueue;
import com.android.commands.monkey.MonkeyEventSource;
import com.android.commands.monkey.MonkeyFlipEvent;
import com.android.commands.monkey.MonkeyKeyEvent;
import com.android.commands.monkey.MonkeyRotationEvent;
import com.android.commands.monkey.MonkeyTouchEvent;
import com.android.commands.monkey.MonkeyTrackballEvent;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonkeySourceRandom
implements MonkeyEventSource {
    private static final int[] NAV_KEYS;
    private static final int[] MAJOR_NAV_KEYS;
    private static final int[] SYS_KEYS;
    private static final boolean[] PHYSICAL_KEY_EXISTS;
    private static final int[] SCREEN_ROTATION_DEGREES;
    public static final int FACTOR_TOUCH = 0;
    public static final int FACTOR_MOTION = 1;
    public static final int FACTOR_PINCHZOOM = 2;
    public static final int FACTOR_TRACKBALL = 3;
    public static final int FACTOR_ROTATION = 4;
    public static final int FACTOR_NAV = 5;
    public static final int FACTOR_MAJORNAV = 6;
    public static final int FACTOR_SYSOPS = 7;
    public static final int FACTOR_APPSWITCH = 8;
    public static final int FACTOR_FLIP = 9;
    public static final int FACTOR_ANYTHING = 10;
    public static final int FACTORZ_COUNT = 11;
    private static final int GESTURE_TAP = 0;
    private static final int GESTURE_DRAG = 1;
    private static final int GESTURE_PINCH_OR_ZOOM = 2;
    private float[] mFactors = new float[11];
    private ArrayList<ComponentName> mMainApps;
    private int mEventCount = 0;
    private MonkeyEventQueue mQ;
    private Random mRandom;
    private int mVerbose = 0;
    private long mThrottle = 0L;
    private boolean mKeyboardOpen = false;

    public static String getKeyName(int keycode) {
        return KeyEvent.keyCodeToString(keycode);
    }

    public static int getKeyCode(String keyName) {
        return KeyEvent.keyCodeFromString(keyName);
    }

    public MonkeySourceRandom(Random random, ArrayList<ComponentName> MainApps, long throttle, boolean randomizeThrottle) {
        this.mFactors[0] = 15.0f;
        this.mFactors[1] = 10.0f;
        this.mFactors[3] = 15.0f;
        this.mFactors[4] = 0.0f;
        this.mFactors[5] = 25.0f;
        this.mFactors[6] = 15.0f;
        this.mFactors[7] = 2.0f;
        this.mFactors[8] = 2.0f;
        this.mFactors[9] = 1.0f;
        this.mFactors[10] = 13.0f;
        this.mFactors[2] = 2.0f;
        this.mRandom = random;
        this.mMainApps = MainApps;
        this.mQ = new MonkeyEventQueue(random, throttle, randomizeThrottle);
    }

    private boolean adjustEventFactors() {
        int i;
        float userSum = 0.0f;
        float defaultSum = 0.0f;
        int defaultCount = 0;
        for (int i2 = 0; i2 < 11; ++i2) {
            if (this.mFactors[i2] <= 0.0f) {
                userSum -= this.mFactors[i2];
                continue;
            }
            defaultSum += this.mFactors[i2];
            ++defaultCount;
        }
        if (userSum > 100.0f) {
            System.err.println("** Event weights > 100%");
            return false;
        }
        if (defaultCount == 0 && (userSum < 99.9f || userSum > 100.1f)) {
            System.err.println("** Event weights != 100%");
            return false;
        }
        float defaultsTarget = 100.0f - userSum;
        float defaultsAdjustment = defaultsTarget / defaultSum;
        for (i = 0; i < 11; ++i) {
            if (this.mFactors[i] <= 0.0f) {
                this.mFactors[i] = -this.mFactors[i];
                continue;
            }
            int n = i;
            this.mFactors[n] = this.mFactors[n] * defaultsAdjustment;
        }
        if (this.mVerbose > 0) {
            System.out.println("// Event percentages:");
            for (i = 0; i < 11; ++i) {
                System.out.println("//   " + i + ": " + this.mFactors[i] + "%");
            }
        }
        if (!this.validateKeys()) {
            return false;
        }
        float sum = 0.0f;
        for (int i3 = 0; i3 < 11; ++i3) {
            this.mFactors[i3] = sum += this.mFactors[i3] / 100.0f;
        }
        return true;
    }

    private static boolean validateKeyCategory(String catName, int[] keys, float factor) {
        if (factor < 0.1f) {
            return true;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (!PHYSICAL_KEY_EXISTS[keys[i]]) continue;
            return true;
        }
        System.err.println("** " + catName + " has no physical keys but with factor " + factor + "%.");
        return false;
    }

    private boolean validateKeys() {
        return MonkeySourceRandom.validateKeyCategory("NAV_KEYS", NAV_KEYS, this.mFactors[5]) && MonkeySourceRandom.validateKeyCategory("MAJOR_NAV_KEYS", MAJOR_NAV_KEYS, this.mFactors[6]) && MonkeySourceRandom.validateKeyCategory("SYS_KEYS", SYS_KEYS, this.mFactors[7]);
    }

    public void setFactors(float[] factors) {
        int c = 11;
        if (factors.length < c) {
            c = factors.length;
        }
        for (int i = 0; i < c; ++i) {
            this.mFactors[i] = factors[i];
        }
    }

    public void setFactors(int index, float v) {
        this.mFactors[index] = v;
    }

    private void generatePointerEvent(Random random, int gesture) {
        Display display = DisplayManagerGlobal.getInstance().getRealDisplay(0);
        PointF p1 = this.randomPoint(random, display);
        PointF v1 = this.randomVector(random);
        long downAt = SystemClock.uptimeMillis();
        this.mQ.addLast(new MonkeyTouchEvent(0).setDownTime(downAt).addPointer(0, p1.x, p1.y).setIntermediateNote(false));
        if (gesture == 1) {
            int count = random.nextInt(10);
            for (int i = 0; i < count; ++i) {
                this.randomWalk(random, display, p1, v1);
                this.mQ.addLast(new MonkeyTouchEvent(2).setDownTime(downAt).addPointer(0, p1.x, p1.y).setIntermediateNote(true));
            }
        } else if (gesture == 2) {
            PointF p2 = this.randomPoint(random, display);
            PointF v2 = this.randomVector(random);
            this.randomWalk(random, display, p1, v1);
            this.mQ.addLast(new MonkeyTouchEvent(261).setDownTime(downAt).addPointer(0, p1.x, p1.y).addPointer(1, p2.x, p2.y).setIntermediateNote(true));
            int count = random.nextInt(10);
            for (int i = 0; i < count; ++i) {
                this.randomWalk(random, display, p1, v1);
                this.randomWalk(random, display, p2, v2);
                this.mQ.addLast(new MonkeyTouchEvent(2).setDownTime(downAt).addPointer(0, p1.x, p1.y).addPointer(1, p2.x, p2.y).setIntermediateNote(true));
            }
            this.randomWalk(random, display, p1, v1);
            this.randomWalk(random, display, p2, v2);
            this.mQ.addLast(new MonkeyTouchEvent(262).setDownTime(downAt).addPointer(0, p1.x, p1.y).addPointer(1, p2.x, p2.y).setIntermediateNote(true));
        }
        this.randomWalk(random, display, p1, v1);
        this.mQ.addLast(new MonkeyTouchEvent(1).setDownTime(downAt).addPointer(0, p1.x, p1.y).setIntermediateNote(false));
    }

    private PointF randomPoint(Random random, Display display) {
        return new PointF(random.nextInt(display.getWidth()), random.nextInt(display.getHeight()));
    }

    private PointF randomVector(Random random) {
        return new PointF((random.nextFloat() - 0.5f) * 50.0f, (random.nextFloat() - 0.5f) * 50.0f);
    }

    private void randomWalk(Random random, Display display, PointF point, PointF vector) {
        point.x = Math.max(Math.min(point.x + random.nextFloat() * vector.x, (float)display.getWidth()), 0.0f);
        point.y = Math.max(Math.min(point.y + random.nextFloat() * vector.y, (float)display.getHeight()), 0.0f);
    }

    private void generateTrackballEvent(Random random) {
        for (int i = 0; i < 10; ++i) {
            int dX = random.nextInt(10) - 5;
            int dY = random.nextInt(10) - 5;
            this.mQ.addLast(new MonkeyTrackballEvent(2).addPointer(0, dX, dY).setIntermediateNote(i > 0));
        }
        if (0 == random.nextInt(10)) {
            long downAt = SystemClock.uptimeMillis();
            this.mQ.addLast(new MonkeyTrackballEvent(0).setDownTime(downAt).addPointer(0, 0.0f, 0.0f).setIntermediateNote(true));
            this.mQ.addLast(new MonkeyTrackballEvent(1).setDownTime(downAt).addPointer(0, 0.0f, 0.0f).setIntermediateNote(false));
        }
    }

    private void generateRotationEvent(Random random) {
        this.mQ.addLast(new MonkeyRotationEvent(SCREEN_ROTATION_DEGREES[random.nextInt(SCREEN_ROTATION_DEGREES.length)], random.nextBoolean()));
    }

    private void generateEvents() {
        float cls = this.mRandom.nextFloat();
        int lastKey = 0;
        if (cls < this.mFactors[0]) {
            this.generatePointerEvent(this.mRandom, 0);
            return;
        }
        if (cls < this.mFactors[1]) {
            this.generatePointerEvent(this.mRandom, 1);
            return;
        }
        if (cls < this.mFactors[2]) {
            this.generatePointerEvent(this.mRandom, 2);
            return;
        }
        if (cls < this.mFactors[3]) {
            this.generateTrackballEvent(this.mRandom);
            return;
        }
        if (cls < this.mFactors[4]) {
            this.generateRotationEvent(this.mRandom);
            return;
        }
        do {
            if (cls < this.mFactors[5]) {
                lastKey = NAV_KEYS[this.mRandom.nextInt(NAV_KEYS.length)];
                continue;
            }
            if (cls < this.mFactors[6]) {
                lastKey = MAJOR_NAV_KEYS[this.mRandom.nextInt(MAJOR_NAV_KEYS.length)];
                continue;
            }
            if (cls < this.mFactors[7]) {
                lastKey = SYS_KEYS[this.mRandom.nextInt(SYS_KEYS.length)];
                continue;
            }
            if (cls < this.mFactors[8]) {
                MonkeyActivityEvent e = new MonkeyActivityEvent(this.mMainApps.get(this.mRandom.nextInt(this.mMainApps.size())));
                this.mQ.addLast(e);
                return;
            }
            if (cls < this.mFactors[9]) {
                MonkeyFlipEvent e = new MonkeyFlipEvent(this.mKeyboardOpen);
                this.mKeyboardOpen = !this.mKeyboardOpen;
                this.mQ.addLast(e);
                return;
            }
            lastKey = 1 + this.mRandom.nextInt(KeyEvent.getMaxKeyCode() - 1);
        } while (lastKey == 26 || lastKey == 6 || !PHYSICAL_KEY_EXISTS[lastKey]);
        MonkeyKeyEvent e = new MonkeyKeyEvent(0, lastKey);
        this.mQ.addLast(e);
        e = new MonkeyKeyEvent(1, lastKey);
        this.mQ.addLast(e);
    }

    @Override
    public boolean validate() {
        return this.adjustEventFactors();
    }

    @Override
    public void setVerbose(int verbose) {
        this.mVerbose = verbose;
    }

    public void generateActivity() {
        MonkeyActivityEvent e = new MonkeyActivityEvent(this.mMainApps.get(this.mRandom.nextInt(this.mMainApps.size())));
        this.mQ.addLast(e);
    }

    @Override
    public MonkeyEvent getNextEvent() {
        if (this.mQ.isEmpty()) {
            this.generateEvents();
        }
        ++this.mEventCount;
        MonkeyEvent e = (MonkeyEvent)this.mQ.getFirst();
        this.mQ.removeFirst();
        return e;
    }

    static {
        int i;
        NAV_KEYS = new int[]{19, 20, 21, 22};
        MAJOR_NAV_KEYS = new int[]{82, 23};
        SYS_KEYS = new int[]{3, 4, 5, 6, 24, 25, 164, 91};
        PHYSICAL_KEY_EXISTS = new boolean[KeyEvent.getMaxKeyCode() + 1];
        for (i = 0; i < PHYSICAL_KEY_EXISTS.length; ++i) {
            MonkeySourceRandom.PHYSICAL_KEY_EXISTS[i] = true;
        }
        for (i = 0; i < SYS_KEYS.length; ++i) {
            MonkeySourceRandom.PHYSICAL_KEY_EXISTS[MonkeySourceRandom.SYS_KEYS[i]] = KeyCharacterMap.deviceHasKey(SYS_KEYS[i]);
        }
        SCREEN_ROTATION_DEGREES = new int[]{0, 1, 2, 3};
    }
}

