/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.monkey;

import android.content.ComponentName;
import android.os.SystemClock;
import com.android.commands.monkey.MonkeyActivityEvent;
import com.android.commands.monkey.MonkeyCommandEvent;
import com.android.commands.monkey.MonkeyEvent;
import com.android.commands.monkey.MonkeyEventQueue;
import com.android.commands.monkey.MonkeyEventSource;
import com.android.commands.monkey.MonkeyFlipEvent;
import com.android.commands.monkey.MonkeyGetAppFrameRateEvent;
import com.android.commands.monkey.MonkeyGetFrameRateEvent;
import com.android.commands.monkey.MonkeyInstrumentationEvent;
import com.android.commands.monkey.MonkeyKeyEvent;
import com.android.commands.monkey.MonkeyMotionEvent;
import com.android.commands.monkey.MonkeyPowerEvent;
import com.android.commands.monkey.MonkeyRotationEvent;
import com.android.commands.monkey.MonkeySourceRandom;
import com.android.commands.monkey.MonkeyTouchEvent;
import com.android.commands.monkey.MonkeyTrackballEvent;
import com.android.commands.monkey.MonkeyWaitEvent;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.Random;

public class MonkeySourceScript
implements MonkeyEventSource {
    private int mEventCountInScript = 0;
    private int mVerbose = 0;
    private double mSpeed = 1.0;
    private String mScriptFileName;
    private MonkeyEventQueue mQ;
    private static final String HEADER_COUNT = "count=";
    private static final String HEADER_SPEED = "speed=";
    private long mLastRecordedDownTimeKey = 0L;
    private long mLastRecordedDownTimeMotion = 0L;
    private long mLastExportDownTimeKey = 0L;
    private long mLastExportDownTimeMotion = 0L;
    private long mLastExportEventTime = -1L;
    private long mLastRecordedEventTime = -1L;
    private boolean mReadScriptLineByLine = false;
    private static final boolean THIS_DEBUG = false;
    private static final long SLEEP_COMPENSATE_DIFF = 16L;
    private static final String HEADER_LINE_BY_LINE = "linebyline";
    private static final int MAX_ONE_TIME_READS = 100;
    private static final String EVENT_KEYWORD_POINTER = "DispatchPointer";
    private static final String EVENT_KEYWORD_TRACKBALL = "DispatchTrackball";
    private static final String EVENT_KEYWORD_ROTATION = "RotateScreen";
    private static final String EVENT_KEYWORD_KEY = "DispatchKey";
    private static final String EVENT_KEYWORD_FLIP = "DispatchFlip";
    private static final String EVENT_KEYWORD_KEYPRESS = "DispatchPress";
    private static final String EVENT_KEYWORD_ACTIVITY = "LaunchActivity";
    private static final String EVENT_KEYWORD_INSTRUMENTATION = "LaunchInstrumentation";
    private static final String EVENT_KEYWORD_WAIT = "UserWait";
    private static final String EVENT_KEYWORD_LONGPRESS = "LongPress";
    private static final String EVENT_KEYWORD_POWERLOG = "PowerLog";
    private static final String EVENT_KEYWORD_WRITEPOWERLOG = "WriteLog";
    private static final String EVENT_KEYWORD_RUNCMD = "RunCmd";
    private static final String EVENT_KEYWORD_TAP = "Tap";
    private static final String EVENT_KEYWORD_PROFILE_WAIT = "ProfileWait";
    private static final String EVENT_KEYWORD_DEVICE_WAKEUP = "DeviceWakeUp";
    private static final String EVENT_KEYWORD_INPUT_STRING = "DispatchString";
    private static final String EVENT_KEYWORD_PRESSANDHOLD = "PressAndHold";
    private static final String EVENT_KEYWORD_DRAG = "Drag";
    private static final String EVENT_KEYWORD_PINCH_ZOOM = "PinchZoom";
    private static final String EVENT_KEYWORD_START_FRAMERATE_CAPTURE = "StartCaptureFramerate";
    private static final String EVENT_KEYWORD_END_FRAMERATE_CAPTURE = "EndCaptureFramerate";
    private static final String EVENT_KEYWORD_START_APP_FRAMERATE_CAPTURE = "StartCaptureAppFramerate";
    private static final String EVENT_KEYWORD_END_APP_FRAMERATE_CAPTURE = "EndCaptureAppFramerate";
    private static final String STARTING_DATA_LINE = "start data >>";
    private boolean mFileOpened = false;
    private static int LONGPRESS_WAIT_TIME = 2000;
    private long mProfileWaitTime = 5000L;
    private long mDeviceSleepTime = 30000L;
    FileInputStream mFStream;
    DataInputStream mInputStream;
    BufferedReader mBufferedReader;
    private float[] mLastX = new float[2];
    private float[] mLastY = new float[2];
    private long mScriptStartTime = -1L;
    private long mMonkeyStartTime = -1L;

    public MonkeySourceScript(Random random, String filename, long throttle, boolean randomizeThrottle, long profileWaitTime, long deviceSleepTime) {
        this.mScriptFileName = filename;
        this.mQ = new MonkeyEventQueue(random, throttle, randomizeThrottle);
        this.mProfileWaitTime = profileWaitTime;
        this.mDeviceSleepTime = deviceSleepTime;
    }

    private void resetValue() {
        this.mLastRecordedDownTimeKey = 0L;
        this.mLastRecordedDownTimeMotion = 0L;
        this.mLastRecordedEventTime = -1L;
        this.mLastExportDownTimeKey = 0L;
        this.mLastExportDownTimeMotion = 0L;
        this.mLastExportEventTime = -1L;
    }

    private boolean readHeader() throws IOException {
        String line;
        this.mFileOpened = true;
        this.mFStream = new FileInputStream(this.mScriptFileName);
        this.mInputStream = new DataInputStream(this.mFStream);
        this.mBufferedReader = new BufferedReader(new InputStreamReader(this.mInputStream));
        while ((line = this.mBufferedReader.readLine()) != null) {
            String value;
            if ((line = line.trim()).indexOf(HEADER_COUNT) >= 0) {
                try {
                    value = line.substring(HEADER_COUNT.length() + 1).trim();
                    this.mEventCountInScript = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println(e);
                    return false;
                }
            }
            if (line.indexOf(HEADER_SPEED) >= 0) {
                try {
                    value = line.substring(HEADER_COUNT.length() + 1).trim();
                    this.mSpeed = Double.parseDouble(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println(e);
                    return false;
                }
            }
            if (line.indexOf(HEADER_LINE_BY_LINE) >= 0) {
                this.mReadScriptLineByLine = true;
                continue;
            }
            if (line.indexOf(STARTING_DATA_LINE) < 0) continue;
            return true;
        }
        return false;
    }

    private int readLines() throws IOException {
        for (int i = 0; i < 100; ++i) {
            String line = this.mBufferedReader.readLine();
            if (line == null) {
                return i;
            }
            line.trim();
            this.processLine(line);
        }
        return 100;
    }

    private int readOneLine() throws IOException {
        String line = this.mBufferedReader.readLine();
        if (line == null) {
            return 0;
        }
        line.trim();
        this.processLine(line);
        return 1;
    }

    private void handleEvent(String s, String[] args) {
        if (s.indexOf(EVENT_KEYWORD_KEY) >= 0 && args.length == 8) {
            try {
                System.out.println(" old key\n");
                long downTime = Long.parseLong(args[0]);
                long eventTime = Long.parseLong(args[1]);
                int action = Integer.parseInt(args[2]);
                int code = Integer.parseInt(args[3]);
                int repeat = Integer.parseInt(args[4]);
                int metaState = Integer.parseInt(args[5]);
                int device = Integer.parseInt(args[6]);
                int scancode = Integer.parseInt(args[7]);
                MonkeyKeyEvent e = new MonkeyKeyEvent(downTime, eventTime, action, code, repeat, metaState, device, scancode);
                System.out.println(" Key code " + code + "\n");
                this.mQ.addLast(e);
                System.out.println("Added key up \n");
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return;
        }
        if ((s.indexOf(EVENT_KEYWORD_POINTER) >= 0 || s.indexOf(EVENT_KEYWORD_TRACKBALL) >= 0) && args.length == 12) {
            try {
                long downTime = Long.parseLong(args[0]);
                long eventTime = Long.parseLong(args[1]);
                int action = Integer.parseInt(args[2]);
                float x = Float.parseFloat(args[3]);
                float y = Float.parseFloat(args[4]);
                float pressure = Float.parseFloat(args[5]);
                float size = Float.parseFloat(args[6]);
                int metaState = Integer.parseInt(args[7]);
                float xPrecision = Float.parseFloat(args[8]);
                float yPrecision = Float.parseFloat(args[9]);
                int device = Integer.parseInt(args[10]);
                int edgeFlags = Integer.parseInt(args[11]);
                MonkeyMotionEvent e = s.indexOf("Pointer") > 0 ? new MonkeyTouchEvent(action) : new MonkeyTrackballEvent(action);
                e.setDownTime(downTime).setEventTime(eventTime).setMetaState(metaState).setPrecision(xPrecision, yPrecision).setDeviceId(device).setEdgeFlags(edgeFlags).addPointer(0, x, y, pressure, size);
                this.mQ.addLast(e);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return;
        }
        if ((s.indexOf(EVENT_KEYWORD_POINTER) >= 0 || s.indexOf(EVENT_KEYWORD_TRACKBALL) >= 0) && args.length == 13) {
            try {
                long scriptElapsedTime;
                long curUpTime;
                long realElapsedTime;
                MonkeyMotionEvent e;
                long downTime = Long.parseLong(args[0]);
                long eventTime = Long.parseLong(args[1]);
                int action = Integer.parseInt(args[2]);
                float x = Float.parseFloat(args[3]);
                float y = Float.parseFloat(args[4]);
                float pressure = Float.parseFloat(args[5]);
                float size = Float.parseFloat(args[6]);
                int metaState = Integer.parseInt(args[7]);
                float xPrecision = Float.parseFloat(args[8]);
                float yPrecision = Float.parseFloat(args[9]);
                int device = Integer.parseInt(args[10]);
                int edgeFlags = Integer.parseInt(args[11]);
                int pointerId = Integer.parseInt(args[12]);
                if (s.indexOf("Pointer") > 0) {
                    e = action == 5 ? new MonkeyTouchEvent(5 | pointerId << 8).setIntermediateNote(true) : new MonkeyTouchEvent(action);
                    if (this.mScriptStartTime < 0L) {
                        this.mMonkeyStartTime = SystemClock.uptimeMillis();
                        this.mScriptStartTime = eventTime;
                    }
                } else {
                    e = new MonkeyTrackballEvent(action);
                }
                if (pointerId == 1) {
                    e.setDownTime(downTime).setEventTime(eventTime).setMetaState(metaState).setPrecision(xPrecision, yPrecision).setDeviceId(device).setEdgeFlags(edgeFlags).addPointer(0, this.mLastX[0], this.mLastY[0], pressure, size).addPointer(1, x, y, pressure, size);
                    this.mLastX[1] = x;
                    this.mLastY[1] = y;
                } else if (pointerId == 0) {
                    e.setDownTime(downTime).setEventTime(eventTime).setMetaState(metaState).setPrecision(xPrecision, yPrecision).setDeviceId(device).setEdgeFlags(edgeFlags).addPointer(0, x, y, pressure, size);
                    if (action == 6) {
                        e.addPointer(1, this.mLastX[1], this.mLastY[1]);
                    }
                    this.mLastX[0] = x;
                    this.mLastY[0] = y;
                }
                if (this.mReadScriptLineByLine && (realElapsedTime = (curUpTime = SystemClock.uptimeMillis()) - this.mMonkeyStartTime) < (scriptElapsedTime = eventTime - this.mScriptStartTime)) {
                    long waitDuration = scriptElapsedTime - realElapsedTime;
                    this.mQ.addLast(new MonkeyWaitEvent(waitDuration));
                }
                this.mQ.addLast(e);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_ROTATION) >= 0 && args.length == 2) {
            try {
                int rotationDegree = Integer.parseInt(args[0]);
                int persist = Integer.parseInt(args[1]);
                if (rotationDegree == 0 || rotationDegree == 1 || rotationDegree == 2 || rotationDegree == 3) {
                    this.mQ.addLast(new MonkeyRotationEvent(rotationDegree, persist != 0));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_TAP) >= 0 && args.length >= 2) {
            try {
                float x = Float.parseFloat(args[0]);
                float y = Float.parseFloat(args[1]);
                long tapDuration = 0L;
                if (args.length == 3) {
                    tapDuration = Long.parseLong(args[2]);
                }
                long downTime = SystemClock.uptimeMillis();
                MonkeyMotionEvent e1 = new MonkeyTouchEvent(0).setDownTime(downTime).setEventTime(downTime).addPointer(0, x, y, 1.0f, 5.0f);
                this.mQ.addLast(e1);
                if (tapDuration > 0L) {
                    this.mQ.addLast(new MonkeyWaitEvent(tapDuration));
                }
                MonkeyMotionEvent e2 = new MonkeyTouchEvent(1).setDownTime(downTime).setEventTime(downTime).addPointer(0, x, y, 1.0f, 5.0f);
                this.mQ.addLast(e2);
            }
            catch (NumberFormatException e) {
                System.err.println("// " + e.toString());
            }
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_PRESSANDHOLD) >= 0 && args.length == 3) {
            try {
                float x = Float.parseFloat(args[0]);
                float y = Float.parseFloat(args[1]);
                long pressDuration = Long.parseLong(args[2]);
                long downTime = SystemClock.uptimeMillis();
                MonkeyMotionEvent e1 = new MonkeyTouchEvent(0).setDownTime(downTime).setEventTime(downTime).addPointer(0, x, y, 1.0f, 5.0f);
                MonkeyWaitEvent e2 = new MonkeyWaitEvent(pressDuration);
                MonkeyMotionEvent e3 = new MonkeyTouchEvent(1).setDownTime(downTime + pressDuration).setEventTime(downTime + pressDuration).addPointer(0, x, y, 1.0f, 5.0f);
                this.mQ.addLast(e1);
                this.mQ.addLast(e2);
                this.mQ.addLast(e2);
            }
            catch (NumberFormatException e) {
                System.err.println("// " + e.toString());
            }
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_DRAG) >= 0 && args.length == 5) {
            float xStart = Float.parseFloat(args[0]);
            float yStart = Float.parseFloat(args[1]);
            float xEnd = Float.parseFloat(args[2]);
            float yEnd = Float.parseFloat(args[3]);
            int stepCount = Integer.parseInt(args[4]);
            float x = xStart;
            float y = yStart;
            long downTime = SystemClock.uptimeMillis();
            long eventTime = SystemClock.uptimeMillis();
            if (stepCount > 0) {
                float xStep = (xEnd - xStart) / (float)stepCount;
                float yStep = (yEnd - yStart) / (float)stepCount;
                MonkeyMotionEvent e = new MonkeyTouchEvent(0).setDownTime(downTime).setEventTime(eventTime).addPointer(0, x, y, 1.0f, 5.0f);
                this.mQ.addLast(e);
                for (int i = 0; i < stepCount; ++i) {
                    eventTime = SystemClock.uptimeMillis();
                    e = new MonkeyTouchEvent(2).setDownTime(downTime).setEventTime(eventTime).addPointer(0, x += xStep, y += yStep, 1.0f, 5.0f);
                    this.mQ.addLast(e);
                }
                eventTime = SystemClock.uptimeMillis();
                e = new MonkeyTouchEvent(1).setDownTime(downTime).setEventTime(eventTime).addPointer(0, x, y, 1.0f, 5.0f);
                this.mQ.addLast(e);
            }
        }
        if (s.indexOf(EVENT_KEYWORD_PINCH_ZOOM) >= 0 && args.length == 9) {
            float pt1xStart = Float.parseFloat(args[0]);
            float pt1yStart = Float.parseFloat(args[1]);
            float pt1xEnd = Float.parseFloat(args[2]);
            float pt1yEnd = Float.parseFloat(args[3]);
            float pt2xStart = Float.parseFloat(args[4]);
            float pt2yStart = Float.parseFloat(args[5]);
            float pt2xEnd = Float.parseFloat(args[6]);
            float pt2yEnd = Float.parseFloat(args[7]);
            int stepCount = Integer.parseInt(args[8]);
            float x1 = pt1xStart;
            float y1 = pt1yStart;
            float x2 = pt2xStart;
            float y2 = pt2yStart;
            long downTime = SystemClock.uptimeMillis();
            long eventTime = SystemClock.uptimeMillis();
            if (stepCount > 0) {
                float pt1xStep = (pt1xEnd - pt1xStart) / (float)stepCount;
                float pt1yStep = (pt1yEnd - pt1yStart) / (float)stepCount;
                float pt2xStep = (pt2xEnd - pt2xStart) / (float)stepCount;
                float pt2yStep = (pt2yEnd - pt2yStart) / (float)stepCount;
                this.mQ.addLast(new MonkeyTouchEvent(0).setDownTime(downTime).setEventTime(eventTime).addPointer(0, x1, y1, 1.0f, 5.0f));
                this.mQ.addLast(new MonkeyTouchEvent(261).setDownTime(downTime).addPointer(0, x1, y1).addPointer(1, x2, y2).setIntermediateNote(true));
                for (int i = 0; i < stepCount; ++i) {
                    eventTime = SystemClock.uptimeMillis();
                    this.mQ.addLast(new MonkeyTouchEvent(2).setDownTime(downTime).setEventTime(eventTime).addPointer(0, x1 += pt1xStep, y1 += pt1yStep, 1.0f, 5.0f).addPointer(1, x2 += pt2xStep, y2 += pt2yStep, 1.0f, 5.0f));
                }
                eventTime = SystemClock.uptimeMillis();
                this.mQ.addLast(new MonkeyTouchEvent(6).setDownTime(downTime).setEventTime(eventTime).addPointer(0, x1, y1).addPointer(1, x2, y2));
            }
        }
        if (s.indexOf(EVENT_KEYWORD_FLIP) >= 0 && args.length == 1) {
            boolean keyboardOpen = Boolean.parseBoolean(args[0]);
            MonkeyFlipEvent e = new MonkeyFlipEvent(keyboardOpen);
            this.mQ.addLast(e);
        }
        if (s.indexOf(EVENT_KEYWORD_ACTIVITY) >= 0 && args.length >= 2) {
            String pkg_name = args[0];
            String cl_name = args[1];
            long alarmTime = 0L;
            ComponentName mApp = new ComponentName(pkg_name, cl_name);
            if (args.length > 2) {
                try {
                    alarmTime = Long.parseLong(args[2]);
                }
                catch (NumberFormatException e) {
                    System.err.println("// " + e.toString());
                    return;
                }
            }
            if (args.length == 2) {
                MonkeyActivityEvent e = new MonkeyActivityEvent(mApp);
                this.mQ.addLast(e);
            } else {
                MonkeyActivityEvent e = new MonkeyActivityEvent(mApp, alarmTime);
                this.mQ.addLast(e);
            }
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_DEVICE_WAKEUP) >= 0) {
            String pkg_name = "com.google.android.powerutil";
            String cl_name = "com.google.android.powerutil.WakeUpScreen";
            long deviceSleepTime = this.mDeviceSleepTime;
            ComponentName mApp = new ComponentName(pkg_name, cl_name);
            this.mQ.addLast(new MonkeyActivityEvent(mApp, deviceSleepTime));
            this.mQ.addLast(new MonkeyKeyEvent(0, 7));
            this.mQ.addLast(new MonkeyKeyEvent(1, 7));
            this.mQ.addLast(new MonkeyWaitEvent(deviceSleepTime + 3000L));
            this.mQ.addLast(new MonkeyKeyEvent(0, 82));
            this.mQ.addLast(new MonkeyKeyEvent(1, 82));
            this.mQ.addLast(new MonkeyKeyEvent(0, 4));
            this.mQ.addLast(new MonkeyKeyEvent(1, 4));
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_INSTRUMENTATION) >= 0 && args.length == 2) {
            String test_name = args[0];
            String runner_name = args[1];
            MonkeyInstrumentationEvent e = new MonkeyInstrumentationEvent(test_name, runner_name);
            this.mQ.addLast(e);
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_WAIT) >= 0 && args.length == 1) {
            try {
                long sleeptime = Integer.parseInt(args[0]);
                MonkeyWaitEvent e = new MonkeyWaitEvent(sleeptime);
                this.mQ.addLast(e);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_PROFILE_WAIT) >= 0) {
            MonkeyWaitEvent e = new MonkeyWaitEvent(this.mProfileWaitTime);
            this.mQ.addLast(e);
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_KEYPRESS) >= 0 && args.length == 1) {
            String key_name = args[0];
            int keyCode = MonkeySourceRandom.getKeyCode(key_name);
            if (keyCode == 0) {
                return;
            }
            MonkeyKeyEvent e = new MonkeyKeyEvent(0, keyCode);
            this.mQ.addLast(e);
            e = new MonkeyKeyEvent(1, keyCode);
            this.mQ.addLast(e);
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_LONGPRESS) >= 0) {
            MonkeyKeyEvent e = new MonkeyKeyEvent(0, 23);
            this.mQ.addLast(e);
            MonkeyWaitEvent we = new MonkeyWaitEvent((long)LONGPRESS_WAIT_TIME);
            this.mQ.addLast(we);
            e = new MonkeyKeyEvent(1, 23);
            this.mQ.addLast(e);
        }
        if (s.indexOf(EVENT_KEYWORD_POWERLOG) >= 0 && args.length > 0) {
            String power_log_type = args[0];
            if (args.length == 1) {
                MonkeyPowerEvent e = new MonkeyPowerEvent(power_log_type);
                this.mQ.addLast(e);
            } else if (args.length == 2) {
                String test_case_status = args[1];
                MonkeyPowerEvent e = new MonkeyPowerEvent(power_log_type, test_case_status);
                this.mQ.addLast(e);
            }
        }
        if (s.indexOf(EVENT_KEYWORD_WRITEPOWERLOG) >= 0) {
            MonkeyPowerEvent e = new MonkeyPowerEvent();
            this.mQ.addLast(e);
        }
        if (s.indexOf(EVENT_KEYWORD_RUNCMD) >= 0 && args.length == 1) {
            String cmd = args[0];
            MonkeyCommandEvent e = new MonkeyCommandEvent(cmd);
            this.mQ.addLast(e);
        }
        if (s.indexOf(EVENT_KEYWORD_INPUT_STRING) >= 0 && args.length == 1) {
            String input = args[0];
            String cmd = "input text " + input;
            MonkeyCommandEvent e = new MonkeyCommandEvent(cmd);
            this.mQ.addLast(e);
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_START_FRAMERATE_CAPTURE) >= 0) {
            MonkeyGetFrameRateEvent e = new MonkeyGetFrameRateEvent("start");
            this.mQ.addLast(e);
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_END_FRAMERATE_CAPTURE) >= 0 && args.length == 1) {
            String input = args[0];
            MonkeyGetFrameRateEvent e = new MonkeyGetFrameRateEvent("end", input);
            this.mQ.addLast(e);
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_START_APP_FRAMERATE_CAPTURE) >= 0 && args.length == 1) {
            String app = args[0];
            MonkeyGetAppFrameRateEvent e = new MonkeyGetAppFrameRateEvent("start", app);
            this.mQ.addLast(e);
            return;
        }
        if (s.indexOf(EVENT_KEYWORD_END_APP_FRAMERATE_CAPTURE) >= 0 && args.length == 2) {
            String app = args[0];
            String label = args[1];
            MonkeyGetAppFrameRateEvent e = new MonkeyGetAppFrameRateEvent("end", app, label);
            this.mQ.addLast(e);
            return;
        }
    }

    private void processLine(String line) {
        int index1 = line.indexOf(40);
        int index2 = line.indexOf(41);
        if (index1 < 0 || index2 < 0) {
            return;
        }
        String[] args = line.substring(index1 + 1, index2).split(",");
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].trim();
        }
        this.handleEvent(line, args);
    }

    private void closeFile() throws IOException {
        this.mFileOpened = false;
        try {
            this.mFStream.close();
            this.mInputStream.close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void readNextBatch() throws IOException {
        int linesRead = 0;
        if (!this.mFileOpened) {
            this.resetValue();
            this.readHeader();
        }
        if ((linesRead = this.mReadScriptLineByLine ? this.readOneLine() : this.readLines()) == 0) {
            this.closeFile();
        }
    }

    private void needSleep(long time) {
        if (time < 1L) {
            return;
        }
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean validate() {
        boolean validHeader;
        try {
            validHeader = this.readHeader();
            this.closeFile();
        }
        catch (IOException e) {
            return false;
        }
        if (this.mVerbose > 0) {
            System.out.println("Replaying " + this.mEventCountInScript + " events with speed " + this.mSpeed);
        }
        return validHeader;
    }

    public void setVerbose(int verbose) {
        this.mVerbose = verbose;
    }

    private void adjustKeyEventTime(MonkeyKeyEvent e) {
        if (e.getEventTime() < 0L) {
            return;
        }
        long thisDownTime = 0L;
        long thisEventTime = 0L;
        long expectedDelay = 0L;
        if (this.mLastRecordedEventTime <= 0L) {
            thisEventTime = thisDownTime = SystemClock.uptimeMillis();
        } else {
            thisDownTime = e.getDownTime() != this.mLastRecordedDownTimeKey ? e.getDownTime() : this.mLastExportDownTimeKey;
            expectedDelay = (long)((double)(e.getEventTime() - this.mLastRecordedEventTime) * this.mSpeed);
            thisEventTime = this.mLastExportEventTime + expectedDelay;
            this.needSleep(expectedDelay - 16L);
        }
        this.mLastRecordedDownTimeKey = e.getDownTime();
        this.mLastRecordedEventTime = e.getEventTime();
        e.setDownTime(thisDownTime);
        e.setEventTime(thisEventTime);
        this.mLastExportDownTimeKey = thisDownTime;
        this.mLastExportEventTime = thisEventTime;
    }

    private void adjustMotionEventTime(MonkeyMotionEvent e) {
        long thisEventTime = SystemClock.uptimeMillis();
        long thisDownTime = e.getDownTime();
        if (thisDownTime == this.mLastRecordedDownTimeMotion) {
            e.setDownTime(this.mLastExportDownTimeMotion);
        } else {
            this.mLastRecordedDownTimeMotion = thisDownTime;
            e.setDownTime(thisEventTime);
            this.mLastExportDownTimeMotion = thisEventTime;
        }
        e.setEventTime(thisEventTime);
    }

    public MonkeyEvent getNextEvent() {
        MonkeyEvent ev;
        long recordedEventTime = -1L;
        if (this.mQ.isEmpty()) {
            try {
                this.readNextBatch();
            }
            catch (IOException e) {
                return null;
            }
        }
        try {
            ev = (MonkeyEvent)this.mQ.getFirst();
            this.mQ.removeFirst();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        if (ev.getEventType() == 0) {
            this.adjustKeyEventTime((MonkeyKeyEvent)ev);
        } else if (ev.getEventType() == 1 || ev.getEventType() == 2) {
            this.adjustMotionEventTime((MonkeyMotionEvent)ev);
        }
        return ev;
    }
}

