/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.pm.ContainerEncryptionParams;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.UserInfo;
import android.content.pm.VerificationParams;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.IUserManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserManager;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.WeakHashMap;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pm {
    IPackageManager mPm;
    IUserManager mUm;
    private WeakHashMap<String, Resources> mResourceCache = new WeakHashMap();
    private String[] mArgs;
    private int mNextArg;
    private String mCurArgData;
    private static final String PM_NOT_RUNNING_ERR = "Error: Could not access the Package Manager.  Is the system running?";

    public static void main(String[] args) {
        new Pm().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        boolean validCommand = false;
        if (args.length < 1) {
            Pm.showUsage();
            return;
        }
        this.mUm = IUserManager.Stub.asInterface(ServiceManager.getService("user"));
        this.mPm = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        if (this.mPm == null) {
            System.err.println(PM_NOT_RUNNING_ERR);
            return;
        }
        this.mArgs = args;
        String op = args[0];
        this.mNextArg = 1;
        if ("list".equals(op)) {
            this.runList();
            return;
        }
        if ("path".equals(op)) {
            this.runPath();
            return;
        }
        if ("dump".equals(op)) {
            this.runDump();
            return;
        }
        if ("install".equals(op)) {
            this.runInstall();
            return;
        }
        if ("uninstall".equals(op)) {
            this.runUninstall();
            return;
        }
        if ("clear".equals(op)) {
            this.runClear();
            return;
        }
        if ("enable".equals(op)) {
            this.runSetEnabledSetting(1);
            return;
        }
        if ("disable".equals(op)) {
            this.runSetEnabledSetting(2);
            return;
        }
        if ("disable-user".equals(op)) {
            this.runSetEnabledSetting(3);
            return;
        }
        if ("disable-until-used".equals(op)) {
            this.runSetEnabledSetting(4);
            return;
        }
        if ("block".equals(op)) {
            this.runSetBlockedSetting(true);
            return;
        }
        if ("unblock".equals(op)) {
            this.runSetBlockedSetting(false);
            return;
        }
        if ("grant".equals(op)) {
            this.runGrantRevokePermission(true);
            return;
        }
        if ("revoke".equals(op)) {
            this.runGrantRevokePermission(false);
            return;
        }
        if ("set-permission-enforced".equals(op)) {
            this.runSetPermissionEnforced();
            return;
        }
        if ("set-install-location".equals(op)) {
            this.runSetInstallLocation();
            return;
        }
        if ("get-install-location".equals(op)) {
            this.runGetInstallLocation();
            return;
        }
        if ("trim-caches".equals(op)) {
            this.runTrimCaches();
            return;
        }
        if ("create-user".equals(op)) {
            this.runCreateUser();
            return;
        }
        if ("remove-user".equals(op)) {
            this.runRemoveUser();
            return;
        }
        if ("get-max-users".equals(op)) {
            this.runGetMaxUsers();
            return;
        }
        try {
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("-l")) {
                    validCommand = true;
                    this.runListPackages(false);
                } else if (args[0].equalsIgnoreCase("-lf")) {
                    validCommand = true;
                    this.runListPackages(true);
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("-p")) {
                validCommand = true;
                this.displayPackageFilePath(args[1]);
            }
        }
        finally {
            if (!validCommand) {
                if (op != null) {
                    System.err.println("Error: unknown command '" + op + "'");
                }
                Pm.showUsage();
            }
        }
    }

    private void runList() {
        String type = this.nextArg();
        if (type == null) {
            System.err.println("Error: didn't specify type of data to list");
            return;
        }
        if ("package".equals(type) || "packages".equals(type)) {
            this.runListPackages(false);
        } else if ("permission-groups".equals(type)) {
            this.runListPermissionGroups();
        } else if ("permissions".equals(type)) {
            this.runListPermissions();
        } else if ("features".equals(type)) {
            this.runListFeatures();
        } else if ("libraries".equals(type)) {
            this.runListLibraries();
        } else if ("instrumentation".equals(type)) {
            this.runListInstrumentation();
        } else if ("users".equals(type)) {
            this.runListUsers();
        } else {
            System.err.println("Error: unknown list type '" + type + "'");
        }
    }

    private void runListPackages(boolean showApplicationPackage) {
        int getFlags = 0;
        boolean listDisabled = false;
        boolean listEnabled = false;
        boolean listSystem = false;
        boolean listThirdParty = false;
        boolean listInstaller = false;
        int userId = 0;
        try {
            String opt;
            while ((opt = this.nextOption()) != null) {
                if (opt.equals("-l")) continue;
                if (opt.equals("-lf")) {
                    showApplicationPackage = true;
                    continue;
                }
                if (opt.equals("-f")) {
                    showApplicationPackage = true;
                    continue;
                }
                if (opt.equals("-d")) {
                    listDisabled = true;
                    continue;
                }
                if (opt.equals("-e")) {
                    listEnabled = true;
                    continue;
                }
                if (opt.equals("-s")) {
                    listSystem = true;
                    continue;
                }
                if (opt.equals("-3")) {
                    listThirdParty = true;
                    continue;
                }
                if (opt.equals("-i")) {
                    listInstaller = true;
                    continue;
                }
                if (opt.equals("--user")) {
                    userId = Integer.parseInt(this.nextArg());
                    continue;
                }
                if (opt.equals("-u")) {
                    getFlags |= 0x2000;
                    continue;
                }
                System.err.println("Error: Unknown option: " + opt);
                return;
            }
        }
        catch (RuntimeException ex) {
            System.err.println("Error: " + ex.toString());
            return;
        }
        String filter = this.nextArg();
        try {
            List<PackageInfo> packages = this.getInstalledPackages(this.mPm, getFlags, userId);
            int count = packages.size();
            for (int p = 0; p < count; ++p) {
                boolean isSystem;
                PackageInfo info = packages.get(p);
                if (filter != null && !info.packageName.contains(filter)) continue;
                boolean bl = isSystem = (info.applicationInfo.flags & 1) != 0;
                if (listDisabled && info.applicationInfo.enabled || listEnabled && !info.applicationInfo.enabled || listSystem && !isSystem || listThirdParty && isSystem) continue;
                System.out.print("package:");
                if (showApplicationPackage) {
                    System.out.print(info.applicationInfo.sourceDir);
                    System.out.print("=");
                }
                System.out.print(info.packageName);
                if (listInstaller) {
                    System.out.print("  installer=");
                    System.out.print(this.mPm.getInstallerPackageName(info.packageName));
                }
                System.out.println();
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private List<PackageInfo> getInstalledPackages(IPackageManager pm, int flags, int userId) throws RemoteException {
        ParceledListSlice slice = pm.getInstalledPackages(flags, userId);
        return slice.getList();
    }

    private void runListFeatures() {
        try {
            ArrayList<FeatureInfo> list = new ArrayList<FeatureInfo>();
            FeatureInfo[] rawList = this.mPm.getSystemAvailableFeatures();
            for (int i = 0; i < rawList.length; ++i) {
                list.add(rawList[i]);
            }
            Collections.sort(list, new Comparator<FeatureInfo>(){

                @Override
                public int compare(FeatureInfo o1, FeatureInfo o2) {
                    if (o1.name == o2.name) {
                        return 0;
                    }
                    if (o1.name == null) {
                        return -1;
                    }
                    if (o2.name == null) {
                        return 1;
                    }
                    return o1.name.compareTo(o2.name);
                }
            });
            int count = list != null ? list.size() : 0;
            for (int p = 0; p < count; ++p) {
                FeatureInfo fi = (FeatureInfo)list.get(p);
                System.out.print("feature:");
                if (fi.name != null) {
                    System.out.println(fi.name);
                    continue;
                }
                System.out.println("reqGlEsVersion=0x" + Integer.toHexString(fi.reqGlEsVersion));
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private void runListLibraries() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            String[] rawList = this.mPm.getSystemSharedLibraryNames();
            for (int i = 0; i < rawList.length; ++i) {
                list.add(rawList[i]);
            }
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
            int count = list != null ? list.size() : 0;
            for (int p = 0; p < count; ++p) {
                String lib = (String)list.get(p);
                System.out.print("library:");
                System.out.println(lib);
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private void runListInstrumentation() {
        int flags = 0;
        boolean showPackage = false;
        String targetPackage = null;
        try {
            String opt;
            while ((opt = this.nextArg()) != null) {
                if (opt.equals("-f")) {
                    showPackage = true;
                    continue;
                }
                if (opt.charAt(0) != '-') {
                    targetPackage = opt;
                    continue;
                }
                System.err.println("Error: Unknown option: " + opt);
                return;
            }
        }
        catch (RuntimeException ex) {
            System.err.println("Error: " + ex.toString());
            return;
        }
        try {
            List<InstrumentationInfo> list = this.mPm.queryInstrumentation(targetPackage, flags);
            Collections.sort(list, new Comparator<InstrumentationInfo>(){

                @Override
                public int compare(InstrumentationInfo o1, InstrumentationInfo o2) {
                    return o1.targetPackage.compareTo(o2.targetPackage);
                }
            });
            int count = list != null ? list.size() : 0;
            for (int p = 0; p < count; ++p) {
                InstrumentationInfo ii = list.get(p);
                System.out.print("instrumentation:");
                if (showPackage) {
                    System.out.print(ii.sourceDir);
                    System.out.print("=");
                }
                ComponentName cn = new ComponentName(ii.packageName, ii.name);
                System.out.print(cn.flattenToShortString());
                System.out.print(" (target=");
                System.out.print(ii.targetPackage);
                System.out.println(")");
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private void runListPermissionGroups() {
        try {
            List<PermissionGroupInfo> pgs = this.mPm.getAllPermissionGroups(0);
            int count = pgs.size();
            for (int p = 0; p < count; ++p) {
                PermissionGroupInfo pgi = pgs.get(p);
                System.out.print("permission group:");
                System.out.println(pgi.name);
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private String loadText(PackageItemInfo pii, int res, CharSequence nonLocalized) {
        Resources r;
        if (nonLocalized != null) {
            return ((Object)nonLocalized).toString();
        }
        if (res != 0 && (r = this.getResources(pii)) != null) {
            return r.getString(res);
        }
        return null;
    }

    private void runListPermissions() {
        try {
            String opt;
            boolean labels = false;
            boolean groups = false;
            boolean userOnly = false;
            boolean summary = false;
            boolean dangerousOnly = false;
            while ((opt = this.nextOption()) != null) {
                if (opt.equals("-f")) {
                    labels = true;
                    continue;
                }
                if (opt.equals("-g")) {
                    groups = true;
                    continue;
                }
                if (opt.equals("-s")) {
                    groups = true;
                    labels = true;
                    summary = true;
                    continue;
                }
                if (opt.equals("-u")) {
                    userOnly = true;
                    continue;
                }
                if (opt.equals("-d")) {
                    dangerousOnly = true;
                    continue;
                }
                System.err.println("Error: Unknown option: " + opt);
                return;
            }
            String grp = this.nextOption();
            ArrayList<String> groupList = new ArrayList<String>();
            if (groups) {
                List<PermissionGroupInfo> infos = this.mPm.getAllPermissionGroups(0);
                for (int i = 0; i < infos.size(); ++i) {
                    groupList.add(infos.get((int)i).name);
                }
                groupList.add(null);
            } else {
                groupList.add(grp);
            }
            if (dangerousOnly) {
                System.out.println("Dangerous Permissions:");
                System.out.println("");
                this.doListPermissions(groupList, groups, labels, summary, 1, 1);
                if (userOnly) {
                    System.out.println("Normal Permissions:");
                    System.out.println("");
                    this.doListPermissions(groupList, groups, labels, summary, 0, 0);
                }
            } else if (userOnly) {
                System.out.println("Dangerous and Normal Permissions:");
                System.out.println("");
                this.doListPermissions(groupList, groups, labels, summary, 0, 1);
            } else {
                System.out.println("All Permissions:");
                System.out.println("");
                this.doListPermissions(groupList, groups, labels, summary, -10000, 10000);
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private void doListPermissions(ArrayList<String> groupList, boolean groups, boolean labels, boolean summary, int startProtectionLevel, int endProtectionLevel) throws RemoteException {
        for (int i = 0; i < groupList.size(); ++i) {
            String groupName = groupList.get(i);
            String prefix = "";
            if (groups) {
                if (i > 0) {
                    System.out.println("");
                }
                if (groupName != null) {
                    PermissionGroupInfo pgi = this.mPm.getPermissionGroupInfo(groupName, 0);
                    if (summary) {
                        Resources res = this.getResources(pgi);
                        if (res != null) {
                            System.out.print(this.loadText(pgi, pgi.labelRes, pgi.nonLocalizedLabel) + ": ");
                        } else {
                            System.out.print(pgi.name + ": ");
                        }
                    } else {
                        System.out.println((labels ? "+ " : "") + "group:" + pgi.name);
                        if (labels) {
                            System.out.println("  package:" + pgi.packageName);
                            Resources res = this.getResources(pgi);
                            if (res != null) {
                                System.out.println("  label:" + this.loadText(pgi, pgi.labelRes, pgi.nonLocalizedLabel));
                                System.out.println("  description:" + this.loadText(pgi, pgi.descriptionRes, pgi.nonLocalizedDescription));
                            }
                        }
                    }
                } else {
                    System.out.println((labels && !summary ? "+ " : "") + "ungrouped:");
                }
                prefix = "  ";
            }
            List<PermissionInfo> ps = this.mPm.queryPermissionsByGroup(groupList.get(i), 0);
            int count = ps.size();
            boolean first = true;
            for (int p = 0; p < count; ++p) {
                Resources res;
                int base;
                PermissionInfo pi = ps.get(p);
                if (groups && groupName == null && pi.group != null || (base = pi.protectionLevel & 0xF) < startProtectionLevel || base > endProtectionLevel) continue;
                if (summary) {
                    if (first) {
                        first = false;
                    } else {
                        System.out.print(", ");
                    }
                    res = this.getResources(pi);
                    if (res != null) {
                        System.out.print(this.loadText(pi, pi.labelRes, pi.nonLocalizedLabel));
                        continue;
                    }
                    System.out.print(pi.name);
                    continue;
                }
                System.out.println(prefix + (labels ? "+ " : "") + "permission:" + pi.name);
                if (!labels) continue;
                System.out.println(prefix + "  package:" + pi.packageName);
                res = this.getResources(pi);
                if (res != null) {
                    System.out.println(prefix + "  label:" + this.loadText(pi, pi.labelRes, pi.nonLocalizedLabel));
                    System.out.println(prefix + "  description:" + this.loadText(pi, pi.descriptionRes, pi.nonLocalizedDescription));
                }
                System.out.println(prefix + "  protectionLevel:" + PermissionInfo.protectionToString(pi.protectionLevel));
            }
            if (!summary) continue;
            System.out.println("");
        }
    }

    private void runPath() {
        String pkg = this.nextArg();
        if (pkg == null) {
            System.err.println("Error: no package specified");
            return;
        }
        this.displayPackageFilePath(pkg);
    }

    private void runDump() {
        String pkg = this.nextArg();
        if (pkg == null) {
            System.err.println("Error: no package specified");
            return;
        }
        ActivityManager.dumpPackageStateStatic(FileDescriptor.out, pkg);
    }

    private String installFailureToString(int result) {
        Field[] fields;
        for (Field f : fields = PackageManager.class.getFields()) {
            String fieldName;
            int modifiers;
            if (f.getType() != Integer.TYPE || ((modifiers = f.getModifiers()) & 0x10) == 0 || (modifiers & 1) == 0 || (modifiers & 8) == 0 || !(fieldName = f.getName()).startsWith("INSTALL_FAILED_") && !fieldName.startsWith("INSTALL_PARSE_FAILED_")) continue;
            try {
                if (result != f.getInt(null)) continue;
                return fieldName;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return Integer.toString(result);
    }

    private void runSetInstallLocation() {
        int loc;
        String arg = this.nextArg();
        if (arg == null) {
            System.err.println("Error: no install location specified.");
            return;
        }
        try {
            loc = Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            System.err.println("Error: install location has to be a number.");
            return;
        }
        try {
            if (!this.mPm.setInstallLocation(loc)) {
                System.err.println("Error: install location has to be a number.");
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private void runGetInstallLocation() {
        try {
            int loc = this.mPm.getInstallLocation();
            String locStr = "invalid";
            if (loc == 0) {
                locStr = "auto";
            } else if (loc == 1) {
                locStr = "internal";
            } else if (loc == 2) {
                locStr = "external";
            }
            System.out.println(loc + "[" + locStr + "]");
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInstall() {
        Uri verificationURI;
        ContainerEncryptionParams encryptionParams;
        String opt;
        int installFlags = 64;
        String installerPackageName = null;
        String algo = null;
        byte[] iv = null;
        byte[] key = null;
        String macAlgo = null;
        byte[] macKey = null;
        byte[] tag = null;
        String originatingUriString = null;
        String referrer = null;
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("-l")) {
                installFlags |= 1;
                continue;
            }
            if (opt.equals("-r")) {
                installFlags |= 2;
                continue;
            }
            if (opt.equals("-i")) {
                installerPackageName = this.nextOptionData();
                if (installerPackageName != null) continue;
                System.err.println("Error: no value specified for -i");
                return;
            }
            if (opt.equals("-t")) {
                installFlags |= 4;
                continue;
            }
            if (opt.equals("-s")) {
                installFlags |= 8;
                continue;
            }
            if (opt.equals("-f")) {
                installFlags |= 0x10;
                continue;
            }
            if (opt.equals("-d")) {
                installFlags |= 0x80;
                continue;
            }
            if (opt.equals("--algo")) {
                algo = this.nextOptionData();
                if (algo != null) continue;
                System.err.println("Error: must supply argument for --algo");
                return;
            }
            if (opt.equals("--iv")) {
                iv = this.hexToBytes(this.nextOptionData());
                if (iv != null) continue;
                System.err.println("Error: must supply argument for --iv");
                return;
            }
            if (opt.equals("--key")) {
                key = this.hexToBytes(this.nextOptionData());
                if (key != null) continue;
                System.err.println("Error: must supply argument for --key");
                return;
            }
            if (opt.equals("--macalgo")) {
                macAlgo = this.nextOptionData();
                if (macAlgo != null) continue;
                System.err.println("Error: must supply argument for --macalgo");
                return;
            }
            if (opt.equals("--mackey")) {
                macKey = this.hexToBytes(this.nextOptionData());
                if (macKey != null) continue;
                System.err.println("Error: must supply argument for --mackey");
                return;
            }
            if (opt.equals("--tag")) {
                tag = this.hexToBytes(this.nextOptionData());
                if (tag != null) continue;
                System.err.println("Error: must supply argument for --tag");
                return;
            }
            if (opt.equals("--originating-uri")) {
                originatingUriString = this.nextOptionData();
                if (originatingUriString != null) continue;
                System.err.println("Error: must supply argument for --originating-uri");
                return;
            }
            if (opt.equals("--referrer")) {
                referrer = this.nextOptionData();
                if (referrer != null) continue;
                System.err.println("Error: must supply argument for --referrer");
                return;
            }
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        if (algo != null || iv != null || key != null || macAlgo != null || macKey != null || tag != null) {
            if (algo == null || iv == null || key == null) {
                System.err.println("Error: all of --algo, --iv, and --key must be specified");
                return;
            }
            if (!(macAlgo == null && macKey == null && tag == null || macAlgo != null && macKey != null && tag != null)) {
                System.err.println("Error: all of --macalgo, --mackey, and --tag must be specified");
                return;
            }
            try {
                SecretKeySpec encKey = new SecretKeySpec(key, "RAW");
                SecretKeySpec macSecretKey = macKey == null || macKey.length == 0 ? null : new SecretKeySpec(macKey, "RAW");
                encryptionParams = new ContainerEncryptionParams(algo, new IvParameterSpec(iv), encKey, macAlgo, null, macSecretKey, tag, -1L, -1L, -1L);
            }
            catch (InvalidAlgorithmParameterException e) {
                e.printStackTrace();
                return;
            }
        } else {
            encryptionParams = null;
        }
        Uri originatingURI = originatingUriString != null ? Uri.parse(originatingUriString) : null;
        Uri referrerURI = referrer != null ? Uri.parse(referrer) : null;
        String apkFilePath = this.nextArg();
        System.err.println("\tpkg: " + apkFilePath);
        if (apkFilePath == null) {
            System.err.println("Error: no package specified");
            return;
        }
        Uri apkURI = Uri.fromFile(new File(apkFilePath));
        String verificationFilePath = this.nextArg();
        if (verificationFilePath != null) {
            System.err.println("\tver: " + verificationFilePath);
            verificationURI = Uri.fromFile(new File(verificationFilePath));
        } else {
            verificationURI = null;
        }
        PackageInstallObserver obs = new PackageInstallObserver();
        try {
            VerificationParams verificationParams = new VerificationParams(verificationURI, originatingURI, referrerURI, -1, null);
            this.mPm.installPackageWithVerificationAndEncryption(apkURI, obs, installFlags, installerPackageName, verificationParams, encryptionParams);
            PackageInstallObserver packageInstallObserver = obs;
            synchronized (packageInstallObserver) {
                while (!obs.finished) {
                    try {
                        obs.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (obs.result == 1) {
                    System.out.println("Success");
                } else {
                    System.err.println("Failure [" + this.installFailureToString(obs.result) + "]");
                }
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private byte[] hexToBytes(String input) {
        if (input == null) {
            return null;
        }
        int inputLength = input.length();
        if (inputLength % 2 != 0) {
            System.err.print("Invalid length; must be multiple of 2");
            return null;
        }
        int byteLength = inputLength / 2;
        byte[] output = new byte[byteLength];
        int byteIndex = 0;
        for (int inputIndex = 0; inputIndex < inputLength; inputIndex += 2) {
            output[byteIndex++] = (byte)Integer.parseInt(input.substring(inputIndex, inputIndex + 2), 16);
        }
        return output;
    }

    public void runCreateUser() {
        String arg = this.nextArg();
        if (arg == null) {
            System.err.println("Error: no user name specified.");
            return;
        }
        String name = arg;
        try {
            UserInfo info = this.mUm.createUser(name, 0);
            if (info != null) {
                System.out.println("Success: created user id " + info.id);
            } else {
                System.err.println("Error: couldn't create User.");
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    public void runRemoveUser() {
        int userId;
        String arg = this.nextArg();
        if (arg == null) {
            System.err.println("Error: no user id specified.");
            return;
        }
        try {
            userId = Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            System.err.println("Error: user id '" + arg + "' is not a number.");
            return;
        }
        try {
            if (this.mUm.removeUser(userId)) {
                System.out.println("Success: removed user");
            } else {
                System.err.println("Error: couldn't remove user id " + userId);
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    public void runListUsers() {
        try {
            List<UserInfo> users = this.mUm.getUsers(false);
            if (users == null) {
                System.err.println("Error: couldn't get users");
            } else {
                System.out.println("Users:");
                for (int i = 0; i < users.size(); ++i) {
                    System.out.println("\t" + users.get(i).toString());
                }
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    public void runGetMaxUsers() {
        System.out.println("Maximum supported users: " + UserManager.getMaxSupportedUsers());
    }

    private void runUninstall() {
        String opt;
        int unInstallFlags = 2;
        while ((opt = this.nextOption()) != null) {
            if (opt.equals("-k")) {
                unInstallFlags |= 1;
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            return;
        }
        String pkg = this.nextArg();
        if (pkg == null) {
            System.err.println("Error: no package specified");
            Pm.showUsage();
            return;
        }
        boolean result = this.deletePackage(pkg, unInstallFlags);
        if (result) {
            System.out.println("Success");
        } else {
            System.out.println("Failure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePackage(String pkg, int unInstallFlags) {
        PackageDeleteObserver obs = new PackageDeleteObserver();
        try {
            this.mPm.deletePackageAsUser(pkg, obs, 0, unInstallFlags);
            PackageDeleteObserver packageDeleteObserver = obs;
            synchronized (packageDeleteObserver) {
                while (!obs.finished) {
                    try {
                        obs.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
        return obs.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runClear() {
        String pkg;
        int userId = 0;
        String option = this.nextOption();
        if (option != null && option.equals("--user")) {
            String optionData = this.nextOptionData();
            if (optionData == null || !Pm.isNumber(optionData)) {
                System.err.println("Error: no USER_ID specified");
                Pm.showUsage();
                return;
            }
            userId = Integer.parseInt(optionData);
        }
        if ((pkg = this.nextArg()) == null) {
            System.err.println("Error: no package specified");
            Pm.showUsage();
            return;
        }
        ClearDataObserver obs = new ClearDataObserver();
        try {
            ActivityManagerNative.getDefault().clearApplicationUserData(pkg, obs, userId);
            ClearDataObserver clearDataObserver = obs;
            synchronized (clearDataObserver) {
                while (!obs.finished) {
                    try {
                        obs.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            if (obs.result) {
                System.err.println("Success");
            } else {
                System.err.println("Failed");
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private static String enabledSettingToString(int state) {
        switch (state) {
            case 0: {
                return "default";
            }
            case 1: {
                return "enabled";
            }
            case 2: {
                return "disabled";
            }
            case 3: {
                return "disabled-user";
            }
            case 4: {
                return "disabled-until-used";
            }
        }
        return "unknown";
    }

    private static boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private void runSetEnabledSetting(int state) {
        String pkg;
        int userId = 0;
        String option = this.nextOption();
        if (option != null && option.equals("--user")) {
            String optionData = this.nextOptionData();
            if (optionData == null || !Pm.isNumber(optionData)) {
                System.err.println("Error: no USER_ID specified");
                Pm.showUsage();
                return;
            }
            userId = Integer.parseInt(optionData);
        }
        if ((pkg = this.nextArg()) == null) {
            System.err.println("Error: no package or component specified");
            Pm.showUsage();
            return;
        }
        ComponentName cn = ComponentName.unflattenFromString(pkg);
        if (cn == null) {
            try {
                this.mPm.setApplicationEnabledSetting(pkg, state, 0, userId, "shell:" + Process.myUid());
                System.err.println("Package " + pkg + " new state: " + Pm.enabledSettingToString(this.mPm.getApplicationEnabledSetting(pkg, userId)));
            }
            catch (RemoteException e) {
                System.err.println(e.toString());
                System.err.println(PM_NOT_RUNNING_ERR);
            }
        } else {
            try {
                this.mPm.setComponentEnabledSetting(cn, state, 0, userId);
                System.err.println("Component " + cn.toShortString() + " new state: " + Pm.enabledSettingToString(this.mPm.getComponentEnabledSetting(cn, userId)));
            }
            catch (RemoteException e) {
                System.err.println(e.toString());
                System.err.println(PM_NOT_RUNNING_ERR);
            }
        }
    }

    private void runSetBlockedSetting(boolean state) {
        String pkg;
        int userId = 0;
        String option = this.nextOption();
        if (option != null && option.equals("--user")) {
            String optionData = this.nextOptionData();
            if (optionData == null || !Pm.isNumber(optionData)) {
                System.err.println("Error: no USER_ID specified");
                Pm.showUsage();
                return;
            }
            userId = Integer.parseInt(optionData);
        }
        if ((pkg = this.nextArg()) == null) {
            System.err.println("Error: no package or component specified");
            Pm.showUsage();
            return;
        }
        try {
            this.mPm.setApplicationBlockedSettingAsUser(pkg, state, userId);
            System.err.println("Package " + pkg + " new blocked state: " + this.mPm.getApplicationBlockedSettingAsUser(pkg, userId));
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private void runGrantRevokePermission(boolean grant) {
        String pkg = this.nextArg();
        if (pkg == null) {
            System.err.println("Error: no package specified");
            Pm.showUsage();
            return;
        }
        String perm = this.nextArg();
        if (perm == null) {
            System.err.println("Error: no permission specified");
            Pm.showUsage();
            return;
        }
        try {
            if (grant) {
                this.mPm.grantPermission(pkg, perm);
            } else {
                this.mPm.revokePermission(pkg, perm);
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Bad argument: " + e.toString());
            Pm.showUsage();
        }
        catch (SecurityException e) {
            System.err.println("Operation not allowed: " + e.toString());
        }
    }

    private void runSetPermissionEnforced() {
        String permission2 = this.nextArg();
        if (permission2 == null) {
            System.err.println("Error: no permission specified");
            Pm.showUsage();
            return;
        }
        String enforcedRaw = this.nextArg();
        if (enforcedRaw == null) {
            System.err.println("Error: no enforcement specified");
            Pm.showUsage();
            return;
        }
        boolean enforced = Boolean.parseBoolean(enforcedRaw);
        try {
            this.mPm.setPermissionEnforced(permission2, enforced);
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Bad argument: " + e.toString());
            Pm.showUsage();
        }
        catch (SecurityException e) {
            System.err.println("Operation not allowed: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTrimCaches() {
        long sizeVal;
        String size = this.nextArg();
        if (size == null) {
            System.err.println("Error: no size specified");
            Pm.showUsage();
            return;
        }
        int len = size.length();
        long multiplier = 1L;
        if (len > 1) {
            char c = size.charAt(len - 1);
            if (c == 'K' || c == 'k') {
                multiplier = 1024L;
            } else if (c == 'M' || c == 'm') {
                multiplier = 0x100000L;
            } else if (c == 'G' || c == 'g') {
                multiplier = 0x40000000L;
            } else {
                System.err.println("Invalid suffix: " + c);
                Pm.showUsage();
                return;
            }
            size = size.substring(0, len - 1);
        }
        try {
            sizeVal = Long.parseLong(size) * multiplier;
        }
        catch (NumberFormatException e) {
            System.err.println("Error: expected number at: " + size);
            Pm.showUsage();
            return;
        }
        ClearDataObserver obs = new ClearDataObserver();
        try {
            this.mPm.freeStorageAndNotify(sizeVal, obs);
            ClearDataObserver clearDataObserver = obs;
            synchronized (clearDataObserver) {
                while (!obs.finished) {
                    try {
                        obs.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Bad argument: " + e.toString());
            Pm.showUsage();
        }
        catch (SecurityException e) {
            System.err.println("Operation not allowed: " + e.toString());
        }
    }

    private void displayPackageFilePath(String pckg) {
        try {
            PackageInfo info = this.mPm.getPackageInfo(pckg, 0, 0);
            if (info != null && info.applicationInfo != null) {
                System.out.print("package:");
                System.out.println(info.applicationInfo.sourceDir);
            }
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
        }
    }

    private Resources getResources(PackageItemInfo pii) {
        Resources res = this.mResourceCache.get(pii.packageName);
        if (res != null) {
            return res;
        }
        try {
            ApplicationInfo ai = this.mPm.getApplicationInfo(pii.packageName, 0, 0);
            AssetManager am = new AssetManager();
            am.addAssetPath(ai.publicSourceDir);
            res = new Resources(am, null, null);
            this.mResourceCache.put(pii.packageName, res);
            return res;
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            System.err.println(PM_NOT_RUNNING_ERR);
            return null;
        }
    }

    private String nextOption() {
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String arg = this.mArgs[this.mNextArg];
        if (!arg.startsWith("-")) {
            return null;
        }
        ++this.mNextArg;
        if (arg.equals("--")) {
            return null;
        }
        if (arg.length() > 1 && arg.charAt(1) != '-') {
            if (arg.length() > 2) {
                this.mCurArgData = arg.substring(2);
                return arg.substring(0, 2);
            }
            this.mCurArgData = null;
            return arg;
        }
        this.mCurArgData = null;
        return arg;
    }

    private String nextOptionData() {
        if (this.mCurArgData != null) {
            return this.mCurArgData;
        }
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String data = this.mArgs[this.mNextArg];
        ++this.mNextArg;
        return data;
    }

    private String nextArg() {
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String arg = this.mArgs[this.mNextArg];
        ++this.mNextArg;
        return arg;
    }

    private static void showUsage() {
        System.err.println("usage: pm list packages [-f] [-d] [-e] [-s] [-3] [-i] [-u] [--user USER_ID] [FILTER]");
        System.err.println("       pm list permission-groups");
        System.err.println("       pm list permissions [-g] [-f] [-d] [-u] [GROUP]");
        System.err.println("       pm list instrumentation [-f] [TARGET-PACKAGE]");
        System.err.println("       pm list features");
        System.err.println("       pm list libraries");
        System.err.println("       pm list users");
        System.err.println("       pm path PACKAGE");
        System.err.println("       pm dump PACKAGE");
        System.err.println("       pm install [-l] [-r] [-t] [-i INSTALLER_PACKAGE_NAME] [-s] [-f]");
        System.err.println("                  [--algo <algorithm name> --key <key-in-hex> --iv <IV-in-hex>]");
        System.err.println("                  [--originating-uri <URI>] [--referrer <URI>] PATH");
        System.err.println("       pm uninstall [-k] PACKAGE");
        System.err.println("       pm clear [--user USER_ID] PACKAGE");
        System.err.println("       pm enable [--user USER_ID] PACKAGE_OR_COMPONENT");
        System.err.println("       pm disable [--user USER_ID] PACKAGE_OR_COMPONENT");
        System.err.println("       pm disable-user [--user USER_ID] PACKAGE_OR_COMPONENT");
        System.err.println("       pm disable-until-used [--user USER_ID] PACKAGE_OR_COMPONENT");
        System.err.println("       pm block [--user USER_ID] PACKAGE_OR_COMPONENT");
        System.err.println("       pm unblock [--user USER_ID] PACKAGE_OR_COMPONENT");
        System.err.println("       pm grant PACKAGE PERMISSION");
        System.err.println("       pm revoke PACKAGE PERMISSION");
        System.err.println("       pm set-install-location [0/auto] [1/internal] [2/external]");
        System.err.println("       pm get-install-location");
        System.err.println("       pm set-permission-enforced PERMISSION [true|false]");
        System.err.println("       pm trim-caches DESIRED_FREE_SPACE");
        System.err.println("       pm create-user USER_NAME");
        System.err.println("       pm remove-user USER_ID");
        System.err.println("       pm get-max-users");
        System.err.println("");
        System.err.println("pm list packages: prints all packages, optionally only");
        System.err.println("  those whose package name contains the text in FILTER.  Options:");
        System.err.println("    -f: see their associated file.");
        System.err.println("    -d: filter to only show disbled packages.");
        System.err.println("    -e: filter to only show enabled packages.");
        System.err.println("    -s: filter to only show system packages.");
        System.err.println("    -3: filter to only show third party packages.");
        System.err.println("    -i: see the installer for the packages.");
        System.err.println("    -u: also include uninstalled packages.");
        System.err.println("");
        System.err.println("pm list permission-groups: prints all known permission groups.");
        System.err.println("");
        System.err.println("pm list permissions: prints all known permissions, optionally only");
        System.err.println("  those in GROUP.  Options:");
        System.err.println("    -g: organize by group.");
        System.err.println("    -f: print all information.");
        System.err.println("    -s: short summary.");
        System.err.println("    -d: only list dangerous permissions.");
        System.err.println("    -u: list only the permissions users will see.");
        System.err.println("");
        System.err.println("pm list instrumentation: use to list all test packages; optionally");
        System.err.println("  supply <TARGET-PACKAGE> to list the test packages for a particular");
        System.err.println("  application.  Options:");
        System.err.println("    -f: list the .apk file for the test package.");
        System.err.println("");
        System.err.println("pm list features: prints all features of the system.");
        System.err.println("");
        System.err.println("pm list users: prints all users on the system.");
        System.err.println("");
        System.err.println("pm path: print the path to the .apk of the given PACKAGE.");
        System.err.println("");
        System.err.println("pm dump: print system state associated w ith the given PACKAGE.");
        System.err.println("");
        System.err.println("pm install: installs a package to the system.  Options:");
        System.err.println("    -l: install the package with FORWARD_LOCK.");
        System.err.println("    -r: reinstall an exisiting app, keeping its data.");
        System.err.println("    -t: allow test .apks to be installed.");
        System.err.println("    -i: specify the installer package name.");
        System.err.println("    -s: install package on sdcard.");
        System.err.println("    -f: install package on internal flash.");
        System.err.println("    -d: allow version code downgrade.");
        System.err.println("");
        System.err.println("pm uninstall: removes a package from the system. Options:");
        System.err.println("    -k: keep the data and cache directories around after package removal.");
        System.err.println("");
        System.err.println("pm clear: deletes all data associated with a package.");
        System.err.println("");
        System.err.println("pm enable, disable, disable-user, disable-until-used: these commands");
        System.err.println("  change the enabled state of a given package or component (written");
        System.err.println("  as \"package/class\").");
        System.err.println("");
        System.err.println("pm grant, revoke: these commands either grant or revoke permissions");
        System.err.println("  to applications.  Only optional permissions the application has");
        System.err.println("  declared can be granted or revoked.");
        System.err.println("");
        System.err.println("pm get-install-location: returns the current install location.");
        System.err.println("    0 [auto]: Let system decide the best location");
        System.err.println("    1 [internal]: Install on internal device storage");
        System.err.println("    2 [external]: Install on external media");
        System.err.println("");
        System.err.println("pm set-install-location: changes the default install location.");
        System.err.println("  NOTE: this is only intended for debugging; using this can cause");
        System.err.println("  applications to break and other undersireable behavior.");
        System.err.println("    0 [auto]: Let system decide the best location");
        System.err.println("    1 [internal]: Install on internal device storage");
        System.err.println("    2 [external]: Install on external media");
        System.err.println("");
        System.err.println("pm trim-caches: trim cache files to reach the given free space.");
        System.err.println("");
        System.err.println("pm create-user: create a new user with the given USER_NAME,");
        System.err.println("  printing the new user identifier of the user.");
        System.err.println("");
        System.err.println("pm remove-user: remove the user with the given USER_IDENTIFIER,");
        System.err.println("  deleting all data associated with that user");
    }

    static class ClearCacheObserver
    extends IPackageDataObserver.Stub {
        boolean finished;
        boolean result;

        ClearCacheObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRemoveCompleted(String packageName, boolean succeeded) throws RemoteException {
            ClearCacheObserver clearCacheObserver = this;
            synchronized (clearCacheObserver) {
                this.finished = true;
                this.result = succeeded;
                this.notifyAll();
            }
        }
    }

    static class ClearDataObserver
    extends IPackageDataObserver.Stub {
        boolean finished;
        boolean result;

        ClearDataObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRemoveCompleted(String packageName, boolean succeeded) throws RemoteException {
            ClearDataObserver clearDataObserver = this;
            synchronized (clearDataObserver) {
                this.finished = true;
                this.result = succeeded;
                this.notifyAll();
            }
        }
    }

    class PackageDeleteObserver
    extends IPackageDeleteObserver.Stub {
        boolean finished;
        boolean result;

        PackageDeleteObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void packageDeleted(String packageName, int returnCode) {
            PackageDeleteObserver packageDeleteObserver = this;
            synchronized (packageDeleteObserver) {
                this.finished = true;
                this.result = returnCode == 1;
                this.notifyAll();
            }
        }
    }

    class PackageInstallObserver
    extends IPackageInstallObserver.Stub {
        boolean finished;
        int result;

        PackageInstallObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void packageInstalled(String name, int status) {
            PackageInstallObserver packageInstallObserver = this;
            synchronized (packageInstallObserver) {
                this.finished = true;
                this.result = status;
                this.notifyAll();
            }
        }
    }
}

