/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.requestsync;

import android.accounts.Account;
import android.content.ContentResolver;
import android.os.Bundle;
import java.net.URISyntaxException;

public class RequestSync {
    private String[] mArgs;
    private int mNextArg;
    private String mCurArgData;
    private String mAccountName = null;
    private String mAccountType = null;
    private String mAuthority = null;
    private Bundle mExtras = new Bundle();

    public static void main(String[] args) {
        try {
            new RequestSync().run(args);
        }
        catch (IllegalArgumentException e) {
            RequestSync.showUsage();
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private void run(String[] args) throws Exception {
        this.mArgs = args;
        this.mNextArg = 0;
        boolean ok = this.parseArgs();
        if (ok) {
            Account account = this.mAccountName != null && this.mAccountType != null ? new Account(this.mAccountName, this.mAccountType) : null;
            System.out.printf("Requesting sync for: \n", new Object[0]);
            if (account != null) {
                System.out.printf("  Account: %s (%s)\n", account.name, account.type);
            } else {
                System.out.printf("  Account: all\n", new Object[0]);
            }
            System.out.printf("  Authority: %s\n", this.mAuthority != null ? this.mAuthority : "All");
            if (this.mExtras.size() > 0) {
                System.out.printf("  Extras:\n", new Object[0]);
                for (String key : this.mExtras.keySet()) {
                    System.out.printf("    %s: %s\n", key, this.mExtras.get(key));
                }
            }
            ContentResolver.requestSync(account, this.mAuthority, this.mExtras);
        }
    }

    private boolean parseArgs() throws URISyntaxException {
        String opt;
        while ((opt = this.nextOption()) != null) {
            String value;
            String key;
            if (opt.equals("-h") || opt.equals("--help")) {
                RequestSync.showUsage();
                return false;
            }
            if (opt.equals("-n") || opt.equals("--account-name")) {
                this.mAccountName = this.nextArgRequired();
                continue;
            }
            if (opt.equals("-t") || opt.equals("--account-type")) {
                this.mAccountType = this.nextArgRequired();
                continue;
            }
            if (opt.equals("-a") || opt.equals("--authority")) {
                this.mAuthority = this.nextArgRequired();
                continue;
            }
            if (opt.equals("--is") || opt.equals("--ignore-settings")) {
                this.mExtras.putBoolean("ignore_settings", true);
                continue;
            }
            if (opt.equals("--ib") || opt.equals("--ignore-backoff")) {
                this.mExtras.putBoolean("ignore_backoff", true);
                continue;
            }
            if (opt.equals("--dd") || opt.equals("--discard-deletions")) {
                this.mExtras.putBoolean("discard_deletions", true);
                continue;
            }
            if (opt.equals("--nr") || opt.equals("--no-retry")) {
                this.mExtras.putBoolean("do_not_retry", true);
                continue;
            }
            if (opt.equals("--ex") || opt.equals("--expedited")) {
                this.mExtras.putBoolean("expedited", true);
                continue;
            }
            if (opt.equals("-i") || opt.equals("--initialize")) {
                this.mExtras.putBoolean("initialize", true);
                continue;
            }
            if (opt.equals("-m") || opt.equals("--manual")) {
                this.mExtras.putBoolean("force", true);
                continue;
            }
            if (opt.equals("--od") || opt.equals("--override-deletions")) {
                this.mExtras.putBoolean("deletions_override", true);
                continue;
            }
            if (opt.equals("-u") || opt.equals("--upload-only")) {
                this.mExtras.putBoolean("upload", true);
                continue;
            }
            if (opt.equals("-e") || opt.equals("--es") || opt.equals("--extra-string")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                this.mExtras.putString(key, value);
                continue;
            }
            if (opt.equals("--esn") || opt.equals("--extra-string-null")) {
                key = this.nextArgRequired();
                this.mExtras.putString(key, null);
                continue;
            }
            if (opt.equals("--ei") || opt.equals("--extra-int")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                this.mExtras.putInt(key, Integer.valueOf(value));
                continue;
            }
            if (opt.equals("--el") || opt.equals("--extra-long")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                this.mExtras.putLong(key, Long.valueOf(value));
                continue;
            }
            if (opt.equals("--ef") || opt.equals("--extra-float")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                this.mExtras.putFloat(key, Long.valueOf(value).longValue());
                continue;
            }
            if (opt.equals("--ed") || opt.equals("--extra-double")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                this.mExtras.putFloat(key, Long.valueOf(value).longValue());
                continue;
            }
            if (opt.equals("--ez") || opt.equals("--extra-bool")) {
                key = this.nextArgRequired();
                value = this.nextArgRequired();
                this.mExtras.putBoolean(key, Boolean.valueOf(value));
                continue;
            }
            System.err.println("Error: Unknown option: " + opt);
            RequestSync.showUsage();
            return false;
        }
        if (this.mNextArg < this.mArgs.length) {
            RequestSync.showUsage();
            return false;
        }
        return true;
    }

    private String nextOption() {
        if (this.mCurArgData != null) {
            String prev = this.mArgs[this.mNextArg - 1];
            throw new IllegalArgumentException("No argument expected after \"" + prev + "\"");
        }
        if (this.mNextArg >= this.mArgs.length) {
            return null;
        }
        String arg = this.mArgs[this.mNextArg];
        if (!arg.startsWith("-")) {
            return null;
        }
        ++this.mNextArg;
        if (arg.equals("--")) {
            return null;
        }
        if (arg.length() > 1 && arg.charAt(1) != '-') {
            if (arg.length() > 2) {
                this.mCurArgData = arg.substring(2);
                return arg.substring(0, 2);
            }
            this.mCurArgData = null;
            return arg;
        }
        this.mCurArgData = null;
        return arg;
    }

    private String nextArg() {
        if (this.mCurArgData != null) {
            String arg = this.mCurArgData;
            this.mCurArgData = null;
            return arg;
        }
        if (this.mNextArg < this.mArgs.length) {
            return this.mArgs[this.mNextArg++];
        }
        return null;
    }

    private String nextArgRequired() {
        String arg = this.nextArg();
        if (arg == null) {
            String prev = this.mArgs[this.mNextArg - 1];
            throw new IllegalArgumentException("Argument expected after \"" + prev + "\"");
        }
        return arg;
    }

    private static void showUsage() {
        System.err.println("usage: requestsync [options]\nWith no options, a sync will be requested for all account and all sync\nauthorities with no extras. Options can be:\n    -h|--help: Display this message\n    -n|--account-name <ACCOUNT-NAME>\n    -t|--account-type <ACCOUNT-TYPE>\n    -a|--authority <AUTHORITY>\n  Add ContentResolver extras:\n    --is|--ignore-settings: Add SYNC_EXTRAS_IGNORE_SETTINGS\n    --ib|--ignore-backoff: Add SYNC_EXTRAS_IGNORE_BACKOFF\n    --dd|--discard-deletions: Add SYNC_EXTRAS_DISCARD_LOCAL_DELETIONS\n    --nr|--no-retry: Add SYNC_EXTRAS_DO_NOT_RETRY\n    --ex|--expedited: Add SYNC_EXTRAS_EXPEDITED\n    --i|--initialize: Add SYNC_EXTRAS_INITIALIZE\n    --m|--manual: Add SYNC_EXTRAS_MANUAL\n    --od|--override-deletions: Add SYNC_EXTRAS_OVERRIDE_TOO_MANY_DELETIONS\n    --u|--upload-only: Add SYNC_EXTRAS_UPLOAD\n  Add custom extras:\n    -e|--es|--extra-string <KEY> <VALUE>\n    --esn|--extra-string-null <KEY>\n    --ei|--extra-int <KEY> <VALUE>\n    --el|--extra-long <KEY> <VALUE>\n    --ef|--extra-float <KEY> <VALUE>\n    --ed|--extra-double <KEY> <VALUE>\n    --ez|--extra-bool <KEY> <VALUE>\n");
    }
}

