/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.settings;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.IContentProvider;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;

public final class SettingsCmd {
    static final String TAG = "settings";
    static String[] mArgs;
    int mNextArg;
    int mUser = -1;
    CommandVerb mVerb = CommandVerb.UNSPECIFIED;
    String mTable = null;
    String mKey = null;
    String mValue = null;

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            SettingsCmd.printUsage();
            return;
        }
        mArgs = args;
        try {
            new SettingsCmd().run();
        }
        catch (Exception e) {
            System.err.println("Unable to run settings command");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean valid = false;
        try {
            String arg;
            while ((arg = this.nextArg()) != null) {
                if ("--user".equals(arg)) {
                    if (this.mUser == -1) {
                        this.mUser = Integer.parseInt(this.nextArg());
                        continue;
                    }
                    break;
                }
                if (this.mVerb == CommandVerb.UNSPECIFIED) {
                    if ("get".equalsIgnoreCase(arg)) {
                        this.mVerb = CommandVerb.GET;
                        continue;
                    }
                    if ("put".equalsIgnoreCase(arg)) {
                        this.mVerb = CommandVerb.PUT;
                        continue;
                    }
                    System.err.println("Invalid command: " + arg);
                    break;
                }
                if (this.mTable == null) {
                    if (!("system".equalsIgnoreCase(arg) || "secure".equalsIgnoreCase(arg) || "global".equalsIgnoreCase(arg))) {
                        System.err.println("Invalid namespace '" + arg + "'");
                        break;
                    } else {
                        this.mTable = arg.toLowerCase();
                        continue;
                    }
                }
                if (this.mVerb == CommandVerb.GET) {
                    this.mKey = arg;
                    if (this.mNextArg >= mArgs.length) {
                        valid = true;
                    } else {
                        System.err.println("Too many arguments");
                    }
                    break;
                }
                if (this.mKey == null) {
                    this.mKey = arg;
                    continue;
                }
                this.mValue = arg;
                if (this.mNextArg >= mArgs.length) {
                    valid = true;
                } else {
                    System.err.println("Too many arguments");
                }
                break;
            }
        }
        catch (Exception e) {
            valid = false;
        }
        if (!valid) {
            SettingsCmd.printUsage();
            return;
        }
        if (this.mUser < 0) {
            this.mUser = 0;
        }
        try {
            IActivityManager activityManager = ActivityManagerNative.getDefault();
            IContentProvider provider = null;
            Binder token = new Binder();
            try {
                IActivityManager.ContentProviderHolder holder = activityManager.getContentProviderExternal(TAG, 0, token);
                if (holder == null) {
                    throw new IllegalStateException("Could not find settings provider");
                }
                provider = holder.provider;
                switch (this.mVerb) {
                    case GET: {
                        System.out.println(this.getForUser(provider, this.mUser, this.mTable, this.mKey));
                        return;
                    }
                    case PUT: {
                        this.putForUser(provider, this.mUser, this.mTable, this.mKey, this.mValue);
                        return;
                    }
                }
                System.err.println("Unspecified command");
                return;
            }
            finally {
                if (provider != null) {
                    activityManager.removeContentProviderExternal(TAG, token);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error while accessing settings provider");
            e.printStackTrace();
            return;
        }
    }

    private String nextArg() {
        if (this.mNextArg >= mArgs.length) {
            return null;
        }
        String arg = mArgs[this.mNextArg];
        ++this.mNextArg;
        return arg;
    }

    String getForUser(IContentProvider provider, int userHandle, String table, String key) {
        String callGetCommand;
        if ("system".equals(table)) {
            callGetCommand = "GET_system";
        } else if ("secure".equals(table)) {
            callGetCommand = "GET_secure";
        } else if ("global".equals(table)) {
            callGetCommand = "GET_global";
        } else {
            System.err.println("Invalid table; no put performed");
            throw new IllegalArgumentException("Invalid table " + table);
        }
        String result = null;
        try {
            Bundle arg = new Bundle();
            arg.putInt("_user", userHandle);
            Bundle b = provider.call(null, callGetCommand, key, arg);
            if (b != null) {
                result = b.getPairValue();
            }
        }
        catch (RemoteException e) {
            System.err.println("Can't read key " + key + " in " + table + " for user " + userHandle);
        }
        return result;
    }

    void putForUser(IContentProvider provider, int userHandle, String table, String key, String value) {
        String callPutCommand;
        if ("system".equals(table)) {
            callPutCommand = "PUT_system";
        } else if ("secure".equals(table)) {
            callPutCommand = "PUT_secure";
        } else if ("global".equals(table)) {
            callPutCommand = "PUT_global";
        } else {
            System.err.println("Invalid table; no put performed");
            return;
        }
        try {
            Bundle arg = new Bundle();
            arg.putString("value", value);
            arg.putInt("_user", userHandle);
            provider.call(null, callPutCommand, key, arg);
        }
        catch (RemoteException e) {
            System.err.println("Can't set key " + key + " in " + table + " for user " + userHandle);
        }
    }

    private static void printUsage() {
        System.err.println("usage:  settings [--user NUM] get namespace key");
        System.err.println("        settings [--user NUM] put namespace key value");
        System.err.println("\n'namespace' is one of {system, secure, global}, case-insensitive");
        System.err.println("If '--user NUM' is not given, the operations are performed on the owner user.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CommandVerb {
        UNSPECIFIED,
        GET,
        PUT;

    }
}

