/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.svc;

import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import com.android.commands.svc.Svc;

public class PowerCommand
extends Svc.Command {
    public PowerCommand() {
        super("power");
    }

    public String shortHelp() {
        return "Control the power manager";
    }

    public String longHelp() {
        return this.shortHelp() + "\n" + "\n" + "usage: svc power stayon [true|false|usb|ac|wireless]\n" + "         Set the 'keep awake while plugged in' setting.\n" + "       svc power reboot [reason]\n" + "         Perform a runtime shutdown and reboot device with specified reason.\n" + "       svc power shutdown\n" + "         Perform a runtime shutdown and power off the device.\n";
    }

    public void run(String[] args) {
        block11: {
            IPowerManager pm;
            block12: {
                int val;
                block14: {
                    block17: {
                        block16: {
                            block15: {
                                block13: {
                                    if (args.length < 2) break block11;
                                    pm = IPowerManager.Stub.asInterface(ServiceManager.getService("power"));
                                    if (!"stayon".equals(args[1]) || args.length != 3) break block12;
                                    if (!"true".equals(args[2])) break block13;
                                    val = 7;
                                    break block14;
                                }
                                if (!"false".equals(args[2])) break block15;
                                val = 0;
                                break block14;
                            }
                            if (!"usb".equals(args[2])) break block16;
                            val = 2;
                            break block14;
                        }
                        if (!"ac".equals(args[2])) break block17;
                        val = 1;
                        break block14;
                    }
                    if (!"wireless".equals(args[2])) break block11;
                    val = 4;
                }
                try {
                    if (val != 0) {
                        pm.wakeUp(SystemClock.uptimeMillis());
                    }
                    pm.setStayOnSetting(val);
                }
                catch (RemoteException e) {
                    System.err.println("Faild to set setting: " + e);
                }
                return;
            }
            if ("reboot".equals(args[1])) {
                String mode = null;
                if (args.length == 3) {
                    mode = args[2];
                }
                try {
                    pm.reboot(false, mode, true);
                }
                catch (RemoteException e) {
                    System.err.println("Failed to reboot.");
                }
                return;
            }
            if ("shutdown".equals(args[1])) {
                try {
                    pm.shutdown(false, true);
                }
                catch (RemoteException e) {
                    System.err.println("Failed to shutdown.");
                }
                return;
            }
        }
        System.err.println(this.longHelp());
    }
}

