/*
 * Decompiled with CFR 0.152.
 */
package com.android.commands.svc;

import com.android.commands.svc.DataCommand;
import com.android.commands.svc.PowerCommand;
import com.android.commands.svc.UsbCommand;
import com.android.commands.svc.WifiCommand;

public class Svc {
    public static final Command COMMAND_HELP = new Command("help"){

        public String shortHelp() {
            return "Show information about the subcommands";
        }

        public String longHelp() {
            return this.shortHelp();
        }

        public void run(String[] args) {
            Command c;
            if (args.length == 2 && (c = Svc.lookupCommand(args[1])) != null) {
                System.err.println(c.longHelp());
                return;
            }
            System.err.println("Available commands:");
            int N = COMMANDS.length;
            int maxlen = 0;
            for (int i = 0; i < N; ++i) {
                Command c2 = COMMANDS[i];
                int len = c2.name().length();
                if (maxlen >= len) continue;
                maxlen = len;
            }
            String format = "    %-" + maxlen + "s    %s";
            for (int i = 0; i < N; ++i) {
                Command c3 = COMMANDS[i];
                System.err.println(String.format(format, c3.name(), c3.shortHelp()));
            }
        }
    };
    public static final Command[] COMMANDS = new Command[]{COMMAND_HELP, new PowerCommand(), new DataCommand(), new WifiCommand(), new UsbCommand()};

    public static void main(String[] args) {
        Command c;
        if (args.length >= 1 && (c = Svc.lookupCommand(args[0])) != null) {
            c.run(args);
            return;
        }
        COMMAND_HELP.run(args);
    }

    private static Command lookupCommand(String name) {
        for (Command c : COMMANDS) {
            if (!c.name().equals(name)) continue;
            return c;
        }
        return null;
    }

    public static abstract class Command {
        private String mName;

        public Command(String name) {
            this.mName = name;
        }

        public String name() {
            return this.mName;
        }

        public abstract String shortHelp();

        public abstract String longHelp();

        public abstract void run(String[] var1);
    }
}

